/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static DiagramCellEditor cellEditor = new DefaultDiagramCellEditor();
    protected AbstractDiagram diagram = null;
    protected CellMapper mapper = null;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList();
    protected Map attributes = DiagramConstants.createMap();
    protected Map allAttributes;
    private List selfReferences = new ArrayList();

    public AbstractCellView(Object object, AbstractDiagram abstractDiagram, CellMapper cellMapper) {
        this.cell = object;
        this.diagram = abstractDiagram;
        this.mapper = cellMapper;
        this.updateAllAttributes();
    }

    public AbstractDiagram getDiagram() {
        return this.diagram;
    }

    public DiagramModel getModel() {
        return this.diagram.getModel();
    }

    public CellMapper getMapper() {
        return this.mapper;
    }

    @Override
    public Object getCell() {
        return this.cell;
    }

    public void setNewBounds(Rectangle rectangle) {
        this.setNewBounds(rectangle, true);
    }

    public void setNewBounds(Rectangle rectangle, boolean bl) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        Map map = DiagramConstants.createMap();
        DiagramConstants.setBounds(map, rectangle);
        hashtable.put(this.cell, map);
        this.diagram.getDiagramLayoutCache().edit(hashtable, null, null, null, bl);
    }

    @Override
    public void refresh(boolean bl) {
        boolean bl2;
        Object object;
        this.update();
        if (this.mapper != null && this.getModel() != null) {
            Object object2 = this.getModel().getParent(this.cell);
            if (this.diagram.getDiagramLayoutCache().isVisible(object2)) {
                object = this.mapper.getMapping(object2, bl);
                if (object != this.parent) {
                    this.removeFromParent();
                }
                this.parent = object;
            } else if (this.parent != null) {
                this.removeFromParent();
                this.parent = null;
            }
        }
        boolean bl3 = bl2 = !this.diagram.getDiagramLayoutCache().isOrdered();
        if (bl2) {
            this.childViews.clear();
        }
        object = this.getModel();
        for (int i = 0; i < object.getChildCount(this.cell); ++i) {
            CellView cellView;
            Object object3 = object.getChild(this.cell, i);
            if (!this.diagram.getDiagramLayoutCache().isVisible(object3) || (cellView = this.mapper.getMapping(object3, bl)) == null || object.isPort(object3) || this.childViews.contains(cellView) && !bl2) continue;
            this.childViews.add(cellView);
        }
    }

    @Override
    public void update() {
        this.updateAllAttributes();
        this.childUpdated();
    }

    protected void updateAllAttributes() {
        boolean bl = false;
        Object v = null;
        Object v2 = null;
        this.allAttributes = this.getModel().getAttributes(this.cell);
        if (this.allAttributes != null) {
            bl = true;
            v = this.allAttributes.get("beginDashed");
            v2 = this.allAttributes.get("endDashed");
            this.allAttributes = DiagramConstants.cloneMap(this.allAttributes);
        } else {
            this.allAttributes = DiagramConstants.createMap();
        }
        this.allAttributes.putAll(this.attributes);
        if (bl && v != null && v2 != null) {
            this.allAttributes.put("beginDashed", v);
            this.allAttributes.put("endDashed", v2);
        }
    }

    @Override
    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
    }

    @Override
    public CellView getParentView() {
        return this.parent;
    }

    @Override
    public CellView[] getChildViews() {
        CellView[] cellViewArray = new CellView[this.childViews.size()];
        this.childViews.toArray(cellViewArray);
        return cellViewArray;
    }

    public static CellView[] getDescendantViews(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            stack.add(cellViewArray[i]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (int i = 0; i < cellViewArray3.length; ++i) {
                stack.add(cellViewArray3[i]);
            }
            arrayList.add(cellViewArray2);
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    @Override
    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public Map getAllAttributes() {
        return this.allAttributes;
    }

    @Override
    public Map setAttributes(Map map) {
        Map map2 = DiagramConstants.applyMap(map, this.attributes);
        this.update();
        return map2;
    }

    @Override
    public abstract Rectangle2D getBounds();

    public static Rectangle2D getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle2D rectangle2D = null;
            for (int i = 0; i < cellViewArray.length; ++i) {
                Rectangle2D rectangle2D2;
                if (cellViewArray[i] == null || (rectangle2D2 = cellViewArray[i].getBounds()) == null) continue;
                if (rectangle2D == null) {
                    rectangle2D = DiagramConstants.createRect(rectangle2D2);
                    continue;
                }
                Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
            }
            return rectangle2D;
        }
        return null;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 == null) {
            rectangle2D2 = DiagramConstants.createRect();
        }
        Point2D point2D = DiagramConstants.createPoint(rectangle2D2.getX(), rectangle2D2.getY());
        Point2D point2D2 = DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY());
        Rectangle2D rectangle2D3 = DiagramConstants.createRect(rectangle2D);
        if (DiagramConstants.isMoveable(this.getAttributes()) && !point2D2.equals(point2D)) {
            this.translate(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        } else {
            rectangle2D3.setFrame(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D.getWidth() - point2D2.getX() + point2D.getX(), rectangle2D.getHeight() - point2D2.getY() + point2D.getY());
        }
        double d = rectangle2D3.getWidth();
        double d2 = rectangle2D3.getHeight();
        double d3 = rectangle2D2.getWidth();
        double d4 = rectangle2D2.getHeight();
        if ((d != d3 || d2 != d4) && d3 > 0.0 && d4 > 0.0) {
            this.scale(d / d3, d2 / d4, point2D2);
        }
    }

    protected void translate(double d, double d2) {
        if (this.isLeaf()) {
            DiagramConstants.translate(this.getAttributes(), d, d2, this.getDiagram());
        } else {
            for (Object e : this.childViews) {
                if (!(e instanceof AbstractCellView)) continue;
                AbstractCellView abstractCellView = (AbstractCellView)e;
                abstractCellView.translate(d, d2);
            }
        }
    }

    protected void scale(double d, double d2, Point2D point2D) {
        if (this.isLeaf()) {
            DiagramConstants.scale(this.getAttributes(), d, d2, point2D, this.getDiagram());
        } else {
            for (Object e : this.childViews) {
                AbstractCellView abstractCellView;
                Map map;
                if (!(e instanceof AbstractCellView) || !DiagramConstants.isSizeable(map = (abstractCellView = (AbstractCellView)e).getAttributes()) && !DiagramConstants.isAutoSize(map)) continue;
                abstractCellView.scale(d, d2, point2D);
            }
        }
    }

    @Override
    public boolean intersects(Graphics graphics, Rectangle2D rectangle2D) {
        if (this.isLeaf()) {
            Rectangle2D rectangle2D2 = this.getBounds();
            if (rectangle2D2 != null) {
                return rectangle2D2.intersects(rectangle2D);
            }
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                if (!((CellView)iterator.next()).intersects(graphics, rectangle2D)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, boolean bl, boolean bl2, boolean bl3) {
        CellViewRenderer cellViewRenderer = this.getRenderer();
        if (cellViewRenderer != null) {
            return cellViewRenderer.getRendererComponent(abstractDiagram, this, bl, bl2, bl3);
        }
        return null;
    }

    public abstract CellViewRenderer getRenderer();

    public abstract Point2D getCenterPoint();

    public abstract Point2D getPerimeterPoint(Point2D var1, Point2D var2, boolean var3);

    @Override
    public abstract CellHandle getHandle(DiagramContext var1);

    @Override
    public DiagramCellEditor getEditor() {
        return cellEditor;
    }

    private boolean containsSelfRef(EdgeView edgeView) {
        for (int i = 0; i < this.selfReferences.size(); ++i) {
            EdgeView edgeView2 = (EdgeView)this.selfReferences.get(i);
            if (edgeView.getCell() == null || edgeView2.getCell() != edgeView.getCell()) continue;
            return true;
        }
        return false;
    }

    public int getSelfRefPos(EdgeView edgeView) {
        int n;
        for (n = this.selfReferences.size() - 1; n >= 0; --n) {
            EdgeView edgeView2 = (EdgeView)this.selfReferences.get(n);
            if (edgeView2.isSelfReference() && ((DefaultEdge)edgeView2.getCell()).getSource() != null && ((DefaultEdge)edgeView2.getCell()).getTarget() != null) continue;
            this.selfReferences.remove(edgeView2);
        }
        if (!this.containsSelfRef(edgeView)) {
            this.selfReferences.add(edgeView);
        }
        if ((n = this.selfReferences.indexOf(edgeView)) < 0) {
            n = 0;
        }
        return n + 1;
    }
}

