/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.event;

import java.util.EventObject;
import oracle.dbtools.crest.swingui.diagram.Messages;

public class DiagramSelectionEvent
extends EventObject {
    protected Object[] cells;
    protected boolean[] areNew;

    public DiagramSelectionEvent(Object object, Object[] objectArray, boolean[] blArray) {
        super(object);
        this.cells = objectArray;
        this.areNew = blArray;
    }

    public Object[] getCells() {
        int n = this.cells.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.cells, 0, objectArray, 0, n);
        return objectArray;
    }

    public Object getCell() {
        return this.cells[0];
    }

    public boolean isAddedCell() {
        return this.areNew[0];
    }

    public boolean isAddedCell(Object object) {
        for (int i = this.cells.length - 1; i >= 0; --i) {
            if (!this.cells[i].equals(object)) continue;
            return this.areNew[i];
        }
        throw new IllegalArgumentException(Messages.getString("DiagramSelectionEvent.CellNotIdentifiedByDiagramSelectionEvent"));
    }

    public boolean isAddedCell(int n) {
        if (this.cells == null || n < 0 || n >= this.cells.length) {
            throw new IllegalArgumentException(Messages.getString("DiagramSelectionEvent.IndexBeyondRange"));
        }
        return this.areNew[n];
    }

    public Object cloneWithSource(Object object) {
        return new DiagramSelectionEvent(object, this.cells, this.areNew);
    }
}

