/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.datatypes;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.datatypes.DTDiagramCell;

public class StructuredTypeDiagramCell
extends DTDiagramCell {
    private JPopupMenu menu;
    private JMenuItem miSelectNeighbors;

    public StructuredTypeDiagramCell(AbstractDTObject abstractDTObject) {
        super(abstractDTObject);
    }

    public StructuredTypeDiagramCell(AbstractDTObject abstractDTObject, Map map) {
        super(abstractDTObject, map);
    }

    private void showProperty() {
        this.getDTObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StructuredTypeDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                    }
                });
                this.menu.addSeparator();
                this.miSelectNeighbors = this.menu.add(new AbstractAction(SELECT_NEIGHBORS){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((DPVDataTypes)StructuredTypeDiagramCell.this.getTopView().getDesignPartView()).selectNeighbors(StructuredTypeDiagramCell.this.getDTObject());
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StructuredTypeDiagramCell.this.deleteStructuredType();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StructuredTypeDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StructuredTypeDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StructuredTypeDiagramCell.this.showProperty();
                }
            });
        }
        if (this.isEditable()) {
            this.miSelectNeighbors.setEnabled(this.enableSelectNeighbors());
        }
        return this.menu;
    }

    private boolean enableSelectNeighbors() {
        StructuredType structuredType = (StructuredType)this.getDTObject();
        DTRelation.Connection[] connectionArray = structuredType.getAllLinks();
        for (int i = 0; i < connectionArray.length; ++i) {
            DTRelation.Connection connection = connectionArray[i];
            if (connection.getDTRelation() instanceof DTInheritance || connection.getDTRelation().getSourceDTObject() == connection.getDTRelation().getTargetDTObject()) continue;
            return true;
        }
        return false;
    }

    public void deleteStructuredType() {
        TVStructuredType tVStructuredType = (TVStructuredType)this.getTopView();
        ApplicationView.log(MessageFormat.format(Messages.getString("StructuredTypeDiagramCell.DeleteStructuredType"), this.getDTObject().getName()));
        tVStructuredType.remove(true);
    }

    @Override
    public void deleteSelected() {
        this.deleteStructuredType();
    }
}

