/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;

public class OverviewPanel
extends JPanel
implements ComponentListener,
DiagramModelListener,
Observer {
    protected AbstractDiagram diagram;
    protected AbstractDiagram originalDiagram;
    protected PannerViewfinder v;
    protected Rectangle r;
    double graphWindowToPannerScale = 0.5;
    static final int PANEL_BUFFER = 2;

    protected OverviewPanel(AbstractDiagram abstractDiagram, JViewport jViewport) {
        this.originalDiagram = abstractDiagram;
        this.v = new PannerViewfinder(this, jViewport);
        ViewRedirector viewRedirector = new ViewRedirector(abstractDiagram, abstractDiagram.getDiagramLayoutCache());
        this.diagram = new AbstractDiagram(abstractDiagram.getModel(), viewRedirector);
        this.diagram.setAntiAliased(true);
        this.diagram.getModel().addDiagramModelListener(this);
        this.diagram.setEnabled(false);
        this.diagram.addMouseListener(this.v);
        this.diagram.addMouseMotionListener(this.v);
        abstractDiagram.addPropertyChangeListener("scale", this.v);
        this.addComponentListener(this);
        abstractDiagram.getDiagramLayoutCache().addObserver(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.diagram, "Center");
    }

    public static JPanel createOverviewPanel(AbstractDiagram abstractDiagram, JViewport jViewport) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE));
        jPanel.add((Component)new OverviewPanel(abstractDiagram, jViewport), "Center");
        return jPanel;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.componentResized(null);
    }

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        this.v.update(graphics);
    }

    @Override
    public void diagramChanged(DiagramModelEvent diagramModelEvent) {
        this.componentResized(null);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.v.getViewport().getView().getSize();
        dimension.setSize((double)(dimension.width * 1) / this.v.zoomScale, (double)(dimension.height * 1) / this.v.zoomScale);
        Dimension dimension2 = this.getSize();
        double d = dimension2.getWidth() / dimension.getWidth();
        double d2 = dimension2.getHeight() / dimension.getHeight();
        this.graphWindowToPannerScale = Math.min(d, d2);
        this.diagram.setScale(this.graphWindowToPannerScale);
        this.v.synchViewportWithPanner();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.componentResized(componentEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    class PannerViewfinder
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    ChangeListener {
        public final int LEFT_VERTICAL = 1;
        public final int RIGHT_VERTICAL = 2;
        public final int UPPER_HORIZONTAL = 4;
        public final int LOWER_HORIZONTAL = 8;
        public final int NW_CORNER = 5;
        public final int NE_CORNER = 6;
        public final int SW_CORNER = 9;
        public final int SE_CORNER = 10;
        int scaledWidth = 50;
        int scaledHeight = 25;
        int last_x;
        int last_y;
        Rectangle pannerContainerRectangle;
        Rectangle pannerViewRectangle;
        Rectangle pannerViewRectangleCopy;
        Rectangle pannerContainerRectangleCopy;
        Container container;
        JViewport viewport;
        double zoomScale = 1.0;
        double combinedScale;
        boolean isActive;
        BasicStroke stroke;
        float[] dash1;
        BasicStroke dashStroke;
        private Point viewportPosition;

        public PannerViewfinder(Container container, JViewport jViewport) {
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            this.isActive = false;
            this.stroke = new BasicStroke(1.0f);
            this.dash1 = new float[]{2.5f};
            this.dashStroke = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash1, 0.0f);
            this.container = container;
            this.viewport = jViewport;
            this.viewport.addChangeListener(this);
            this.pannerViewRectangle = new Rectangle(0, 0, this.scaledWidth, this.scaledHeight);
            this.viewportPosition = new Point(0, 0);
        }

        private boolean isContained(MouseEvent mouseEvent) {
            return this.pannerViewRectangle.contains(mouseEvent.getX(), mouseEvent.getY());
        }

        public JViewport getViewport() {
            return this.viewport;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.synchViewportWithPanner();
            this.container.repaint();
        }

        public void synchViewportWithPanner() {
            Point point = this.viewport.getViewPosition();
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            int n = (int)(point.getX() * this.combinedScale);
            int n2 = (int)(point.getY() * this.combinedScale);
            this.pannerViewRectangle.setLocation(n, n2);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.zoomScale = (Double)propertyChangeEvent.getNewValue();
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            this.container.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Cursor cursor = this.container.getCursor();
            int n = cursor.getType();
            if (n == 0) {
                this.last_x = this.pannerViewRectangle.x - mouseEvent.getX();
                this.last_y = this.pannerViewRectangle.y - mouseEvent.getY();
                if (this.isContained(mouseEvent)) {
                    this.updatePannerLocation(mouseEvent);
                    this.isActive = true;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.isActive) {
                this.updatePannerLocation(mouseEvent);
                this.updateViewPort(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isActive) {
                this.isActive = false;
            }
        }

        private void updateViewPort(MouseEvent mouseEvent) {
            int n = (int)(1.0 / this.combinedScale * this.pannerViewRectangle.getX());
            int n2 = (int)(1.0 / this.combinedScale * this.pannerViewRectangle.getY());
            Rectangle rectangle = this.viewport.getViewRect();
            if ((double)n + rectangle.getWidth() > this.viewport.getViewSize().getWidth()) {
                n = (int)(this.viewport.getViewSize().getWidth() - rectangle.getWidth());
            }
            if ((double)n2 + rectangle.getHeight() > this.viewport.getViewSize().getHeight()) {
                n2 = (int)(this.viewport.getViewSize().getHeight() - rectangle.getHeight());
            }
            this.viewportPosition.setLocation(n, n2);
            this.viewport.setViewPosition(this.viewportPosition);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isContained(mouseEvent)) {
                this.isActive = true;
                this.pannerViewRectangle.setLocation(mouseEvent.getPoint());
                this.container.repaint();
                this.isActive = false;
                this.updateViewPort(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void updatePannerLocation(MouseEvent mouseEvent) {
            this.pannerViewRectangle.setLocation(this.last_x + mouseEvent.getX(), this.last_y + mouseEvent.getY());
            this.ensureWithinPannerBounds();
            this.container.repaint();
        }

        public void update(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = this.viewport.getViewRect();
            Dimension dimension = this.viewport.getView().getSize();
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            if (this.pannerContainerRectangle == null) {
                this.pannerContainerRectangle = new Rectangle();
            }
            this.pannerContainerRectangle.setSize((int)(dimension.getWidth() * this.combinedScale) - 2, (int)(dimension.getHeight() * this.combinedScale) - 2);
            this.scaledWidth = (int)(rectangle.getWidth() * this.pannerContainerRectangle.getWidth() / dimension.getWidth());
            this.scaledHeight = (int)(rectangle.getHeight() * this.pannerContainerRectangle.getHeight() / dimension.getHeight());
            graphics2D.setStroke(this.stroke);
            this.pannerViewRectangle.setSize(this.scaledWidth, this.scaledHeight);
            graphics2D.setColor(Color.red);
            graphics2D.draw(this.pannerViewRectangle);
        }

        private void ensureWithinPannerBounds() {
            int n = this.pannerViewRectangle.x;
            int n2 = this.pannerViewRectangle.y;
            if ((double)(this.pannerViewRectangle.x + this.scaledWidth) > this.pannerContainerRectangle.getWidth()) {
                n = (int)this.pannerContainerRectangle.getWidth() - this.scaledWidth + 2;
            }
            if (this.pannerViewRectangle.x < 0) {
                n = 0;
            }
            if ((double)(this.pannerViewRectangle.y + this.scaledHeight) > this.pannerContainerRectangle.getHeight()) {
                n2 = (int)this.pannerContainerRectangle.getHeight() - this.scaledHeight + 2;
            }
            if (this.pannerViewRectangle.y < 0) {
                n2 = 0;
            }
            this.pannerViewRectangle.setLocation(n, n2);
        }
    }

    public class ViewRedirector
    extends DiagramLayoutCache {
        protected DiagramLayoutCache realView;

        public ViewRedirector(AbstractDiagram abstractDiagram, DiagramLayoutCache diagramLayoutCache) {
            super(abstractDiagram);
            this.realView = diagramLayoutCache;
            this.setModel(abstractDiagram.getModel());
        }

        @Override
        public CellView[] getRoots() {
            return this.realView.getRoots();
        }

        @Override
        public CellView getMapping(Object object, boolean bl) {
            if (this.realView != null) {
                return this.realView.getMapping(object, bl);
            }
            return null;
        }

        @Override
        public void putMapping(Object object, CellView cellView) {
            if (this.realView != null) {
                this.realView.putMapping(object, cellView);
            }
        }
    }
}

