/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.MatteBorder;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;

public class DiagramViewPanel
extends JPanel
implements ComponentListener,
DiagramModelListener,
Observer {
    protected AbstractDiagram diagram;
    protected AbstractDiagram originalDiagram;
    protected Rectangle r;
    double graphWindowToPannerScale = 0.5;
    static final int PANEL_BUFFER = 2;
    public int hIndex;

    public DiagramViewPanel(AbstractDiagram abstractDiagram, JViewport jViewport) {
        this.originalDiagram = abstractDiagram;
        ViewRedirector viewRedirector = new ViewRedirector(abstractDiagram, abstractDiagram.getDiagramLayoutCache());
        this.diagram = new AbstractDiagram(abstractDiagram.getModel(), viewRedirector);
        this.diagram.setAntiAliased(true);
        this.diagram.getModel().addDiagramModelListener(this);
        this.diagram.setEnabled(false);
        this.addComponentListener(this);
        abstractDiagram.getDiagramLayoutCache().addObserver(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.diagram, "Center");
    }

    public static JPanel createOverviewPanel(AbstractDiagram abstractDiagram, JViewport jViewport) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE));
        jPanel.add((Component)new DiagramViewPanel(abstractDiagram, jViewport), "Center");
        return jPanel;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.componentResized(null);
    }

    @Override
    public void diagramChanged(DiagramModelEvent diagramModelEvent) {
        this.componentResized(null);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.fitScreen();
        this.repaint();
    }

    private void fitScreen() {
        Rectangle rectangle;
        Rectangle2D rectangle2D = this.diagram.getCellBounds(this.diagram.getRoots());
        if (rectangle2D != null && (rectangle = rectangle2D.getBounds()) != null) {
            double d;
            Dimension dimension = new Dimension(this.getSize().width, this.getSize().height - this.hIndex);
            double d2 = 1.0;
            double d3 = dimension.getWidth() / ((double)rectangle.x + rectangle.getWidth());
            d2 = d3 < (d = dimension.getHeight() / ((double)rectangle.y + rectangle.getHeight())) ? Math.max(Math.min(d3, 16.0), 0.01) : Math.max(Math.min(d, 16.0), 0.01);
            this.diagram.setScale(d2);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.componentResized(componentEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    public class ViewRedirector
    extends DiagramLayoutCache {
        protected DiagramLayoutCache realView;

        public ViewRedirector(AbstractDiagram abstractDiagram, DiagramLayoutCache diagramLayoutCache) {
            super(abstractDiagram);
            this.realView = diagramLayoutCache;
            this.setModel(abstractDiagram.getModel());
        }

        @Override
        public CellView[] getRoots() {
            return this.realView.getRoots();
        }

        @Override
        public CellView getMapping(Object object, boolean bl) {
            if (this.realView != null) {
                return this.realView.getMapping(object, bl);
            }
            return null;
        }

        @Override
        public void putMapping(Object object, CellView cellView) {
            if (this.realView != null) {
                this.realView.putMapping(object, cellView);
            }
        }
    }
}

