/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.BasicMarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewFactory;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramSelectionModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramSelectionModel;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.process.FlowEdge;
import oracle.dbtools.crest.swingui.diagram.process.FlowView;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramUI;

public class AbstractDiagram
extends JComponent
implements CellViewFactory,
Scrollable,
Accessible,
Serializable {
    public static final int DOT_GRID_MODE = 0;
    public static final int CROSS_GRID_MODE = 1;
    public static final int LINE_GRID_MODE = 2;
    private static final String uiClassID = "DiagramUI";
    protected transient DiagramSelectionRedirector selectionRedirector;
    protected transient DiagramModel diagramModel;
    protected transient DiagramLayoutCache diagramLayoutCache;
    protected transient BasicMarqueeHandler marquee;
    protected transient DiagramSelectionModel selectionModel;
    protected double scale = 1.0;
    protected boolean antiAliased = false;
    protected boolean editable = true;
    protected boolean gridVisible = false;
    protected double gridSize = 10.0;
    protected int gridMode = 0;
    protected boolean portsVisible = false;
    protected boolean moveBelowZero = false;
    protected Color highlightColor = Color.green;
    protected Color handleColor;
    protected Color lockedHandleColor;
    protected Color marqueeColor;
    protected Color gridColor;
    protected boolean dragEnabled = false;
    protected boolean dropEnabled = true;
    protected int editClickCount = 2;
    protected boolean enabled = true;
    protected boolean gridEnabled = false;
    protected int handleSize = 3;
    protected int tolerance = 4;
    protected int minimumMove = 5;
    protected boolean selectNewCells = false;
    protected boolean disconnectOnMove = false;
    protected boolean moveable = true;
    protected boolean cloneable = false;
    protected boolean sizeable = true;
    protected boolean bendable = true;
    protected boolean connectable = true;
    protected boolean disconnectable = true;
    protected boolean invokesStopCellEditing;
    public static final String DIAGRAM_MODEL_PROPERTY = "model";
    public static final String DIAGRAM_LAYOUT_CACHE_PROPERTY = "view";
    public static final String MARQUEE_HANDLER_PROPERTY = "marquee";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String SCALE_PROPERTY = "scale";
    public static final String ANTIALIASED_PROPERTY = "antiAliased";
    public static final String GRID_SIZE_PROPERTY = "gridSize";
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    public static final String PORTS_VISIBLE_PROPERTY = "portsVisible";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    private boolean clearDetails = false;

    protected static DiagramLayoutCache createDefaultDiagramView(AbstractDiagram abstractDiagram) {
        return new DiagramLayoutCache(abstractDiagram);
    }

    public static Map createBounds(int n, int n2, Color color) {
        Map map = DiagramConstants.createMap();
        DiagramConstants.setBounds(map, DiagramConstants.createRect(n, n2, 90.0, 30.0));
        DiagramConstants.setBorder(map, BorderFactory.createRaisedBevelBorder());
        DiagramConstants.setBackground(map, color.darker());
        DiagramConstants.setForeground(map, Color.white);
        DiagramConstants.setFont(map, DiagramConstants.defaultFont.deriveFont(1, 12.0f));
        DiagramConstants.setOpaque(map, true);
        return map;
    }

    public AbstractDiagram() {
        this(null);
    }

    public AbstractDiagram(DiagramModel diagramModel) {
        this(diagramModel, (DiagramLayoutCache)null);
    }

    public AbstractDiagram(DiagramModel diagramModel, DiagramLayoutCache diagramLayoutCache) {
        this(diagramModel, diagramLayoutCache, new BasicMarqueeHandler());
    }

    public AbstractDiagram(DiagramModel diagramModel, BasicMarqueeHandler basicMarqueeHandler) {
        this(diagramModel, null, basicMarqueeHandler);
    }

    public AbstractDiagram(DiagramModel diagramModel, DiagramLayoutCache diagramLayoutCache, BasicMarqueeHandler basicMarqueeHandler) {
        this.selectionModel = new DefaultDiagramSelectionModel(this);
        this.setLayout(null);
        this.marquee = basicMarqueeHandler;
        if (diagramLayoutCache == null) {
            diagramLayoutCache = AbstractDiagram.createDefaultDiagramView(this);
        }
        this.setDiagramLayoutCache(diagramLayoutCache);
        this.updateUI();
        if (diagramModel == null) {
            diagramModel = new DefaultDiagramModel();
            this.setModel(diagramModel);
        } else {
            this.setModel(diagramModel);
        }
        this.setDoubleBuffered(true);
    }

    @Override
    public DiagramUI getUI() {
        return (DiagramUI)this.ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(DiagramUI diagramUI) {
        if ((DiagramUI)this.ui != diagramUI) {
            super.setUI(diagramUI);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new DefaultDiagramUI());
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Object[] getRoots() {
        return DefaultDiagramModel.getRoots(this.diagramModel);
    }

    public Object[] getRoots(Rectangle rectangle) {
        CellView[] cellViewArray = this.diagramLayoutCache.getRoots(rectangle);
        Object[] objectArray = new Object[cellViewArray.length];
        for (int i = 0; i < cellViewArray.length; ++i) {
            objectArray[i] = cellViewArray[i].getCell();
        }
        return objectArray;
    }

    public Object[] getDescendants(Object[] objectArray) {
        Set set = DefaultDiagramModel.getDescendants(this.getModel(), objectArray);
        return set.toArray();
    }

    public Object[] getDescendantList(Object[] objectArray) {
        return DefaultDiagramModel.getDescendantList(this.getModel(), objectArray).toArray();
    }

    public Map cloneCells(Object[] objectArray) {
        return this.diagramModel.cloneCells(objectArray);
    }

    public Object getFirstCellForLocation(double d, double d2) {
        return this.getNextCellForLocation(null, d, d2);
    }

    public Object getNextCellForLocation(Object object, double d, double d2) {
        CellView cellView = this.diagramLayoutCache.getMapping(object, false);
        CellView cellView2 = this.getNextViewAt(cellView, d /= this.scale, d2 /= this.scale);
        if (cellView2 != null) {
            return cellView2.getCell();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object object) {
        CellView cellView = this.diagramLayoutCache.getMapping(object, false);
        if (cellView != null) {
            return cellView.getBounds();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            Rectangle2D rectangle2D = DiagramConstants.createRect(this.getCellBounds(objectArray[0]));
            for (int i = 1; i < objectArray.length; ++i) {
                Rectangle2D rectangle2D2 = this.getCellBounds(objectArray[i]);
                if (rectangle2D2 == null) continue;
                if (rectangle2D == null) {
                    rectangle2D = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
                    continue;
                }
                Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
            }
            return rectangle2D;
        }
        return null;
    }

    public CellView getNextViewAt(CellView cellView, double d, double d2) {
        Object[] objectArray = this.diagramLayoutCache.order(this.getSelectionModel().getSelectables());
        CellView[] cellViewArray = this.diagramLayoutCache.getMapping(objectArray);
        CellView cellView2 = this.getNextViewAt(cellViewArray, cellView, d, d2);
        return cellView2;
    }

    public CellView getNextViewAt(CellView[] cellViewArray, CellView cellView, double d, double d2) {
        if (cellViewArray != null) {
            Rectangle2D rectangle2D = DiagramConstants.createRect(d - (double)this.tolerance, d2 - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            CellView cellView2 = null;
            boolean bl = cellView == null;
            Graphics graphics = this.getGraphics();
            for (int i = cellViewArray.length - 1; i >= 0; --i) {
                if (cellViewArray[i] == null || !cellViewArray[i].intersects(graphics, rectangle2D)) continue;
                if (bl && !this.selectionModel.isChildrenSelected(cellViewArray[i].getCell())) {
                    return cellViewArray[i];
                }
                if (cellView2 == null) {
                    cellView2 = cellViewArray[i];
                }
                bl |= cellViewArray[i] == cellView;
            }
            return cellView2;
        }
        return null;
    }

    public Object getPortForLocation(double d, double d2) {
        PortView portView = this.getPortViewAt(d, d2);
        if (portView != null) {
            return portView.getCell();
        }
        return null;
    }

    public PortView getPortViewAt(double d, double d2) {
        Rectangle2D rectangle2D = DiagramConstants.createRect(d - (double)this.tolerance, d2 - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
        PortView[] portViewArray = this.diagramLayoutCache.getPorts();
        for (int i = portViewArray.length - 1; i >= 0; --i) {
            if (portViewArray[i] == null || !portViewArray[i].intersects(this.getGraphics(), rectangle2D)) continue;
            return portViewArray[i];
        }
        return null;
    }

    public String convertValueToString(Object object) {
        CellView cellView;
        CellView cellView2 = cellView = object instanceof CellView ? (CellView)object : this.getDiagramLayoutCache().getMapping(object, false);
        if (cellView != null) {
            Object object2 = DiagramConstants.getValue(cellView.getAllAttributes());
            object = object2 != null ? object2 : cellView.getCell();
        }
        if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() != null) {
            return ((DefaultMutableTreeNode)object).getUserObject().toString();
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Point2D snap(Point2D point2D) {
        if (this.gridVisible && point2D != null) {
            double d = this.gridSize * this.getScale();
            double d2 = Math.round((double)Math.round(point2D.getX() / d) * d);
            double d3 = Math.round((double)Math.round(point2D.getY() / d) * d);
            point2D.setLocation(d2, d3);
        }
        return point2D;
    }

    public Dimension2D snap(Dimension2D dimension2D) {
        if (this.gridEnabled && dimension2D != null) {
            double d = this.gridSize * this.getScale();
            dimension2D.setSize(1L + Math.round((double)Math.round(dimension2D.getWidth() / d) * d), 1L + Math.round((double)Math.round(dimension2D.getHeight() / d) * d));
        }
        return dimension2D;
    }

    public Point2D toScreen(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        point2D.setLocation(Math.round(point2D.getX() * this.scale), (double)Math.round(point2D.getY()) * this.scale);
        return point2D;
    }

    public Point2D fromScreen(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        point2D.setLocation(Math.round(point2D.getX() / this.scale), (double)Math.round(point2D.getY()) / this.scale);
        return point2D;
    }

    public Rectangle2D toScreen(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        rectangle2D.setFrame(rectangle2D.getX() * this.scale, rectangle2D.getY() * this.scale, rectangle2D.getWidth() * this.scale, rectangle2D.getHeight() * this.scale);
        return rectangle2D;
    }

    public Rectangle2D fromScreen(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        rectangle2D.setFrame(rectangle2D.getX() / this.scale, rectangle2D.getY() / this.scale, rectangle2D.getWidth() / this.scale, rectangle2D.getHeight() / this.scale);
        return rectangle2D;
    }

    @Override
    public CellView createView(AbstractDiagram abstractDiagram, CellMapper cellMapper, Object object) {
        AbstractCellView abstractCellView = null;
        abstractCellView = abstractDiagram.getModel().isPort(object) ? this.createPortView(abstractDiagram, cellMapper, object) : (abstractDiagram.getModel().isEdge(object) ? this.createEdgeView(abstractDiagram, cellMapper, object) : this.createVertexView(abstractDiagram, cellMapper, object));
        cellMapper.putMapping(object, abstractCellView);
        abstractCellView.refresh(true);
        abstractCellView.update();
        return abstractCellView;
    }

    @Override
    public void updateAutoSize(AbstractDiagram abstractDiagram, CellView cellView) {
        Rectangle2D rectangle2D;
        if (cellView != null && !abstractDiagram.isEditing() && DiagramConstants.isAutoSize(cellView.getAllAttributes()) && (rectangle2D = cellView.getBounds()) != null) {
            Dimension2D dimension2D = abstractDiagram.getUI().getPreferredSize(abstractDiagram, cellView);
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
        }
    }

    protected EdgeView createEdgeView(AbstractDiagram abstractDiagram, CellMapper cellMapper, Object object) {
        if (object instanceof Edge) {
            if (object instanceof FlowEdge) {
                return new FlowView(object, abstractDiagram, cellMapper);
            }
            return this.createEdgeView(abstractDiagram, cellMapper, (Edge)object);
        }
        return new EdgeView(object, abstractDiagram, cellMapper);
    }

    protected PortView createPortView(AbstractDiagram abstractDiagram, CellMapper cellMapper, Object object) {
        if (object instanceof Port) {
            return this.createPortView(abstractDiagram, cellMapper, (Port)object);
        }
        return new PortView(object, abstractDiagram, cellMapper);
    }

    protected EdgeView createEdgeView(AbstractDiagram abstractDiagram, CellMapper cellMapper, Edge edge) {
        return new EdgeView(edge, abstractDiagram, cellMapper);
    }

    protected PortView createPortView(AbstractDiagram abstractDiagram, CellMapper cellMapper, Port port) {
        return new PortView(port, abstractDiagram, cellMapper);
    }

    protected AbstractCellView createVertexView(AbstractDiagram abstractDiagram, CellMapper cellMapper, Object object) {
        return new ContainerView(object, abstractDiagram, cellMapper);
    }

    public int getEditClickCount() {
        return this.editClickCount;
    }

    public void setEditClickCount(int n) {
        this.editClickCount = n;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean bl) {
        this.dropEnabled = bl;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean bl) {
        this.moveable = bl;
    }

    public boolean isBendable() {
        return this.bendable;
    }

    public void setBendable(boolean bl) {
        this.bendable = bl;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean bl) {
        this.connectable = bl;
    }

    public boolean isDisconnectable() {
        return this.disconnectable;
    }

    public void setDisconnectable(boolean bl) {
        this.disconnectable = bl;
    }

    public boolean isCloneable() {
        return this.cloneable;
    }

    public void setCloneable(boolean bl) {
        this.cloneable = bl;
    }

    public boolean isSizeable() {
        return this.sizeable;
    }

    public void setSizeable(boolean bl) {
        this.sizeable = bl;
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove && this.disconnectable;
    }

    public void setSelectNewCells(boolean bl) {
        this.selectNewCells = bl;
    }

    public boolean isSelectNewCells() {
        return this.selectNewCells;
    }

    public void setDisconnectOnMove(boolean bl) {
        this.disconnectOnMove = bl;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean bl) {
        this.gridEnabled = bl;
    }

    public boolean isMoveBelowZero() {
        return this.moveBelowZero;
    }

    public void setMoveBelowZero(boolean bl) {
        this.moveBelowZero = bl;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int n) {
        this.tolerance = n;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int n) {
        this.handleSize = n;
    }

    public int getMinimumMove() {
        return this.minimumMove;
    }

    public void setMinimumMove(int n) {
        this.minimumMove = n;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public Color getHandleColor() {
        return this.handleColor;
    }

    public void setHandleColor(Color color) {
        this.handleColor = color;
    }

    public Color getLockedHandleColor() {
        return this.lockedHandleColor;
    }

    public void setLockedHandleColor(Color color) {
        this.lockedHandleColor = color;
    }

    public Color getMarqueeColor() {
        return this.marqueeColor;
    }

    public void setMarqueeColor(Color color) {
        this.marqueeColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        if (d > 0.0) {
            double d2 = this.scale;
            this.scale = d;
            this.clearDetails = d < 0.4;
            this.firePropertyChange(SCALE_PROPERTY, d2, d);
        }
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public void setGridSize(double d) {
        double d2 = this.gridSize;
        this.gridSize = d;
        this.firePropertyChange(GRID_SIZE_PROPERTY, d2, d);
    }

    public void setGridMode(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.gridMode = n;
            this.repaint();
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        boolean bl2 = this.gridVisible;
        this.gridVisible = bl;
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean isPortsVisible() {
        return this.portsVisible;
    }

    public void setPortsVisible(boolean bl) {
        boolean bl2 = this.portsVisible;
        this.portsVisible = bl;
        this.firePropertyChange(PORTS_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean bl) {
        boolean bl2 = this.antiAliased;
        this.antiAliased = bl;
        this.firePropertyChange(ANTIALIASED_PROPERTY, bl2, bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, bl);
    }

    public DiagramModel getModel() {
        return this.diagramModel;
    }

    public void setModel(DiagramModel diagramModel) {
        DiagramModel diagramModel2 = this.diagramModel;
        this.diagramModel = diagramModel;
        this.firePropertyChange(DIAGRAM_MODEL_PROPERTY, diagramModel2, this.diagramModel);
        if (this.diagramLayoutCache != null && this.diagramLayoutCache.getModel() != this.diagramModel) {
            this.diagramLayoutCache.setModel(this.diagramModel);
        }
        this.invalidate();
    }

    public DiagramLayoutCache getDiagramLayoutCache() {
        return this.diagramLayoutCache;
    }

    public void setDiagramLayoutCache(DiagramLayoutCache diagramLayoutCache) {
        DiagramLayoutCache diagramLayoutCache2 = this.diagramLayoutCache;
        this.diagramLayoutCache = diagramLayoutCache;
        this.firePropertyChange(DIAGRAM_LAYOUT_CACHE_PROPERTY, diagramLayoutCache2, this.diagramLayoutCache);
        if (this.diagramLayoutCache != null && this.diagramLayoutCache.getModel() != this.getModel()) {
            this.diagramLayoutCache.setModel(this.getModel());
        }
        this.invalidate();
    }

    public BasicMarqueeHandler getMarqueeHandler() {
        return this.marquee;
    }

    public void setMarqueeHandler(BasicMarqueeHandler basicMarqueeHandler) {
        BasicMarqueeHandler basicMarqueeHandler2 = this.marquee;
        this.marquee = basicMarqueeHandler;
        this.firePropertyChange(MARQUEE_HANDLER_PROPERTY, basicMarqueeHandler2, basicMarqueeHandler);
        this.invalidate();
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean isCellEditable(Object object) {
        CellView cellView;
        if (object != null && (cellView = this.diagramLayoutCache.getMapping(object, false)) != null) {
            return this.isEditable() && DiagramConstants.isEditable(cellView.getAllAttributes());
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Object object = this.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (object instanceof DefaultDiagramCell && ((DefaultDiagramCell)object).getTopView() != null && ((DefaultDiagramCell)object).getTopView().getModel() != null) {
                if (object instanceof LabelDiagramCell) {
                    return ((Label)((DefaultDiagramCell)object).getTopView().getModel()).getText();
                }
                return ((DefaultDiagramCell)object).getTopView().getModel().getName();
            }
            String string = this.convertValueToString(object);
            return string != null && string.length() > 0 ? string : null;
        }
        return null;
    }

    public void setSelectionModel(DiagramSelectionModel diagramSelectionModel) {
        if (diagramSelectionModel == null) {
            diagramSelectionModel = EmptySelectionModel.sharedInstance();
        }
        DiagramSelectionModel diagramSelectionModel2 = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeDiagramSelectionListener(this.selectionRedirector);
        }
        this.selectionModel = diagramSelectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addDiagramSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, diagramSelectionModel2, this.selectionModel);
    }

    public DiagramSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void clearSelection() {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().clearSelection();
        }
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addDiagramSelectionListener(DiagramSelectionListener diagramSelectionListener) {
        this.listenerList.add(DiagramSelectionListener.class, diagramSelectionListener);
        if (this.listenerList.getListenerCount(DiagramSelectionListener.class) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new DiagramSelectionRedirector();
            this.selectionModel.addDiagramSelectionListener(this.selectionRedirector);
        }
    }

    public void removeDiagramSelectionListener(DiagramSelectionListener diagramSelectionListener) {
        this.listenerList.remove(DiagramSelectionListener.class, diagramSelectionListener);
        if (this.listenerList.getListenerCount(DiagramSelectionListener.class) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeDiagramSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    protected void fireValueChanged(DiagramSelectionEvent diagramSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DiagramSelectionListener.class) continue;
            ((DiagramSelectionListener)objectArray[i + 1]).valueChanged(diagramSelectionEvent);
        }
    }

    public void setSelectionCell(Object object) {
        this.getSelectionModel().setSelectionCell(object);
    }

    public void setSelectionCells(Object[] objectArray) {
        this.getSelectionModel().setSelectionCells(objectArray);
    }

    public void addSelectionCell(Object object) {
        this.getSelectionModel().addSelectionCell(object);
    }

    public void addSelectionCells(Object[] objectArray) {
        this.getSelectionModel().addSelectionCells(objectArray);
    }

    public void removeSelectionCell(Object object) {
        this.getSelectionModel().removeSelectionCell(object);
    }

    public Object getSelectionCell() {
        return this.getSelectionModel().getSelectionCell();
    }

    public Object[] getSelectionCells() {
        return this.getSelectionModel().getSelectionCells();
    }

    public int getSelectionCount() {
        return this.getSelectionModel().getSelectionCount();
    }

    public boolean isCellSelected(Object object) {
        return this.getSelectionModel().isCellSelected(object);
    }

    public void scrollCellToVisible(Object object) {
        Rectangle2D rectangle2D = this.getCellBounds(object);
        if (rectangle2D != null) {
            Rectangle2D rectangle2D2 = this.toScreen((Rectangle2D)rectangle2D.clone());
            this.scrollRectToVisible(new Rectangle((int)rectangle2D2.getX(), (int)rectangle2D2.getY(), (int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight()));
        }
    }

    public void scrollPointToVisible(Point2D point2D) {
        if (point2D != null) {
            this.scrollRectToVisible(new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1));
        }
    }

    public boolean isEditing() {
        DiagramUI diagramUI = this.getUI();
        if (diagramUI != null) {
            return diagramUI.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        DiagramUI diagramUI = this.getUI();
        if (diagramUI != null) {
            return diagramUI.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        DiagramUI diagramUI = this.getUI();
        if (diagramUI != null) {
            diagramUI.cancelEditing(this);
        }
    }

    public void startEditingAtCell(Object object) {
        DiagramUI diagramUI = this.getUI();
        if (diagramUI != null) {
            diagramUI.startEditingAtCell(this, object);
        }
    }

    public Object getEditingCell() {
        DiagramUI diagramUI = this.getUI();
        if (diagramUI != null) {
            return diagramUI.getEditingCell(this);
        }
        return null;
    }

    public void diagramDidChange() {
        this.revalidate();
        this.repaint();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.diagramModel instanceof Serializable) {
            vector.addElement("diagramModel");
            vector.addElement(this.diagramModel);
        }
        if (this.diagramLayoutCache instanceof Serializable) {
            vector.addElement("diagramLayoutCache");
            vector.addElement(this.diagramLayoutCache);
        }
        if (this.selectionModel instanceof Serializable) {
            vector.addElement(SELECTION_MODEL_PROPERTY);
            vector.addElement(this.selectionModel);
        }
        objectOutputStream.writeObject(vector);
        if (this.getUIClassID().equals(uiClassID) && this.ui != null) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("diagramModel")) {
            this.diagramModel = (DiagramModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("diagramLayoutCache")) {
            this.diagramLayoutCache = (DiagramLayoutCache)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (DiagramSelectionModel)vector.elementAt(++n);
            ++n;
        }
        if (this.listenerList.getListenerCount(DiagramSelectionListener.class) != 0) {
            this.selectionRedirector = new DiagramSelectionRedirector();
            this.selectionModel.addDiagramSelectionListener(this.selectionRedirector);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return 20;
        }
        return 40;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    protected String paramString() {
        String string = this.editable ? "true" : "false";
        String string2 = this.invokesStopCellEditing ? "true" : "false";
        return super.paramString() + ",editable=" + string + ",invokesStopCellEditing=" + string2;
    }

    public boolean isGroup(Object object) {
        CellView cellView = this.getDiagramLayoutCache().getMapping(object, false);
        if (cellView != null) {
            return !cellView.isLeaf();
        }
        return false;
    }

    public boolean isVertex(Object object) {
        if (!(object instanceof Port) && !(object instanceof Edge)) {
            return !this.isGroup(object) && object != null;
        }
        return false;
    }

    public boolean isPort(Object object) {
        return object instanceof Port;
    }

    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    public boolean clearDetails() {
        return this.clearDetails;
    }

    protected class DiagramSelectionRedirector
    implements Serializable,
    DiagramSelectionListener {
        protected DiagramSelectionRedirector() {
        }

        @Override
        public void valueChanged(DiagramSelectionEvent diagramSelectionEvent) {
            DiagramSelectionEvent diagramSelectionEvent2 = (DiagramSelectionEvent)diagramSelectionEvent.cloneWithSource(AbstractDiagram.this);
            AbstractDiagram.this.fireValueChanged(diagramSelectionEvent2);
        }
    }

    public static class EmptySelectionModel
    extends DefaultDiagramSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public EmptySelectionModel() {
            super(null);
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        @Override
        public void setSelectionCells(Object[] objectArray) {
        }

        @Override
        public void addSelectionCells(Object[] objectArray) {
        }

        @Override
        public void removeSelectionCells(Object[] objectArray) {
        }
    }
}

