/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.RuleNode;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.CheckResultComponent;
import oracle.dbtools.crest.swingui.designrules.DRMCellRenderer;
import oracle.dbtools.crest.swingui.designrules.DesignRuleManagerTreeModel;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSetPropertiesDialog;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class DesignRuleView
extends CustomDialog
implements ActionListener {
    private static final long serialVersionUID = 8407946894969410152L;
    private static final String RULESET_NAME = "RuleSet";
    private CheckResultComponent checkResultComponent;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private DesignRuleManagerTreeModel treeModel;
    private JTree jtree;
    private JDialog dialog;
    private RelationalDesign relDesign;
    private Action applySelectedAction;
    private JPanel mainPanel;
    private JPanel designRulesPanel;
    private int cgCounter = 0;
    public List<DesignRuleSet> ruleSetsContainerList;
    private JTable ruleSetsTable;
    private JButton btnAddRuleSet;
    private JButton btnRemoveRuleSet;
    private JButton btnProperties;
    private DesignRuleSet currentRuleSet;
    protected static Settings settings;
    private JButton bnApplySelectedRuleSets;
    private JButton bnApplyAllRuleSets;
    private JButton bnApplySelected;
    public JButton bnSaveRuleSets;
    private ApplicationView appView;
    private DesignRuleView drv;
    private JSplitPane splitPane;
    private ArrayList<DesignRule> allDesignRules = new ArrayList();
    private JTabbedPane tpane;
    private JPanel buttonPanel;
    public boolean ruleSetsSaved = true;
    private JButton bnApplyAll;

    public DesignRuleView(ApplicationView applicationView, RelationalDesign relationalDesign, DataFlowDesign dataFlowDesign) {
        super(applicationView);
        this.appView = applicationView;
        this.relDesign = relationalDesign;
        this.drv = this;
        this.setLayout(new BorderLayout());
        if (settings == null) {
            settings = this.getApplicationView().getSettings();
        }
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    public void close(Window window) {
        this.getDesign().getDLSettings().getNamingStandardRule().clearGlossaries();
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        settings.setDialogSettings(this.getClass().getName(), rectangle);
        this.nullifyDesignRuleManager();
        window.dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_RULES_DIALOG";
    }

    public DesignRuleManager getRuleManager() {
        return this.getDesign().getAppView().getDesignRuleManager(this.relDesign);
    }

    public CheckResultComponent getCheckResultComponent() {
        if (this.checkResultComponent == null) {
            this.checkResultComponent = new CheckResultComponent(this.appView);
        }
        return this.checkResultComponent;
    }

    public DesignRuleManagerTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new DesignRuleManagerTreeModel(this.getRuleManager());
            this.getRuleManager().addUpdateListener(this.treeModel);
        }
        return this.treeModel;
    }

    public JTree getJTree() {
        if (this.jtree == null) {
            this.jtree = new JTree(this.getTreeModel());
            this.jtree.setRootVisible(true);
            this.jtree.addTreeSelectionListener(new TreeListener());
            this.jtree.setCellRenderer(new DRMCellRenderer());
        }
        return this.jtree;
    }

    public Action createExpandAll() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.ExpandAll")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < DesignRuleView.this.getJTree().getRowCount(); ++i) {
                    DesignRuleView.this.getJTree().expandRow(i);
                }
            }
        };
        return abstractAction;
    }

    public Action createCollapseAll() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.CollapseAll")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = DesignRuleView.this.getJTree().getRowCount(); i >= 1; --i) {
                    DesignRuleView.this.getJTree().collapseRow(i);
                }
            }
        };
        return abstractAction;
    }

    public Action createApplyAllRules() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.ApplyAll")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignRuleView.this.setCheckResults(DesignRuleView.this.getRuleManager().applyRulesToSubject(), DesignRuleView.this.getRuleManager().res);
            }
        };
        return abstractAction;
    }

    public Action closeAction() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.Close")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DesignRuleView.this.canClose()) {
                    DesignRuleView.this.close();
                }
            }
        };
        return abstractAction;
    }

    public Action createApplySelectedRules() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.ApplySelected")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                List list = DesignRuleView.this.getSelectedRuleHandlers();
                if (list.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    for (Object e : list) {
                        RuleNode ruleNode;
                        if (e instanceof RuleHandler) {
                            ruleNode = (RuleHandler)e;
                            ((RuleHandler)ruleNode).hasEvalErr = false;
                            ((RuleHandler)ruleNode).applyRulesToSubject(arrayList);
                            if (!((RuleHandler)ruleNode).hasEvalErr) continue;
                            bl = true;
                            break;
                        }
                        if (!(e instanceof DesignRule)) continue;
                        ruleNode = (DesignRule)e;
                        RuleHandler ruleHandler = ((DesignRule)ruleNode).getRuleHandler();
                        ruleHandler.hasEvalErr = false;
                        ruleHandler.applyRule(arrayList, (DesignRule)ruleNode);
                        if (!ruleHandler.hasEvalErr) continue;
                        bl = true;
                        break;
                    }
                    DesignRuleView.this.setCheckResults(arrayList, bl);
                }
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    public Action createApplySelectedRuleSets() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.ApplySelecteRuleSet")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                ArrayList arrayList = new ArrayList();
                int[] nArray = DesignRuleView.this.ruleSetsTable.getSelectedRows();
                block0: for (int i = 0; i < nArray.length; ++i) {
                    DesignRuleSet designRuleSet = DesignRuleView.this.ruleSetsContainerList.get(nArray[i]);
                    for (DesignRule designRule : designRuleSet.getDesignRules()) {
                        RuleHandler ruleHandler = designRule.getRuleHandler();
                        ruleHandler.hasEvalErr = false;
                        ruleHandler.applyRule(arrayList, designRule);
                        if (!ruleHandler.hasEvalErr) continue;
                        bl = true;
                        continue block0;
                    }
                }
                DesignRuleView.this.setCheckResults(arrayList, bl);
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    public Action createApplyAllRuleSets() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.ApplyAllRS")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                ArrayList arrayList = new ArrayList();
                block0: for (DesignRuleSet designRuleSet : DesignRuleView.this.ruleSetsContainerList) {
                    for (DesignRule designRule : designRuleSet.getDesignRules()) {
                        RuleHandler ruleHandler = designRule.getRuleHandler();
                        ruleHandler.hasEvalErr = false;
                        ruleHandler.applyRule(arrayList, designRule);
                        if (!ruleHandler.hasEvalErr) continue;
                        bl = true;
                        continue block0;
                    }
                }
                DesignRuleView.this.setCheckResults(arrayList, bl);
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    public void setCheckResults(Collection collection, boolean bl) {
        this.getCheckResultComponent().clearCheckResults();
        if (collection.size() > 0) {
            this.getCheckResultComponent().add(collection.toArray(new CheckResult[0]));
            this.getCheckResultComponent().bnSaveCSV.setEnabled(true);
            this.getCheckResultComponent().bnClearAll.setEnabled(true);
        } else if (!bl) {
            JOptionPane.showMessageDialog(this, Messages.getString("DesignRuleView.CheckDesignOK"));
        }
    }

    public List getSelectedRuleHandlers() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreePath[] treePathArray = this.getJTree().getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                Object object = treePathArray[i].getLastPathComponent();
                if (!(object instanceof RuleHandler) && !(object instanceof DesignRule)) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DesignRuleView.DesignRules"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 800);
            this.dialog.setModal(true);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.mainPanel);
            this.tpane = new JTabbedPane();
            this.tpane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DesignRuleView.this.showHideButtons();
                }
            });
            this.designRulesPanel = new JPanel();
            this.designRulesPanel.setLayout(new BorderLayout());
            this.designRulesPanel.add((Component)this.tpane, "East");
            this.mainPanel.add((Component)this.designRulesPanel, "Center");
            this.initTreeDesignRules();
            this.initCustomDesignRuleSets();
            this.setDefaultActions(this.dialog);
            Rectangle rectangle = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (rectangle == null) {
                this.dialog.setSize(800, 800);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                this.dialog.setSize(rectangle.getSize());
                this.dialog.setLocation(rectangle.getLocation());
            }
        }
        return this.dialog;
    }

    public Window getDialog(Dialog dialog) {
        if (this.dialog == null) {
            this.dialog = new JDialog(dialog, Messages.getString("DesignRuleView.DesignRules"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 800);
            this.dialog.setModal(true);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.mainPanel);
            this.tpane = new JTabbedPane();
            this.tpane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DesignRuleView.this.showHideButtons();
                }
            });
            this.designRulesPanel = new JPanel();
            this.designRulesPanel.setLayout(new BorderLayout());
            this.designRulesPanel.add((Component)this.tpane, "East");
            this.mainPanel.add((Component)this.designRulesPanel, "Center");
            this.initTreeDesignRules();
            this.initCustomDesignRuleSets();
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    DesignRuleView.this.close();
                }
            });
            this.setDefaultActions(this.dialog);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public RelationalDesign getRelDesign() {
        return this.relDesign;
    }

    public void setRelDesign(RelationalDesign relationalDesign) {
        this.relDesign = relationalDesign;
        this.getRuleManager().setRelDesign(relationalDesign);
    }

    public void setDataFlowDesign(DataFlowDesign dataFlowDesign) {
        this.getRuleManager().setDataFlowDesign(dataFlowDesign);
    }

    private void initCustomDesignRuleSets() {
        this.initRuleSets();
        Iterator<DesignRuleSet> iterator = settings.getDesignRuleSets().iterator();
        while (iterator.hasNext()) {
            DesignRuleSet designRuleSet = iterator.next().copy();
            this.ruleSetsContainerList.add(designRuleSet);
        }
        this.bnApplyAllRuleSets.setEnabled(this.ruleSetsContainerList.size() > 0);
    }

    private void initRuleSets() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.ruleSetsContainerList = new ArrayList<DesignRuleSet>();
        this.ruleSetsTable = new JTable(new RuleSetTableModel());
        TableColumn tableColumn = this.ruleSetsTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(30);
        tableColumn.setMaxWidth(30);
        JTextField jTextField = new JTextField();
        TableColumn tableColumn2 = this.ruleSetsTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(300);
        tableColumn2.setMaxWidth(1000);
        tableColumn2.setCellEditor(new TFCellEditor(jTextField));
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                DesignRuleView.this.ruleSetsSaved = false;
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
            }
        });
        this.ruleSetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DesignRuleView.this.ruleSetsTable.getSelectedRow() == -1) {
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(false);
                } else {
                    DesignRuleView.this.currentRuleSet = ((RuleSetTableModel)DesignRuleView.this.ruleSetsTable.getModel()).getRuleSetList().get(DesignRuleView.this.ruleSetsTable.getSelectedRow());
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(true);
                }
            }
        });
        this.ruleSetsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DesignRuleView.this.stopCellediting();
                    DesignRuleSetPropertiesDialog designRuleSetPropertiesDialog = new DesignRuleSetPropertiesDialog(DesignRuleView.this.appView, DesignRuleView.this.currentRuleSet, DesignRuleView.this.drv);
                    designRuleSetPropertiesDialog.showDialog();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.ruleSetsTable);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.bnSaveRuleSets = new JButton(this.createSaveRuleSets());
        this.bnSaveRuleSets.setToolTipText(Messages.getString("DesignRuleView.SaveRuleSets"));
        this.bnSaveRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnSaveRuleSets);
        jPanel.add((Component)this.createRuleSetToolbarPanel(this.ruleSetsTable), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.tpane.addTab(Messages.getString("DesignRuleView.RuleSets"), jPanel);
    }

    private void initTreeDesignRules() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(this.createExpandAll());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jButton.setToolTipText(Messages.getString("DesignRuleView.ExpandAllT"));
        jButton.setMnemonic(69);
        JButton jButton2 = new JButton(this.createCollapseAll());
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jButton2.setToolTipText(Messages.getString("DesignRuleView.CollapseAllT"));
        jButton2.setMnemonic(79);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(new JScrollPane(this.getJTree()));
        this.splitPane = new JSplitPane(1, this.tpane, this.getCheckResultComponent());
        this.splitPane.setDividerLocation(350);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.bnApplyAll = new JButton(this.createApplyAllRules());
        this.bnApplyAll.setToolTipText(Messages.getString("DesignRuleView.ApplyAllDesignRules"));
        this.bnApplyAll.setMnemonic(65);
        this.applySelectedAction = this.createApplySelectedRules();
        this.bnApplySelected = new JButton(this.applySelectedAction);
        this.bnApplySelected.setToolTipText(Messages.getString("DesignRuleView.ApplyTreeSelectedDesignRules"));
        this.bnApplySelected.setMnemonic(83);
        this.bnApplySelectedRuleSets = new JButton(this.createApplySelectedRuleSets());
        this.bnApplySelectedRuleSets.setMnemonic(69);
        this.bnApplySelectedRuleSets.setToolTipText(Messages.getString("DesignRuleView.ApplySelectedRuleSets"));
        this.bnApplyAllRuleSets = new JButton(this.createApplyAllRuleSets());
        this.bnApplyAllRuleSets.setMnemonic(80);
        this.bnApplyAllRuleSets.setToolTipText(Messages.getString("DesignRuleView.ApplyAllRuleSets"));
        JButton jButton3 = new JButton(this.closeAction());
        jButton3.setToolTipText(Messages.getString("DesignRuleView.CloseDialog"));
        jButton3.setMnemonic(67);
        JButton jButton4 = new JButton(this.getHelpAction());
        jButton4.setToolTipText(Messages.getString("DesignRuleView.Help"));
        jButton4.setMnemonic(72);
        this.bnApplyAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnApplySelected.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        this.bnApplySelectedRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        this.bnApplyAllRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton4.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonPanel.add(this.bnApplyAll);
        this.buttonPanel.add(this.bnApplyAllRuleSets);
        this.buttonPanel.add(this.bnApplySelected);
        this.buttonPanel.add(this.bnApplySelectedRuleSets);
        this.buttonPanel.add(jButton3);
        this.buttonPanel.add(jButton4);
        this.designRulesPanel.add((Component)this.buttonPanel, "South");
        this.designRulesPanel.add((Component)this.splitPane, "Center");
        this.tpane.addTab(Messages.getString("DesignRuleView.DesignRules"), jPanel);
        this.getDesign().getDLSettings().getNamingStandardRule().clearGlossaries();
    }

    protected JPanel createRuleSetToolbarPanel(JTable jTable) {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        this.btnAddRuleSet = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddRuleSet.setToolTipText(Messages.getString("DesignRuleView.AddRuleSet"));
        this.btnAddRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignRuleSet designRuleSet = new DesignRuleSet(DesignRuleView.this.generateRuleSetName(), null);
                DesignRuleView.this.ruleSetsContainerList.add(designRuleSet);
                DesignRuleView.this.ruleSetsTable.updateUI();
                DesignRuleView.this.ruleSetsTable.getSelectionModel().setSelectionInterval(DesignRuleView.this.ruleSetsTable.getRowCount() - 1, DesignRuleView.this.ruleSetsTable.getRowCount() - 1);
                DesignRuleView.this.currentRuleSet = ((RuleSetTableModel)DesignRuleView.this.ruleSetsTable.getModel()).getRuleSetList().get(DesignRuleView.this.ruleSetsTable.getSelectedRow());
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
                DesignRuleView.this.bnApplyAllRuleSets.setEnabled(true);
                DesignRuleView.this.ruleSetsSaved = false;
                DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                DesignRuleView.this.btnProperties.setEnabled(true);
            }
        });
        this.btnRemoveRuleSet = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveRuleSet.setToolTipText(Messages.getString("DesignRuleView.RemoveRuleSet"));
        this.btnRemoveRuleSet.setEnabled(false);
        this.btnRemoveRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DesignRuleView.this.ruleSetsTable.getSelectedRow();
                DesignRuleView.this.ruleSetsContainerList.remove(n);
                if (DesignRuleView.this.ruleSetsContainerList.size() > 0) {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                    DesignRuleView.this.ruleSetsTable.getSelectionModel().setSelectionInterval(0, 0);
                    DesignRuleView.this.currentRuleSet = ((RuleSetTableModel)DesignRuleView.this.ruleSetsTable.getModel()).getRuleSetList().get(DesignRuleView.this.ruleSetsTable.getSelectedRow());
                    DesignRuleView.this.bnApplyAllRuleSets.setEnabled(true);
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(true);
                } else {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(false);
                    DesignRuleView.this.btnProperties.setEnabled(false);
                    DesignRuleView.this.bnApplyAllRuleSets.setEnabled(false);
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(false);
                }
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
                DesignRuleView.this.ruleSetsSaved = false;
                DesignRuleView.this.ruleSetsTable.updateUI();
            }
        });
        this.btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", 16));
        this.btnProperties.setToolTipText(Messages.getString("DesignRuleView.RuleSetProperties"));
        this.btnProperties.setEnabled(false);
        this.btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DesignRuleView.this.ruleSetsTable.getSelectedRow();
                if (n != -1) {
                    DesignRuleView.this.stopCellediting();
                    DesignRuleSetPropertiesDialog designRuleSetPropertiesDialog = new DesignRuleSetPropertiesDialog(DesignRuleView.this.appView, DesignRuleView.this.currentRuleSet, DesignRuleView.this.drv);
                    designRuleSetPropertiesDialog.showDialog();
                }
            }
        });
        this.ruleSetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DesignRuleView.this.ruleSetsTable.getSelectedRow() == -1) {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(false);
                    DesignRuleView.this.btnProperties.setEnabled(false);
                } else {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                    DesignRuleView.this.btnProperties.setEnabled(true);
                }
            }
        });
        if (ApplicationView.IS_VIEWER) {
            this.btnAddRuleSet.setEnabled(false);
            this.btnRemoveRuleSet.setEnabled(false);
        }
        jToolBar.add(this.btnAddRuleSet);
        jToolBar.add(this.btnRemoveRuleSet);
        jToolBar.add(this.btnProperties);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        jPanel.add(jToolBar);
        return jPanel;
    }

    private void stopCellediting() {
        TableCellEditor tableCellEditor = this.ruleSetsTable.getCellEditor();
        if (tableCellEditor != null) {
            this.ruleSetsTable.getCellEditor().stopCellEditing();
        }
    }

    protected String generateRuleSetName() {
        String string = RULESET_NAME;
        int n = 0;
        int n2 = this.drv.ruleSetsContainerList.size();
        if (n2 != 0) {
            n = this.cgCounter = n2 + 1;
        } else {
            ++this.cgCounter;
            n = this.cgCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.ruleSetExists(string2)) {
            n = ++this.cgCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean ruleSetExists(String string) {
        for (int i = 0; i < this.drv.ruleSetsContainerList.size(); ++i) {
            DesignRuleSet designRuleSet = this.drv.ruleSetsContainerList.get(i);
            if (!string.equalsIgnoreCase(designRuleSet.getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<DesignRule> getAllDesignRules() {
        DesignRule designRule;
        int n;
        RuleHandler ruleHandler;
        int n2;
        this.allDesignRules.clear();
        DesignRuleManager designRuleManager = this.getRuleManager();
        RuleHandler ruleHandler2 = designRuleManager.getGeneralRuleHandler();
        RuleHandler ruleHandler3 = designRuleManager.getRelationalRuleHandler();
        RuleHandler ruleHandler4 = designRuleManager.getLogicalRuleHandler();
        RuleHandler ruleHandler5 = designRuleManager.getProcessModelRuleHandler();
        for (n2 = 0; n2 <= ruleHandler2.size() - 1; ++n2) {
            ruleHandler = (RuleHandler)ruleHandler2.getElement(n2);
            for (n = 0; n <= ruleHandler.size() - 1; ++n) {
                designRule = (DesignRule)ruleHandler.getElement(n);
                this.allDesignRules.add(designRule);
            }
        }
        if (this.relDesign != null) {
            for (n2 = 0; n2 <= ruleHandler3.size() - 1; ++n2) {
                ruleHandler = (RuleHandler)ruleHandler3.getElement(n2);
                for (n = 0; n <= ruleHandler.size() - 1; ++n) {
                    designRule = (DesignRule)ruleHandler.getElement(n);
                    this.allDesignRules.add(designRule);
                }
            }
        }
        for (n2 = 0; n2 <= ruleHandler4.size() - 1; ++n2) {
            ruleHandler = (RuleHandler)ruleHandler4.getElement(n2);
            for (n = 0; n <= ruleHandler.size() - 1; ++n) {
                designRule = (DesignRule)ruleHandler.getElement(n);
                this.allDesignRules.add(designRule);
            }
        }
        for (n2 = 0; n2 <= ruleHandler5.size() - 1; ++n2) {
            ruleHandler = (RuleHandler)ruleHandler5.getElement(n2);
            for (n = 0; n <= ruleHandler.size() - 1; ++n) {
                designRule = (DesignRule)ruleHandler.getElement(n);
                this.allDesignRules.add(designRule);
            }
        }
        return this.allDesignRules;
    }

    private void showHideButtons() {
        if (this.tpane.getSelectedIndex() == 0) {
            this.bnApplySelected.setVisible(true);
            this.bnApplySelectedRuleSets.setVisible(false);
            this.bnApplyAllRuleSets.setVisible(false);
            this.bnApplyAll.setVisible(true);
        } else if (this.tpane.getSelectedIndex() == 1) {
            this.bnApplySelected.setVisible(false);
            this.bnApplySelectedRuleSets.setVisible(true);
            this.bnApplyAllRuleSets.setVisible(true);
            this.bnApplyAll.setVisible(false);
        }
    }

    @Override
    protected boolean canClose() {
        if (!this.ruleSetsSaved) {
            String string = Messages.getString("DesignRuleView.Yes");
            String string2 = Messages.getString("DesignRuleView.No");
            Object[] objectArray = new Object[]{string, string2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("DesignRuleView.RuleSetsNotSaved"), Messages.getString("DesignRuleView.CloseConfirmation"), 0, 3, null, objectArray, string);
            return n == 0;
        }
        return true;
    }

    public Action createSaveRuleSets() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DesignRuleView.Save")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignRuleView.this.stopCellediting();
                settings.getDesignRuleSets().clear();
                settings.getDesignRuleSets().addAll(DesignRuleView.this.ruleSetsContainerList);
                DesignRuleView.this.bnSaveRuleSets.setEnabled(false);
                DesignRuleView.this.ruleSetsSaved = true;
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void nullifyDesignRuleManager() {
        this.getDesign().getAppView().nullifyDesignRuleManager();
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField jTextField) {
            super(jTextField);
            this.tf = jTextField;
            jTextField.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tf.setText(object.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = jTable;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            String string = jTextField.getText().trim();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(null, Messages.getString("DesignRuleView.NameEmpty"), Messages.getString("DesignRuleView.DesignRuleView.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
            TableModel tableModel = this.tab.getModel();
            for (DesignRuleSet designRuleSet : ((RuleSetTableModel)tableModel).getRuleSetList()) {
                if (!designRuleSet.getName().equals(string) || string.equals(this.val)) continue;
                JOptionPane.showMessageDialog(null, Messages.getString("DesignRuleView.NameExists"), Messages.getString("DesignRuleView.DesignRuleView.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
            return super.stopCellEditing();
        }
    }

    class RuleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 6102267778062841713L;

        RuleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DesignRule designRule = (DesignRule)object;
            this.setText(designRule.getName());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class RuleSetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2214015596642439352L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("DesignRuleView.DesignRuleView.Name")};

        private RuleSetTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleView.this.ruleSetsContainerList.size();
        }

        public List<DesignRuleSet> getRuleSetList() {
            return DesignRuleView.this.ruleSetsContainerList;
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignRuleSet designRuleSet = DesignRuleView.this.ruleSetsContainerList.get(n);
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return designRuleSet.getName();
            }
            return n + 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DesignRuleSet designRuleSet = DesignRuleView.this.ruleSetsContainerList.get(n);
            if (n2 == 1) {
                designRuleSet.setName(object.toString());
            }
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DesignRuleView.this.applySelectedAction.setEnabled(treeSelectionEvent.getPath() != null);
        }
    }
}

