/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.swingui.transformations.ApplyCustomTransformation;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomTransformationsManager
extends CustomDialog {
    private static final long serialVersionUID = 908911503909816768L;
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private final String NAME = "Tr";
    String MODEL = "model";
    private JDialog dialog;
    private DesignPart dp;
    public List<DRCustomScript> customTransformationsContainerList;
    private JTable customTransformationsTable;
    public JButton bnSave;
    public JButton bnApply;
    public JButton bnClose;
    private JButton bnImport;
    private JButton bnExport;
    private JButton btnAddCustomTransformation;
    private JButton btnRemoveCustomTransformation;
    private DRCustomScript currentTransformation;
    private int cgCounter = 0;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JSplitPane mainPanel;
    private boolean saved = true;
    private JTextArea scriptEditor;
    private ApplicationView appView;
    private ScriptEngineManager scriptEngineManager;
    private JComboBox cbMethod = new JComboBox();
    private JComboBox cbLibrary;
    private File file;
    private boolean autoChanged = false;
    private JComboBox obCombo;
    private JComboBox engCombo;
    private ArrayList allEngines;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    private ArrayList<DRCustomScript> allCR;
    private static final Logger LOGGER = new Logger(CustomTransformationsManager.class);

    public CustomTransformationsManager(ApplicationView applicationView, DesignPart designPart, ScriptEngineManager scriptEngineManager) {
        super(applicationView);
        this.appView = applicationView;
        this.dp = designPart;
        this.scriptEngineManager = scriptEngineManager;
        UIManager.put("TextArea.inactiveForeground", Color.BLACK);
        this.allEngines = applicationView.getScriptEngines();
        this.allCR = applicationView.getCustomDesignRules();
        this.init();
        this.loadCustomTS();
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomTransformationsManager.Script")));
        this.mainPanel = new JSplitPane(0, jPanel, jPanel2);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.setDividerLocation(200);
        this.customTransformationsContainerList = new ArrayList<DRCustomScript>();
        this.customTransformationsTable = new JTable(new CustomTransformationModel());
        this.customTransformationsTable.setSelectionMode(0);
        this.customTransformationsTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        TableColumn tableColumn = this.customTransformationsTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(30);
        tableColumn.setMaxWidth(30);
        JTextField jTextField = new JTextField();
        TableColumn tableColumn2 = this.customTransformationsTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(220);
        tableColumn2.setMaxWidth(1000);
        tableColumn2.setCellEditor(new TFCellEditor(jTextField));
        this.obCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getObjecTypes().toArray()));
        TableColumn tableColumn3 = this.customTransformationsTable.getColumnModel().getColumn(2);
        tableColumn3.setWidth(120);
        tableColumn3.setMaxWidth(120);
        tableColumn3.setCellEditor(new DefaultCellEditor(this.obCombo));
        this.engCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.appView.getScriptEngines().toArray()));
        TableColumn tableColumn4 = this.customTransformationsTable.getColumnModel().getColumn(3);
        tableColumn4.setWidth(300);
        tableColumn4.setMaxWidth(300);
        tableColumn4.setCellEditor(new DefaultCellEditor(this.engCombo));
        TableColumn tableColumn5 = this.customTransformationsTable.getColumnModel().getColumn(4);
        tableColumn5.setWidth(100);
        tableColumn5.setMaxWidth(100);
        TableColumn tableColumn6 = this.customTransformationsTable.getColumnModel().getColumn(5);
        this.customTransformationsTable.getColumnModel().removeColumn(tableColumn6);
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CustomTransformationsManager.this.saved = false;
                CustomTransformationsManager.this.bnSave.setEnabled(true);
            }
        });
        this.obCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)CustomTransformationsManager.this.customTransformationsTable.getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 2);
                String string2 = (String)CustomTransformationsManager.this.obCombo.getSelectedItem();
                if (string != null && string2 != null && !string.equals(string2)) {
                    CustomTransformationsManager.this.bnSave.setEnabled(true);
                    CustomTransformationsManager.this.saved = false;
                }
            }
        });
        this.engCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)CustomTransformationsManager.this.customTransformationsTable.getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 3);
                String string2 = (String)CustomTransformationsManager.this.engCombo.getSelectedItem();
                if (string != null && string2 != null && !string.equals(string2)) {
                    CustomTransformationsManager.this.bnSave.setEnabled(true);
                    CustomTransformationsManager.this.saved = false;
                }
            }
        });
        this.customTransformationsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CustomTransformationsManager.this.customTransformationsTable.getSelectedRow();
                if (n == -1) {
                    CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(false);
                    CustomTransformationsManager.this.scriptEditor.setEnabled(false);
                } else {
                    if (CustomTransformationsManager.this.currentTransformation != null) {
                        CustomTransformationsManager.this.currentTransformation.setScript(CustomTransformationsManager.this.scriptEditor.getText());
                        CustomTransformationsManager.this.currentTransformation.setFunction((String)CustomTransformationsManager.this.cbMethod.getSelectedItem());
                        for (DRLibrary dRLibrary : CustomTransformationsManager.this.appView.getCustomLibraries()) {
                            if (!dRLibrary.getName().equals(CustomTransformationsManager.this.cbLibrary.getSelectedItem())) continue;
                            CustomTransformationsManager.this.currentTransformation.setLibrary(dRLibrary);
                            break;
                        }
                    }
                    CustomTransformationsManager.this.currentTransformation = ((CustomTransformationModel)CustomTransformationsManager.this.customTransformationsTable.getModel()).getCustomTransformationsContainerList().get(n);
                    CustomTransformationsManager.this.scriptEditor.setText("");
                    CustomTransformationsManager.this.scriptEditor.setText(CustomTransformationsManager.this.currentTransformation.getScript());
                    CustomTransformationsManager.this.autoChanged = true;
                    CustomTransformationsManager.this.cbLibrary.setSelectedItem(CustomTransformationsManager.this.currentTransformation.getLibrary() != null ? CustomTransformationsManager.this.currentTransformation.getLibrary().getName() : "");
                    CustomTransformationsManager.this.cbMethod.setSelectedItem(CustomTransformationsManager.this.currentTransformation.getFunction());
                    CustomTransformationsManager.this.autoChanged = false;
                    CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(true);
                    CustomTransformationsManager.this.bnApply.setEnabled(true);
                }
            }
        });
        jPanel.add((Component)this.createCustomTransformationsToolbarPanel(), "North");
        JScrollPane jScrollPane = new JScrollPane(this.customTransformationsTable);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        JLabel jLabel = new JLabel(Messages.getString("CustomTransformationsManager.Library"));
        jLabel.setPreferredSize(new Dimension(70, 20));
        this.cbLibrary = new JComboBox<Object>(this.getLibraries().toArray());
        this.cbLibrary.setPreferredSize(new Dimension(250, 20));
        this.cbLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)itemEvent.getItem();
                    if (string != "") {
                        CustomTransformationsManager.this.cbMethod.removeAllItems();
                        for (DRLibrary dRLibrary : CustomTransformationsManager.this.appView.getCustomLibraries()) {
                            if (!dRLibrary.getName().equals(string)) continue;
                            Iterator<String> iterator = dRLibrary.getFunctions().iterator();
                            while (iterator.hasNext()) {
                                CustomTransformationsManager.this.cbMethod.addItem(iterator.next());
                            }
                            CustomTransformationsManager.this.scriptEditor.setText("");
                            CustomTransformationsManager.this.scriptEditor.setText(dRLibrary.getScript());
                            CustomTransformationsManager.this.scriptEditor.setEnabled(false);
                            break;
                        }
                        CustomTransformationsManager.this.cbMethod.updateUI();
                        CustomTransformationsManager.this.bnApply.setEnabled(true);
                    } else if (string == "") {
                        CustomTransformationsManager.this.cbMethod.removeAllItems();
                        CustomTransformationsManager.this.cbMethod.updateUI();
                        CustomTransformationsManager.this.scriptEditor.setText("");
                        CustomTransformationsManager.this.scriptEditor.setText(CustomTransformationsManager.this.currentTransformation.getScript());
                        CustomTransformationsManager.this.scriptEditor.setEnabled(true);
                    }
                    if (!CustomTransformationsManager.this.autoChanged) {
                        CustomTransformationsManager.this.saved = false;
                        CustomTransformationsManager.this.bnSave.setEnabled(true);
                    }
                } else if (itemEvent.getStateChange() == 2) {
                    System.out.println("");
                }
            }
        });
        this.cbMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && !CustomTransformationsManager.this.autoChanged) {
                    CustomTransformationsManager.this.saved = false;
                    CustomTransformationsManager.this.bnSave.setEnabled(true);
                }
            }
        });
        JLabel jLabel2 = new JLabel(Messages.getString("CustomTransformationsManager.Method"));
        jLabel2.setPreferredSize(new Dimension(70, 20));
        this.cbMethod.setPreferredSize(new Dimension(250, 20));
        jPanel3.add(jLabel);
        jPanel3.add(this.cbLibrary);
        jPanel3.add(jLabel2);
        jPanel3.add(this.cbMethod);
        jPanel2.add((Component)jPanel3, "North");
        this.scriptEditor = new JTextArea();
        this.scriptEditor.setLineWrap(true);
        this.scriptEditor.setWrapStyleWord(true);
        this.scriptEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CustomTransformationsManager.this.saved = false;
                CustomTransformationsManager.this.bnSave.setEnabled(true);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.scriptEditor);
        jScrollPane2.setPreferredSize(new Dimension(300, 550));
        jPanel2.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        this.bnApply = new JButton(Messages.getString("CustomTransformationsManager.Apply"));
        this.bnApply.setToolTipText(Messages.getString("CustomTransformationsManager.ApplyTooltip"));
        this.bnApply.setEnabled(false);
        this.bnApply.setMnemonic(65);
        this.bnSave = new JButton(Messages.getString("CustomTransformationsManager.Save"));
        this.bnSave.setToolTipText(Messages.getString("CustomTransformationsManager.SaveTooltip"));
        this.bnSave.setEnabled(false);
        this.bnApply.addActionListener(new ApplyAction());
        this.bnSave.addActionListener(new SaveAction());
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnSave);
        this.bnSave.setMnemonic(83);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnApply);
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setToolTipText(Messages.getString("CustomTransformationsManager.ImportTooltip"));
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnImport);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setToolTipText(Messages.getString("CustomTransformationsManager.ExportTooltip"));
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnExport);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setToolTipText(Messages.getString("CustomTransformationsManager.CloseDialogTooltip"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        jPanel4.add(this.bnClose);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setToolTipText(Messages.getString("CustomTransformationsManager.HelpTooltip"));
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(jButton);
        jPanel2.add((Component)jPanel4, "South");
    }

    private void loadCustomTS() {
        Iterator<DRCustomScript> iterator = this.allCR.iterator();
        this.customTransformationsContainerList.clear();
        while (iterator.hasNext()) {
            DRCustomScript dRCustomScript = iterator.next().copy();
            if (!dRCustomScript.getPurpose().equals("transformation")) continue;
            dRCustomScript.setVariable(this.MODEL);
            this.customTransformationsContainerList.add(dRCustomScript);
        }
        this.customTransformationsTable.updateUI();
        this.saved = true;
        this.bnSave.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < CustomTransformationsManager.this.customTransformationsTable.getRowCount(); ++i) {
                    if (!CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(i, 5).equals("err")) continue;
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.MissingEngine"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    break;
                }
            }
        });
    }

    protected JPanel createCustomTransformationsToolbarPanel() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        this.btnAddCustomTransformation = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddCustomTransformation.setToolTipText(Messages.getString("CustomTransformationsManager.AddTransformation"));
        this.btnAddCustomTransformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DRCustomScript dRCustomScript = new DRCustomScript(CustomTransformationsManager.this.generateName(), null, "transformation");
                dRCustomScript.setScriptEngineManager(CustomTransformationsManager.this.scriptEngineManager);
                CustomTransformationsManager.this.customTransformationsContainerList.add(dRCustomScript);
                CustomTransformationsManager.this.customTransformationsTable.updateUI();
                CustomTransformationsManager.this.customTransformationsTable.getSelectionModel().setSelectionInterval(CustomTransformationsManager.this.customTransformationsTable.getRowCount() - 1, CustomTransformationsManager.this.customTransformationsTable.getRowCount() - 1);
                CustomTransformationsManager.this.customTransformationsTable.scrollRectToVisible(new Rectangle(CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth() * CustomTransformationsManager.this.customTransformationsTable.getSelectedColumn(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight() * CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight()));
                CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(CustomTransformationsManager.this.customTransformationsContainerList.size() > 0);
                CustomTransformationsManager.this.scriptEditor.setEnabled(true);
                CustomTransformationsManager.this.bnSave.setEnabled(true);
                CustomTransformationsManager.this.saved = false;
            }
        });
        this.btnRemoveCustomTransformation = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveCustomTransformation.setToolTipText(Messages.getString("CustomTransformationsManager.RemoveTransformation"));
        this.btnRemoveCustomTransformation.setEnabled(false);
        this.btnRemoveCustomTransformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomTransformationsManager.this.customTransformationsTable.getSelectedRow();
                CustomTransformationsManager.this.customTransformationsContainerList.remove(n);
                CustomTransformationsManager.this.customTransformationsTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomTransformationsManager.this.customTransformationsTable.updateUI();
                CustomTransformationsManager.this.customTransformationsTable.scrollRectToVisible(new Rectangle(CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth() * CustomTransformationsManager.this.customTransformationsTable.getSelectedColumn(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight() * CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight()));
                if (CustomTransformationsManager.this.customTransformationsContainerList.size() == 0) {
                    CustomTransformationsManager.this.cbLibrary.setSelectedItem("");
                    CustomTransformationsManager.this.cbMethod.removeAllItems();
                    CustomTransformationsManager.this.scriptEditor.setText("");
                    CustomTransformationsManager.this.scriptEditor.setEnabled(false);
                    CustomTransformationsManager.this.bnApply.setEnabled(false);
                    CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(false);
                }
                CustomTransformationsManager.this.bnSave.setEnabled(true);
                CustomTransformationsManager.this.saved = false;
            }
        });
        jToolBar.add(this.btnAddCustomTransformation);
        jToolBar.add(this.btnRemoveCustomTransformation);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        jPanel.add(jToolBar);
        return jPanel;
    }

    protected String generateName() {
        String string = "Tr";
        int n = 0;
        int n2 = this.customTransformationsContainerList.size();
        if (n2 != 0) {
            n = this.cgCounter = n2 + 1;
        } else {
            ++this.cgCounter;
            n = this.cgCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.exists(string2)) {
            n = ++this.cgCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean exists(String string) {
        for (int i = 0; i < this.customTransformationsContainerList.size(); ++i) {
            DRCustomScript dRCustomScript = this.customTransformationsContainerList.get(i);
            if (!string.equalsIgnoreCase(dRCustomScript.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomTransformationsManager.CustomTransformations"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 600);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "CUSTOM_TRANSFORMATIONS_DIALOG";
    }

    private void stopCellediting() {
        if (this.scriptEditor.isEnabled()) {
            this.currentTransformation.setScript(this.scriptEditor.getText());
        }
        for (DRLibrary object2 : this.appView.getCustomLibraries()) {
            if (!object2.getName().equals(this.cbLibrary.getSelectedItem())) continue;
            this.currentTransformation.setLibrary(object2);
            break;
        }
        this.currentTransformation.setFunction((String)this.cbMethod.getSelectedItem());
        TableCellEditor tableCellEditor = this.customTransformationsTable.getCellEditor();
        if (tableCellEditor != null) {
            this.customTransformationsTable.getCellEditor().stopCellEditing();
        }
    }

    public Action closeAction() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomTransformationsManager.Close")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomTransformationsManager.this.canClose()) {
                    CustomTransformationsManager.this.close();
                }
            }
        };
        return abstractAction;
    }

    private ArrayList<String> getObjecTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("logical");
        arrayList.add("relational");
        return arrayList;
    }

    protected boolean canSave() {
        block5: {
            block6: {
                if (this.customTransformationsContainerList.size() <= 0) break block5;
                if (this.customTransformationsTable.getSelectedRow() <= -1) break block6;
                if (this.customTransformationsTable.getModel().getValueAt(this.customTransformationsTable.getSelectedRow(), 2) == null) {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NoObjectChosen"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                if (this.customTransformationsTable.getModel().getValueAt(this.customTransformationsTable.getSelectedRow(), 3) == null) {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NoEngineChosen"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                if (this.scriptEditor.getText().trim().length() == 0 || this.scriptEditor.getText() == null) {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NoScript"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                for (DRCustomScript dRCustomScript : this.customTransformationsContainerList) {
                    if (dRCustomScript.getObject() != null && dRCustomScript.getEngineName() != null && (dRCustomScript.getLibrary() != null || !dRCustomScript.getScript().equals(""))) continue;
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NoObjectEngineScript"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                break block5;
            }
            if (this.customTransformationsTable.getSelectedRow() != -1) break block5;
            for (DRCustomScript dRCustomScript : this.customTransformationsContainerList) {
                if (dRCustomScript.getObject() != null && dRCustomScript.getEngineName() != null && (dRCustomScript.getLibrary() != null || !dRCustomScript.getScript().equals(""))) continue;
                JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NoObjectEngineScript"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canClose() {
        if (!this.saved) {
            String string = Messages.getString("CustomTransformationsManager.Yes");
            String string2 = Messages.getString("CustomTransformationsManager.No");
            Object[] objectArray = new Object[]{string, string2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("CustomTransformationsManager.TransformationsNotSaved"), Messages.getString("CustomTransformationsManager.CloseConfirmation"), 0, 3, null, objectArray, string);
            return n == 0;
        }
        return true;
    }

    public ArrayList<String> getLibraries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<DRLibrary> iterator = this.appView.getCustomLibraries().iterator();
        arrayList.add("");
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getName());
        }
        return arrayList;
    }

    public Action createImportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomTransformationsManager.Import")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                URLFilter uRLFilter = new URLFilter(){

                    public boolean accept(URL uRL) {
                        File file = new File(uRL.getPath());
                        return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("CustomTransformationsManager.XMLFiles");
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(0);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setURLFilter(uRLFilter);
                if (lastImpFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                } else {
                    String string = CustomTransformationsManager.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        serializable = CustomTransformationsManager.this.getApplicationView().getUserHomeDirectory();
                        if (serializable != null) {
                            uRLChooser.setSelectedURL((URL)serializable);
                        }
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsManager.ImportS"));
                if (n == 0) {
                    CustomTransformationsManager.this.file = new File(uRLChooser.getSelectedURL().getPath());
                    if (CustomTransformationsManager.this.file != null) {
                        lastImpFolder = CustomTransformationsManager.this.file.getParentFile();
                        try {
                            int n2;
                            serializable = new StringBuffer();
                            FileInputStream fileInputStream = new FileInputStream(CustomTransformationsManager.this.file);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            while ((n2 = ((Reader)bufferedReader).read()) > -1) {
                                ((StringBuffer)serializable).append((char)n2);
                            }
                            ((Reader)bufferedReader).close();
                            CustomTransformationsManager.this.importTS(((StringBuffer)serializable).toString());
                        }
                        catch (Exception exception) {
                            LOGGER.error("Unable to load custom transformation scripts from imported file: ", exception);
                        }
                    }
                }
            }
        };
        return abstractAction;
    }

    /*
     * WARNING - void declaration
     */
    public void importTS(String string) {
        try {
            Object object;
            Object object2;
            DRCustomScript dRCustomScript;
            Object object3;
            int n;
            StringReader stringReader = new StringReader(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            ArrayList<DRCustomScript> arrayList = new ArrayList<DRCustomScript>();
            NodeList nodeList = document.getElementsByTagName("scr");
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                void var16_21;
                object3 = null;
                Element element = (Element)nodeList.item(n);
                dRCustomScript = new DRCustomScript(element.getAttribute(StringUtilities.decodeAttributeValue("name")), element.getAttribute("id"), element.getAttribute("purpose"));
                dRCustomScript.setObject(element.getAttribute("object"));
                dRCustomScript.setEngineName(element.getAttribute("engine"));
                dRCustomScript.setVariable(element.getAttribute("var"));
                dRCustomScript.setScriptEngineManager(this.appView.getScriptEngineManager());
                object2 = element.getChildNodes();
                StringBuffer stringBuffer = new StringBuffer();
                boolean i = false;
                while (var16_21 < object2.getLength()) {
                    object = object2.item((int)var16_21);
                    stringBuffer.append(object.getTextContent());
                    ++var16_21;
                }
                String object4 = element.getAttribute("library");
                if (object4 != null && object4.trim().length() > 0) {
                    object = element.getAttribute("method");
                    for (DRLibrary dRLibrary : this.appView.getCustomLibraries()) {
                        if (!dRLibrary.getName().equals(StringUtilities.decodeAttributeValue(object4))) continue;
                        dRCustomScript.setLibrary(dRLibrary);
                        if (dRLibrary.getFunctions().contains(object)) {
                            dRCustomScript.setFunction((String)object);
                        } else {
                            dRLibrary.getFunctions().add((String)object);
                            dRCustomScript.setFunction((String)object);
                        }
                        object3 = dRLibrary;
                        break;
                    }
                    if (object3 == null) {
                        object3 = new DRLibrary(StringUtilities.decodeAttributeValue(element.getAttribute("library")), null);
                        ((DRLibrary)object3).setFunctions(new ArrayList<String>());
                        ((DRLibrary)object3).setEngine(element.getAttribute("engine"));
                        ((DRLibrary)object3).getFunctions().add(StringUtilities.decodeAttributeValue((String)object));
                        ((DRLibrary)object3).setScript(stringBuffer.toString().trim());
                        dRCustomScript.setFunction((String)object);
                        dRCustomScript.setLibrary((DRLibrary)object3);
                        this.appView.getCustomLibraries().add((DRLibrary)object3);
                        this.cbLibrary.removeAllItems();
                        Iterator<String> iterator = this.getLibraries().iterator();
                        while (iterator.hasNext()) {
                            this.cbLibrary.addItem(iterator.next());
                        }
                    }
                }
                dRCustomScript.setScript(stringBuffer.toString().trim());
                arrayList.add(dRCustomScript);
            }
            n = 0;
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                boolean bl = false;
                dRCustomScript = (DRCustomScript)object3.next();
                object2 = dRCustomScript.getRuleId();
                for (DRCustomScript dRCustomScript2 : this.allCR) {
                    object = dRCustomScript2.getRuleId();
                    if (!((String)object2).equals(object)) {
                        bl = false;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.allCR.add(dRCustomScript);
                this.customTransformationsContainerList.add(dRCustomScript);
                n = 1;
            }
            if (n != 0) {
                this.appView.saveCustomDRScripts();
            }
            this.customTransformationsTable.updateUI();
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Unable to import custom transformation scripts: ", runtimeException);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to import custom transformation scripts: ", exception);
        }
    }

    public Action createExportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomTransformationsManager.Export")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomTransformationsManager.this.saved) {
                    Object object;
                    URLFilter uRLFilter = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("CustomTransformationsManager.XMLFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter(uRLFilter);
                    if (lastExpFolder != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                    } else {
                        String string = CustomTransformationsManager.this.getApplicationView().getSettings().getDefaultSavePath();
                        if (string != null && string.length() > 0) {
                            uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                        } else {
                            object = CustomTransformationsManager.this.getApplicationView().getUserHomeDirectory();
                            if (object != null) {
                                uRLChooser.setSelectedURL((URL)object);
                            }
                        }
                    }
                    int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsManager.ExportS"));
                    if (n == 0) {
                        object = uRLChooser.getSelectedURL().getPath();
                        int n2 = ((String)object).lastIndexOf(".");
                        if (n2 > -1) {
                            CustomTransformationsManager.this.file = new File(((String)object).substring(0, n2) + ".xml");
                        } else {
                            CustomTransformationsManager.this.file = new File((String)object + ".xml");
                        }
                        if (CustomTransformationsManager.this.file != null) {
                            lastExpFolder = CustomTransformationsManager.this.file.getParentFile();
                            CustomTransformationsManager.this.exportTS();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NotSaved"), Messages.getString("CustomTransformationsManager.Error"), 0);
                }
            }
        };
        return abstractAction;
    }

    public void exportTS() {
        boolean bl = true;
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            stringBuffer.append("\n");
            stringBuffer.append("<!-- File contains Custom Transformation scripts -->");
            stringBuffer.append("\n");
            stringBuffer.append("<").append("custom_transformation_scripts").append(">");
            for (DRCustomScript dRCustomScript : this.customTransformationsContainerList) {
                stringBuffer.append("\n");
                stringBuffer.append("\t").append("<").append("scr").append(' ');
                stringBuffer.append("id=\"").append(dRCustomScript.getRuleId()).append("\"").append(' ');
                stringBuffer.append("name=\"").append(StringUtilities.encodeAttributeValue(dRCustomScript.getName())).append("\"").append(' ');
                stringBuffer.append("object=\"").append(dRCustomScript.getObject()).append("\"").append(' ');
                stringBuffer.append("engine=\"").append(dRCustomScript.getEngineName()).append("\"").append(' ');
                stringBuffer.append("var=\"").append(dRCustomScript.getVariable()).append("\"").append(' ');
                stringBuffer.append("library=\"").append(StringUtilities.encodeAttributeValue(dRCustomScript.getLibrary() != null ? dRCustomScript.getLibrary().getName() : "")).append("\"").append(' ');
                stringBuffer.append("method=\"").append(StringUtilities.encodeAttributeValue(dRCustomScript.getFunction() != null ? dRCustomScript.getFunction() : "")).append("\"").append(' ');
                stringBuffer.append("purpose=\"").append(StringUtilities.encodeAttributeValue(dRCustomScript.getPurpose())).append("\"").append(' ');
                stringBuffer.append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("script").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t\t").append("<![CDATA[").append(dRCustomScript.getLibrary() != null ? dRCustomScript.getLibrary().getScript() : dRCustomScript.getScript()).append("]]>");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("</").append("script").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t").append("</").append("scr").append(">");
            }
            stringBuffer.append("\n");
            stringBuffer.append("</").append("custom_transformation_scripts").append(">");
            if (this.file.exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomTransformationsManager.FileExists"), this.file), Messages.getString("CustomTransformationsManager.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                bl = false;
            }
            if (bl) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(stringBuffer.toString());
                outputStreamWriter.close();
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Unable to export libraries: ", runtimeException);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to export custom transformation scripts: ", exception);
        }
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 2737192443575947005L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Color color = null;
            if (jTable.getModel().getValueAt(n, 5).equals("err")) {
                color = Color.RED;
            }
            component.setForeground(color);
            return component;
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CustomTransformationsManager.this.saved) {
                if (CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 5).equals("err")) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("CustomTransformationsManager.CannotApply"), CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 1), CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 2), CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 3)), Messages.getString("CustomDesignRulesManager.Error"), 0);
                } else if (CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 5).equals("ok") && CustomTransformationsManager.this.customTransformationsTable.getSelectedRow() > -1 && CustomTransformationsManager.this.scriptEditor.getText() != null && !CustomTransformationsManager.this.scriptEditor.getText().trim().equals("")) {
                    DRCustomScript dRCustomScript = CustomTransformationsManager.this.customTransformationsContainerList.get(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow());
                    try {
                        ApplyCustomTransformation applyCustomTransformation = new ApplyCustomTransformation(dRCustomScript.getObject(), CustomTransformationsManager.this.dp, new ArrayList<DRCustomScript>(Arrays.asList(dRCustomScript)));
                        boolean bl = applyCustomTransformation.runTransformation();
                        if (!bl) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsManager.Finished"), Messages.getString("CustomTransformationsManager.CustomTransformations"), 1);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error during execution of custom transformation script : ", exception);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NotSavedBeforeApply"), Messages.getString("CustomTransformationsManager.Warning"), 2);
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomTransformationsManager.this.stopCellediting();
            if (CustomTransformationsManager.this.canSave()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object : CustomTransformationsManager.this.allCR) {
                    if (!((DRCustomScript)object).getPurpose().equals("transformation")) continue;
                    arrayList.add(object);
                }
                for (DRCustomScript dRCustomScript : CustomTransformationsManager.this.customTransformationsContainerList) {
                    dRCustomScript.compiledScript = null;
                }
                CustomTransformationsManager.this.allCR.removeAll(arrayList);
                CustomTransformationsManager.this.allCR.addAll(CustomTransformationsManager.this.customTransformationsContainerList);
                CustomTransformationsManager.this.bnSave.setEnabled(false);
                CustomTransformationsManager.this.bnApply.setEnabled(true);
                CustomTransformationsManager.this.saved = true;
                CustomTransformationsManager.this.appView.saveCustomDRScripts();
            }
        }
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField jTextField) {
            super(jTextField);
            this.tf = jTextField;
            jTextField.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tf.setText(object.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = jTable;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            String string = jTextField.getText().trim();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NameEmpty"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
            TableModel tableModel = this.tab.getModel();
            for (DRCustomScript dRCustomScript : ((CustomTransformationModel)tableModel).getCustomTransformationsContainerList()) {
                if (!dRCustomScript.getName().equals(string) || string.equals(this.val)) continue;
                JOptionPane.showMessageDialog(null, Messages.getString("CustomTransformationsManager.NameExists"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
            CustomTransformationsManager.this.currentTransformation.setScript(CustomTransformationsManager.this.scriptEditor.getText());
            return super.stopCellEditing();
        }
    }

    private class CustomTransformationModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -362794593669886434L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomTransformationsManager.Name"), Messages.getString("CustomTransformationsManager.Object"), Messages.getString("CustomTransformationsManager.Engine"), Messages.getString("CustomTransformationsManager.Variable"), "state"};

        private CustomTransformationModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomTransformationsManager.this.customTransformationsContainerList.size();
        }

        public List<DRCustomScript> getCustomTransformationsContainerList() {
            return CustomTransformationsManager.this.customTransformationsContainerList;
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0 || n2 == 4) {
                return false;
            }
            return n2 != 3 || !this.getValueAt(n, 5).equals("err");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DRCustomScript dRCustomScript = CustomTransformationsManager.this.customTransformationsContainerList.get(n);
            String string = dRCustomScript.getObject();
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return dRCustomScript.getName();
            }
            if (n2 == 2) {
                return string;
            }
            if (n2 == 3) {
                return dRCustomScript.getEngineName();
            }
            if (n2 == 4) {
                return CustomTransformationsManager.this.MODEL;
            }
            if (n2 == 5) {
                if (dRCustomScript.getEngineName() != null) {
                    for (String string2 : CustomTransformationsManager.this.allEngines) {
                        if (!string2.equals(dRCustomScript.getEngineName())) continue;
                        return "ok";
                    }
                    return "err";
                }
                return "ok";
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DRCustomScript dRCustomScript = CustomTransformationsManager.this.customTransformationsContainerList.get(n);
            if (n2 == 1) {
                dRCustomScript.setName(object.toString());
            } else if (n2 == 2) {
                dRCustomScript.setObject((String)object);
                dRCustomScript.setVariable(CustomTransformationsManager.this.MODEL);
            } else if (n2 == 3) {
                dRCustomScript.setEngineName((String)object);
            }
        }
    }
}

