/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.CheckResultComponent;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomDesignRulesManager
extends CustomDialog {
    private static final long serialVersionUID = -4695332256421700394L;
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private final String RULE_NAME = "Rule";
    private final String ATTRIBUTE = "attribute";
    private final String ENTITY = "entity";
    private final String KEY = "key";
    private final String ENTITY_VIEW = "entView";
    private final String EXTERNAL_AGENT = "extAgent";
    private final String INFORMATION_FLOW = "infFlow";
    private final String INFORMATION_STORE = "infStore";
    private final String PROCESS = "process";
    private final String TRANSFORMATION_TASK = "trTask";
    private final String TRANSFORMATION = "transformation";
    private final String COLUMN = "column";
    private final String DOMAIN = "domain";
    private final String INDEX = "index";
    private final String TL_CONSTRAINT = "tlConstraint";
    private final String TABLE = "table";
    private int result = 0;
    private JDialog dialog;
    private RelationalDesign relDesign;
    public List<DRCustomValidationScript> customScriptsContainerList;
    private JTable customRulesTable;
    public JButton bnSaveRules;
    public JButton bnApply;
    public JButton bnClose;
    private JButton bnImport;
    private JButton bnExport;
    private JButton btnAddCustomRule;
    private JButton btnRemoveCustomRule;
    private DRCustomValidationScript currentRule;
    private CheckResultComponent checkResultComponent;
    private int cgCounter = 0;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JSplitPane mainPanel;
    private JSplitPane leftPanel;
    private boolean rulesSaved = true;
    private JTextArea scriptEditor;
    private ApplicationView appView;
    private TreeMap<String, Object> objects;
    private TreeMap<String, String> mapVariables = new TreeMap();
    private TreeMap<String, Object> mapClasses = new TreeMap();
    private ScriptEngineManager scriptEngineManager;
    private JComboBox cbMethod = new JComboBox();
    private JComboBox cbLibrary;
    private File file;
    private JComboBox obCombo;
    private JComboBox engCombo;
    private JComboBox resCombo;
    private boolean autoChanged = false;
    private ArrayList allEngines;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    private ArrayList allCR;
    private static final Logger LOGGER = new Logger(CustomDesignRulesManager.class);

    public CustomDesignRulesManager(ApplicationView applicationView, RelationalDesign relationalDesign, ScriptEngineManager scriptEngineManager) {
        super(applicationView);
        this.appView = applicationView;
        this.relDesign = relationalDesign;
        this.scriptEngineManager = scriptEngineManager;
        UIManager.put("TextArea.inactiveForeground", Color.BLACK);
        this.allEngines = applicationView.getScriptEngines();
        this.allCR = applicationView.getCustomDesignRules();
        this.init();
        this.loadCustomDR();
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomDesignRulesManager.RuleScript")));
        this.leftPanel = new JSplitPane(0, jPanel, jPanel2);
        this.leftPanel.setMinimumSize(new Dimension(650, 800));
        this.leftPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.leftPanel.setDividerLocation(200);
        this.mainPanel = new JSplitPane(1, this.leftPanel, this.getCheckResultComponent());
        this.mainPanel.setDividerLocation(660);
        this.customScriptsContainerList = new ArrayList<DRCustomValidationScript>();
        this.customRulesTable = new JTable(new CustomRuleModel());
        this.customRulesTable.setSelectionMode(0);
        this.customRulesTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        TableColumn tableColumn = this.customRulesTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(30);
        tableColumn.setMaxWidth(30);
        JTextField jTextField = new JTextField();
        TableColumn tableColumn2 = this.customRulesTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(220);
        tableColumn2.setMaxWidth(1000);
        tableColumn2.setCellEditor(new TFCellEditor(jTextField));
        this.obCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getObjecTypes().toArray()));
        TableColumn tableColumn3 = this.customRulesTable.getColumnModel().getColumn(2);
        tableColumn3.setWidth(120);
        tableColumn3.setMaxWidth(120);
        tableColumn3.setCellEditor(new DefaultCellEditor(this.obCombo));
        this.engCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.appView.getScriptEngines().toArray()));
        TableColumn tableColumn4 = this.customRulesTable.getColumnModel().getColumn(3);
        tableColumn4.setWidth(300);
        tableColumn4.setMaxWidth(300);
        tableColumn4.setCellEditor(new DefaultCellEditor(this.engCombo));
        this.resCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getResultTypes().toArray()));
        TableColumn tableColumn5 = this.customRulesTable.getColumnModel().getColumn(4);
        tableColumn5.setWidth(100);
        tableColumn5.setMaxWidth(100);
        tableColumn5.setCellEditor(new DefaultCellEditor(this.resCombo));
        TableColumn tableColumn6 = this.customRulesTable.getColumnModel().getColumn(5);
        tableColumn6.setWidth(100);
        tableColumn6.setMaxWidth(100);
        TableColumn tableColumn7 = this.customRulesTable.getColumnModel().getColumn(6);
        this.customRulesTable.getColumnModel().removeColumn(tableColumn7);
        this.obCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string;
                if (itemEvent.getStateChange() == 1) {
                    string = (String)itemEvent.getItem();
                    CustomDesignRulesManager.this.customRulesTable.setValueAt(CustomDesignRulesManager.this.mapVariables.get(string), CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 5);
                    CustomDesignRulesManager.this.updateUI();
                }
                string = (String)CustomDesignRulesManager.this.customRulesTable.getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 2);
                String string2 = (String)CustomDesignRulesManager.this.obCombo.getSelectedItem();
                if (string != null && string2 != null && !string.equals(string2)) {
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                    CustomDesignRulesManager.this.rulesSaved = false;
                }
            }
        });
        this.engCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)CustomDesignRulesManager.this.customRulesTable.getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 3);
                String string2 = (String)CustomDesignRulesManager.this.engCombo.getSelectedItem();
                if (string != null && string2 != null && !string.equals(string2)) {
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                    CustomDesignRulesManager.this.rulesSaved = false;
                }
                if (itemEvent.getStateChange() == 1) {
                    boolean bl = true;
                    if (!CustomDesignRulesManager.this.cbLibrary.getSelectedItem().equals("")) {
                        bl = CustomDesignRulesManager.this.checkIfEngineSupportsInvocable(string2);
                    }
                    if (!bl && !CustomDesignRulesManager.this.engCombo.getSelectedItem().equals("")) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("CustomDesignRulesManager.EnginNotSupportingInvocable"), CustomDesignRulesManager.this.currentRule.getEngineName()), Messages.getString("CustomDesignRulesManager.Error"), 0);
                        CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                        CustomDesignRulesManager.this.cbMethod.removeAllItems();
                        CustomDesignRulesManager.this.scriptEditor.setText("");
                        CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                    }
                }
            }
        });
        this.resCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)CustomDesignRulesManager.this.customRulesTable.getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 4);
                String string2 = (String)CustomDesignRulesManager.this.resCombo.getSelectedItem();
                if (string != null && string2 != null && !string.equals(string2)) {
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                    CustomDesignRulesManager.this.rulesSaved = false;
                }
            }
        });
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CustomDesignRulesManager.this.rulesSaved = false;
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
            }
        });
        this.customRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CustomDesignRulesManager.this.customRulesTable.getSelectedRow();
                if (n == -1) {
                    CustomDesignRulesManager.this.btnRemoveCustomRule.setEnabled(false);
                    CustomDesignRulesManager.this.scriptEditor.setEnabled(false);
                } else {
                    CustomDesignRulesManager.this.saveSelected();
                    CustomDesignRulesManager.this.currentRule = ((CustomRuleModel)CustomDesignRulesManager.this.customRulesTable.getModel()).getCustomRulesContainerList().get(n);
                    CustomDesignRulesManager.this.scriptEditor.setText("");
                    CustomDesignRulesManager.this.scriptEditor.setText(CustomDesignRulesManager.this.currentRule.getScript());
                    CustomDesignRulesManager.this.autoChanged = true;
                    CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                    CustomDesignRulesManager.this.cbLibrary.setSelectedItem(CustomDesignRulesManager.this.currentRule.getLibrary() != null ? CustomDesignRulesManager.this.currentRule.getLibrary().getName() : "");
                    CustomDesignRulesManager.this.cbMethod.setSelectedItem(CustomDesignRulesManager.this.currentRule.getFunction());
                    CustomDesignRulesManager.this.autoChanged = false;
                    CustomDesignRulesManager.this.btnRemoveCustomRule.setEnabled(true);
                    CustomDesignRulesManager.this.bnApply.setEnabled(true);
                }
            }
        });
        jPanel.add((Component)this.createCustomRulesToolbarPanel(), "North");
        JScrollPane jScrollPane = new JScrollPane(this.customRulesTable);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        JLabel jLabel = new JLabel(Messages.getString("CustomDesignRulesManager.Library"));
        jLabel.setPreferredSize(new Dimension(70, 20));
        this.cbLibrary = new JComboBox<Object>(this.getLibraries().toArray());
        this.cbLibrary.setPreferredSize(new Dimension(230, 20));
        this.cbLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    boolean bl = true;
                    if (!CustomDesignRulesManager.this.autoChanged && CustomDesignRulesManager.this.currentRule.getEngineName() != null && !CustomDesignRulesManager.this.currentRule.getEngineName().equals("")) {
                        bl = CustomDesignRulesManager.this.checkIfEngineSupportsInvocable((String)CustomDesignRulesManager.this.engCombo.getSelectedItem());
                    }
                    if (bl) {
                        String string = (String)itemEvent.getItem();
                        if (string != "") {
                            CustomDesignRulesManager.this.cbMethod.removeAllItems();
                            for (DRLibrary dRLibrary : CustomDesignRulesManager.this.appView.getCustomLibraries()) {
                                if (!dRLibrary.getName().equals(string)) continue;
                                Iterator<String> iterator = dRLibrary.getFunctions().iterator();
                                while (iterator.hasNext()) {
                                    CustomDesignRulesManager.this.cbMethod.addItem(iterator.next());
                                }
                                CustomDesignRulesManager.this.scriptEditor.setText("");
                                CustomDesignRulesManager.this.scriptEditor.setText(dRLibrary.getScript());
                                CustomDesignRulesManager.this.scriptEditor.setEnabled(false);
                                break;
                            }
                            CustomDesignRulesManager.this.cbMethod.updateUI();
                            CustomDesignRulesManager.this.bnApply.setEnabled(true);
                        } else if (string == "") {
                            CustomDesignRulesManager.this.cbMethod.removeAllItems();
                            CustomDesignRulesManager.this.cbMethod.updateUI();
                            CustomDesignRulesManager.this.scriptEditor.setText("");
                            CustomDesignRulesManager.this.scriptEditor.setText(CustomDesignRulesManager.this.currentRule.getScript());
                            CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                        }
                        if (!CustomDesignRulesManager.this.autoChanged) {
                            CustomDesignRulesManager.this.rulesSaved = false;
                            CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                        }
                    } else if (!CustomDesignRulesManager.this.cbLibrary.getSelectedItem().equals("")) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("CustomDesignRulesManager.EnginNotSupportingInvocable"), CustomDesignRulesManager.this.currentRule.getEngineName()), Messages.getString("CustomDesignRulesManager.Error"), 0);
                        CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                        CustomDesignRulesManager.this.cbMethod.removeAllItems();
                        CustomDesignRulesManager.this.scriptEditor.setText("");
                        CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                    }
                }
            }
        });
        this.cbMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && !CustomDesignRulesManager.this.autoChanged) {
                    CustomDesignRulesManager.this.rulesSaved = false;
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                }
            }
        });
        JLabel jLabel2 = new JLabel(Messages.getString("CustomDesignRulesManager.Method"));
        jLabel2.setPreferredSize(new Dimension(70, 20));
        this.cbMethod.setPreferredSize(new Dimension(230, 20));
        jPanel3.add(jLabel);
        jPanel3.add(this.cbLibrary);
        jPanel3.add(jLabel2);
        jPanel3.add(this.cbMethod);
        jPanel2.add((Component)jPanel3, "North");
        this.scriptEditor = new JTextArea();
        this.scriptEditor.setLineWrap(true);
        this.scriptEditor.setWrapStyleWord(true);
        this.scriptEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CustomDesignRulesManager.this.rulesSaved = false;
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.scriptEditor);
        jScrollPane2.setPreferredSize(new Dimension(300, 550));
        jPanel2.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        this.bnApply = new JButton(Messages.getString("CustomDesignRulesManager.Apply"));
        this.bnApply.setToolTipText(Messages.getString("CustomDesignRulesManager.ApplyTooltip"));
        this.bnApply.setEnabled(false);
        this.bnApply.setMnemonic(65);
        this.bnSaveRules = new JButton(Messages.getString("CustomDesignRulesManager.Save"));
        this.bnSaveRules.setToolTipText(Messages.getString("CustomDesignRulesManager.SaveTooltip"));
        this.bnSaveRules.setEnabled(false);
        this.bnSaveRules.setMnemonic(83);
        this.bnApply.addActionListener(new ApplyAction());
        this.bnSaveRules.addActionListener(new SaveAction());
        this.bnSaveRules.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnSaveRules);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnApply);
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setToolTipText(Messages.getString("CustomDesignRulesManager.importTooltip"));
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnImport);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setToolTipText(Messages.getString("CustomDesignRulesManager.ExportTooltip"));
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnExport);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setToolTipText(Messages.getString("CustomDesignRulesManager.CloseDialogTooltip"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        jPanel4.add(this.bnClose);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setToolTipText(Messages.getString("CustomDesignRulesManager.HelpTooltip"));
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(jButton);
        jPanel2.add((Component)jPanel4, "South");
    }

    private void saveSelected() {
        if (this.currentRule != null) {
            if (this.scriptEditor.isEnabled()) {
                this.currentRule.setScript(this.scriptEditor.getText());
                this.currentRule.setLibrary(null);
                this.currentRule.setFunction(null);
            } else {
                for (DRLibrary dRLibrary : this.appView.getCustomLibraries()) {
                    if (!dRLibrary.getName().equals(this.cbLibrary.getSelectedItem())) continue;
                    this.currentRule.setLibrary(dRLibrary);
                    break;
                }
                this.currentRule.setFunction((String)this.cbMethod.getSelectedItem());
                this.currentRule.setScript(null);
            }
        }
    }

    private void loadCustomDR() {
        Iterator iterator = this.allCR.iterator();
        this.customScriptsContainerList.clear();
        while (iterator.hasNext()) {
            DRCustomValidationScript dRCustomValidationScript;
            Object e = iterator.next();
            if (!(e instanceof DRCustomValidationScript) || !(dRCustomValidationScript = ((DRCustomValidationScript)e).copy()).getPurpose().equals("validation")) continue;
            dRCustomValidationScript.setVariable(this.mapVariables.get(dRCustomValidationScript.getObject()));
            this.customScriptsContainerList.add(dRCustomValidationScript);
        }
        if (this.customScriptsContainerList.size() > 0) {
            this.customRulesTable.clearSelection();
            this.customRulesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.customRulesTable.updateUI();
        this.rulesSaved = true;
        this.bnSaveRules.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < CustomDesignRulesManager.this.customRulesTable.getRowCount(); ++i) {
                    if (!CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(i, 6).equals("err")) continue;
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.MissingEngine"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    break;
                }
            }
        });
    }

    protected JPanel createCustomRulesToolbarPanel() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        this.btnAddCustomRule = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddCustomRule.setToolTipText(Messages.getString("DesignRuleView.AddRule"));
        this.btnAddCustomRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DRCustomValidationScript dRCustomValidationScript = new DRCustomValidationScript(CustomDesignRulesManager.this.generateRuleName(), null, "validation");
                dRCustomValidationScript.setScriptEngineManager(CustomDesignRulesManager.this.scriptEngineManager);
                CustomDesignRulesManager.this.customScriptsContainerList.add(dRCustomValidationScript);
                CustomDesignRulesManager.this.customRulesTable.updateUI();
                CustomDesignRulesManager.this.customRulesTable.getSelectionModel().setSelectionInterval(CustomDesignRulesManager.this.customRulesTable.getRowCount() - 1, CustomDesignRulesManager.this.customRulesTable.getRowCount() - 1);
                CustomDesignRulesManager.this.customRulesTable.scrollRectToVisible(new Rectangle(CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth() * CustomDesignRulesManager.this.customRulesTable.getSelectedColumn(), CustomDesignRulesManager.this.customRulesTable.getRowHeight() * CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth(), CustomDesignRulesManager.this.customRulesTable.getRowHeight()));
                CustomDesignRulesManager.this.btnRemoveCustomRule.setEnabled(CustomDesignRulesManager.this.customScriptsContainerList.size() > 0);
                CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                CustomDesignRulesManager.this.rulesSaved = false;
            }
        });
        this.btnRemoveCustomRule = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveCustomRule.setToolTipText(Messages.getString("DesignRuleView.RemoveRule"));
        this.btnRemoveCustomRule.setEnabled(false);
        this.btnRemoveCustomRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomDesignRulesManager.this.customRulesTable.getSelectedRow();
                CustomDesignRulesManager.this.customScriptsContainerList.remove(n);
                CustomDesignRulesManager.this.customRulesTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomDesignRulesManager.this.customRulesTable.updateUI();
                CustomDesignRulesManager.this.customRulesTable.scrollRectToVisible(new Rectangle(CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth() * CustomDesignRulesManager.this.customRulesTable.getSelectedColumn(), CustomDesignRulesManager.this.customRulesTable.getRowHeight() * CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth(), CustomDesignRulesManager.this.customRulesTable.getRowHeight()));
                if (CustomDesignRulesManager.this.customScriptsContainerList.size() == 0) {
                    CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                    CustomDesignRulesManager.this.cbMethod.removeAllItems();
                    CustomDesignRulesManager.this.scriptEditor.setText("");
                    CustomDesignRulesManager.this.scriptEditor.setEnabled(false);
                    CustomDesignRulesManager.this.bnApply.setEnabled(false);
                }
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                CustomDesignRulesManager.this.rulesSaved = false;
            }
        });
        jToolBar.add(this.btnAddCustomRule);
        jToolBar.add(this.btnRemoveCustomRule);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        jPanel.add(jToolBar);
        return jPanel;
    }

    protected String generateRuleName() {
        String string = "Rule";
        int n = 0;
        int n2 = this.customScriptsContainerList.size();
        if (n2 != 0) {
            n = this.cgCounter = n2 + 1;
        } else {
            ++this.cgCounter;
            n = this.cgCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.ruleExists(string2)) {
            n = ++this.cgCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean ruleExists(String string) {
        for (int i = 0; i < this.customScriptsContainerList.size(); ++i) {
            DRCustomValidationScript dRCustomValidationScript = this.customScriptsContainerList.get(i);
            if (!string.equalsIgnoreCase(dRCustomValidationScript.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomDesignRulesManager.CustomDesignRules"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(1000, 600);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "CUSTOM_DESIGN_RULES_DIALOG";
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public void setCheckResults(Collection collection) {
        this.getCheckResultComponent().clearCheckResults();
        if (collection.size() > 0) {
            this.getCheckResultComponent().add(collection.toArray(new CheckResult[0]));
            this.getCheckResultComponent().bnSaveCSV.setEnabled(true);
            this.getCheckResultComponent().bnClearAll.setEnabled(true);
        } else if (!this.currentRule.hasEvalError()) {
            JOptionPane.showMessageDialog(this, Messages.getString("DesignRuleView.CheckDesignOK"));
        }
    }

    private void stopCellediting() {
        if (this.scriptEditor.isEnabled()) {
            this.currentRule.setScript(this.scriptEditor.getText());
        }
        for (DRLibrary object2 : this.appView.getCustomLibraries()) {
            if (!object2.getName().equals(this.cbLibrary.getSelectedItem())) continue;
            this.currentRule.setLibrary(object2);
            break;
        }
        this.currentRule.setFunction((String)this.cbMethod.getSelectedItem());
        TableCellEditor tableCellEditor = this.customRulesTable.getCellEditor();
        if (tableCellEditor != null) {
            this.customRulesTable.getCellEditor().stopCellEditing();
        }
    }

    public Action closeAction() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomDesignRulesManager.Close")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomDesignRulesManager.this.canClose()) {
                    CustomDesignRulesManager.this.nullifyDesignRuleManager();
                    CustomDesignRulesManager.this.close();
                }
            }
        };
        return abstractAction;
    }

    private ArrayList getObjecTypes() {
        DesignRuleManager designRuleManager = this.getRuleManager();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.objects = designRuleManager.getObjects();
        arrayList.addAll(this.objects.keySet());
        Set<Map.Entry<String, Object>> set = this.objects.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String string = entry.getKey();
            if (string.equals("Attribute")) {
                this.mapVariables.put(string, "attribute");
                this.mapClasses.put("attribute", Attribute.class);
                continue;
            }
            if (string.equals("Entity")) {
                this.mapVariables.put(string, "entity");
                this.mapClasses.put("entity", Entity.class);
                continue;
            }
            if (string.equals("Key")) {
                this.mapVariables.put(string, "key");
                continue;
            }
            if (string.equals("View")) {
                this.mapVariables.put(string, "entView");
                this.mapClasses.put("entView", EntityView.class);
                continue;
            }
            if (string.equals("External Agent")) {
                this.mapVariables.put(string, "extAgent");
                this.mapClasses.put("extAgent", ExternalAgent.class);
                continue;
            }
            if (string.equals("Information Flow")) {
                this.mapVariables.put(string, "infFlow");
                this.mapClasses.put("infFlow", Flow.class);
                continue;
            }
            if (string.equals("Information Store")) {
                this.mapVariables.put(string, "infStore");
                this.mapClasses.put("infStore", InfoStore.class);
                continue;
            }
            if (string.equals("Process")) {
                this.mapVariables.put(string, "process");
                this.mapClasses.put("process", Process.class);
                continue;
            }
            if (string.equals("Transformation Task")) {
                this.mapVariables.put(string, "trTask");
                this.mapClasses.put("trTask", TransformationTask.class);
                continue;
            }
            if (string.equals("Transformation")) {
                this.mapVariables.put(string, "transformation");
                this.mapClasses.put("transformation", Transformation.class);
                continue;
            }
            if (string.equals("Column")) {
                this.mapVariables.put(string, "column");
                this.mapClasses.put("column", Column.class);
                continue;
            }
            if (string.equals("Domain")) {
                this.mapVariables.put(string, "domain");
                this.mapClasses.put("domain", Domain.class);
                continue;
            }
            if (string.equals("Index/Constraint")) {
                this.mapVariables.put(string, "index");
                this.mapClasses.put("index", Index.class);
                continue;
            }
            if (string.equals("Table Level Constraint")) {
                this.mapVariables.put(string, "tlConstraint");
                this.mapClasses.put("tlConstraint", Constraint.class);
                continue;
            }
            if (!string.equals("Table")) continue;
            this.mapVariables.put(string, "table");
            this.mapClasses.put("table", Table.class);
        }
        return arrayList;
    }

    public CheckResultComponent getCheckResultComponent() {
        if (this.checkResultComponent == null) {
            this.checkResultComponent = new CheckResultComponent(this.appView);
        }
        return this.checkResultComponent;
    }

    private DesignRuleManager getRuleManager() {
        return this.getDesign().getAppView().getDesignRuleManager(this.appView.getCurrentDesign().getRelationalDesign());
    }

    protected boolean canSave() {
        block6: {
            block7: {
                if (this.customScriptsContainerList.size() <= 0) break block6;
                if (this.customRulesTable.getSelectedRow() <= -1) break block7;
                if (this.customRulesTable.getModel().getValueAt(this.customRulesTable.getSelectedRow(), 2) == null) {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.NoObjectChosen"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                if (this.customRulesTable.getModel().getValueAt(this.customRulesTable.getSelectedRow(), 3) == null) {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.NoEngineChosen"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                if (this.customRulesTable.getModel().getValueAt(this.customRulesTable.getSelectedRow(), 4) == null) {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.NoTypeChosen"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                if (this.scriptEditor.getText().trim().length() == 0 || this.scriptEditor.getText() == null) {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.NoScript"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                for (DRCustomValidationScript dRCustomValidationScript : this.customScriptsContainerList) {
                    if (dRCustomValidationScript.getObject() != null && dRCustomValidationScript.getEngineName() != null && dRCustomValidationScript.getResultType() != null && (dRCustomValidationScript.getLibrary() != null || !dRCustomValidationScript.getScript().equals(""))) continue;
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.NoObjectEngineScript"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                break block6;
            }
            if (this.customRulesTable.getSelectedRow() != -1) break block6;
            for (DRCustomValidationScript dRCustomValidationScript : this.customScriptsContainerList) {
                if (dRCustomValidationScript.getObject() != null && dRCustomValidationScript.getEngineName() != null && dRCustomValidationScript.getResultType() != null && (dRCustomValidationScript.getLibrary() != null || !dRCustomValidationScript.getScript().equals(""))) continue;
                JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.NoObjectEngineScript"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canClose() {
        if (!this.rulesSaved) {
            String string = Messages.getString("CustomDesignRulesManager.Yes");
            String string2 = Messages.getString("CustomDesignRulesManager.No");
            Object[] objectArray = new Object[]{string, string2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("CustomDesignRulesManager.RulesNotSaved"), Messages.getString("CustomDesignRulesManager.CloseConfirmation"), 0, 3, null, objectArray, string);
            return n == 0;
        }
        return true;
    }

    public ArrayList getResultTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Warning");
        arrayList.add("Error");
        return arrayList;
    }

    public RelationalDesign getRelDesign() {
        return this.relDesign;
    }

    public ArrayList<String> getLibraries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<DRLibrary> iterator = this.appView.getCustomLibraries().iterator();
        arrayList.add("");
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getName());
        }
        return arrayList;
    }

    private boolean checkIfEngineSupportsInvocable(String string) {
        ScriptEngine scriptEngine;
        String string2 = string;
        return string2 != null && !string2.equals("") && (scriptEngine = this.scriptEngineManager.getEngineByName(string2)) instanceof Invocable;
    }

    public Action createImportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomDesignRulesManager.Import")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                URLFilter uRLFilter = new URLFilter(){

                    public boolean accept(URL uRL) {
                        File file = new File(uRL.getPath());
                        return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("CustomDesignRulesManager.XMLFiles");
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(0);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setURLFilter(uRLFilter);
                if (lastImpFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                } else {
                    String string = CustomDesignRulesManager.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        serializable = CustomDesignRulesManager.this.getApplicationView().getUserHomeDirectory();
                        if (serializable != null) {
                            uRLChooser.setSelectedURL((URL)serializable);
                        }
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("CustomDesignRulesManager.ImportCDR"));
                if (n == 0) {
                    CustomDesignRulesManager.this.file = new File(uRLChooser.getSelectedURL().getPath());
                    if (CustomDesignRulesManager.this.file != null) {
                        lastImpFolder = CustomDesignRulesManager.this.file.getParentFile();
                        try {
                            int n2;
                            serializable = new StringBuffer();
                            FileInputStream fileInputStream = new FileInputStream(CustomDesignRulesManager.this.file);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            while ((n2 = ((Reader)bufferedReader).read()) > -1) {
                                ((StringBuffer)serializable).append((char)n2);
                            }
                            ((Reader)bufferedReader).close();
                            CustomDesignRulesManager.this.importCDR(((StringBuffer)serializable).toString());
                        }
                        catch (Exception exception) {
                            LOGGER.error("Unable to load custom design rules from imported file: ", exception);
                        }
                    }
                }
            }
        };
        return abstractAction;
    }

    public void importCDR(String string) {
        try {
            Object object;
            Object object2;
            DRCustomValidationScript dRCustomValidationScript;
            Object object3;
            int n;
            StringReader stringReader = new StringReader(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            ArrayList<DRCustomValidationScript> arrayList = new ArrayList<DRCustomValidationScript>();
            NodeList nodeList = document.getElementsByTagName("scr");
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                object3 = null;
                Element element = (Element)nodeList.item(n);
                dRCustomValidationScript = new DRCustomValidationScript(element.getAttribute(StringUtilities.decodeAttributeValue("name")), element.getAttribute("id"), element.getAttribute("purpose"));
                dRCustomValidationScript.setObject(element.getAttribute("object"));
                dRCustomValidationScript.setEngineName(element.getAttribute("engine"));
                dRCustomValidationScript.setResultType(element.getAttribute("type"));
                dRCustomValidationScript.setVariable(element.getAttribute("var"));
                dRCustomValidationScript.setScriptEngineManager(this.appView.getScriptEngineManager());
                object2 = element.getChildNodes();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < object2.getLength(); ++i) {
                    object = object2.item(i);
                    stringBuffer.append(object.getTextContent());
                }
                Object object4 = element.getAttribute("library");
                if (object4 != null && ((String)object4).trim().length() > 0) {
                    object = element.getAttribute("method");
                    for (DRLibrary dRLibrary : this.appView.getCustomLibraries()) {
                        if (!dRLibrary.getName().equals(StringUtilities.decodeAttributeValue((String)object4))) continue;
                        dRCustomValidationScript.setLibrary(dRLibrary);
                        if (dRLibrary.getFunctions().contains(object)) {
                            dRCustomValidationScript.setFunction((String)object);
                        } else {
                            dRLibrary.getFunctions().add((String)object);
                            dRCustomValidationScript.setFunction((String)object);
                        }
                        object3 = dRLibrary;
                        break;
                    }
                    if (object3 == null) {
                        object3 = new DRLibrary(StringUtilities.decodeAttributeValue(element.getAttribute("library")), null);
                        ((DRLibrary)object3).setFunctions(new ArrayList<String>());
                        ((DRLibrary)object3).setEngine(element.getAttribute("engine"));
                        ((DRLibrary)object3).getFunctions().add(StringUtilities.decodeAttributeValue((String)object));
                        ((DRLibrary)object3).setScript(stringBuffer.toString().trim());
                        dRCustomValidationScript.setFunction((String)object);
                        dRCustomValidationScript.setLibrary((DRLibrary)object3);
                        this.appView.getCustomLibraries().add((DRLibrary)object3);
                        this.cbLibrary.removeAllItems();
                        Iterator<String> iterator = this.getLibraries().iterator();
                        while (iterator.hasNext()) {
                            this.cbLibrary.addItem(iterator.next());
                        }
                    }
                }
                dRCustomValidationScript.setScript(stringBuffer.toString().trim());
                arrayList.add(dRCustomValidationScript);
            }
            n = 0;
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                boolean bl = false;
                dRCustomValidationScript = (DRCustomValidationScript)object3.next();
                object2 = dRCustomValidationScript.getRuleId();
                for (Object object4 : this.allCR) {
                    object = ((DRCustomScript)object4).getRuleId();
                    if (!((String)object2).equals(object)) {
                        bl = false;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.allCR.add(dRCustomValidationScript);
                this.customScriptsContainerList.add(dRCustomValidationScript);
                n = 1;
            }
            if (n != 0) {
                this.appView.saveCustomDRScripts();
            }
            this.customRulesTable.updateUI();
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Unable to export libraries: ", runtimeException);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to import custom design rules: ", exception);
        }
    }

    public Action createExportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomDesignRulesManager.Export")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomDesignRulesManager.this.rulesSaved) {
                    Object object;
                    URLFilter uRLFilter = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("CustomDesignRulesManager.XMLFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter(uRLFilter);
                    if (lastExpFolder != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                    } else {
                        String string = CustomDesignRulesManager.this.getApplicationView().getSettings().getDefaultSavePath();
                        if (string != null && string.length() > 0) {
                            uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                        } else {
                            object = CustomDesignRulesManager.this.getApplicationView().getUserHomeDirectory();
                            if (object != null) {
                                uRLChooser.setSelectedURL((URL)object);
                            }
                        }
                    }
                    int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CustomDesignRulesManager.ExportCDR"));
                    if (n == 0) {
                        object = uRLChooser.getSelectedURL().getPath();
                        int n2 = ((String)object).lastIndexOf(".");
                        if (n2 > -1) {
                            CustomDesignRulesManager.this.file = new File(((String)object).substring(0, n2) + ".xml");
                        } else {
                            CustomDesignRulesManager.this.file = new File((String)object + ".xml");
                        }
                        if (CustomDesignRulesManager.this.file != null) {
                            lastExpFolder = CustomDesignRulesManager.this.file.getParentFile();
                            CustomDesignRulesManager.this.exportCDR();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.NotSaved"), Messages.getString("CustomDesignRulesManager.Error"), 0);
                }
            }
        };
        return abstractAction;
    }

    public void exportCDR() {
        boolean bl = true;
        try {
            int outputStreamWriter;
            StringBuffer stringBuffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            stringBuffer.append("\n");
            stringBuffer.append("<!-- File contains Custom Validation Scripts -->");
            stringBuffer.append("\n");
            stringBuffer.append("<").append("custom__validation_scripts").append(">");
            for (DRCustomValidationScript object2 : this.customScriptsContainerList) {
                stringBuffer.append("\n");
                stringBuffer.append("\t").append("<").append("scr").append(' ');
                stringBuffer.append("id=\"").append(object2.getRuleId()).append("\"").append(' ');
                stringBuffer.append("name=\"").append(StringUtilities.encodeAttributeValue(object2.getName())).append("\"").append(' ');
                stringBuffer.append("object=\"").append(object2.getObject()).append("\"").append(' ');
                stringBuffer.append("engine=\"").append(object2.getEngineName()).append("\"").append(' ');
                stringBuffer.append("type=\"").append(object2.getResultType() != null ? object2.getResultType() : "").append("\"").append(' ');
                stringBuffer.append("var=\"").append(object2.getVariable()).append("\"").append(' ');
                stringBuffer.append("library=\"").append(StringUtilities.encodeAttributeValue(object2.getLibrary() != null ? object2.getLibrary().getName() : "")).append("\"").append(' ');
                stringBuffer.append("method=\"").append(StringUtilities.encodeAttributeValue(object2.getFunction())).append("\"").append(' ');
                stringBuffer.append("purpose=\"").append(StringUtilities.encodeAttributeValue(object2.getPurpose())).append("\"").append(' ');
                stringBuffer.append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("script").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t\t").append("<![CDATA[").append(object2.getScript() != null ? object2.getScript() : "").append("]]>");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("</").append("script").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t").append("</").append("scr").append(">");
            }
            stringBuffer.append("\n");
            stringBuffer.append("</").append("custom__validation_scripts").append(">");
            File file = new File(this.file.toString());
            if (file.exists() && (outputStreamWriter = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomDesignRulesManager.FileExists"), file), Messages.getString("CustomDesignRulesManager.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                bl = false;
            }
            if (bl) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter2.write(stringBuffer.toString());
                outputStreamWriter2.close();
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Unable to export libraries: ", runtimeException);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to export custom design rules: ", exception);
        }
    }

    private void nullifyDesignRuleManager() {
        this.getDesign().getAppView().nullifyDesignRuleManager();
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 489944703777167381L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl) {
                component.setBackground(jTable.getSelectionBackground());
                component.setForeground(jTable.getSelectionForeground());
            } else {
                component.setBackground(jTable.getBackground());
                component.setForeground(jTable.getForeground());
            }
            if (jTable.getModel().getValueAt(n, 6).equals("err")) {
                component.setForeground(Color.RED);
            }
            return component;
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CustomDesignRulesManager.this.rulesSaved) {
                if (CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 6).equals("err")) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("CustomDesignRulesManager.CannotApply"), CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 1), CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 2), CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 3)), Messages.getString("CustomDesignRulesManager.Error"), 0);
                } else if (CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 6).equals("ok")) {
                    ArrayList arrayList = new ArrayList();
                    if (CustomDesignRulesManager.this.customRulesTable.getSelectedRow() > -1 && CustomDesignRulesManager.this.scriptEditor.getText() != null && !CustomDesignRulesManager.this.scriptEditor.getText().trim().equals("")) {
                        DRCustomValidationScript dRCustomValidationScript = CustomDesignRulesManager.this.customScriptsContainerList.get(CustomDesignRulesManager.this.customRulesTable.getSelectedRow());
                        RuleHandler ruleHandler = dRCustomValidationScript.getRuleHandler();
                        ruleHandler.hasEvalErr = false;
                        ruleHandler.applyRule(arrayList, dRCustomValidationScript);
                        CustomDesignRulesManager.this.setCheckResults(arrayList);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, Messages.getString("CustomDesignRulesManager.ApplyRuleNotSaved"), Messages.getString("CustomDesignRulesManager.Warning"), 0);
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomDesignRulesManager.this.stopCellediting();
            if (CustomDesignRulesManager.this.canSave()) {
                CustomDesignRulesManager.this.saveSelected();
                ArrayList<DRCustomValidationScript> arrayList = new ArrayList<DRCustomValidationScript>();
                for (Object object : CustomDesignRulesManager.this.allCR) {
                    DRCustomValidationScript dRCustomValidationScript;
                    if (!(object instanceof DRCustomValidationScript) || !(dRCustomValidationScript = (DRCustomValidationScript)object).getPurpose().equals("validation")) continue;
                    arrayList.add(dRCustomValidationScript);
                }
                for (DRCustomValidationScript dRCustomValidationScript : CustomDesignRulesManager.this.customScriptsContainerList) {
                    dRCustomValidationScript.compiledScript = null;
                }
                CustomDesignRulesManager.this.allCR.removeAll(arrayList);
                CustomDesignRulesManager.this.allCR.addAll(CustomDesignRulesManager.this.customScriptsContainerList);
                CustomDesignRulesManager.this.getRuleManager().addRemoveCustomRules();
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(false);
                CustomDesignRulesManager.this.bnApply.setEnabled(true);
                CustomDesignRulesManager.this.rulesSaved = true;
                CustomDesignRulesManager.this.appView.saveCustomDRScripts();
            }
        }
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField jTextField) {
            super(jTextField);
            this.tf = jTextField;
            jTextField.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tf.setText(object.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = jTable;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            String string = jTextField.getText().trim();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(null, Messages.getString("DesignRuleView.NameEmpty"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
            TableModel tableModel = this.tab.getModel();
            for (DRCustomValidationScript dRCustomValidationScript : ((CustomRuleModel)tableModel).getCustomRulesContainerList()) {
                if (!dRCustomValidationScript.getName().equals(string) || string.equals(this.val)) continue;
                JOptionPane.showMessageDialog(null, Messages.getString("DesignRuleView.NameExists"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
            CustomDesignRulesManager.this.currentRule.setScript(CustomDesignRulesManager.this.scriptEditor.getText());
            return super.stopCellEditing();
        }
    }

    private class CustomRuleModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -362794593669886434L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomDesignRulesManager.Name"), Messages.getString("CustomDesignRulesManager.Object"), Messages.getString("CustomDesignRulesManager.Engine"), Messages.getString("CustomDesignRulesManager.Type"), Messages.getString("CustomDesignRulesManager.Variable"), "state"};

        private CustomRuleModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomDesignRulesManager.this.customScriptsContainerList.size();
        }

        public List<DRCustomValidationScript> getCustomRulesContainerList() {
            return CustomDesignRulesManager.this.customScriptsContainerList;
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0 || n2 == 5) {
                return false;
            }
            return n2 != 3 || !this.getValueAt(n, 6).equals("err");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DRCustomValidationScript dRCustomValidationScript = CustomDesignRulesManager.this.customScriptsContainerList.get(n);
            String string = dRCustomValidationScript.getObject();
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return dRCustomValidationScript.getName();
            }
            if (n2 == 2) {
                return string;
            }
            if (n2 == 3) {
                return dRCustomValidationScript.getEngineName();
            }
            if (n2 == 4) {
                return dRCustomValidationScript.getResultType();
            }
            if (n2 == 5) {
                if (string != null) {
                    return CustomDesignRulesManager.this.mapVariables.get(dRCustomValidationScript.getObject());
                }
            } else if (n2 == 6) {
                if (dRCustomValidationScript.getEngineName() != null) {
                    for (String string2 : CustomDesignRulesManager.this.allEngines) {
                        if (!string2.equals(dRCustomValidationScript.getEngineName())) continue;
                        return "ok";
                    }
                    return "err";
                }
                return "ok";
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.getRowCount() > n) {
                DRCustomValidationScript dRCustomValidationScript = CustomDesignRulesManager.this.customScriptsContainerList.get(n);
                if (n2 == 1) {
                    dRCustomValidationScript.setName(object.toString());
                } else if (n2 == 2) {
                    dRCustomValidationScript.setObject((String)object);
                    if (object != null) {
                        dRCustomValidationScript.setVariable((String)CustomDesignRulesManager.this.mapVariables.get(object));
                        dRCustomValidationScript.setRuleHandler((RuleHandler)CustomDesignRulesManager.this.objects.get(object));
                    }
                } else if (n2 == 3) {
                    dRCustomValidationScript.setEngineName((String)object);
                } else if (n2 == 4) {
                    dRCustomValidationScript.setResultType((String)object);
                }
            }
        }
    }
}

