/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.designrules.CRAdapter;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class CheckResultComponent
extends JPanel {
    private static final long serialVersionUID = -4575436576944253090L;
    private JList jlist;
    private JTextField counterField;
    private CRListModel listModel;
    public JButton bnSaveCSV;
    public JButton bnClearAll;
    private ApplicationView appView;
    private File file;
    private List checkResults = new ArrayList();
    private static final Logger LOGGER;
    private static File lastFolder;

    public CheckResultComponent(ApplicationView applicationView) {
        this.appView = applicationView;
        this.init();
    }

    protected void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("CheckResultComponent.Results")));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.getCounterField(), "North");
        jPanel3.add((Component)new JScrollPane(this.getJList()), "Center");
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        this.bnClearAll = new JButton(this.createClearAllAction());
        this.bnClearAll.setEnabled(false);
        this.bnClearAll.setToolTipText(Messages.getString("CheckResultComponent.ClearTooltip"));
        this.bnClearAll.setMnemonic(76);
        this.bnClearAll.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel4.add(this.bnClearAll);
        this.bnSaveCSV = new JButton(Messages.getString("CheckResultComponent.SaveCSV"));
        this.bnSaveCSV.setToolTipText(Messages.getString("CheckResultComponent.SaveCSVFile"));
        this.bnSaveCSV.setEnabled(false);
        this.bnSaveCSV.addActionListener(new SaveAction());
        this.bnSaveCSV.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.bnSaveCSV.setMnemonic(83);
        jPanel4.add(this.bnSaveCSV);
        jPanel2.add((Component)jPanel4, "South");
        jPanel.add(jPanel2);
        this.add(jPanel);
    }

    protected JList getJList() {
        if (this.jlist == null) {
            this.jlist = new JList(this.getListModel());
            this.jlist.setCellRenderer(new CRRenderer());
            this.jlist.addMouseListener(this.createDoubleClickMouseAdapter());
            this.jlist.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        int n = listSelectionEvent.getFirstIndex();
                        CheckResult checkResult = (CheckResult)CheckResultComponent.this.getListModel().getElementAt(n);
                    }
                }
            });
        }
        return this.jlist;
    }

    protected CRListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new CRListModel();
        }
        return this.listModel;
    }

    public Action createCheckAllAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.RecheckAll")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckResultComponent.this.recheckAll();
            }
        };
    }

    public Action createCheckSelectedAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.RecheckSelected")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckResultComponent.this.recheckSelected();
            }
        };
    }

    public Action createClearAllAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.Clear")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckResultComponent.this.clearCheckResults();
                CheckResultComponent.this.bnSaveCSV.setEnabled(false);
            }
        };
    }

    public Action createClearOKAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.RemoveOK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckResultComponent.this.clearOKCheckResults();
            }
        };
    }

    protected MouseListener createDoubleClickMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = CheckResultComponent.this.getJList().locationToIndex(mouseEvent.getPoint());
                    CheckResultComponent.this.getListModel().selectInModel(n);
                }
            }
        };
    }

    protected JTextField getCounterField() {
        if (this.counterField == null) {
            this.counterField = new JTextField();
            this.counterField.setEditable(false);
        }
        return this.counterField;
    }

    public void add(CheckResult checkResult) {
        this.getListModel().add(checkResult);
    }

    private void updateCounters(CheckResult[] checkResultArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < checkResultArray.length; ++i) {
            CheckResult checkResult = checkResultArray[i];
            if (checkResult.isWarning()) {
                ++n2;
                continue;
            }
            if (checkResult.isOk()) continue;
            ++n;
        }
        this.getCounterField().setText("ERRORS:" + n + "WARNINGS:" + n2);
    }

    public void add(Collection collection) {
        this.getListModel().add(collection.toArray(new CheckResult[0]));
    }

    public void add(CheckResult[] checkResultArray) {
        this.updateCounters(checkResultArray);
        this.getListModel().add(checkResultArray);
    }

    public void remove(CheckResult checkResult) {
        this.getListModel().remove(checkResult);
    }

    public void clearCheckResults() {
        this.getListModel().removeAll();
        this.getCounterField().setText("");
    }

    public void clearOKCheckResults() {
        this.getListModel().removeAllOK();
    }

    public void recheckAll() {
        this.getListModel().recheckAll();
    }

    public void recheckSelected() {
        this.getListModel().recheckSelected();
    }

    public void saveResults() {
        Writer writer = null;
        try {
            EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
            FileOutputStream fileOutputStream = new FileOutputStream(this.file.toString());
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, environOptions.getEncoding());
            writer.append("Type,Object,Message,Object Type Name,Object ID");
            writer.append("\n");
            for (CRAdapter cRAdapter : this.checkResults) {
                if (!(cRAdapter.getAffected() instanceof ModelIDObject)) continue;
                DesignObject designObject = (DesignObject)cRAdapter.getAffected();
                writer.append((cRAdapter.toString().substring(0, cRAdapter.toString().lastIndexOf(":")) + ":" + "\"" + cRAdapter.toString().substring(cRAdapter.toString().lastIndexOf(":") + 1, cRAdapter.toString().length()).trim() + "\"" + ":" + designObject.getObjectTypeName() + ":" + designObject.getObjectID()).replace(":", ","));
                writer.append("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to save results: ", exception);
            try {
                writer.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to close weiter: ", exception);
            }
        }
    }

    static {
        lastFolder = null;
        LOGGER = new Logger(CheckResultComponent.class);
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("CheckResultComponent.CSVFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String string = CheckResultComponent.this.appView.getSettings().getDefaultSavePath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    object = CheckResultComponent.this.appView.getUserHomeDirectory();
                    if (object != null) {
                        uRLChooser.setSelectedURL((URL)object);
                    }
                }
            }
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CheckResultComponent.SaveResults"));
            if (n == 0) {
                object = uRLChooser.getSelectedURL().getPath();
                int n2 = ((String)object).lastIndexOf(".");
                if (n2 > -1) {
                    CheckResultComponent.this.file = new File(((String)object).substring(0, n2) + ".csv");
                } else {
                    CheckResultComponent.this.file = new File((String)object + ".csv");
                }
                if (CheckResultComponent.this.file != null) {
                    lastFolder = CheckResultComponent.this.file.getParentFile();
                    CheckResultComponent.this.saveResults();
                }
            }
        }
    }

    static class CRRenderer
    extends DefaultListCellRenderer {
        private final Color COLOR_ERROR = new Color(16718351);
        private final Color COLOR_WARNING = new Color(1033471);
        private final Color COLOR_INFO = new Color(4380752);
        private final Color COLOR_CUSTOM = new Color(0xFFFF66);

        CRRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null && object instanceof CheckResult) {
                CheckResult checkResult = (CheckResult)object;
                jLabel.setToolTipText(checkResult.getRule().getDescription());
                if (checkResult.isInfo()) {
                    jLabel.setBackground(bl ? this.COLOR_INFO.darker() : this.COLOR_INFO);
                } else if (checkResult.isWarning()) {
                    jLabel.setBackground(bl ? this.COLOR_WARNING.darker() : this.COLOR_WARNING);
                } else if (checkResult.isCustom()) {
                    jLabel.setBackground(bl ? this.COLOR_CUSTOM.darker() : this.COLOR_CUSTOM);
                } else if (!checkResult.isOk()) {
                    jLabel.setBackground(bl ? this.COLOR_ERROR.darker() : this.COLOR_ERROR);
                }
            }
            return jLabel;
        }
    }

    class CRListModel
    extends AbstractListModel
    implements UpdateListener {
        CRListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            if (n > -1 && n < CheckResultComponent.this.checkResults.size()) {
                return CheckResultComponent.this.checkResults.get(n);
            }
            return null;
        }

        @Override
        public int getSize() {
            return CheckResultComponent.this.checkResults.size();
        }

        protected void fireChangeAdded(int n) {
            this.fireChangeAdded(n, n);
        }

        protected void fireChangeAdded(int n, int n2) {
            this.fireIntervalAdded(this, n, n2);
        }

        protected void fireChangeRemoved(int n) {
            this.fireChangeRemoved(n, n);
        }

        protected void fireChangeRemoved(int n, int n2) {
            this.fireIntervalRemoved(this, n, n2);
        }

        protected void fireContentChange() {
            this.fireContentChange(0, this.getSize() - 1);
        }

        protected void fireContentChange(int n, int n2) {
            this.fireContentsChanged(this, n, n2);
        }

        public void add(CheckResult checkResult) {
            CheckResultComponent.this.checkResults.add(checkResult);
            checkResult.addUpdateListener(this);
            this.fireChangeAdded(CheckResultComponent.this.checkResults.indexOf(checkResult));
        }

        public void add(CheckResult[] checkResultArray) {
            int n = CheckResultComponent.this.checkResults.size();
            int n2 = n + checkResultArray.length;
            for (int i = 0; i < checkResultArray.length; ++i) {
                this.add(checkResultArray[i]);
            }
            this.fireChangeAdded(n, n2);
        }

        public void remove(CheckResult checkResult) {
            int n = CheckResultComponent.this.checkResults.indexOf(checkResult);
            CheckResultComponent.this.checkResults.remove(n);
            checkResult.removeUpdateListener(this);
            this.fireChangeRemoved(n);
        }

        public void removeAll() {
            if (!CheckResultComponent.this.checkResults.isEmpty()) {
                int n = CheckResultComponent.this.checkResults.size() - 1;
                for (CheckResult checkResult : CheckResultComponent.this.checkResults) {
                    checkResult.removeUpdateListener(this);
                }
                CheckResultComponent.this.checkResults.clear();
                this.fireChangeRemoved(0, n);
            }
        }

        public void removeAllOK() {
            Iterator iterator = CheckResultComponent.this.checkResults.iterator();
            while (iterator.hasNext()) {
                CheckResult checkResult = (CheckResult)iterator.next();
                if (!checkResult.isOk()) continue;
                iterator.remove();
            }
            this.fireContentChange();
        }

        public void selectInModel(int n) {
            CheckResult checkResult;
            if (n < CheckResultComponent.this.checkResults.size() && (checkResult = (CheckResult)CheckResultComponent.this.checkResults.get(n)) != null) {
                checkResult.selectInModel();
            }
        }

        public void recheck(int n) {
            CheckResult checkResult;
            if (n < CheckResultComponent.this.checkResults.size() && (checkResult = (CheckResult)CheckResultComponent.this.checkResults.get(n)) != null) {
                checkResult.reCheck();
            }
        }

        public void recheck(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                this.recheck(nArray[i]);
            }
        }

        public void recheckSelected() {
            int[] nArray = CheckResultComponent.this.getJList().getSelectedIndices();
            this.recheck(nArray);
        }

        public void recheckAll() {
            int n = CheckResultComponent.this.checkResults.size();
            for (int i = 0; i < n; ++i) {
                this.recheck(i);
            }
        }

        @Override
        public void update() {
            this.fireContentChange();
        }
    }
}

