/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ddl.Messages;

public class DDLSelectionTabs {
    private JPanel panel;
    private JTable table;
    private List list;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;
    private GUIConfiguration configuration;

    public DDLSelectionTabs(JPanel jPanel, JTable jTable, List list) {
        this.panel = jPanel;
        this.table = jTable;
        this.list = list;
        this.initPanel();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.table.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.table);
        this.configuration = GUIConfiguration.getInstance();
        this.btnSelectAll = new JButton(this.configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.btnSelectAll.setToolTipText(Messages.getString("DDLSelectionTabs.SelectAll"));
        this.btnDeselectAll = new JButton(this.configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.btnDeselectAll.setToolTipText(Messages.getString("DDLSelectionTabs.DeselectAll"));
        this.btnSelectAll.addActionListener(new SelectAllListener(this.list, this.table));
        this.btnDeselectAll.addActionListener(new DeselectAllListener(this.list, this.table));
        this.toolBar = new JToolBar(0);
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.btnSelectAll);
        this.toolBar.add(this.btnDeselectAll);
        this.panel.add((Component)this.toolBar, "North");
        this.panel.add((Component)this.scrollPane, "Center");
    }

    private int getPreferredIconSize() {
        return 16;
    }

    public class DeselectAllListener
    implements ActionListener {
        private List deselList;
        private JTable deselTable;

        public DeselectAllListener(List list, JTable jTable) {
            this.deselList = list;
            this.deselTable = jTable;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (ModelIdObjectSelection modelIdObjectSelection : this.deselList) {
                modelIdObjectSelection.setSelected(false);
            }
            this.deselTable.updateUI();
        }
    }

    public class SelectAllListener
    implements ActionListener {
        private List selList;
        private JTable selTable;

        public SelectAllListener(List list, JTable jTable) {
            this.selList = list;
            this.selTable = jTable;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (ModelIdObjectSelection modelIdObjectSelection : this.selList) {
                modelIdObjectSelection.setSelected(true);
            }
            this.selTable.updateUI();
        }
    }

    public class ObjectModel
    extends AbstractTableModel {
        private List modelList;

        public ObjectModel(List list) {
            this.modelList = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionTabs.ObjectName");
            }
            if (n == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                return modelIdObjectSelection.isSelected();
            }
            if (n2 == 1) {
                SynonymOracle synonymOracle;
                if (modelIdObjectSelection.getObject() instanceof SynonymSqlServer) {
                    if (((SynonymSqlServer)modelIdObjectSelection.getObject()).getProcedure() != null) {
                        return ((SynonymSqlServer)modelIdObjectSelection.getObject()).getProcedure().getLongName();
                    }
                    if (((SynonymSqlServer)modelIdObjectSelection.getObject()).getTable() != null) {
                        return ((SynonymSqlServer)modelIdObjectSelection.getObject()).getTable().getLongName();
                    }
                    if (((SynonymSqlServer)modelIdObjectSelection.getObject()).getView() != null) {
                        return ((SynonymSqlServer)modelIdObjectSelection.getObject()).getView().getLongName();
                    }
                }
                if ((synonymOracle = (SynonymOracle)modelIdObjectSelection.getObject()).getObjectUser() != null) {
                    return new StringBuffer(synonymOracle.getObjectUser().getLongName()).append('.').append(synonymOracle.getObject()).toString();
                }
                return synonymOracle.getObject();
            }
            if (n2 == 2) {
                if (modelIdObjectSelection.getObject() instanceof SynonymOracle) {
                    SynonymOracle synonymOracle = (SynonymOracle)modelIdObjectSelection.getObject();
                    return synonymOracle.getLongName();
                }
                return modelIdObjectSelection.getName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                modelIdObjectSelection.setSelected((Boolean)object);
            }
        }
    }

    public class UserModel
    extends AbstractTableModel {
        private List modelList;

        public UserModel(List list) {
            this.modelList = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                return modelIdObjectSelection.isSelected();
            }
            if (n2 == 1) {
                if (modelIdObjectSelection.getObject() instanceof UserSqlServer) {
                    return ((UserSqlServer)modelIdObjectSelection.getObject()).getDatabase().getName() + "." + modelIdObjectSelection.getObject().getName();
                }
                return ((SchemaSqlServer)modelIdObjectSelection.getObject()).getDatabase().getName() + "." + modelIdObjectSelection.getObject().getName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                modelIdObjectSelection.setSelected((Boolean)object);
            }
        }
    }

    public class ConstraintModel
    extends AbstractTableModel {
        private List modelList;

        public ConstraintModel(List list) {
            this.modelList = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionTabs.TableName");
            }
            if (n == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= this.modelList.size()) return null;
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                return modelIdObjectSelection.isSelected();
            }
            if (n2 == 1) {
                if (modelIdObjectSelection.getObject() instanceof Index) {
                    if (!modelIdObjectSelection.getObject().getDesign().getRelationalDesign().getStorageDesign().isOpen()) return ((Index)modelIdObjectSelection.getObject()).getContainerObject().getLongName();
                    Iterator iterator = modelIdObjectSelection.getObject().getDesign().getRelationalDesign().getStorageDesign().getTableProxySet().iterator();
                    while (iterator.hasNext()) {
                        TableProxy tableProxy = (TableProxy)iterator.next();
                        if (!tableProxy.getObjectID().equals(((Index)modelIdObjectSelection.getObject()).getContainerObject().getObjectID())) continue;
                        return tableProxy.getLongName();
                    }
                    return ((IndexProxy)modelIdObjectSelection.getObject()).getTableProxy().getLongName();
                } else {
                    if (modelIdObjectSelection.getObject() instanceof FKIndexAssociation) {
                        return ((FKIndexAssociation)modelIdObjectSelection.getObject()).getContainerWithKeyObject().getLongName();
                    }
                    if (modelIdObjectSelection.getObject() instanceof BitmapJoinIndexOracle) {
                        return ((BitmapJoinIndexOracle)modelIdObjectSelection.getObject()).getTable().getLongName();
                    }
                    if (modelIdObjectSelection.getObject() instanceof Trigger) {
                        if (modelIdObjectSelection.getObject().getDesign().getRelationalDesign().getStorageDesign() instanceof StorageDesignOracle) {
                            if (((TriggerOracle)modelIdObjectSelection.getObject()).getTable() != null) {
                                return ((TriggerOracle)modelIdObjectSelection.getObject()).getTable().getLongName();
                            }
                            if (((TriggerOracle)modelIdObjectSelection.getObject()).getView() == null) return ((IndexProxy)modelIdObjectSelection.getObject()).getTableProxy().getLongName();
                            return ((TriggerOracle)modelIdObjectSelection.getObject()).getView().getLongName();
                        }
                        if (modelIdObjectSelection.getObject().getDesign().getRelationalDesign().getStorageDesign() instanceof StorageDesignUDB) {
                            if (((TriggerUDB)modelIdObjectSelection.getObject()).getTable() != null) {
                                return ((TriggerUDB)modelIdObjectSelection.getObject()).getTable().getLongName();
                            }
                            if (((TriggerUDBv81)modelIdObjectSelection.getObject()).getView() == null) return ((IndexProxy)modelIdObjectSelection.getObject()).getTableProxy().getLongName();
                            return ((TriggerUDBv81)modelIdObjectSelection.getObject()).getView().getLongName();
                        }
                        if (!(modelIdObjectSelection.getObject().getDesign().getRelationalDesign().getStorageDesign() instanceof StorageDesignSqlServer)) return ((IndexProxy)modelIdObjectSelection.getObject()).getTableProxy().getLongName();
                        if (((TriggerSqlServer)modelIdObjectSelection.getObject()).getTable() != null) {
                            return ((TriggerSqlServer)modelIdObjectSelection.getObject()).getTable().getLongName();
                        }
                        if (((TriggerSqlServer)modelIdObjectSelection.getObject()).getView() == null) return ((IndexProxy)modelIdObjectSelection.getObject()).getTableProxy().getLongName();
                        return ((TriggerSqlServer)modelIdObjectSelection.getObject()).getView().getLongName();
                    }
                    if (!(modelIdObjectSelection.getObject() instanceof IndexOnViewSqlServer)) return ((IndexProxy)modelIdObjectSelection.getObject()).getTableProxy().getLongName();
                    return ((IndexOnViewSqlServer)modelIdObjectSelection.getObject()).getView().getLongName();
                }
            }
            if (n2 != 2) return new Integer(n * n2);
            if (modelIdObjectSelection.getObject() instanceof Index) {
                if (!((Index)modelIdObjectSelection.getObject()).isPK()) return modelIdObjectSelection.getName();
                return "(PK) " + modelIdObjectSelection.getName();
            }
            if (!(modelIdObjectSelection.getObject() instanceof IndexProxy)) return modelIdObjectSelection.getName();
            if (!((IndexProxy)modelIdObjectSelection.getObject()).getIndex().isPK()) return modelIdObjectSelection.getName();
            return "(PK) " + modelIdObjectSelection.getName();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                modelIdObjectSelection.setSelected((Boolean)object);
            }
        }
    }

    public class TableViewSchemaModel
    extends AbstractTableModel {
        private List modelList;

        public TableViewSchemaModel(List list) {
            this.modelList = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionTabs.Schema");
            }
            if (n == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.modelList.size()) {
                ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
                ModelIDObject modelIDObject = modelIdObjectSelection.getObject();
                String string = modelIDObject.getLongName();
                String string2 = "";
                String string3 = string;
                int n3 = string.indexOf(46);
                if (n3 > 0 && n3 < string.length() - 1) {
                    string2 = string.substring(0, n3);
                    string3 = string.substring(n3 + 1);
                }
                if (n2 == 0) {
                    return modelIdObjectSelection.isSelected();
                }
                if (n2 == 1) {
                    return string2;
                }
                if (n2 == 2) {
                    return string3;
                }
                return new Integer(n * n2);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                modelIdObjectSelection.setSelected((Boolean)object);
            }
        }
    }

    public class TableViewModel
    extends AbstractTableModel {
        private List modelList;

        public TableViewModel(List list) {
            this.modelList = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                return modelIdObjectSelection.isSelected();
            }
            if (n2 == 1) {
                return modelIdObjectSelection.getObject().getLongName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.modelList.get(n);
            if (n2 == 0) {
                modelIdObjectSelection.setSelected((Boolean)object);
            }
        }
    }
}

