/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionOraclev8i;

public class DDLSelectionOraclev9i
extends DDLSelectionOraclev8i {
    private static final String UNDO_TABLESPACES = Messages.getString("DDLSelectionOraclev9i.UndoTablespaces");
    private static final String BJINDEXES = Messages.getString("DDLSelectionOraclev9i.BitmapJoinIndexes");
    private static final String EXTERNAL_TABLES = Messages.getString("DDLSelectionOraclev9i.ExternalTables");
    private static final String COLLECTION_TYPES = Messages.getString("DDLSelectionOraclev9i.CollectionTypes");
    private List extTableList;
    private List collTypeList;
    private List bjList;

    public DDLSelectionOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public DDLSelectionOraclev9i(StorageDesign storageDesign, DesignPartView designPartView) {
        super(storageDesign, designPartView);
    }

    @Override
    protected void addFromStorageDesign() {
        super.addFromStorageDesign();
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            this.addObjects(UNDO_TABLESPACES, this, ((StorageDesignOraclev9i)this.getStorageDesign()).getUndoTablespaceSet().getElementsList());
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            this.addObjects(UNDO_TABLESPACES, this, ((StorageDesignOraclev10g)this.getStorageDesign()).getUndoTablespaceSet().getElementsList());
        }
        this.sort();
    }

    @Override
    protected void addObjectsNotAssignedToUsers(String string, ModelIdObjectSelection modelIdObjectSelection) {
        super.addObjectsNotAssignedToUsers(string, modelIdObjectSelection);
        for (ModelIdObjectSelection modelIdObjectSelection2 : modelIdObjectSelection.getChilds()) {
            if (!modelIdObjectSelection2.getName().equalsIgnoreCase(string)) continue;
            this.addContainerObjects(COLLECTION_TYPES, modelIdObjectSelection2, this.getCollTypeWithoutUser(), this.getCollTypeList());
            this.addContainerObjects(EXTERNAL_TABLES, modelIdObjectSelection2, this.getExtTablesWithoutUser(), this.getExtTableList());
            modelIdObjectSelection2.sort();
        }
    }

    @Override
    protected void addUserDetails(UserOracle userOracle, ModelIdObjectSelection modelIdObjectSelection) {
        super.addUserDetails(userOracle, modelIdObjectSelection);
        List list = this.getExtTablesForUser(userOracle);
        if (list.size() > 0) {
            this.addContainerObjects(EXTERNAL_TABLES, modelIdObjectSelection, list, this.getExtTableList());
            modelIdObjectSelection.sort();
        }
        if ((list = this.getCollTypeForUser(userOracle)).size() > 0) {
            this.addContainerObjects(COLLECTION_TYPES, modelIdObjectSelection, list, this.getCollTypeList());
            modelIdObjectSelection.sort();
        }
    }

    @Override
    protected void addTableProxyDetails(TableProxyOracle tableProxyOracle, ModelIdObjectSelection modelIdObjectSelection) {
        super.addTableProxyDetails(tableProxyOracle, modelIdObjectSelection);
        StorageObjectCollection storageObjectCollection = null;
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            storageObjectCollection = ((TableProxyOraclev9i)tableProxyOracle).getBjIndexes();
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            storageObjectCollection = ((TableProxyOraclev10g)tableProxyOracle).getBjIndexes();
        }
        if (storageObjectCollection != null && storageObjectCollection.size() > 0) {
            this.addContainerObjects(BJINDEXES, modelIdObjectSelection, storageObjectCollection.getElementsList(), this.getBjList());
        }
    }

    @Override
    public List getExtTableList() {
        if (this.extTableList == null) {
            this.extTableList = new ArrayList();
        }
        return this.extTableList;
    }

    @Override
    public List getCollTypeList() {
        if (this.collTypeList == null) {
            this.collTypeList = new ArrayList();
        }
        return this.collTypeList;
    }

    private List getExtTablesWithoutUser() {
        ArrayList<ExternalTableOracle> arrayList = new ArrayList<ExternalTableOracle>();
        List list = new ArrayList();
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            list = ((StorageDesignOraclev9i)this.getStorageDesign()).getExternalTableSet().getElementsList();
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            list = ((StorageDesignOraclev10g)this.getStorageDesign()).getExternalTableSet().getElementsList();
        }
        if (list.size() > 0) {
            for (ExternalTableOracle externalTableOracle : list) {
                if (externalTableOracle.getOwner() != null) continue;
                arrayList.add(externalTableOracle);
            }
        }
        return arrayList;
    }

    private List getExtTablesForUser(UserOracle userOracle) {
        ArrayList<ExternalTableOracle> arrayList = new ArrayList<ExternalTableOracle>();
        List list = new ArrayList();
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            list = ((StorageDesignOraclev9i)this.getStorageDesign()).getExternalTableSet().getElementsList();
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            list = ((StorageDesignOraclev10g)this.getStorageDesign()).getExternalTableSet().getElementsList();
        }
        if (list.size() > 0) {
            for (ExternalTableOracle externalTableOracle : list) {
                if (externalTableOracle.getOwner() == null || !externalTableOracle.getOwner().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
                arrayList.add(externalTableOracle);
            }
        }
        return arrayList;
    }

    private List getCollTypeWithoutUser() {
        ArrayList<CollectionTypeProxyOracle> arrayList = new ArrayList<CollectionTypeProxyOracle>();
        Iterator iterator = this.getStorageDesign().getCollectionTypeProxySet().iterator();
        while (iterator.hasNext()) {
            CollectionTypeProxyOracle collectionTypeProxyOracle = (CollectionTypeProxyOracle)iterator.next();
            if (collectionTypeProxyOracle.getOwner() != null) continue;
            arrayList.add(collectionTypeProxyOracle);
        }
        return arrayList;
    }

    private List getCollTypeForUser(UserOracle userOracle) {
        ArrayList<CollectionTypeProxyOracle> arrayList = new ArrayList<CollectionTypeProxyOracle>();
        Iterator iterator = this.getStorageDesign().getCollectionTypeProxySet().iterator();
        while (iterator.hasNext()) {
            CollectionTypeProxyOracle collectionTypeProxyOracle = (CollectionTypeProxyOracle)iterator.next();
            if (collectionTypeProxyOracle.getOwner() == null || !collectionTypeProxyOracle.getOwner().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(collectionTypeProxyOracle);
        }
        return arrayList;
    }

    @Override
    public List getBjList() {
        if (this.bjList == null) {
            this.bjList = new ArrayList();
        }
        return this.bjList;
    }
}

