/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.ddl.DDLFileMakerEditor;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.SyntaxDocument;
import oracle.dbtools.crest.swingui.ddl.SyntaxOffDocument;
import oracle.dbtools.crest.swingui.ddl.models.DDLCheckEditor;
import oracle.dbtools.crest.swingui.ddl.models.DDLNavigationTreeRenderer;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionDB2;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionOraclev8i;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionTabs;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionUDBv71;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionUDBv81;
import oracle.dbtools.crest.swingui.ddl.models.DDLTreeNavigationDesign;
import oracle.dbtools.crest.swingui.designrules.DesignRuleView;
import oracle.dbtools.crest.swingui.editor.DDLExceptionPropertyDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public class DDLSelectionDialog
extends CustomDialog {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTabbedPane selectionTabbedPane;
    String BTN_OK = Messages.getString("DDLSelectionDialog.OK");
    String BTN_APPLY = Messages.getString("DDLSelectionDialog.Apply");
    String BTN_CANCEL = Messages.getString("DDLSelectionDialog.Cancel");
    private JButton bnCancel;
    private JTree tree;
    private JPanel treePanel;
    private JPanel dropPanel;
    private DDLTreeNavigationDesign stdes;
    private StorageDesign storageDesign;
    private JFrame owner;
    private JCheckBox chIncludeComments;
    private JComboBox cbDDLType;
    private JButton bnDesRules;
    private DDLFileMakerEditor fileMakerEditor;
    private DefaultListModel dropableModel;
    private JList dropableList;
    private List drpList = new ArrayList();
    private JDialog dialog;
    private JPanel optionsPanel;
    private List eList;
    private JTable eTable;
    private int counter = 0;
    private JCheckBox chApplyNameSubstitution;
    private JPanel substPanel;
    private List substitutionList;
    private JTable tbSubstituiton;
    private JButton bnAddColumn;
    private JButton bnRemoveColumn;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private List objectTypesList = new ArrayList();
    private JTable tbObjectTypes;
    private static final String BTN_ADD = Messages.getString("DDLSelectionDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("DDLSelectionDialog.Remove");
    private List insertionList = new ArrayList();
    private JTable insertionTable;
    private List triggerList = new ArrayList();
    private List packagesList = new ArrayList();
    private List packageBodiesList = new ArrayList();
    private List stProcList = new ArrayList();
    private List functionsList = new ArrayList();
    private List typeList = new ArrayList();
    private List aliasList = new ArrayList();
    private static final Logger LOGGER = new Logger(DDLSelectionDialog.class);
    JToolBar dropBar;
    JCheckBox chbDropGenerated;
    JCheckBox chbUseDropDependency;
    private Settings settings;

    public DDLSelectionDialog(ApplicationView applicationView, StorageDesign storageDesign, DDLFileMakerEditor dDLFileMakerEditor) {
        super(applicationView);
        this.fileMakerEditor = dDLFileMakerEditor;
        this.owner = (JFrame)dDLFileMakerEditor.getDialog();
        this.storageDesign = storageDesign;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbedPane.setPreferredSize(new Dimension(750, 470));
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)this.getOptionsPanel(), "South");
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(this.BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        this.bnCancel = new JButton(this.BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        JButton jButton2 = new JButton(this.getHelpAction());
        jButton2.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.settings = this.getDesign().getDLSettings();
        jPanel2.add(jButton);
        jPanel2.add(this.bnCancel);
        jPanel2.add(jButton2);
        this.add((Component)jPanel2, "South");
        this.initProperties();
    }

    @Override
    public Design getDesign() {
        if (this.storageDesign != null) {
            return this.storageDesign.getDesign();
        }
        return super.getDesign();
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.fileMakerEditor.getDialog(), this.getCaption());
            this.dialog.setModal(true);
            this.dialog.setDefaultCloseOperation(2);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "DDL_GENERATION_OPTIONS_DIALOG";
    }

    public String getCaption() {
        return Messages.getString("DDLSelectionDialog.DDLGenerationOptions");
    }

    private void initProperties() {
        this.initTreePanel();
        this.initDropPanel();
        this.initNameSubstitutionPanel();
        this.initInsertionPanel();
        this.initDDLExceptionsPanel();
        this.tabbedPane.setEnabledAt(4, this.cbDDLType.getSelectedIndex() > 0);
    }

    private void initInsertionPanel() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        this.insertionList = new ArrayList();
        Iterator iterator = this.getDesign().getRelationalDesign().getTableSet().iterator();
        while (iterator.hasNext()) {
            object2 = (Table)iterator.next();
            if (!this.checkForScripts((Table)object2)) continue;
            object = new InsertionObject((Table)object2, ((ContainerObject)object2).getShouldGenerateScript());
            this.insertionList.add(object);
        }
        object2 = new InsertionModel();
        this.insertionTable = new JTable((TableModel)object2);
        this.insertionTable.setSelectionMode(0);
        this.insertionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = DDLSelectionDialog.this.insertionTable.getSelectedColumn();
                    int n2 = DDLSelectionDialog.this.insertionTable.getSelectedRow();
                    if (n2 != -1 && n == 1 && DDLSelectionDialog.this.insertionList.size() > 0 && n2 < DDLSelectionDialog.this.insertionList.size()) {
                        InsertionObject insertionObject = (InsertionObject)DDLSelectionDialog.this.insertionList.get(n2);
                        Table table = insertionObject.getObject();
                        table.showModal = true;
                        table.showPropertyDialog();
                        if (!DDLSelectionDialog.this.checkForScripts(table)) {
                            DDLSelectionDialog.this.insertionList.remove(insertionObject);
                        } else {
                            insertionObject.setObject(table);
                            insertionObject.setSelected(table.getShouldGenerateScript());
                        }
                        DDLSelectionDialog.this.insertionTable.updateUI();
                    }
                }
            }
        });
        object = this.insertionTable.getColumnModel().getColumn(0);
        ((TableColumn)object).setPreferredWidth(100);
        object = this.insertionTable.getColumnModel().getColumn(1);
        ((TableColumn)object).setPreferredWidth(200);
        JScrollPane jScrollPane = new JScrollPane(this.insertionTable);
        jPanel.add(jScrollPane);
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.IncludeTableScripts"), jPanel);
    }

    private boolean checkForScripts(Table table) {
        return !table.getBeforeDrop().trim().equals("") || !table.getBeforeCreate().trim().equals("") || !table.getAfterCreate().trim().equals("") || !table.getEndOfScript().trim().equals("");
    }

    private void initNameSubstitutionPanel() {
        this.substPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = this.createSubstitutionPanel();
        JPanel jPanel2 = this.createObjectTypesPanel();
        jTabbedPane.add(Messages.getString("DDLSelectionDialog.NameSubstitution"), jPanel);
        jTabbedPane.add(Messages.getString("DDLSelectionDialog.ObjectTypes"), jPanel2);
        this.substPanel.add(jTabbedPane);
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.NameSubstitution"), this.substPanel);
    }

    private JPanel createObjectTypesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        this.objectTypesList = this.storageDesign.getNameSubstitutionTypesList();
        ObjectTypesModel objectTypesModel = new ObjectTypesModel();
        this.tbObjectTypes = new JTable(objectTypesModel);
        this.tbObjectTypes.setSelectionMode(0);
        TableColumn tableColumn = this.tbObjectTypes.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = this.tbObjectTypes.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(400);
        JScrollPane jScrollPane = new JScrollPane(this.tbObjectTypes);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private void initTreePanel() {
        this.selectionTabbedPane = new JTabbedPane();
        this.selectionTabbedPane.setTabPlacement(3);
        this.treePanel = new JPanel(new BorderLayout());
        DesignPartView designPartView = (DesignPartView)this.fileMakerEditor.getDesignSubViewCombo().getSelectedItem();
        if (designPartView == null || designPartView.getName().equals(this.getDesign().getRelationalDesign().getName())) {
            this.stdes = new DDLTreeNavigationDesign(this.storageDesign);
            designPartView = null;
        } else {
            this.stdes = new DDLTreeNavigationDesign(this.storageDesign, designPartView);
        }
        this.stdes.setSelectedSubView(designPartView);
        this.tree = new JTree(this.stdes);
        this.tree.setEditable(true);
        DDLNavigationTreeRenderer dDLNavigationTreeRenderer = new DDLNavigationTreeRenderer();
        this.tree.setCellRenderer(dDLNavigationTreeRenderer);
        DDLCheckEditor dDLCheckEditor = new DDLCheckEditor();
        this.tree.setCellEditor(dDLCheckEditor);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.treePanel.add((Component)jScrollPane, "Center");
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.TreeView"), this.treePanel);
        List list = ((DDLSelectionLists)this.stdes.getRoot()).getTableList();
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable();
        this.initObjectTab(jPanel, jTable, list);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Tables"), jPanel);
        List list2 = ((DDLSelectionLists)this.stdes.getRoot()).getConstraintList();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JTable jTable2 = new JTable();
        this.initContainerTab(jPanel2, jTable2, list2);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.PKUKConstraints"), jPanel2);
        List list3 = ((DDLSelectionLists)this.stdes.getRoot()).getIndexList();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JTable jTable3 = new JTable();
        this.initContainerTab(jPanel3, jTable3, list3);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Indexes"), jPanel3);
        List list4 = ((DDLSelectionLists)this.stdes.getRoot()).getFkList();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JTable jTable4 = new JTable();
        this.initContainerTab(jPanel4, jTable4, list4);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.ForeignKeys"), jPanel4);
        List list5 = ((DDLSelectionLists)this.stdes.getRoot()).getViewList();
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JTable jTable5 = new JTable();
        this.initObjectTab(jPanel5, jTable5, list5);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Views"), jPanel5);
        if (this.storageDesign.isOpen()) {
            Object object;
            JComponent jComponent;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            JComponent jComponent2;
            Object object6;
            Object object7;
            JComponent jComponent3;
            JComponent jComponent4;
            Object object8;
            Object object9;
            JComponent jComponent5;
            Object object10;
            Object object11;
            JComponent jComponent6;
            Object object12;
            Object object13;
            JComponent jComponent7;
            Object object14;
            Object object15;
            JComponent jComponent8;
            Object object16;
            if (this.storageDesign instanceof StorageDesignUDB || this.storageDesign instanceof StorageDesignDB2v70 || this.storageDesign instanceof StorageDesignDB2v80) {
                if (this.storageDesign instanceof StorageDesignUDB) {
                    this.aliasList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getAliasList();
                } else if (this.storageDesign instanceof StorageDesignDB2v70 || this.storageDesign instanceof StorageDesignDB2v80) {
                    this.aliasList = ((DDLSelectionDB2)this.stdes.getRoot()).getAliasList();
                }
                object16 = new JPanel(new BorderLayout());
                jComponent8 = new JTable();
                this.initObjectTab((JPanel)object16, (JTable)jComponent8, this.aliasList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Aliases"), (Component)object16);
                if (this.storageDesign instanceof StorageDesignDB2v70 || this.storageDesign instanceof StorageDesignDB2v80) {
                    object15 = ((DDLSelectionDB2)this.stdes.getRoot()).getAuxTableList();
                    object14 = new JPanel(new BorderLayout());
                    jComponent7 = new JTable();
                    this.initObjectTab((JPanel)object14, (JTable)jComponent7, (List)object15);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.AuxTables"), (Component)object14);
                    this.stProcList = ((DDLSelectionDB2)this.stdes.getRoot()).getStoredProcedureList();
                    object13 = new JPanel(new BorderLayout());
                    object12 = new JTable();
                    this.initObjectTab((JPanel)object13, (JTable)object12, this.stProcList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StoredProcedures"), (Component)object13);
                }
            }
            if (this.storageDesign instanceof StorageDesignOracle || this.storageDesign instanceof StorageDesignUDB) {
                if (this.storageDesign instanceof StorageDesignOracle) {
                    this.triggerList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getTriggerList();
                    this.packagesList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getPackagesList();
                    this.packageBodiesList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getPackageBodiesList();
                    this.stProcList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getStoredProceduresList();
                    this.functionsList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getFunctionsList();
                    this.typeList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getTypeList();
                    object16 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getClusterList();
                    jComponent8 = new JPanel(new BorderLayout());
                    object15 = new JTable();
                    this.initObjectTab((JPanel)jComponent8, (JTable)object15, (List)object16);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Clusters"), jComponent8);
                    object14 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getDimensionList();
                    jComponent7 = new JPanel(new BorderLayout());
                    object13 = new JTable();
                    this.initObjectTab((JPanel)jComponent7, (JTable)object13, (List)object14);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Dimensions"), jComponent7);
                    object12 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getSnapshotList();
                    jComponent6 = new JPanel(new BorderLayout());
                    object11 = new JTable();
                    this.initObjectTab((JPanel)jComponent6, (JTable)object11, (List)object12);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Snapshots"), jComponent6);
                    object10 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getSynonymList();
                    jComponent5 = new JPanel(new BorderLayout());
                    object9 = new JTable();
                    this.initObjectModelTab((JPanel)jComponent5, (JTable)object9, (List)object10);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Synonyms"), jComponent5);
                    object8 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getSequenceList();
                    jComponent4 = new JPanel(new BorderLayout());
                    jComponent3 = new JTable();
                    this.initObjectTab((JPanel)jComponent4, (JTable)jComponent3, (List)object8);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Sequences"), jComponent4);
                    if (this.storageDesign instanceof StorageDesignOraclev9i || this.storageDesign instanceof StorageDesignOraclev10g) {
                        object7 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getBjList();
                        object6 = new JPanel(new BorderLayout());
                        jComponent2 = new JTable();
                        this.initContainerTab((JPanel)object6, (JTable)jComponent2, (List)object7);
                        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.BitmapJoinIndexes"), (Component)object6);
                        object5 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getExtTableList();
                        object4 = new JPanel(new BorderLayout());
                        object3 = new JTable();
                        this.initObjectTab((JPanel)object4, (JTable)object3, (List)object5);
                        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.ExternalTables"), (Component)object4);
                        object2 = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getCollTypeList();
                        jComponent = new JPanel(new BorderLayout());
                        object = new JTable();
                        this.initObjectTab((JPanel)jComponent, (JTable)object, (List)object2);
                        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.CollectionTypes"), jComponent);
                    }
                } else if (this.storageDesign instanceof StorageDesignUDB) {
                    this.triggerList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getTriggerList();
                    this.stProcList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getStoredProcedureList();
                    this.typeList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getTypeList();
                }
                object16 = new JPanel(new BorderLayout());
                jComponent8 = new JTable();
                this.initContainerTab((JPanel)object16, (JTable)jComponent8, this.triggerList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Triggers"), (Component)object16);
                if (this.storageDesign instanceof StorageDesignOracle) {
                    object15 = new JPanel(new BorderLayout());
                    object14 = new JTable();
                    this.initObjectTab((JPanel)object15, (JTable)object14, this.packagesList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Packages"), (Component)object15);
                    jComponent7 = new JPanel(new BorderLayout());
                    object13 = new JTable();
                    this.initObjectTab((JPanel)jComponent7, (JTable)object13, this.packageBodiesList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.PackageBodies"), jComponent7);
                }
                object15 = new JPanel(new BorderLayout());
                object14 = new JTable();
                this.initObjectTab((JPanel)object15, (JTable)object14, this.stProcList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StoredProcedures"), (Component)object15);
                if (this.storageDesign instanceof StorageDesignOracle) {
                    jComponent7 = new JPanel(new BorderLayout());
                    object13 = new JTable();
                    this.initObjectTab((JPanel)jComponent7, (JTable)object13, this.functionsList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Functions"), jComponent7);
                }
                jComponent7 = new JPanel(new BorderLayout());
                object13 = new JTable();
                this.initObjectTab((JPanel)jComponent7, (JTable)object13, this.typeList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StructuredTypes"), jComponent7);
                if (this.storageDesign instanceof StorageDesignUDBv81) {
                    object12 = ((DDLSelectionUDBv81)this.stdes.getRoot()).getSequenceList();
                    jComponent6 = new JPanel(new BorderLayout());
                    object11 = new JTable();
                    this.initObjectTab((JPanel)jComponent6, (JTable)object11, (List)object12);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Sequences"), jComponent6);
                }
            }
            if (this.storageDesign instanceof StorageDesignSqlServer) {
                object16 = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getDatabaseList();
                jComponent8 = new JPanel(new BorderLayout());
                object15 = new JTable();
                this.initObjectTab((JPanel)jComponent8, (JTable)object15, (List)object16);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Databases"), jComponent8);
                this.triggerList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getTriggerList();
                object14 = new JPanel(new BorderLayout());
                jComponent7 = new JTable();
                this.initContainerTab((JPanel)object14, (JTable)jComponent7, this.triggerList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Triggers"), (Component)object14);
                object13 = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getDefaultList();
                object12 = new JPanel(new BorderLayout());
                jComponent6 = new JTable();
                this.initObjectTab((JPanel)object12, (JTable)jComponent6, (List)object13);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Defaults"), (Component)object12);
                object11 = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getRoleList();
                object10 = new JPanel(new BorderLayout());
                jComponent5 = new JTable();
                this.initObjectTab((JPanel)object10, (JTable)jComponent5, (List)object11);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Roles"), (Component)object10);
                object9 = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getRuleList();
                object8 = new JPanel(new BorderLayout());
                jComponent4 = new JTable();
                this.initObjectTab((JPanel)object8, (JTable)jComponent4, (List)object9);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Rules"), (Component)object8);
                this.stProcList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getProcedureList();
                jComponent3 = new JPanel(new BorderLayout());
                object7 = new JTable();
                this.initObjectTab((JPanel)jComponent3, (JTable)object7, this.stProcList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StoredProcedures"), jComponent3);
                object6 = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getUserList();
                jComponent2 = new JPanel(new BorderLayout());
                object5 = new JTable();
                object4 = new DDLSelectionTabs((JPanel)jComponent2, (JTable)object5, (List)object6);
                DDLSelectionTabs dDLSelectionTabs = object4;
                dDLSelectionTabs.getClass();
                ((JTable)object5).setModel(new DDLSelectionTabs.UserModel(dDLSelectionTabs, (List)object6));
                this.setColumnWidth((JTable)object5);
                if (this.storageDesign instanceof StorageDesignSqlServerv2k) {
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Users"), jComponent2);
                } else if (this.storageDesign instanceof StorageDesignSqlServerv2k5) {
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Schemas"), jComponent2);
                    object3 = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getSynonymList();
                    object2 = new JPanel(new BorderLayout());
                    jComponent = new JTable();
                    this.initObjectModelTab((JPanel)object2, (JTable)jComponent, (List)object3);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Synonyms"), (Component)object2);
                    object = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getDistTypeList();
                    JPanel jPanel6 = new JPanel(new BorderLayout());
                    JTable jTable6 = new JTable();
                    this.initObjectTab(jPanel6, jTable6, (List)object);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.UDDTDistinctTypes"), jPanel6);
                    List list6 = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getDomainTypeList();
                    JPanel jPanel7 = new JPanel(new BorderLayout());
                    JTable jTable7 = new JTable();
                    this.initObjectTab(jPanel7, jTable7, list6);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.UDDTDomains"), jPanel7);
                    List list7 = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getCollTypeList();
                    JPanel jPanel8 = new JPanel(new BorderLayout());
                    JTable jTable8 = new JTable();
                    this.initObjectTab(jPanel8, jTable8, list7);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.XMLSchemaCollections"), jPanel8);
                }
            }
        }
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.CreateSelection"), this.selectionTabbedPane);
    }

    private void initDropPanel() {
        Object object;
        Object object22;
        this.dropBar = new JToolBar(0);
        this.dropBar.setFloatable(false);
        this.dropableModel = new DefaultListModel();
        this.chbDropGenerated = new JCheckBox(Messages.getString("DDLSelectionDialog.DropGeneratedObjectsOnly"));
        Design.DROP_GENERATED_OBJECTS_ONLY = true;
        this.chbDropGenerated.setSelected(Design.DROP_GENERATED_OBJECTS_ONLY);
        this.dropBar.add(this.chbDropGenerated);
        this.chbUseDropDependency = new JCheckBox(Messages.getString("DDLSelectionDialog.UseDropDependencies"));
        Design.USE_DROP_DEPENDENCY = true;
        this.chbUseDropDependency.setSelected(Design.USE_DROP_DEPENDENCY);
        this.dropBar.add(this.chbUseDropDependency);
        this.dropableList = new JList(this.dropableModel);
        List list = null;
        if (this.storageDesign.isOpen()) {
            list = this.storageDesign.getDropableSets();
        } else if (this.storageDesign.getPhysicalDesign() != null) {
            list = this.storageDesign.getPhysicalDesign().getDropableSets();
        }
        for (Object object22 : list) {
            object = new Dropable((ModelObject)object22);
            this.drpList.add(object);
        }
        this.dropableList.setListData(this.drpList.toArray());
        object22 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object e;
                if (!DDLSelectionDialog.this.dropableList.isEnabled()) {
                    return;
                }
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                Rectangle rectangle = jList.getCellBounds(n, n);
                if (n > -1 && (e = jList.getModel().getElementAt(n)) != null && e instanceof Dropable && rectangle.contains(mouseEvent.getPoint())) {
                    Dropable dropable = (Dropable)e;
                    boolean bl = dropable.selected;
                    dropable.selected = !bl;
                    jList.repaint(rectangle);
                }
            }
        };
        this.dropableList.setCellRenderer(new CBCellRenderer());
        this.dropableList.addMouseListener((MouseListener)object22);
        this.dropPanel = new JPanel(new BorderLayout());
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add((Component)this.dropableList, null);
        this.dropPanel.add((Component)this.dropBar, "North");
        this.dropPanel.add((Component)object, "Center");
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.DropSelection"), this.dropPanel);
    }

    private void initDDLExceptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.eList = new ArrayList<DDLException>(this.getApplicationView().getDDLExceptionList().getDDLExceptions());
        this.eTable = new JTable(new DDLExceptionsModel());
        this.eTable.setSelectionMode(0);
        TableColumn tableColumn = this.eTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = this.eTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(200);
        this.eTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DDLSelectionDialog.this.eTable.getSelectedRow()) != -1 && DDLSelectionDialog.this.eList.size() > 0 && n < DDLSelectionDialog.this.eList.size()) {
                    DDLException dDLException = (DDLException)DDLSelectionDialog.this.eList.get(n);
                    DDLExceptionPropertyDialog dDLExceptionPropertyDialog = new DDLExceptionPropertyDialog(DDLSelectionDialog.this.getApplicationView(), dDLException, (JDialog)DDLSelectionDialog.this.getDialog());
                    dDLExceptionPropertyDialog.initProperties();
                    dDLExceptionPropertyDialog.showDialog();
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.eTable);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", 16));
        jButton.setToolTipText(Messages.getString("DDLSelectionDialog.ViewProperties"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DDLSelectionDialog.this.eTable.getSelectedRow();
                if (n != -1 && DDLSelectionDialog.this.eList.size() > 0 && n < DDLSelectionDialog.this.eList.size()) {
                    DDLException dDLException = (DDLException)DDLSelectionDialog.this.eList.get(n);
                    DDLExceptionPropertyDialog dDLExceptionPropertyDialog = new DDLExceptionPropertyDialog(DDLSelectionDialog.this.getApplicationView(), dDLException, (JDialog)DDLSelectionDialog.this.getDialog());
                    dDLExceptionPropertyDialog.initProperties();
                    dDLExceptionPropertyDialog.showDialog();
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton2.setToolTipText(Messages.getString("DDLSelectionDialog.AddDDLException"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DDLException dDLException = new DDLException(DDLSelectionDialog.this.generateNumber(), "");
                if (DDLSelectionDialog.this.getApplicationView().getDDLExceptionList().addDDLException(dDLException)) {
                    DDLSelectionDialog.this.eList.add(dDLException);
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        jButton3.setToolTipText(Messages.getString("DDLSelectionDialog.RemoveDDLException"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DDLSelectionDialog.this.eTable.getSelectedRow();
                if (n != -1 && DDLSelectionDialog.this.eList.size() > 0 && n < DDLSelectionDialog.this.eList.size()) {
                    DDLException dDLException = (DDLException)DDLSelectionDialog.this.eList.get(n);
                    DDLSelectionDialog.this.eList.remove(dDLException);
                    DDLSelectionDialog.this.getApplicationView().getDDLExceptionList().removeDDLException(dDLException);
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel2.add(jToolBar);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add(jScrollPane);
        jPanel.add(jPanel3);
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.OracleErrorsToMask"), jPanel);
    }

    @Override
    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private void setProperties() {
        Object object;
        Design.DROP_GENERATED_OBJECTS_ONLY = this.chbDropGenerated.isSelected();
        Design.USE_DROP_DEPENDENCY = this.chbUseDropDependency.isSelected();
        ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.stdes.getRoot();
        modelIdObjectSelection.applySelectionToObjects();
        for (Object object2 : this.drpList) {
            object = null;
            if (((Dropable)object2).collection instanceof ModelIDObjectSet) {
                object = ((ModelIDObjectSet)((Dropable)object2).collection).iterator();
            } else if (((Dropable)object2).collection instanceof DesignObjectSet) {
                object = ((DesignObjectSet)((Dropable)object2).collection).iterator();
            } else if (((Dropable)object2).collection instanceof RelationalObjectProxySet) {
                object = ((RelationalObjectProxySet)((Dropable)object2).collection).iterator();
            }
            if (object == null) continue;
            while (object.hasNext()) {
                ModelIDObject modelIDObject = (ModelIDObject)object.next();
                modelIDObject.setDropEnabled(((Dropable)object2).selected);
            }
        }
        for (Object object2 : this.insertionList) {
            object = ((InsertionObject)object2).getObject();
            ((ContainerObject)object).setShouldGenerateScript(((InsertionObject)object2).isSelected);
        }
    }

    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel(new FlowLayout(0));
            this.optionsPanel.setBorder(BorderFactory.createEtchedBorder());
            this.bnDesRules = new JButton(Messages.getString("DDLSelectionDialog.DesignRules"));
            this.bnDesRules.setIcon(this.getConfiguration().getIcon("DESIGN_RULES_ICON", 16));
            this.bnDesRules.setMnemonic(82);
            this.bnDesRules.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
            this.bnDesRules.addActionListener(new DesignRulesAction());
            this.chIncludeComments = new JCheckBox(Messages.getString("DDLSelectionDialog.IncludeComments"));
            this.chIncludeComments.setSelected(false);
            this.cbDDLType = new JComboBox<Object>(DDLGenerationOptions.DDL_TYPES);
            this.cbDDLType.setEnabled(this.canSelect());
            this.cbDDLType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DDLSelectionDialog.this.tabbedPane.setEnabledAt(4, DDLSelectionDialog.this.cbDDLType.getSelectedIndex() > 0);
                    DDLGenerationOptions.setDDLType(DDLSelectionDialog.this.cbDDLType.getSelectedIndex());
                }
            });
            this.chApplyNameSubstitution = new JCheckBox(Messages.getString("DDLSelectionDialog.ApplyNameSubstitution"));
            this.chApplyNameSubstitution.setSelected(false);
            this.optionsPanel.add(this.bnDesRules);
            this.optionsPanel.add(this.chIncludeComments);
            this.optionsPanel.add(this.chApplyNameSubstitution);
            this.optionsPanel.add(this.cbDDLType);
        }
        return this.optionsPanel;
    }

    private boolean canSelect() {
        return this.storageDesign instanceof StorageDesignOracle;
    }

    private void cancelTableEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).cancelCellEditing();
        }
    }

    private void stopTableEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private void showDesignRules() {
        DesignRuleView designRuleView = new DesignRuleView(this.getApplicationView(), this.storageDesign.getPhysicalDesign(), null);
        designRuleView.getDialog((JDialog)this.getDialog()).setVisible(true);
    }

    protected int generateNumber() {
        int n = 0;
        int n2 = this.eList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        while (this.numberExists(n)) {
            n = ++this.counter;
        }
        return n;
    }

    private boolean numberExists(int n) {
        for (int i = 0; i < this.eList.size(); ++i) {
            DDLException dDLException = (DDLException)this.eList.get(i);
            if (n != dDLException.getNumber()) continue;
            return true;
        }
        return false;
    }

    private JPanel createSubstitutionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        this.createSubstitutionDefaultsPanel(jPanel);
        return jPanel;
    }

    private void createSubstitutionDefaultsPanel(JPanel jPanel) {
        Object object;
        Object object22;
        this.substitutionList = new ArrayList();
        for (Object object22 : this.settings.getSubstitutionList()) {
            object = new SubstitutionPattern(((SubstitutionPattern)object22).getSourceString(), ((SubstitutionPattern)object22).getReplacementString(), ((SubstitutionPattern)object22).isSelected(), ((SubstitutionPattern)object22).isCaseSensitive(), ((SubstitutionPattern)object22).getComments());
            this.substitutionList.add(object);
        }
        object22 = new SubstitutionModel();
        this.tbSubstituiton = new JTable((TableModel)object22);
        this.tbSubstituiton.setSelectionMode(0);
        object = new JScrollPane(this.tbSubstituiton);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.bnAddColumn = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        this.bnAddColumn.setToolTipText(BTN_ADD);
        this.bnAddColumn.addActionListener(new AddSubstitutionAction());
        this.bnRemoveColumn = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.bnRemoveColumn.setToolTipText(BTN_REMOVE);
        this.bnRemoveColumn.addActionListener(new RemoveSubstitutionAction());
        this.bnSelectAll = new JButton(gUIConfiguration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.bnSelectAll.setToolTipText(Messages.getString("DDLSelectionDialog.SelectAll"));
        this.bnSelectAll.addActionListener(new SelectAllSubstitutionAction());
        this.bnDeselectAll = new JButton(gUIConfiguration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.bnDeselectAll.setToolTipText(Messages.getString("DDLSelectionDialog.DeselectAll"));
        this.bnDeselectAll.addActionListener(new DeselectAllSubstitutionAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.addSeparator();
        jToolBar.add(this.bnAddColumn);
        jToolBar.add(this.bnRemoveColumn);
        jToolBar.addSeparator();
        jToolBar.add(this.bnSelectAll);
        jToolBar.add(this.bnDeselectAll);
        jPanel2.add(jToolBar);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.setPreferredSize(new Dimension(410, 261));
        jPanel3.add((Component)object);
        jPanel.add(jPanel3);
    }

    private int getPreferredIconSize() {
        return 16;
    }

    private void initObjectTab(JPanel jPanel, JTable jTable, List list) {
        DDLSelectionTabs dDLSelectionTabs;
        DDLSelectionTabs dDLSelectionTabs2 = dDLSelectionTabs = new DDLSelectionTabs(jPanel, jTable, list);
        dDLSelectionTabs2.getClass();
        jTable.setModel(new DDLSelectionTabs.TableViewSchemaModel(dDLSelectionTabs2, list));
        jTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jTable, 1);
        this.setColumnWidth(jTable);
    }

    private void initContainerTab(JPanel jPanel, JTable jTable, List list) {
        DDLSelectionTabs dDLSelectionTabs;
        DDLSelectionTabs dDLSelectionTabs2 = dDLSelectionTabs = new DDLSelectionTabs(jPanel, jTable, list);
        dDLSelectionTabs2.getClass();
        jTable.setModel(new DDLSelectionTabs.ConstraintModel(dDLSelectionTabs2, list));
        jTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jTable, 1);
        this.setColumnWidth(jTable);
    }

    private void initObjectModelTab(JPanel jPanel, JTable jTable, List list) {
        DDLSelectionTabs dDLSelectionTabs;
        DDLSelectionTabs dDLSelectionTabs2 = dDLSelectionTabs = new DDLSelectionTabs(jPanel, jTable, list);
        dDLSelectionTabs2.getClass();
        jTable.setModel(new DDLSelectionTabs.ObjectModel(dDLSelectionTabs2, list));
        jTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jTable, 1);
        this.setColumnWidth(jTable);
    }

    private void setColumnWidth(JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(60);
        if (jTable.getColumnModel().getColumnCount() > 2) {
            tableColumn = jTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(300);
            tableColumn = jTable.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(300);
        } else {
            tableColumn = jTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(600);
        }
    }

    class InsertionObject {
        Table object;
        boolean isSelected = false;

        public InsertionObject(Table table, boolean bl) {
            this.isSelected = bl;
            this.object = table;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public Table getObject() {
            return this.object;
        }

        public void setObject(Table table) {
            this.object = table;
        }
    }

    public class ObjectTypesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.objectTypesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionDialog.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StorageDesign.ObjectType objectType = (StorageDesign.ObjectType)DDLSelectionDialog.this.objectTypesList.get(n);
            if (n2 == 0) {
                return objectType.isSelected();
            }
            if (n2 == 1) {
                return objectType.getTypeName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            StorageDesign.ObjectType objectType = (StorageDesign.ObjectType)DDLSelectionDialog.this.objectTypesList.get(n);
            if (n2 == 0) {
                objectType.setSelected((Boolean)object);
            }
        }
    }

    private class DeselectAllSubstitutionAction
    implements ActionListener {
        private DeselectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (SubstitutionPattern substitutionPattern : DDLSelectionDialog.this.substitutionList) {
                substitutionPattern.setSelected(false);
            }
            DDLSelectionDialog.this.tbSubstituiton.updateUI();
        }
    }

    private class SelectAllSubstitutionAction
    implements ActionListener {
        private SelectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (SubstitutionPattern substitutionPattern : DDLSelectionDialog.this.substitutionList) {
                substitutionPattern.setSelected(true);
            }
            DDLSelectionDialog.this.tbSubstituiton.updateUI();
        }
    }

    private class RemoveSubstitutionAction
    implements ActionListener {
        private RemoveSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = DDLSelectionDialog.this.tbSubstituiton.getSelectedRow();
            if (n != -1 && DDLSelectionDialog.this.substitutionList.size() > 0 && n < DDLSelectionDialog.this.substitutionList.size()) {
                SubstitutionPattern substitutionPattern = (SubstitutionPattern)DDLSelectionDialog.this.substitutionList.get(n);
                DDLSelectionDialog.this.substitutionList.remove(substitutionPattern);
                DDLSelectionDialog.this.tbSubstituiton.updateUI();
            }
        }
    }

    private class AddSubstitutionAction
    implements ActionListener {
        private AddSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SubstitutionPattern substitutionPattern = new SubstitutionPattern();
            DDLSelectionDialog.this.substitutionList.add(substitutionPattern);
            int n = DDLSelectionDialog.this.tbSubstituiton.getRowCount() - 1;
            DDLSelectionDialog.this.tbSubstituiton.changeSelection(n, 0, false, false);
            DDLSelectionDialog.this.tbSubstituiton.updateUI();
        }
    }

    public class InsertionModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionDialog.InsertScripts");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionDialog.Name");
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.insertionList.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InsertionObject insertionObject = (InsertionObject)DDLSelectionDialog.this.insertionList.get(n);
            if (n2 == 0) {
                return insertionObject.isSelected;
            }
            if (n2 == 1) {
                return insertionObject.getObject().getName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            InsertionObject insertionObject = (InsertionObject)DDLSelectionDialog.this.insertionList.get(n);
            if (n2 == 0) {
                insertionObject.setSelected((Boolean)object);
            }
        }
    }

    public class SubstitutionModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.substitutionList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionDialog.CaseSensitive");
            }
            if (n == 2) {
                return Messages.getString("DDLSelectionDialog.Old");
            }
            if (n == 3) {
                return Messages.getString("DDLSelectionDialog.New");
            }
            if (n == 4) {
                return Messages.getString("DDLSelectionDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SubstitutionPattern substitutionPattern = (SubstitutionPattern)DDLSelectionDialog.this.substitutionList.get(n);
            if (n2 == 0) {
                return substitutionPattern.isSelected();
            }
            if (n2 == 1) {
                return substitutionPattern.isCaseSensitive();
            }
            if (n2 == 2) {
                return substitutionPattern.getSourceString();
            }
            if (n2 == 3) {
                return substitutionPattern.getReplacementString();
            }
            if (n2 == 4) {
                return substitutionPattern.getComments();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SubstitutionPattern substitutionPattern = (SubstitutionPattern)DDLSelectionDialog.this.substitutionList.get(n);
            if (n2 == 0) {
                substitutionPattern.setSelected((Boolean)object);
            } else if (n2 == 1) {
                substitutionPattern.setCaseSensitive((Boolean)object);
            } else if (n2 == 2) {
                substitutionPattern.setSourceString(this.checkValue((String)object, true));
            } else if (n2 == 3) {
                substitutionPattern.setReplacementString(this.checkValue((String)object, false));
            } else if (n2 == 4) {
                substitutionPattern.setComments((String)object);
            }
        }

        private String checkValue(String string, boolean bl) {
            return string;
        }
    }

    class Dropable {
        boolean selected = false;
        ModelObject collection;

        Dropable(ModelObject modelObject) {
            this.collection = modelObject;
        }

        public String toString() {
            if (this.collection != null) {
                return this.collection.getName();
            }
            return "";
        }
    }

    class CBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            Dropable dropable = (Dropable)object;
            this.setSelected(dropable.selected);
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    private class DesignRulesAction
    implements ActionListener {
        private DesignRulesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DDLSelectionDialog.this.showDesignRules();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((ModelIdObjectSelection)DDLSelectionDialog.this.stdes.getRoot()).restoreOldSelectionToObjects();
            DDLSelectionDialog.this.cancelTableEditing(DDLSelectionDialog.this.tbSubstituiton);
            DDLSelectionDialog.this.cancelTableEditing(DDLSelectionDialog.this.insertionTable);
            DDLSelectionDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DDLSelectionDialog.this.stopTableEditing(DDLSelectionDialog.this.tbSubstituiton);
            DDLSelectionDialog.this.stopTableEditing(DDLSelectionDialog.this.insertionTable);
            DDLSelectionDialog.this.setProperties();
            DDLGenerationOptions.setIncludeComments(DDLSelectionDialog.this.chIncludeComments.isSelected());
            DDLGenerationOptions.setDDLType(DDLSelectionDialog.this.cbDDLType.getSelectedIndex());
            DDLSelectionDialog.this.settings.getSubstitutionList().clear();
            DDLSelectionDialog.this.settings.getSubstitutionList().addAll(DDLSelectionDialog.this.substitutionList);
            DDLSelectionDialog.this.getApplicationView().getCurrentDesign().setApplyNameSubstitution(DDLSelectionDialog.this.chApplyNameSubstitution.isSelected());
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DDLSelectionDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        ProgressDialog progressDialog = new ProgressDialog(DDLSelectionDialog.this.getApplicationView(), "", 0, 100);
                        progressDialog.setParentComponent(DDLSelectionDialog.this.owner);
                        try {
                            int n;
                            DDLSelectionDialog.this.fileMakerEditor.getEditorPane().setText("");
                            DDLSelectionDialog.this.fileMakerEditor.getDDLFileMaker().generateDDLContent(progressDialog);
                            DDLSelectionDialog.this.fileMakerEditor.getScrollPane().setVisible(false);
                            int n2 = DDLSelectionDialog.this.fileMakerEditor.getDDLFileMaker().getTextSize();
                            boolean bl = false;
                            if (n2 > 1000000 && (n = JOptionPane.showConfirmDialog(DDLSelectionDialog.this, Messages.getString("DDLGenerationOptions.LongDDLText"), Messages.getString("DDLGenerationOptions.SelectAnOption"), 0)) == 0) {
                                bl = true;
                            }
                            JTextPane jTextPane = (JTextPane)DDLSelectionDialog.this.fileMakerEditor.getEditorPane();
                            DefaultStyledDocument defaultStyledDocument = bl ? new SyntaxOffDocument() : new SyntaxDocument();
                            try {
                                defaultStyledDocument.insertString(0, DDLSelectionDialog.this.fileMakerEditor.getDDLFileMaker().getContent(), jTextPane.getLogicalStyle());
                                jTextPane.setDocument(defaultStyledDocument);
                            }
                            catch (BadLocationException badLocationException) {
                                LOGGER.error("DDLSelectionDialog.OKAction", badLocationException);
                            }
                            DDLSelectionDialog.this.fileMakerEditor.getScrollPane().setVisible(true);
                        }
                        finally {
                            progressDialog.close();
                            DDLSelectionDialog.this.fileMakerEditor.getDDLFileMaker().checkErrors(DDLSelectionDialog.this.fileMakerEditor);
                        }
                    }
                    finally {
                        DDLSelectionDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                        DDLSelectionDialog.this.getApplicationView().getCurrentDesign().setApplyNameSubstitution(false);
                    }
                }
            };
            thread.start();
            DDLSelectionDialog.this.close();
        }
    }

    public class DDLExceptionsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DDLSelectionDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("DDLSelectionDialog.Type");
            }
            if (n == 2) {
                return Messages.getString("DDLSelectionDialog.Description");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DDLException dDLException = (DDLException)DDLSelectionDialog.this.eList.get(n);
            if (n2 == 0) {
                return dDLException.isSelected();
            }
            if (n2 == 1) {
                return String.valueOf(dDLException.getNumber());
            }
            if (n2 == 2) {
                return dDLException.getDescription();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DDLException dDLException = (DDLException)DDLSelectionDialog.this.eList.get(n);
            if (n2 == 0) {
                dDLException.setSelected((Boolean)object);
            }
        }
    }
}

