/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JSelectableLabel;

public class DDLNavigationTreeRenderer
implements TreeCellRenderer {
    private JSelectableLabel component = new JSelectableLabel();
    private JPanel panel = new JPanel(new BorderLayout());
    protected JCheckBox cbox = new JCheckBox();
    private static Map icons = NavigationTreeRenderer.icons;
    private static Icon defaultIcon;
    private static Icon openIcon;
    static GUIConfiguration conf;
    static int iconSize;
    private static final String COLUMNFK = "ColumnFK.class";
    protected ModelIdObjectSelection node;

    public DDLNavigationTreeRenderer() {
        this.panel.setLayout(new BorderLayout());
        this.cbox.setMargin(new Insets(0, 0, 0, 0));
        this.cbox.setBorderPaintedFlat(true);
        this.cbox.setOpaque(false);
        this.panel.add((Component)this.cbox, "West");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = "";
        this.node = (ModelIdObjectSelection)object;
        ModelIDObject modelIDObject = this.node.getObject();
        string = modelIDObject instanceof KeyObject && ((KeyObject)modelIDObject).isPK() ? "(PK) " + this.node.getName() : this.node.getName();
        this.panel.setOpaque(false);
        this.cbox.setOpaque(false);
        if (modelIDObject instanceof RelationalObjectProxy) {
            modelIDObject = ((RelationalObjectProxy)modelIDObject).getObject();
        }
        this.component.setText(string);
        this.component.setSelected(bl);
        this.component.setHasFocus(bl4);
        ImageIcon imageIcon = null;
        if (modelIDObject instanceof Index) {
            imageIcon = (ImageIcon)icons.get(modelIDObject.getClass());
            if (((Index)modelIDObject).isFK()) {
                imageIcon = (ImageIcon)icons.get(FKIndexAssociation.class);
            }
        } else if (modelIDObject instanceof Column) {
            if (((Column)modelIDObject).isFKColumn()) {
                imageIcon = (ImageIcon)icons.get(COLUMNFK);
            } else if (modelIDObject != null) {
                imageIcon = (ImageIcon)icons.get(modelIDObject.getClass());
            }
        } else if (modelIDObject instanceof TopView) {
            imageIcon = (ImageIcon)icons.get(((TopView)((Object)modelIDObject)).getModel().getClass());
        } else if (modelIDObject instanceof SubViewObjectSet) {
            imageIcon = (ImageIcon)icons.get(((SubViewObjectSet)((Object)modelIDObject)).getElementDescriptor());
        } else if (modelIDObject instanceof DesignObjectCollection) {
            imageIcon = (ImageIcon)icons.get(((DesignObjectCollection)((Object)modelIDObject)).getElementDescriptor());
        } else if (modelIDObject != null) {
            imageIcon = (ImageIcon)icons.get(modelIDObject.getClass());
        }
        if (imageIcon == null) {
            imageIcon = (ImageIcon)icons.get(this.node.getElementDescriptor());
        }
        if (imageIcon != null) {
            this.component.setIcon(imageIcon);
        } else if (modelIDObject instanceof StorageObject) {
            this.component.setIcon(conf.getIcon("STORAGE_OBJECT_ICON", iconSize));
        } else if (bl2) {
            this.component.setIcon(openIcon);
        } else {
            this.component.setIcon(defaultIcon);
        }
        if (object instanceof ModelIdObjectSelection) {
            ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)object;
            this.panel.remove(this.component);
            this.cbox.setSelected(modelIdObjectSelection.isSelected());
            this.panel.add((Component)this.component, "Center");
            return this.panel;
        }
        this.panel.remove(this.component);
        return this.component;
    }

    static {
        conf = GUIConfiguration.getInstance();
        iconSize = 16;
        defaultIcon = conf.getIcon("BROWSER_CLOSED_ICON", iconSize);
        openIcon = conf.getIcon("BROWSER_OPEN_ICON", iconSize);
    }
}

