/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledEditorKit;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.SyntaxDocument;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class DDLViewer
extends CustomDialog
implements ObjectListener,
UpdateListener {
    private Object ddlObject;
    private StringBuffer buffer = new StringBuffer();
    private JDialog dialog;
    private JEditorPane editor;
    private JPanel headerPanel;
    private JLabel headerLabel;
    private static final Logger LOGGER = new Logger(DDLViewer.class);

    public DDLViewer(ApplicationView applicationView) {
        super(applicationView);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.getEditorPane());
        this.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(Messages.getString("DDLViewer.Close"));
        jButton.setMnemonic(67);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DDLViewer.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    @Override
    protected void close() {
        this.getDialog().setVisible(false);
        this.setDDLObject(null);
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public void setDDLObject(Object object) {
        if (this.ddlObject instanceof DesignObject) {
            ((DesignObject)this.ddlObject).removeObjectListener(this);
        } else if (this.ddlObject instanceof UpdateSubject) {
            ((UpdateSubject)this.ddlObject).removeUpdateListener(this);
        }
        this.ddlObject = object;
        if (object != null) {
            if (object instanceof DesignObject) {
                ((DesignObject)object).addObjectListener(this);
            } else if (object instanceof UpdateSubject) {
                ((UpdateSubject)object).addUpdateListener(this);
            }
            this.doChange(this.ddlObject);
        }
    }

    public Object getDDLObject() {
        return this.ddlObject;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (!designObject.getIsBeingRemoved() && this.getDialog().isVisible()) {
            this.doChange(designObject);
        }
    }

    @Override
    public void update() {
        this.doChange(this.ddlObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChange(Object object) {
        StorageDesign storageDesign = null;
        if (object instanceof StorageObject) {
            storageDesign = ((StorageObject)object).getStorageDesign();
        } else if (object instanceof DesignObject) {
            storageDesign = ((RelationalDesign)((DesignObject)object).getDesignPart()).getStorageDesign();
        } else if (object instanceof ModelIDObject) {
            storageDesign = this.getDesign().getRelationalDesign().getStorageDesign();
        }
        if (storageDesign != null) {
            boolean bl = ((ModelIDObject)this.ddlObject).isMarkedGenerate();
            try {
                ((ModelIDObject)this.ddlObject).setMarkedGenerate(true);
                this.buffer.setLength(0);
                List list = this.getListOfObjects(object, storageDesign);
                for (ModelIDObject modelIDObject : list) {
                    if (modelIDObject instanceof AbstractStorageObjectOracle) {
                        storageDesign.getDDLUserGenerator().appendDDLFor(this.buffer, modelIDObject);
                    }
                    storageDesign.getDDLGenerator().appendDDLFor(this.buffer, modelIDObject);
                    if (!(modelIDObject instanceof Table) && !(modelIDObject instanceof TableView) && !(modelIDObject instanceof TableProxy) && !(modelIDObject instanceof TableViewProxy) && !(modelIDObject instanceof FKArc)) continue;
                    this.appendExtraDDL(modelIDObject, storageDesign);
                }
                this.getEditorPane().setText("");
                try {
                    this.getEditorPane().getDocument().insertString(0, this.buffer.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.error("DDLViewer", badLocationException);
                }
                this.getEditorPane().setCaretPosition(0);
            }
            finally {
                ((ModelIDObject)this.ddlObject).setMarkedGenerate(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void ddlPreview(Object[] objectArray, RelationalDesign relationalDesign) {
        StorageDesign storageDesign = relationalDesign.getStorageDesign();
        if (storageDesign != null) {
            DDLFileMaker.setddlAdvancedGenenerator(null);
            this.getApplicationView().initLineTerminator();
            ArrayList<ModelIDObject> arrayList = new ArrayList<ModelIDObject>();
            ArrayList<void> arrayList2 = new ArrayList<void>();
            ArrayList arrayList3 = new ArrayList();
            for (int i = 0; i < objectArray.length; ++i) {
                void modelIDObject2;
                Iterator iterator = objectArray[i];
                Object badLocationException = null;
                if (iterator instanceof Table) {
                    Table table = (Table)((Object)iterator);
                } else if (iterator instanceof TableProxy) {
                    Table table = (Table)((TableProxy)((Object)iterator)).getObject();
                }
                if (modelIDObject2 != null) {
                    arrayList2.add(modelIDObject2);
                    for (ModelIDObject modelIDObject : modelIDObject2.getFKAssociationsList()) {
                        if (!modelIDObject.isMarkedGenerate()) continue;
                        arrayList.add(modelIDObject);
                    }
                    for (ModelIDObject modelIDObject2 : modelIDObject2.getArcs()) {
                        if (!modelIDObject2.isMarkedGenerate()) continue;
                        arrayList.add(modelIDObject2);
                    }
                    continue;
                }
                if (!(iterator instanceof TableView)) continue;
                arrayList3.add(iterator);
            }
            Collections.sort(arrayList2, ModelObjectSet.NAME_COMPARATOR);
            Collections.sort(arrayList, ModelObjectSet.LONG_NAME_COMPARATOR);
            Collections.sort(arrayList3, ModelObjectSet.NAME_COMPARATOR);
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            arrayList4.addAll(arrayList2);
            arrayList4.addAll(arrayList);
            arrayList4.addAll(arrayList3);
            this.buffer.setLength(0);
            for (ModelIDObject modelIDObject : arrayList4) {
                void var9_17;
                if (modelIDObject instanceof Table) {
                    ModelIDObject modelIDObject2;
                    Table table = (Table)modelIDObject;
                    RelationalObjectProxy relationalObjectProxy = storageDesign.getTableProxySet().getProxy(table.getObjectID());
                    if (relationalObjectProxy instanceof TableProxyOracle && (modelIDObject2 = ((TableProxyOracle)relationalObjectProxy).getSnapshot()) != null) {
                        ModelIDObject modelIDObject3 = modelIDObject2;
                    }
                }
                boolean bl = var9_17.isMarkedGenerate();
                var9_17.setMarkedGenerate(true);
                try {
                    storageDesign.getDDLGenerator().appendDDLFor(this.buffer, var9_17);
                    if (!(var9_17 instanceof Table) && !(var9_17 instanceof TableView) && !(var9_17 instanceof FKArc)) continue;
                    this.appendExtraDDL((ModelIDObject)var9_17, storageDesign);
                }
                finally {
                    var9_17.setMarkedGenerate(bl);
                }
            }
            this.getEditorPane().setText("");
            try {
                this.getEditorPane().getDocument().insertString(0, this.buffer.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.error("DDLViewer", badLocationException);
            }
            this.getEditorPane().setCaretPosition(0);
        }
    }

    private void appendExtraDDL(ModelIDObject modelIDObject, StorageDesign storageDesign) {
        Object object3;
        Object object2;
        storageDesign.getDDLScopeGenerator().appendDDLFor(this.buffer, modelIDObject);
        if ((modelIDObject instanceof Table || modelIDObject instanceof TableProxy) && (object2 = (TableProxy)storageDesign.getTableProxySet().getProxy(modelIDObject.getObjectID())) != null && (object3 = ((TableProxy)object2).getTriggers()) != null) {
            Iterator iterator = ((ModelObjectSet)object3).iterator();
            while (iterator.hasNext()) {
                Trigger trigger = (Trigger)iterator.next();
                storageDesign.getDDLPhysicalTriggerGenerator().appendDDLFor(this.buffer, trigger);
            }
        }
        storageDesign.getDDLTriggerGenerator().appendDDLFor(this.buffer, modelIDObject);
        storageDesign.getDDLAutoIncrementColumnGenerator().appendDDLFor(this.buffer, modelIDObject);
        for (Object object3 : storageDesign.getDDLEndScriptGenerators()) {
            ((DDLGenerator)object3).appendDDLFor(this.buffer, modelIDObject);
        }
    }

    List getListOfObjects(Object object, StorageDesign storageDesign) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Table table = null;
        RelationalObjectProxy relationalObjectProxy = null;
        if (object instanceof Table) {
            table = (Table)object;
            relationalObjectProxy = storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxy) {
            relationalObjectProxy = (TableProxy)object;
            table = (Table)relationalObjectProxy.getObject();
        }
        if (relationalObjectProxy instanceof TableProxyOracle && (object2 = ((TableProxyOracle)relationalObjectProxy).getSnapshot()) != null) {
            object = object2;
        }
        arrayList.add(object);
        if (table != null) {
            for (ModelIDObject object3 : table.getFKAssociationsList()) {
                if (!object3.isMarkedGenerate()) continue;
                arrayList.add(object3);
            }
            for (ModelIDObject modelIDObject : table.getArcs()) {
                if (!modelIDObject.isMarkedGenerate()) continue;
                arrayList.add(modelIDObject);
            }
        }
        return arrayList;
    }

    protected JEditorPane getEditorPane() {
        if (this.editor == null) {
            this.editor = new JEditorPane();
            this.editor.setEditorKit(new StyledEditorKit());
            this.editor.setDocument(new SyntaxDocument());
            this.editor.setEditable(false);
        }
        return this.editor;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DDLViewer.DDLPreview"));
            this.dialog.setContentPane(this);
            this.dialog.setSize(750, 600);
            this.setDefaultActions(this.dialog, false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void setDialogVisible(boolean bl) {
        this.getDialog().setVisible(bl);
    }

    public boolean isDialogVisible() {
        return this.getDialog().isVisible();
    }

    public JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel(new BorderLayout());
            this.headerPanel.add((Component)this.getHeaderLabel(), "Center");
        }
        return this.headerPanel;
    }

    public JLabel getHeaderLabel() {
        if (this.headerLabel == null) {
            this.headerLabel = new JLabel();
            this.headerLabel.setForeground(Color.black);
            Font font = this.headerLabel.getFont().deriveFont(0, 10.0f);
            this.headerLabel.setFont(font);
            this.headerLabel.setText(Messages.getString("DDLViewer.NotInitialized"));
        }
        return this.headerLabel;
    }
}

