/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultCaret;
import javax.swing.text.StyledEditorKit;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.FindDialog;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class DDLFileMakerEditor
extends CustomDialog {
    private DDLFileMaker fileMaker;
    private JFrame dialog;
    private JTextPane editor;
    private JPanel headerPanel;
    private JPanel bottomPanel;
    private JComboBox storageDesignCombo;
    private JComboBox designSubViewCombo;
    private JButton generateButton;
    private JButton findButton;
    private JButton clearButton;
    private JButton saveButton;
    private FindDialog findDialog;
    private DDLFileMakerEditor ddlFileMakerEditor = this;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(DDLFileMakerEditor.class);
    private JScrollPane scrollPane;
    private Action actionFind = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DDLFileMakerEditor.this.getFindDialog().showFind(DDLFileMakerEditor.this.getEditorPane());
        }
    };
    private static final String SD_DB2_70 = StorageDesignDB2v70.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_DB2_80 = StorageDesignDB2v80.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_ORACLE_9i = StorageDesignOraclev9i.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_ORACLE_10g = StorageDesignOraclev10g.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_ORACLE_11g = StorageDesignOraclev11g.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_UDB_71 = StorageDesignUDBv71.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_UDB_81 = StorageDesignUDBv81.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_SQLSERVER_2k = StorageDesignSqlServerv2k.RDBMS_TYPE.getStorageDesignClassName();
    private static final String SD_SQLSERVER_2k5 = StorageDesignSqlServerv2k5.RDBMS_TYPE.getStorageDesignClassName();

    public DDLFileMakerEditor(ApplicationView applicationView) {
        super(applicationView);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.getEditorPane());
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.getBottomPanel(), "South");
    }

    public JEditorPane getEditorPane() {
        if (this.editor == null) {
            this.editor = new JTextPane();
            this.editor.setContentType("text/plain");
            this.editor.setEditorKit(new StyledEditorKit());
            this.editor.setFont(new Font("Courier New", 0, 12));
        }
        return this.editor;
    }

    public DDLFileMaker getDDLFileMaker() {
        if (this.fileMaker == null) {
            this.fileMaker = this.getApplicationView().getDDLFileMaker();
            this.fileMaker.setStatusBarOwner(this.getApplicationView());
        }
        return this.fileMaker;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JFrame(Messages.getString("DDLFileMakerEditor.DDLFileEditor"));
            this.dialog.setContentPane(this);
            this.dialog.setSize(780, 600);
            this.dialog.setIconImage(this.getApplicationView().getFrame().getIconImage());
            this.setDefaultActions(this, true);
            int n = 1;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(70, 128, false);
            this.getInputMap(n).put(keyStroke, "KEY_FIND");
            this.getActionMap().put("KEY_FIND", this.actionFind);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void setDialogVisible(boolean bl) {
        this.getDialog().setVisible(bl);
    }

    public JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel(new FlowLayout(0));
            this.headerPanel.add(this.getStorageDesignCombo());
            this.headerPanel.add(this.getDesignSubViewCombo());
            this.headerPanel.add(this.getGenerateButton());
            this.headerPanel.add(this.getFindButton());
            this.headerPanel.add(this.getClearButton());
        }
        return this.headerPanel;
    }

    public JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FlowLayout(2));
            this.bottomPanel.add(this.getSaveButton());
            JButton jButton = new JButton(Messages.getString("DDLFileMakerEditor.Close"));
            jButton.setMnemonic(67);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DDLFileMakerEditor.this.close();
                }
            });
            this.bottomPanel.add(jButton);
            JButton jButton2 = new JButton(this.getHelpAction());
            jButton2.setMnemonic(72);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bottomPanel.add(jButton2);
        }
        return this.bottomPanel;
    }

    public void updateRDBMSSitesComboBox() {
        this.storageDesignCombo.removeAllItems();
        RDBMSSite[] rDBMSSiteArray = this.getDesign().getRDBMSSiteSet().toSiteArray();
        for (int i = 0; i < rDBMSSiteArray.length; ++i) {
            this.storageDesignCombo.addItem(rDBMSSiteArray[i]);
        }
    }

    public void updateDesignSubViewComboBox() {
        if (this.designSubViewCombo != null) {
            this.designSubViewCombo.removeAllItems();
            DesignPartView[] designPartViewArray = this.getDesign().getRelationalDesign().getMainViewAndSubViews();
            for (int i = 0; i < designPartViewArray.length; ++i) {
                this.designSubViewCombo.addItem(designPartViewArray[i]);
            }
        } else {
            DesignPartView[] designPartViewArray = this.getDesign().getRelationalDesign().getMainViewAndSubViews();
            this.designSubViewCombo = new JComboBox<DesignPartView>(designPartViewArray);
            this.designSubViewCombo.setMaximumRowCount(20);
        }
    }

    public JComboBox getStorageDesignCombo() {
        if (this.storageDesignCombo == null) {
            RDBMSSite[] rDBMSSiteArray = this.getDesign().getRDBMSSiteSet().toSiteArray();
            this.storageDesignCombo = new JComboBox<RDBMSSite>(rDBMSSiteArray);
            this.storageDesignCombo.setMaximumRowCount(20);
            this.storageDesignCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DDLFileMakerEditor.this.getDDLFileMaker().clearContent();
                    DDLFileMakerEditor.this.getEditorPane().setText(DDLFileMakerEditor.this.getDDLFileMaker().getContent());
                }
            });
            this.storageDesignCombo.setPreferredSize(new Dimension(200, 23));
        }
        return this.storageDesignCombo;
    }

    public JComboBox getDesignSubViewCombo() {
        if (this.designSubViewCombo == null) {
            DesignPartView[] designPartViewArray = this.getDesign().getRelationalDesign().getMainViewAndSubViews();
            this.designSubViewCombo = new JComboBox<DesignPartView>(designPartViewArray);
            this.designSubViewCombo.setMaximumRowCount(20);
            this.designSubViewCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignPartView designPartView = (DesignPartView)DDLFileMakerEditor.this.designSubViewCombo.getSelectedItem();
                    DDLFileMakerEditor.this.getDesign().setSelectedSubView(designPartView);
                }
            });
            this.designSubViewCombo.setPreferredSize(new Dimension(200, 23));
            this.designSubViewCombo.setToolTipText(Messages.getString("DDLFileMakerEditor.SelectSubView"));
        }
        return this.designSubViewCombo;
    }

    public void setStorageDesignSelection(Object object) {
        this.getDDLFileMaker().setStorageDesign(object);
        ((JFrame)this.getDialog()).setTitle(new StringBuffer(Messages.getString("DDLFileMakerEditor.DDLFileEditorS")).append(String.valueOf(object)).toString());
        this.repaint();
    }

    public JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton(Messages.getString("DDLFileMakerEditor.Clear"));
            this.clearButton.setMnemonic(76);
            this.clearButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DDLFileMakerEditor.this.getDDLFileMaker().clearContent();
                    DDLFileMakerEditor.this.getEditorPane().setText(DDLFileMakerEditor.this.getDDLFileMaker().getContent());
                }
            });
            this.clearButton.setToolTipText(Messages.getString("DDLFileMakerEditor.ClearAllDDLContent"));
        }
        return this.clearButton;
    }

    public JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton(Messages.getString("DDLFileMakerEditor.Find"));
            this.findButton.setMnemonic(70);
            this.findButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DDLFileMakerEditor.this.getFindDialog().showFind(DDLFileMakerEditor.this.getEditorPane());
                }
            });
            this.findButton.setToolTipText(Messages.getString("DDLFileMakerEditor.Find"));
        }
        return this.findButton;
    }

    public JButton getGenerateButton() {
        if (this.generateButton == null) {
            this.generateButton = new JButton(Messages.getString("DDLFileMakerEditor.Generate"));
            this.generateButton.setMnemonic(71);
            this.generateButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.generateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RDBMSSite rDBMSSite = (RDBMSSite)DDLFileMakerEditor.this.getStorageDesignCombo().getSelectedItem();
                    DDLFileMakerEditor.this.getDesign().getRelationalDesign().setSelectedRDBMSSite(rDBMSSite);
                    DDLFileMakerEditor.this.setStorageDesignSelection(rDBMSSite);
                    StorageDesign storageDesign = DDLFileMakerEditor.this.getDesign().getStorageDesign(rDBMSSite);
                    if (rDBMSSite.getType().getStorageDesignClassName().equals(SD_DB2_70) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_DB2_80) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_ORACLE_9i) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_ORACLE_10g) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_ORACLE_11g) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_UDB_71) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_UDB_81) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_SQLSERVER_2k) || rDBMSSite.getType().getStorageDesignClassName().equals(SD_SQLSERVER_2k5) || !storageDesign.isOpen()) {
                        DDLSelectionDialog dDLSelectionDialog = new DDLSelectionDialog(DDLFileMakerEditor.this.getApplicationView(), storageDesign, DDLFileMakerEditor.this.getDdlFileMakerEditor());
                        dDLSelectionDialog.showDialog();
                    } else {
                        DDLGenerationOptions dDLGenerationOptions = new DDLGenerationOptions(DDLFileMakerEditor.this.getApplicationView(), DDLFileMakerEditor.this.getDesign(), (RDBMSSite)DDLFileMakerEditor.this.getStorageDesignCombo().getSelectedItem(), DDLFileMakerEditor.this.getDdlFileMakerEditor());
                        dDLGenerationOptions.getDialog().setVisible(true);
                    }
                }
            });
            this.generateButton.setToolTipText(Messages.getString("DDLFileMakerEditor.GenerateNewDDL"));
        }
        return this.generateButton;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getString("DDLFileMakerEditor.Save"));
            this.saveButton.setMnemonic(83);
            this.saveButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DDLFileMakerEditor.this.saveLocalCopy();
                }
            });
            this.saveButton.setToolTipText(Messages.getString("DDLFileMakerEditor.SaveDDLContent"));
        }
        return this.saveButton;
    }

    private FindDialog getFindDialog() {
        if (this.findDialog == null) {
            this.findDialog = new FindDialog((Frame)this.getDialog());
            DefaultCaret defaultCaret = new DefaultCaret(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    this.setVisible(false);
                }
            };
            defaultCaret.setBlinkRate(this.editor.getCaret().getBlinkRate());
            this.editor.setCaret(defaultCaret);
        }
        this.editor.getDocument().putProperty("__EndOfLine__", "\n");
        return this.findDialog;
    }

    public void saveLocalCopy() {
        try {
            Serializable serializable;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".sql") || file.getName().toLowerCase().endsWith(".ddl") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("DDLFileMakerEditor.DDLFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String string = this.getApplicationView().getSettings().getDefaultSavePath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    serializable = this.getApplicationView().getUserHomeDirectory();
                    if (serializable != null) {
                        uRLChooser.setSelectedURL((URL)serializable);
                    }
                }
            }
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("DDLFileMakerEditor.SaveDDLLocally"));
            if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                lastFolder = ((File)serializable).getParentFile();
                if (this.saveLocalCopy((File)serializable)) {
                    JOptionPane.showMessageDialog(this.getDialog(), Messages.getString("DDLFileMakerEditor.ExportedOk"));
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error("", iOException);
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("DDLFileMakerEditor.CanNotWriteToFile"), iOException.getMessage()}, Messages.getString("DDLFileMakerEditor.WriteError"), 0);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("DDLFileMakerEditor.UnexpectedError"), throwable.getMessage()}, Messages.getString("DDLFileMakerEditor.WriteError"), 0);
        }
    }

    private boolean saveLocalCopy(File file) throws IOException {
        int n;
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.getDialog(), MessageFormat.format(Messages.getString("DDLFileMakerEditor.FileExists"), file.getAbsolutePath()), Messages.getString("DDLFileMakerEditor.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return false;
        }
        String string = this.getEditorPane().getText();
        file.getParentFile().mkdirs();
        file.createNewFile();
        EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, environOptions.getEncoding());
        outputStreamWriter.write(string);
        outputStreamWriter.close();
        return true;
    }

    public DDLFileMakerEditor getDdlFileMakerEditor() {
        return this.ddlFileMakerEditor;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DDL_FILE_EDITOR_DIALOG";
    }
}

