/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.ControllerDataTypes;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.Messages;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;

public class DPVDataTypesSubView
extends DPVDataTypes {
    private AbstractController controller;
    private DesignObjectCollection tvStructuredTypes = new DesignObjectCollection(true);

    public DPVDataTypesSubView(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        ((DataTypesDesign)designPart).getStructuredTypeSet().addSetListener(this.tvStructuredTypes);
        this.controller = new ControllerDataTypes(applicationView);
        this.controller.setName("DataTypes_SubView");
        this.controller.setDesignPartView(this);
        this.tvStructuredTypes.setElementDescriptor(StructuredType.class);
        this.tvStructuredTypes.setName(Messages.getString("DPVDataTypesSubView.DPVDataTypesSubView.StructuredTypes"));
    }

    @Override
    public void clearDPV() {
        ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().removeSetListener(this.tvStructuredTypes);
        super.clearDPV();
    }

    @Override
    public void sortCollections() {
        this.tvStructuredTypes.sort();
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return;
        }
        TopView topView = this.getViewFor(designObject);
        if (topView == null) {
            this.addViewFor(designObject);
        }
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        TopView topView = null;
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return null;
        }
        topView = this.createTopViewFor(designObject);
        return topView;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.tvStructuredTypes;
            }
            case 1: {
                return this.getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.tvStructuredTypes) {
            return 0;
        }
        if (modelObject == this.getDisplays()) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public void setPlaceHolder(PlaceHolder placeHolder) {
        super.setPlaceHolder(placeHolder);
        this.tvStructuredTypes.setParent(this.getPlaceHolder());
        this.getDisplays().setParent(this.getPlaceHolder());
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    @Override
    public void registerForTreemodel(TopView topView) {
        if (topView instanceof TVStructuredType && !this.tvStructuredTypes.containsPlaceHolderFor(topView.getModel())) {
            DesignObjectPlaceHolder designObjectPlaceHolder = new DesignObjectPlaceHolder(topView.getModel().getDesignPart(), topView.getModel());
            designObjectPlaceHolder.setTopView(topView);
            this.tvStructuredTypes.add(designObjectPlaceHolder);
        }
        if (this.getViewFor(topView.getModel()) == null) {
            this.modelToView.put(topView.getModel(), topView);
        }
    }

    @Override
    public void unregisterFromTreemodel(TopView topView) {
        if (topView != null) {
            this.unregisterTopView(topView);
            if (topView instanceof TVStructuredType) {
                this.tvStructuredTypes.removePlaceHolderFor(topView.getModel());
            }
        }
    }

    private Collection getSTTopViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = this.tvStructuredTypes.iterator();
        while (iterator.hasNext()) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)iterator.next();
            TopView topView = designObjectPlaceHolder.getTopView();
            if (topView == null) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    public void rearrangeDiagram() {
        int n = 20;
        int n2 = 20;
        int n3 = 35;
        int n4 = 25;
        int n5 = 0;
        Collection collection = this.getSTTopViews();
        float f = (float)Math.sqrt(collection.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        ++l;
        for (TopView topView : collection) {
            if (topView == null) continue;
            ++n5;
            Dimension dimension = this.getTypeSize((StructuredType)topView.getModel());
            n3 = dimension.width;
            n4 = Math.max(dimension.height, n4);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(n, n2), dimension));
            } else {
                topView.setBounds(new Rectangle(new Point(n, n2), dimension));
            }
            n = n + n3 + 50;
            if ((long)n5 != l) continue;
            n5 = 0;
            n = 20;
            n2 = n2 + n4 + 50;
            n4 = 25;
        }
    }

    public Dimension getTypeSize(StructuredType structuredType) {
        int n = 35;
        int n2 = 25;
        int n3 = structuredType.getElements().length + structuredType.getMethods().length + 1;
        n2 += n3 * 14;
        int n4 = structuredType.getName().length() * 6;
        int n5 = 1;
        for (int i = 0; i < structuredType.getElements().length; ++i) {
            TypeElement typeElement = structuredType.getElements()[i];
            int n6 = typeElement.getName().length() * 7;
            int n7 = typeElement.getDataType().toString().length() * 7 + 10;
            n4 = Math.max(n6, n4);
            n5 = Math.max(n7, n5);
        }
        if (n4 == 1) {
            n4 = structuredType.getName().length() * 7;
        }
        return new Dimension(n + n4 + n5, n2);
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVDataTypesSubView(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    protected void showPropertiesDialog() {
        if (!this.getPlaceHolder().isDialogVisible()) {
            ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
            modelPropertiesDialogEx.initProperties(this.getPlaceHolder());
            modelPropertiesDialogEx.show();
        }
    }
}

