/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTReferenceSet;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.SelectNeighborsDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.ControllerDataTypes;
import oracle.dbtools.crest.swingui.datatypes.Messages;
import oracle.dbtools.crest.swingui.datatypes.TVDTInheritance;
import oracle.dbtools.crest.swingui.datatypes.TVDTReference;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;

public class DPVDataTypes
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(100, 100);
    public static final String MI_ATTRIBUTES = Messages.getString("DPVDataTypes.Attributes");
    public static final String MI_METHODS = Messages.getString("DPVDataTypes.Methods");
    private ControllerDataTypes controller;
    private JPopupMenu menu;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miShowGrid;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miDatatype;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miShowLegend;
    private JMenuItem miDiagramColor;

    public DPVDataTypes(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        this.controller = new ControllerDataTypes(applicationView);
        this.controller.setName("DataTypes");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        return this.createTopViewFor(designObject);
    }

    public TopView createViewSynonim(DesignObject designObject) {
        AbstractDTObject abstractDTObject = (AbstractDTObject)designObject;
        TopView topView = abstractDTObject.getFirstViewForDPV(this);
        if (topView == null) {
            if (designObject instanceof DTInheritance) {
                topView = new TVDTInheritance(this.getApplicationView(), this);
            } else if (designObject instanceof DTReference) {
                topView = new TVDTReference(this.getApplicationView(), this);
            }
        }
        if (topView != null) {
            topView.setModel(designObject);
            this.modelToView.put(designObject, topView);
            this.add(topView);
        }
        return topView;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVDataTypes(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public boolean canCreateDisplays() {
        return true;
    }

    @Override
    public TopView createTopViewFor(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof StructuredType) {
            TVStructuredType tVStructuredType = new TVStructuredType(this.getApplicationView(), this);
            tVStructuredType.setModel(designObject);
            topView = tVStructuredType;
            topView.setSize(new Dimension(TOPVIEW_SIZE));
        } else if (designObject instanceof DTInheritance) {
            TVDTInheritance tVDTInheritance = new TVDTInheritance(this.getApplicationView(), this);
            tVDTInheritance.setModel(designObject);
            topView = tVDTInheritance;
        } else if (designObject instanceof DTReference) {
            TVDTReference tVDTReference = new TVDTReference(this.getApplicationView(), this);
            tVDTReference.setModel(designObject);
            topView = tVDTReference;
        } else if (designObject instanceof Note) {
            TVNote tVNote = new TVNote(this.getApplicationView(), this);
            tVNote.setModel(designObject);
            topView = tVNote;
        } else if (designObject instanceof Legend) {
            TVLegend tVLegend = new TVLegend(this.getApplicationView(), this);
            tVLegend.setModel(designObject);
            topView = tVLegend;
        } else if (designObject instanceof DiagramView) {
            TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
            tVDiagramView.setModel(designObject);
            topView = tVDiagramView;
        } else {
            return null;
        }
        this.registerForTreemodel(topView);
        this.setDirty(true);
        return topView;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.addSubViewAndDisplayMenus(this.menu);
            this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
            this.miAutoRoute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVDataTypes.this.setAutoRoute(!DPVDataTypes.this.isAutoRoute());
                    DPVDataTypes.this.getWorkSpace().updateSettings();
                }
            });
            this.menu.add(this.miAutoRoute);
            this.menu.addSeparator();
            this.menu.add(this.getStraightenLinesItem());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.miDiagramColor = this.menu.add(new AbstractAction(MI_DIAGRAM_COLOR){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVDataTypes.this.changeDiagramColor();
                }
            });
            this.miDiagramColor.setEnabled(false);
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.showPropertiesDialog();
            }
        });
        if (this.isEditable()) {
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miDatatype.setSelected(this.showDatatype());
            this.miKeys.setSelected(this.showKeys());
            this.miDiagramColor.setEnabled(true);
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.setShowGrid(!DPVDataTypes.this.showGrid());
            }
        });
        jMenu.add(this.miShowGrid);
        jMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.setShowLegend(!DPVDataTypes.this.showLegend());
            }
        });
        jMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowLegend.setSelected(this.showLegend());
        return jMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ATTRIBUTES));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_ATTRIBUTES));
        this.miDatatype = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_DATATYPE));
        this.miDatatype.setMnemonic(MenuUtils.getMnemonicKey(MI_DATATYPE));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_METHODS));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_METHODS));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.setShowAllDetails(true);
                DPVDataTypes.this.setShowNamesOnly(false);
                DPVDataTypes.this.setShowElements(false);
                DPVDataTypes.this.setShowDatatype(false);
                DPVDataTypes.this.setShowKeys(false);
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.setShowNamesOnly(true);
                DPVDataTypes.this.setShowAllDetails(false);
                DPVDataTypes.this.setShowNamesOnly(true);
                DPVDataTypes.this.setShowElements(false);
                DPVDataTypes.this.setShowDatatype(false);
                DPVDataTypes.this.setShowKeys(false);
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.setShowElements(!DPVDataTypes.this.showElements());
                if (!DPVDataTypes.this.showElements()) {
                    DPVDataTypes.this.setShowDatatype(false);
                    if (!DPVDataTypes.this.showKeys()) {
                        DPVDataTypes.this.setShowAllDetails(true);
                    }
                } else {
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miElements);
        this.miDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.setShowDatatype(!DPVDataTypes.this.showDatatype());
                if (DPVDataTypes.this.showDatatype()) {
                    DPVDataTypes.this.setShowElements(true);
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miDatatype);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVDataTypes.this.setShowKeys(!DPVDataTypes.this.showKeys());
                if (DPVDataTypes.this.showKeys()) {
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                } else if (!DPVDataTypes.this.showElements()) {
                    DPVDataTypes.this.setShowAllDetails(true);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miKeys);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miDatatype.setSelected(this.showDatatype());
        this.miKeys.setSelected(this.showKeys());
        return this.detailsMenu;
    }

    protected void showPropertiesDialog() {
        if (!this.isMasterDPV()) {
            if (!this.getPlaceHolder().isDialogVisible()) {
                ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
                modelPropertiesDialogEx.initProperties(this.getPlaceHolder());
                modelPropertiesDialogEx.show();
            }
        } else {
            this.getDesignPart().showPropertyDialog();
        }
    }

    @Override
    public void createSubViewFromSelected() {
        DesignPartView designPartView;
        Object[] objectArray = this.getSelectedObjects();
        if (objectArray.length > 0 && (designPartView = this.getApplicationView().createSubview(this)) != null) {
            ObjectListener objectListener;
            Object object;
            designPartView.setAutoRoute(false);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (!(object2 instanceof StructuredType)) continue;
                object = ((ContainerView)((DesignObject)object2).getTopView()).createViewSynonim(designPartView);
                objectListener = this.getViewFor((DesignObject)object2);
                if (((TopView)object).getCellView() != null) {
                    ((TopView)object).getCellView().setNewBounds(((TopView)objectListener).getBounds());
                } else {
                    ((TopView)object).setBounds(((TopView)objectListener).getBounds());
                }
                if (object instanceof TVStructuredType) {
                    ((TVStructuredType)object).addTVRelations();
                    ((TVStructuredType)object).addTVInheritances();
                }
                designPartView.synchronizeSynonymWithDisplays((TopView)object);
            }
            DTReferenceSet dTReferenceSet = ((DataTypesDesign)this.getDesignPart()).getDTReferenceSet();
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof StructuredType)) continue;
                objectListener = (StructuredType)object;
                Collection collection = dTReferenceSet.getRelationsToSource((StructuredType)objectListener);
                collection.addAll(((DataTypesDesign)this.getDesignPart()).getDTInheritanceSet().getInheritancesToSource((StructuredType)objectListener));
                Object[] objectArray2 = collection.toArray();
                for (int j = 0; j < objectArray2.length; ++j) {
                    Object object3;
                    int n;
                    List list;
                    List list2;
                    DesignObject designObject = (DesignObject)objectArray2[j];
                    TVConnector tVConnector = (TVConnector)designObject.getFirstViewForDPV(this);
                    TVConnector tVConnector2 = (TVConnector)designObject.getFirstViewForDPV(designPartView);
                    if (tVConnector2 == null || tVConnector == null) continue;
                    EdgeView edgeView = null;
                    if (tVConnector.getEdge() != null) {
                        edgeView = (EdgeView)tVConnector.getEdge().getCellView();
                    }
                    if (edgeView != null) {
                        list2 = edgeView.getPoints();
                        list = tVConnector2.getEdgePoints();
                        list.clear();
                        for (n = 0; n < list2.size(); ++n) {
                            object3 = list2.get(n);
                            Point2D point2D = null;
                            if (object3 instanceof Point2D) {
                                point2D = (Point2D)object3;
                            } else if (object3 instanceof PortView) {
                                point2D = ((PortView)object3).getPoint();
                            }
                            if (point2D == null) continue;
                            list.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
                        }
                        if (tVConnector2.getEdge() == null || tVConnector2.getEdge().getCellView() == null) continue;
                        Hashtable hashtable = new Hashtable();
                        DiagramConstants.setPoints(hashtable, list);
                        tVConnector2.getEdge().changeAttributes(hashtable);
                        tVConnector2.getEdge().getCellView().update();
                        if (list.size() != 2) continue;
                        tVConnector2.getEdge().straightLine(false);
                        continue;
                    }
                    list2 = tVConnector.getEdgePoints();
                    list = tVConnector2.getEdgePoints();
                    list.clear();
                    for (n = 0; n < list2.size(); ++n) {
                        object3 = (Point2D)list2.get(n);
                        list.add(DiagramConstants.createPoint(((Point2D)object3).getX(), ((Point2D)object3).getY()));
                    }
                }
            }
            designPartView.setAutoRoute(this.isAutoRoute());
            designPartView.getWorkSpace().updateSettings();
        }
    }

    public void selectNeighbors(AbstractDTObject abstractDTObject) {
        SelectNeighborsDialog selectNeighborsDialog = new SelectNeighborsDialog(this.getApplicationView());
        selectNeighborsDialog.showDialog();
        int n = selectNeighborsDialog.getZones();
        if (n > -1) {
            ArrayList<AbstractDTObject> arrayList = new ArrayList<AbstractDTObject>();
            arrayList.add(abstractDTObject);
            this.collectNeighbors(abstractDTObject, arrayList, n, n == 0);
            this.getWorkSpace().setSelectionCells(this.getCellsFromObjects(arrayList).toArray());
        }
    }

    private void collectNeighbors(AbstractDTObject abstractDTObject, List list, int n, boolean bl) {
        int n2 = --n;
        DTRelation.Connection[] connectionArray = abstractDTObject.getAllLinks();
        for (int i = 0; i < connectionArray.length; ++i) {
            AbstractDTObject abstractDTObject2;
            DTRelation.Connection connection = connectionArray[i];
            if (connection.getDTRelation() instanceof DTInheritance || list.contains(abstractDTObject2 = connection.getDTRelation().getOtherDTObject(abstractDTObject))) continue;
            list.add(abstractDTObject2);
            if (!bl && n2 <= 0) continue;
            this.collectNeighbors(abstractDTObject2, list, n2, bl);
        }
    }
}

