/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.datatypes.Messages;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.datatypes.StructuredTypeDiagramCell;
import oracle.ide.Ide;

public class ControllerDataTypes
extends AbstractController {
    private final String[] OBJECT_DTD_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.DTD_CAPTION};
    private DesignPartView dpv = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private STCollector stCollector = null;
    private NewStructuredType newStructureType;
    private NewReferenceLink newRefLink;
    private NewEmbeddedStructureLink newEmbeddedStructureLink;
    private NewCollectionOfRefsLink newCollectionOfRefsLink;
    private NewCollectionOfEmbeddedStructureLink newCollectionOfEmbeddedStructureLink;
    private NewNote newNote;
    private Delete delete;

    public ControllerDataTypes(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectDataTypesMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_DTD_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newStructureType = new NewStructuredType();
            this.newRefLink = new NewReferenceLink();
            this.newEmbeddedStructureLink = new NewEmbeddedStructureLink();
            this.newCollectionOfRefsLink = new NewCollectionOfRefsLink();
            this.newCollectionOfEmbeddedStructureLink = new NewCollectionOfEmbeddedStructureLink();
            this.newNote = new NewNote();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newStructureType);
            this.add(this.newRefLink);
            this.add(this.newEmbeddedStructureLink);
            this.add(this.newCollectionOfRefsLink);
            this.add(this.newCollectionOfEmbeddedStructureLink);
            this.add(this.newNote);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    public FitScreen getFitScreen() {
        return this.fitScreen;
    }

    public ActualSize getActualSize() {
        return this.actualSize;
    }

    @Override
    public MDBAction getSearch() {
        return this.search;
    }

    public ZoomIn getZoomIn() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOut() {
        return this.zoomOut;
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerDataTypes.DataTypes");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
        this.dpv = designPartView;
    }

    @Override
    public void updateActions() {
        boolean bl = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            bl = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newStructureType, bl);
        this.setEnabled(this.newRefLink, bl);
        this.setEnabled(this.newEmbeddedStructureLink, bl);
        this.setEnabled(this.newCollectionOfRefsLink, bl);
        this.setEnabled(this.newCollectionOfEmbeddedStructureLink, bl);
        this.setEnabled(this.newNote, bl);
        this.setEnabled(this.delete, bl);
    }

    public class STCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        private int type = 1;

        public STCollector() {
            this.startCollecting();
        }

        public STCollector(int n) {
            this.type = n;
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerDataTypes.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            TVStructuredType tVStructuredType = this.getTopViewFor(pointArray[0]);
            TVStructuredType tVStructuredType2 = this.getTopViewFor(pointArray[1]);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (tVStructuredType == null) {
                arrayList.add(Messages.getString("ControllerDataTypes.NoSourceObjectSelected"));
            }
            if (tVStructuredType2 == null) {
                arrayList.add(Messages.getString("ControllerDataTypes.NoTargetObjectSelected"));
            }
            if (arrayList.size() == 0) {
                this.createRelation(tVStructuredType, tVStructuredType2);
            } else {
                JOptionPane.showMessageDialog(ControllerDataTypes.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerDataTypes.NewReference"), 0);
            }
            this.startCollecting();
        }

        private TVStructuredType getTopViewFor(Point point) {
            Object object = ControllerDataTypes.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof StructuredTypeDiagramCell) {
                return (TVStructuredType)((StructuredTypeDiagramCell)object).getTopView();
            }
            return null;
        }

        private boolean hasValidContainment(StructuredType structuredType, StructuredType structuredType2) {
            if (this.type == 2 || this.type == 4) {
                if (structuredType.isParentOf(structuredType2) || structuredType2.isParentOf(structuredType)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ControllerDataTypes.TypePartOf"), structuredType2.getName(), structuredType.getName()), Messages.getString("ControllerDataTypes.ForbidenSelfContainment"), 0);
                    return false;
                }
                if (structuredType2.containsElementOfStructuredType(structuredType)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ControllerDataTypes.CyclicContainment"), structuredType2.getName()), Messages.getString("ControllerDataTypes.ForbidenCyclicContainment"), 0);
                    return false;
                }
            }
            return true;
        }

        private void createRelation(TVStructuredType tVStructuredType, TVStructuredType tVStructuredType2) {
            StructuredType structuredType = (StructuredType)tVStructuredType.getModel();
            StructuredType structuredType2 = (StructuredType)tVStructuredType2.getModel();
            if (structuredType != null && structuredType2 != null && this.hasValidContainment(structuredType2, structuredType)) {
                if (this.type == 1) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateReferenceTo"), structuredType.getName()));
                } else if (this.type == 2) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateUsageOf"), structuredType.getName()));
                } else if (this.type == 3) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateCollectionOfReferences"), structuredType.getName()));
                } else if (this.type == 4) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateCollectionOf"), structuredType.getName()));
                }
                DataTypesDesign dataTypesDesign = (DataTypesDesign)structuredType.getDesignPart();
                if (this.type == 1 || this.type == 2) {
                    TypeElement typeElement = new TypeElement(structuredType2.getDesignPart(), structuredType2);
                    typeElement.setDesign(structuredType2.getDesign());
                    structuredType2.add(typeElement);
                    typeElement.setType(structuredType);
                    if (this.type == 1) {
                        typeElement.setReference(true);
                        typeElement.setName(dataTypesDesign.getReferencePrefix() + structuredType.getName());
                    } else {
                        typeElement.setName(dataTypesDesign.getEmbeddedStructuredTypePrefix() + structuredType.getName());
                    }
                    typeElement.updateReference();
                } else if (this.type == 3 || this.type == 4) {
                    CollectionType collectionType = dataTypesDesign.getOrCreateCollectionFor(structuredType, this.type == 3);
                    TypeElement typeElement = new TypeElement(structuredType2.getDesignPart(), structuredType2);
                    typeElement.setDesign(structuredType2.getDesign());
                    structuredType2.add(typeElement);
                    typeElement.setType(collectionType);
                    if (this.type == 3) {
                        typeElement.setName(dataTypesDesign.getCollectionOfRefsPrefix() + structuredType.getName());
                    } else {
                        typeElement.setName(dataTypesDesign.getCollectionPrefix() + structuredType.getName());
                    }
                    typeElement.updateReference();
                }
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerDataTypes.this.getDesignPartView().getWorkSpace();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("SEARCH_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerDataTypes.this.getApplicationView().search(5);
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            designPartView.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            designPartView.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            designPartView.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerDataTypes.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            designPartView.zoomIn();
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("DELETE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NOTE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerDataTypes.this.updateToolbar(this);
        }
    }

    class NewCollectionOfEmbeddedStructureLink
    extends MDBAction {
        private NewCollectionOfEmbeddedStructureLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_COLLECTION_OF_EMBEDDED_STRUCTURE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_COL_COMPOSITIONS_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_COLLECTION_OF_EMBEDDED_STRUCTURE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector(4);
        }
    }

    class NewCollectionOfRefsLink
    extends MDBAction {
        private NewCollectionOfRefsLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_COLLECTION_OF_REFERENCE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_COL_REFS_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_COLLECTION_OF_REFERENCE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector(3);
        }
    }

    class NewEmbeddedStructureLink
    extends MDBAction {
        private NewEmbeddedStructureLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_EMBEDDED_STRUCTURE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_COMPOSITION_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_EMBEDDED_STRUCTURE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector(2);
        }
    }

    class NewReferenceLink
    extends MDBAction {
        private NewReferenceLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_REFERENCE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_REFERENCE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_REFERENCE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector();
        }
    }

    class NewStructuredType
    extends MDBAction {
        private NewStructuredType() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_STRUCTURED_TYPE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("STRUCTURED_TYPE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_STRUCTURED_TYPE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(17);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerDataTypes.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("SELECT_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerDataTypes.this.updateToolbar(this);
        }
    }
}

