/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.xmlmeta;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareDialog;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.compare.MapCompareBuilder;
import oracle.dbtools.crest.model.metadata.compare.MetaMapSelection;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertiesComparator;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertyHolder;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.compare.xmlmeta.MetaMapCheckEditor;
import oracle.dbtools.crest.swingui.compare.xmlmeta.MetaMapRenderer;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class XMLMetadataComparator
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private static final String PROPERTY_X = "x";
    private static final String PROPERTY_Y = "y";
    private static final String PROPERTY_W = "w";
    private static final String PROPERTY_H = "h";
    private static final String PROPERTY_HPOS = "hpos";
    private static final String PROPERTY_VPOS = "vpos";
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JScrollPane detailsSP;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private JTable compareTable = new JTable();
    private SelectedCellRenderer selRenderer = new SelectedCellRenderer();
    private ModifiableCellRenderer propertyNamerenderer = new ModifiableCellRenderer();
    private ValueCellRenderer colorPropertyRenderer = new ValueCellRenderer();
    private JDialog dialog;
    private JPanel buttonPanel;
    private List eList;
    private int counter = 0;
    private JButton button;
    JCheckBoxMenuItem item = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowAllObjects"));
    JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowNewObjects"));
    JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowDeletedObjects"));
    JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowModifiedObjects"));
    private JPopupMenu menu;
    private JButton bnMerge;
    private JScrollBar leftSB;
    private JScrollBar rightSB;
    private MapCompareBuilder mcb;
    private JSplitPane vsp;
    private JSplitPane hsp;
    private Map mergedMap = null;
    private boolean mergeEnabled;
    private static final Logger LOGGER = new Logger(XMLMetadataComparator.class);
    MyJTree startTree = null;
    boolean started = false;
    boolean sb_started = false;
    boolean sel_started = false;
    List list = new ArrayList();

    public XMLMetadataComparator(Design design, StorageDesign storageDesign, InputStream inputStream, String string, InputStream inputStream2, String string2, boolean bl) {
        super(design.getAppView());
        this.mergeEnabled = bl;
        try {
            this.mcb = new MapCompareBuilder(design, storageDesign, inputStream, string, inputStream2, string2);
            this.initLeftTreePanel(this.mcb.getLeftRoot());
            this.initRightTreePanel(this.mcb.getRightRoot());
            this.leftTreePanel.setPreferredSize(new Dimension(350, 400));
            this.rightTreePanel.setPreferredSize(new Dimension(350, 400));
            this.leftTreePanel.setMinimumSize(new Dimension(350, 200));
            this.rightTreePanel.setMinimumSize(new Dimension(350, 200));
            this.tabbedPane.setPreferredSize(new Dimension(700, 200));
            this.detailsSP = new JScrollPane(this.compareTable);
            this.compareTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && ((n = XMLMetadataComparator.this.compareTable.getSelectedColumn()) == 2 || n == 3)) {
                        String string;
                        String string2;
                        int n2 = XMLMetadataComparator.this.compareTable.getSelectedRow();
                        CompareModel compareModel = (CompareModel)XMLMetadataComparator.this.compareTable.getModel();
                        MetaPropertyHolder metaPropertyHolder = compareModel.getPropertyHolder(n2);
                        ClassDescription.PropertyDescription propertyDescription = metaPropertyHolder.getPropertyDescription();
                        String string3 = metaPropertyHolder.getPresentationName();
                        boolean bl = true;
                        if (propertyDescription != null && propertyDescription.isMergeCompare) {
                            string2 = metaPropertyHolder.getLeftValue();
                            string = metaPropertyHolder.getRightValue();
                            bl = false;
                        } else {
                            string2 = metaPropertyHolder.getLeftValuePresentation();
                            string = metaPropertyHolder.getRightValue();
                        }
                        if (!"".equalsIgnoreCase(string2) || !"".equalsIgnoreCase(string)) {
                            InputStream inputStream = XMLMetadataComparator.this.getStream(string2);
                            InputStream inputStream2 = XMLMetadataComparator.this.getStream(string);
                            VCSTextCompareDialog vCSTextCompareDialog = new VCSTextCompareDialog(XMLMetadataComparator.this.getDialog(), null, inputStream, "left", inputStream2, "right", true, bl);
                            vCSTextCompareDialog.setTitle(string3);
                            vCSTextCompareDialog.setVisible(true);
                            if (propertyDescription != null && propertyDescription.isMergeCompare && vCSTextCompareDialog.isOk()) {
                                String string4 = vCSTextCompareDialog.getEditor().getRightText();
                                metaPropertyHolder.setRightValue(string4);
                                metaPropertyHolder.setMerged(true);
                                XMLMetadataComparator.this.compareTable.updateUI();
                            }
                        }
                    }
                }
            });
            this.detailsSP.setPreferredSize(new Dimension(700, 200));
            this.hsp = new JSplitPane(1);
            this.hsp.setLeftComponent(this.leftTreePanel);
            this.hsp.setRightComponent(this.rightTreePanel);
            this.hsp.setDividerLocation(-1);
            this.hsp.setResizeWeight(0.5);
            this.vsp = new JSplitPane(0, this.hsp, this.tabbedPane);
            this.initToolbar();
            this.add((Component)this.vsp, "Center");
            this.tabbedPane.add(Messages.getString("CompareModelsDialog.Details"), this.detailsSP);
            this.add((Component)this.getButtonPanel(), "South");
        }
        catch (Exception exception) {
            LOGGER.error("XMLMetadataComparator:", exception);
        }
    }

    private void initToolbar() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.button = new JButton(Messages.getString("CompareModelsDialog.Filter"));
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = XMLMetadataComparator.this.getPopupMenu();
                jPopupMenu.show(XMLMetadataComparator.this.button, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        });
        this.button.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.button);
        this.add((Component)jPanel, "North");
    }

    private void setFilter(JTree jTree, EngFilter engFilter) {
        MetaMapSelection metaMapSelection = (MetaMapSelection)jTree.getModel().getRoot();
        metaMapSelection.setFilter(engFilter);
    }

    private JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            PopupMenuListener popupMenuListener = new PopupMenuListener();
            this.item1.addActionListener(popupMenuListener);
            this.item2.addActionListener(popupMenuListener);
            this.item3.addActionListener(popupMenuListener);
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item2);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    private void initLeftTreePanel(ModelIdObjectSelection modelIdObjectSelection) {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.setEditable(true);
        MetaMapRenderer metaMapRenderer = new MetaMapRenderer(true);
        this.leftTree.setCellRenderer(metaMapRenderer);
        MetaMapCheckEditor metaMapCheckEditor = new MetaMapCheckEditor(true);
        this.leftTree.setCellEditor(metaMapCheckEditor);
        JScrollPane jScrollPane = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jScrollPane, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jScrollPane.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
        if (modelIdObjectSelection != null) {
            this.resetLeftTree(modelIdObjectSelection);
        }
    }

    private void resetLeftTree(ModelIdObjectSelection modelIdObjectSelection) {
        this.leftNavDesign = new CompareTreeNavigationDesign(modelIdObjectSelection);
        this.leftTree.setModel(this.leftNavDesign);
    }

    private void initRightTreePanel(ModelIdObjectSelection modelIdObjectSelection) {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        MetaMapRenderer metaMapRenderer = new MetaMapRenderer(false);
        metaMapRenderer.setShowCheckbox(false);
        this.rightTree.setCellRenderer(metaMapRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jScrollPane, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jScrollPane.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
        if (modelIdObjectSelection != null) {
            this.resetRightTree(modelIdObjectSelection);
        }
    }

    private void resetRightTree(ModelIdObjectSelection modelIdObjectSelection) {
        this.rightNavDesign = new CompareTreeNavigationDesign(modelIdObjectSelection);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void unregisterListeners() {
        if (this.leftNavDesign != null) {
            this.leftNavDesign.unregisterAsListener();
        }
        if (this.rightNavDesign != null) {
            this.rightNavDesign.unregisterAsListener();
        }
    }

    protected void setObjectConstraints(SpringLayout springLayout, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.synchroizeSelection(treeSelectionEvent);
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof MetaMapSelection) {
            int[] nArray = new int[]{0, 0, 0, 0};
            boolean bl = this.compareTable.getColumnModel() != null;
            int n = 4;
            if (bl) {
                n = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            MetaPropertiesComparator metaPropertiesComparator = ((MetaMapSelection)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(metaPropertiesComparator));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn tableColumn = this.compareTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(60);
            tableColumn.setWidth(60);
            tableColumn.setMaxWidth(70);
            tableColumn.setCellRenderer(this.selRenderer);
            tableColumn = this.compareTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(this.propertyNamerenderer);
            tableColumn = this.compareTable.getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(this.colorPropertyRenderer);
            tableColumn = this.compareTable.getColumnModel().getColumn(3);
            tableColumn.setCellRenderer(this.colorPropertyRenderer);
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(nArray[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, true);
    }

    void processExpEvent(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        Object object = treeExpansionEvent.getSource();
        if (object instanceof JTree && !this.started) {
            this.startTree = (MyJTree)object;
            this.started = true;
            TreePath treePath = treeExpansionEvent.getPath();
            MetaMapSelection metaMapSelection = (MetaMapSelection)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setExpandedState(new TreePath(metaMapSelection.getCorrespondentNode().getPath()), bl);
            this.started = false;
        }
    }

    MyJTree getOtherTree(JTree jTree) {
        if (jTree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof JScrollBar && !this.sb_started) {
            JScrollBar jScrollBar = (JScrollBar)object;
            if (jScrollBar == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jScrollBar == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    private void synchroizeSelection(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getSource();
        if (object instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)object;
            this.sel_started = true;
            TreePath treePath = treeSelectionEvent.getPath();
            MetaMapSelection metaMapSelection = (MetaMapSelection)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setSelectionPath(new TreePath(metaMapSelection.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("XMLMetadataComparator.XMLMetadataComparator"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = XMLMetadataComparator.this.dialog.getWidth();
                    int n2 = XMLMetadataComparator.this.dialog.getHeight();
                    n = Math.max(720, n);
                    n2 = Math.max(600, n2);
                    XMLMetadataComparator.this.dialog.setSize(n, n2);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            Map map = this.getDesign().getAppView().getSettings().getCustomSettings(this.getClass().getName());
            if (map != null) {
                try {
                    int n = Integer.parseInt((String)map.get(PROPERTY_X));
                    int n2 = Integer.parseInt((String)map.get(PROPERTY_Y));
                    int n3 = Integer.parseInt((String)map.get(PROPERTY_W));
                    int n4 = Integer.parseInt((String)map.get(PROPERTY_H));
                    int n5 = Integer.parseInt((String)map.get(PROPERTY_HPOS));
                    int n6 = Integer.parseInt((String)map.get(PROPERTY_VPOS));
                    Rectangle rectangle = this.getDesign().getAppView().getSettings().fixScreenLocation(n, n2, n3, n4);
                    if (rectangle == null) {
                        this.dialog.setSize(720, 600);
                        CommonUtil.centerOnScreen(this.dialog);
                    } else {
                        this.dialog.setSize(rectangle.getSize());
                        this.dialog.setLocation(rectangle.getLocation());
                    }
                    this.hsp.setDividerLocation(n5);
                    this.vsp.setDividerLocation(n6);
                }
                catch (Exception exception) {}
            } else {
                this.dialog.setSize(720, 600);
                CommonUtil.centerOnScreen(this.dialog);
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        if (this.hsp != null && this.vsp != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(PROPERTY_X, String.valueOf(this.getDialog().getLocation().x));
            hashMap.put(PROPERTY_Y, String.valueOf(this.getDialog().getLocation().y));
            hashMap.put(PROPERTY_W, String.valueOf(this.getDialog().getSize().width));
            hashMap.put(PROPERTY_H, String.valueOf(this.getDialog().getSize().height));
            hashMap.put(PROPERTY_HPOS, String.valueOf(this.hsp.getDividerLocation()));
            hashMap.put(PROPERTY_VPOS, String.valueOf(this.vsp.getDividerLocation()));
            this.getDesign().getAppView().getSettings().setCustomSettings(this.getClass().getName(), hashMap);
        }
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "XML_METADATA_COMPARATOR_DIALOG";
    }

    public void setModal(boolean bl) {
        ((JDialog)this.getDialog()).setModal(bl);
    }

    @Override
    public void show() {
        this.getDialog().setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map showModal() {
        try {
            this.setModal(true);
            this.show();
            Map map = this.getMergedMap();
            return map;
        }
        finally {
            this.setModal(false);
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.bnMerge = new JButton(Messages.getString("CompareModelsDialog.Merge"));
            this.bnMerge.setMnemonic(77);
            this.bnMerge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    XMLMetadataComparator.this.merge();
                    XMLMetadataComparator.this.close();
                }
            });
            JButton jButton = new JButton("Close");
            jButton.setMnemonic(67);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    XMLMetadataComparator.this.mergedMap = null;
                    XMLMetadataComparator.this.close();
                }
            });
            JButton jButton2 = new JButton(this.getHelpAction());
            jButton2.setMnemonic(72);
            this.bnMerge.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(this.bnMerge);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            this.bnMerge.setEnabled(this.mergeEnabled);
        }
        return this.buttonPanel;
    }

    public void enableMergeButton(boolean bl) {
    }

    protected int generateNumber() {
        int n = 0;
        int n2 = this.eList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        while (this.numberExists(n)) {
            n = ++this.counter;
        }
        return n;
    }

    private boolean numberExists(int n) {
        for (int i = 0; i < this.eList.size(); ++i) {
            DDLException dDLException = (DDLException)this.eList.get(i);
            if (n != dDLException.getNumber()) continue;
            return true;
        }
        return false;
    }

    protected JPanel createRow(String string, String string2, JTextField jTextField) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(110, 20));
        jTextField.setPreferredSize(new Dimension(250, 20));
        jTextField.setText(string2);
        jPanel.add((Component)jLabel, "West");
        jPanel.add(jTextField);
        return jPanel;
    }

    private void merge() {
        this.mcb.mergeToRightMap();
        this.mergedMap = this.mcb.getRightMap();
    }

    public Map getMergedMap() {
        return this.mergedMap;
    }

    public Map getLeftMap() {
        return this.mcb.getLefttMap();
    }

    private InputStream getStream(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        }
        return byteArrayInputStream;
    }

    class ShowAllListener
    implements ActionListener {
        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (XMLMetadataComparator.this.item.isSelected()) {
                XMLMetadataComparator.this.item.setEnabled(false);
                XMLMetadataComparator.this.item1.setSelected(false);
                XMLMetadataComparator.this.item2.setSelected(false);
                XMLMetadataComparator.this.item3.setSelected(false);
                EngFilter engFilter = new EngFilter();
                engFilter.addFilter(EngFilter.NO_FILTER);
                XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.leftTree, engFilter);
                XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.rightTree, engFilter);
                XMLMetadataComparator.this.leftTree.updateUI();
                XMLMetadataComparator.this.rightTree.updateUI();
            } else {
                XMLMetadataComparator.this.item.setEnabled(true);
            }
            XMLMetadataComparator.this.item.setSelected(true);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EngFilter engFilter = new EngFilter();
            if (XMLMetadataComparator.this.item1.isSelected() || XMLMetadataComparator.this.item2.isSelected() || XMLMetadataComparator.this.item3.isSelected()) {
                XMLMetadataComparator.this.item.setSelected(false);
            }
            if (XMLMetadataComparator.this.item1.isSelected()) {
                engFilter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (XMLMetadataComparator.this.item2.isSelected()) {
                engFilter.addFilter(EngFilter.STATE_DELETED_FILTER);
            }
            if (XMLMetadataComparator.this.item3.isSelected()) {
                engFilter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            XMLMetadataComparator.this.item.setEnabled(true);
            if (!(XMLMetadataComparator.this.item1.isSelected() || XMLMetadataComparator.this.item2.isSelected() || XMLMetadataComparator.this.item3.isSelected())) {
                engFilter.addFilter(EngFilter.NO_FILTER);
                XMLMetadataComparator.this.item.setSelected(true);
                XMLMetadataComparator.this.item.setEnabled(false);
            }
            XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.leftTree, engFilter);
            XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.rightTree, engFilter);
            XMLMetadataComparator.this.leftTree.updateUI();
            XMLMetadataComparator.this.rightTree.updateUI();
        }
    }

    class ValueCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.getModel() instanceof CompareModel) {
                boolean bl3;
                int n3;
                CompareModel compareModel = (CompareModel)jTable.getModel();
                MetaPropertyHolder metaPropertyHolder = compareModel.getPropertyHolder(n);
                ClassDescription.PropertyDescription propertyDescription = metaPropertyHolder.getPropertyDescription();
                this.setOpaque(true);
                if (n2 == 2) {
                    this.setText(metaPropertyHolder.getLeftValuePresentation());
                } else if (n2 == 3) {
                    this.setText(metaPropertyHolder.getRightValuePresentation());
                }
                if (metaPropertyHolder.isColorProperty()) {
                    n3 = 0;
                    bl3 = true;
                    if (n2 == 2) {
                        try {
                            n3 = Integer.parseInt(metaPropertyHolder.getLeftValue());
                        }
                        catch (Exception exception) {
                            bl3 = false;
                        }
                    } else if (n2 == 3) {
                        try {
                            n3 = Integer.parseInt(metaPropertyHolder.getRightValue());
                        }
                        catch (Exception exception) {
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        this.setForeground(new Color(n3));
                    }
                } else {
                    this.setForeground(jTable.getForeground());
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    if (metaPropertyHolder.isColorProperty()) {
                        n3 = 0;
                        bl3 = true;
                        if (n2 == 2) {
                            try {
                                n3 = Integer.parseInt(metaPropertyHolder.getLeftValue());
                            }
                            catch (Exception exception) {
                                bl3 = false;
                            }
                        } else if (n2 == 3) {
                            try {
                                n3 = Integer.parseInt(metaPropertyHolder.getRightValue());
                            }
                            catch (Exception exception) {
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            this.setForeground(new Color(n3));
                        }
                    }
                } else {
                    this.setBackground(jTable.getBackground());
                }
                if (n2 == 3 && propertyDescription != null && propertyDescription.isMergeCompare && metaPropertyHolder.isModified()) {
                    if (metaPropertyHolder.isMerged()) {
                        if (bl) {
                            this.setForeground(Color.WHITE);
                        } else {
                            this.setForeground(Color.BLUE);
                        }
                    } else {
                        this.setForeground(Color.RED);
                    }
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                MetaPropertyHolder metaPropertyHolder = (MetaPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setText(metaPropertyHolder.getPresentationName());
                if (metaPropertyHolder.isModified()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(jTable.getForeground());
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    if (!metaPropertyHolder.isModified()) {
                        this.setForeground(jTable.getSelectionForeground());
                    }
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(bl3);
                if (engPropertyHolder.isModified()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            return this;
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private MetaPropertiesComparator comp;

        CompareModel(MetaPropertiesComparator metaPropertiesComparator) {
            this.comp = metaPropertiesComparator;
        }

        public List getPropertiesList() {
            return this.comp.getPropertiesList();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.comp.getPropertiesList().size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CompareModelsDialog.Property");
            }
            if (n == 1) {
                return Messages.getString("CompareModelsDialog.Selected");
            }
            if (n == 2) {
                return this.comp.getLeftName();
            }
            if (n == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                MetaPropertyHolder metaPropertyHolder = (MetaPropertyHolder)this.comp.getPropertiesList().get(n);
                return metaPropertyHolder.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MetaPropertyHolder metaPropertyHolder = (MetaPropertyHolder)this.comp.getPropertiesList().get(n);
            if (n2 == 0) {
                return metaPropertyHolder.getPresentationName();
            }
            if (n2 == 1) {
                return metaPropertyHolder.isSelected();
            }
            if (n2 == 2) {
                return metaPropertyHolder.getLeftValuePresentation();
            }
            if (n2 == 3) {
                return metaPropertyHolder.getRightValuePresentation();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
                engPropertyHolder.setSelected((Boolean)object);
            }
        }

        public MetaPropertyHolder getPropertyHolder(int n) {
            MetaPropertyHolder metaPropertyHolder = (MetaPropertyHolder)this.comp.getPropertiesList().get(n);
            return metaPropertyHolder;
        }
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel treeModel) {
            super(treeModel);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath treePath, boolean bl) {
            super.setExpandedState(treePath, bl);
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            XMLMetadataComparator.this.unregisterListeners();
        }
    }
}

