/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.compare.CompareModelsController;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ModelChooserDialog
extends JDialog
implements AbstractEditorConstants {
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private static final Logger LOGGER = new Logger(ModelChooserDialog.class);
    private static final String EMPTY_STRING = "";
    private CompareModelsController controller;
    private Object[] relationals;
    private Object importFile;
    private ApplicationView view;
    private JPanel generalPanel;
    private JComboBox cbTargetModel;
    private JComboBox cbSourceModel;
    private JComboBox cbSourceDBType;
    private String targetModelName = "";
    public static boolean isSelectedDatabase = true;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelChooserDialog.this.dispose();
            ModelChooserDialog.this.getController().removeTempDesign();
        }
    };
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelChooserDialog.this.showHelp();
        }
    };

    public ModelChooserDialog(ApplicationView applicationView, File file) {
        super(applicationView.getFrame());
        this.view = applicationView;
        this.targetModelName = applicationView.getDesignName();
        this.importFile = file;
        this.relationals = applicationView.getCurrentDesign().getRelationalDesigns().toArray();
        this.loadTempDesign();
        this.setTitle(Messages.getString("ModelChooserDialog.RelationalModelsDialog"));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.initMainPanel(), "Center");
        this.getContentPane().add(this.initBottomPanel(), "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, false);
        jComponent.getInputMap(n).put(keyStroke, "KEY_F1");
        jComponent.getActionMap().put("KEY_F1", this.actF1);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.setModal(true);
    }

    protected void showHelp() {
        HelpManager.showTopic((Component)Ide.getMainWindow(), this.getHelpIndex());
    }

    protected String getHelpIndex() {
        return "COMPARE_RELATIONAL_MODELS";
    }

    private Component initBottomPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("ModelChooserDialog.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new OKAction());
        JButton jButton2 = new JButton(Messages.getString("ModelChooserDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        JButton jButton3 = new JButton(Messages.getString("ModelChooserDialog.Help"));
        jButton3.setMnemonic(72);
        jButton3.addActionListener(new HelpAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private Component initMainPanel() {
        this.generalPanel = new JPanel(new GridLayout(4, 0));
        this.generalPanel.setPreferredSize(new Dimension(350, 300));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(EMPTY_STRING);
        arrayList.addAll(this.getApplicationView().getCurrentDesign().getRDBMSSiteSet().getValueSet());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new SpringLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("ModelChooserDialog.From"), this.getSourceModelName())));
        JLabel jLabel = new JLabel(Messages.getString("ModelChooserDialog.FromLabel"));
        jPanel.add(jLabel);
        this.setLabelConstraints(jPanel, jLabel, 20);
        this.cbSourceModel = new JComboBox<Object>(this.getTempRelationDesigns().toArray());
        this.cbSourceModel.setPreferredSize(new Dimension(180, 20));
        this.cbSourceModel.setBackground(Color.WHITE);
        jPanel.add(this.cbSourceModel);
        this.setObjectConstraints(jPanel, this.cbSourceModel, 20);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new SpringLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelChooserDialog.DatabaseTypes")));
        JLabel jLabel2 = new JLabel(Messages.getString("ModelChooserDialog.DatabaseType"));
        jPanel2.add(jLabel2);
        this.setLabelConstraints(jPanel2, jLabel2, 20);
        this.cbSourceDBType = new JComboBox<Object>(arrayList.toArray());
        this.cbSourceDBType.setPreferredSize(this.cbSourceModel.getPreferredSize());
        this.cbSourceDBType.setBackground(Color.WHITE);
        this.cbSourceDBType.setMaximumRowCount(arrayList.size() + 1);
        jPanel2.add(this.cbSourceDBType);
        this.setObjectConstraints(jPanel2, this.cbSourceDBType, 20);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new SpringLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("ModelChooserDialog.To"), this.getTargetModelName())));
        JLabel jLabel3 = new JLabel(Messages.getString("ModelChooserDialog.ToLabel"));
        jPanel3.add(jLabel3);
        this.setLabelConstraints(jPanel3, jLabel3, 20);
        this.cbTargetModel = new JComboBox<Object>(this.relationals);
        this.cbTargetModel.setPreferredSize(this.cbSourceModel.getPreferredSize());
        this.cbTargetModel.setBackground(Color.WHITE);
        jPanel3.add(this.cbTargetModel);
        this.setObjectConstraints(jPanel3, this.cbTargetModel, 20);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new SpringLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelChooserDialog.CompareMapping")));
        JButton jButton = new JButton(Messages.getString("ModelChooserDialog.ViewCompareMapping"));
        jButton.setPreferredSize(new Dimension(240, 20));
        jPanel4.add(jButton);
        this.setObjectConstraints(jPanel4, jButton, 60, 10);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareMappingDialog compareMappingDialog = new CompareMappingDialog(ModelChooserDialog.this.getApplicationView());
                compareMappingDialog.show();
            }
        });
        this.generalPanel.add(jPanel);
        this.generalPanel.add(jPanel3);
        this.generalPanel.add(jPanel2);
        this.generalPanel.add(jPanel4);
        return this.generalPanel;
    }

    private String getTargetModelName() {
        return this.targetModelName;
    }

    private String getSourceModelName() {
        return this.getController().getApplicationView().getDesignName();
    }

    private void setObjectConstraints(JPanel jPanel, Component component, int n) {
        SpringLayout.Constraints constraints = ((SpringLayout)jPanel.getLayout()).getConstraints(component);
        constraints.setX(Spring.constant(150));
        constraints.setY(Spring.constant(n));
    }

    private void setObjectConstraints(JPanel jPanel, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = ((SpringLayout)jPanel.getLayout()).getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    protected void setLabelConstraints(JPanel jPanel, JLabel jLabel, int n) {
        SpringLayout.Constraints constraints = ((SpringLayout)jPanel.getLayout()).getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(n));
    }

    private List getTempRelationDesigns() {
        return this.getController().getDPObject();
    }

    private void loadTempDesign() {
        try {
            this.getController().loadTempDesign((File)this.getImportFile());
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ModelChooserDialog.UnableGenerateDesign"), Messages.getString("ModelChooserDialog.ErrorGenerateDesign"), 0);
            this.doClose();
        }
    }

    private void doClose() {
        this.dispose();
        this.getController().removeTempDesign();
    }

    public CompareModelsController getController() {
        if (this.controller == null) {
            this.controller = new CompareModelsController(this.view);
        }
        return this.controller;
    }

    public Object getImportFile() {
        return this.importFile;
    }

    public void setImportFile(Object object) {
        this.importFile = object;
    }

    public ApplicationView getApplicationView() {
        return this.view;
    }

    public void setApplicationView(ApplicationView applicationView) {
        this.view = applicationView;
    }

    private boolean disableDDLPreview() {
        RelationalDesign relationalDesign = (RelationalDesign)this.cbTargetModel.getSelectedItem();
        return this.cbSourceDBType.getSelectedItem().equals(EMPTY_STRING) && !(relationalDesign.getStorageDesign() instanceof StorageDesignOracle);
    }

    private class HelpAction
    implements ActionListener {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelChooserDialog.this.showHelp();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelChooserDialog.this.dispose();
            ModelChooserDialog.this.getController().removeTempDesign();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelChooserDialog.this.dispose();
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ModelChooserDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ProgressDialog progressDialog = new ProgressDialog(ModelChooserDialog.this.getApplicationView(), ModelChooserDialog.EMPTY_STRING, 0, 100);
                    progressDialog.setParentComponent(ModelChooserDialog.this.getContentPane());
                    try {
                        Object object;
                        ApplicationView.loading = true;
                        ApplicationView.canLogging = false;
                        RelationalDesign relationalDesign = (RelationalDesign)ModelChooserDialog.this.cbSourceModel.getSelectedItem();
                        progressDialog.setNote(Messages.getString("ModelChooserDialog.Loading"));
                        progressDialog.setProgress(10);
                        if (relationalDesign.getDesign().isOldRepositoryType()) {
                            relationalDesign.getDesign().getDataTypesDesign().load();
                        } else {
                            ModelChooserDialog.this.getApplicationView().getXMLTransformationManager().openDesignPart(relationalDesign.getDesign().getDataTypesDesign());
                        }
                        ModelChooserDialog.this.getController().loadRelationalDesign(relationalDesign);
                        progressDialog.setProgress(40);
                        RelationalDesign relationalDesign2 = (RelationalDesign)ModelChooserDialog.this.cbTargetModel.getSelectedItem();
                        isSelectedDatabase = !ModelChooserDialog.this.cbSourceDBType.getSelectedItem().equals(ModelChooserDialog.EMPTY_STRING);
                        if (ModelChooserDialog.this.cbSourceDBType.getSelectedItem() instanceof RDBMSSite) {
                            relationalDesign.setSelectedRDBMSSite((RDBMSSite)ModelChooserDialog.this.cbSourceDBType.getSelectedItem());
                            relationalDesign2.setSelectedRDBMSSite((RDBMSSite)ModelChooserDialog.this.cbSourceDBType.getSelectedItem());
                        } else {
                            relationalDesign.setSelectedRDBMSSite(relationalDesign2.getSelectedRDBMSSite());
                        }
                        boolean bl = ModelChooserDialog.this.disableDDLPreview();
                        progressDialog.setProgress(50);
                        if (isSelectedDatabase) {
                            object = relationalDesign.getStorageDesign(relationalDesign.getSelectedRDBMSSite());
                            if (relationalDesign.getDesign().isOldRepositoryType()) {
                                ((StorageDesign)object).load();
                            } else {
                                ModelChooserDialog.this.getApplicationView().getXMLTransformationManager().openPhysicalModel((StorageDesign)object);
                            }
                            progressDialog.setProgress(60);
                            ((StorageDesign)object).setOpen(true);
                            ModelChooserDialog.this.getController().removeTempDesign();
                            progressDialog.setProgress(70);
                            StorageDesign storageDesign = relationalDesign2.getStorageDesign(relationalDesign2.getSelectedRDBMSSite());
                            storageDesign.openStorageDesign();
                            progressDialog.setProgress(80);
                        } else {
                            ModelChooserDialog.this.getController().removeTempDesign();
                            progressDialog.setProgress(80);
                        }
                        try {
                            progressDialog.setProgress(90);
                            object = new CompareModelsDialog(ModelChooserDialog.this.getApplicationView(), relationalDesign, relationalDesign2, bl);
                            progressDialog.setProgress(100);
                            progressDialog.close();
                            ModelChooserDialog.this.view.setMerging(false);
                            ((CompareModelsDialog)object).show();
                        }
                        catch (Exception exception) {
                            progressDialog.close();
                            LOGGER.error("Error in Compare status", exception);
                        }
                        finally {
                            ModelChooserDialog.this.view.setMerging(false);
                            FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
                        }
                    }
                    finally {
                        ApplicationView.loading = false;
                        ApplicationView.canLogging = true;
                        ModelChooserDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            thread.start();
        }
    }
}

