/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.browser;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignSet;
import oracle.dbtools.crest.model.design.GlobalKeyObjectSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;

public class NavigationTreeDesign
implements ModelObjectSetListener,
TreeModel,
SetListener,
ObjectListener,
ContainerObjectListener,
StorageObjectListener,
RelationalObjectProxySetListener,
DesignListener {
    private Set listeners = new HashSet();
    private ApplicationView appView;
    private JTree tree;

    public NavigationTreeDesign(ApplicationView applicationView) {
        this.appView = applicationView;
        this.traverseTreeAndRegisterListener(applicationView.getDesigns());
    }

    protected void traverseTreeAndRegisterListener(ModelObject modelObject) {
        int n = modelObject.getNumberOfChildren();
        if (modelObject instanceof DesignSet) {
            ((DesignSet)modelObject).addSetListener(this);
        }
        if (modelObject instanceof DesignObjectSet) {
            ((DesignObjectSet)modelObject).addSetListener(this);
        }
        if (modelObject instanceof DesignPart) {
            ((DesignPart)modelObject).addDesignListener(this);
        }
        if (modelObject instanceof ModelObjectSet || modelObject instanceof DesignObjectCollection) {
            ((ModelObjectSet)modelObject).addSetListener(this);
        }
        if (modelObject instanceof DesignObject) {
            ((DesignObject)modelObject).addObjectListener(this);
        }
        if (modelObject instanceof ContainerObject) {
            ((ContainerObject)modelObject).addContainerListener(this);
        }
        if (modelObject instanceof StorageObject) {
            ((StorageObject)modelObject).addObjectListener(this);
        }
        if (modelObject instanceof RelationalObjectProxy) {
            ((RelationalObjectProxy)modelObject).addObjectListener(this);
        }
        if (modelObject instanceof RelationalObjectProxySet) {
            ((RelationalObjectProxySet)modelObject).addSetListener(this);
        }
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject2 = modelObject.getChild(i);
            if (modelObject2 == null) continue;
            this.traverseTreeAndRegisterListener(modelObject2);
        }
    }

    protected ModelObject toModelObject(Object object) {
        return (ModelObject)object;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object instanceof ModelObject) {
            return this.toModelObject(object).isLeaf();
        }
        return true;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public Object getRoot() {
        return this.appView.getDesigns();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.toModelObject(object).getChildPlain(n);
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof ModelObject) {
            return this.toModelObject(object).getNumberOfChildren();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object2 instanceof ModelObject) {
            return this.toModelObject(object).getIndexForChild(this.toModelObject(object2));
        }
        return this.toModelObject(object).getIndexForChild(object2);
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (SetEvent.SORT_COLLECTION.equals(setEvent)) {
            return;
        }
        if (!this.isLoading()) {
            if (setEvent.getAffected() != null) {
                if (SetEvent.OBJECT_ADDED.equals(setEvent)) {
                    if (setEvent.getAffected() instanceof DesignPartViewPlaceHolder) {
                        this.traverseTreeAndRegisterListener(setEvent.getAffected());
                    } else {
                        setEvent.getAffected().addObjectListener(this);
                    }
                    if (setEvent.getAffected() instanceof ContainerObject) {
                        this.traverseTreeAndRegisterListener(setEvent.getAffected());
                    }
                    if (setEvent.getAffected() instanceof Dimension || setEvent.getAffected() instanceof Process || setEvent.getAffected() instanceof TransformationPackage) {
                        this.traverseTreeAndRegisterListener(setEvent.getAffected());
                    }
                } else if (SetEvent.OBJECT_REMOVED.equals(setEvent)) {
                    setEvent.getAffected().removeObjectListener(this);
                    if (setEvent.getAffected() instanceof ContainerObject) {
                        ((ContainerObject)setEvent.getAffected()).removeContainerListener(this);
                    }
                } else if (SetEvent.STRUCTURE_CHANGED.equals(setEvent)) {
                    // empty if block
                }
            }
            this.fireStructureChanged(designObjectSet);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSet instanceof DesignSet || modelObjectSet instanceof DesignObjectCollection || modelObjectSet instanceof GlobalKeyObjectSet || modelObjectSet instanceof RelationalDesignSet || modelObjectSet instanceof MultidimensionalDesignSet) {
            if (modelObjectSetEvent.isType(1)) {
                this.traverseTreeAndRegisterListener(modelObjectSetEvent.getAffected());
                if (modelObjectSetEvent.childIndex > -1) {
                    this.fireStructureChanged(false, modelObjectSet, modelObjectSetEvent.getAffected(), modelObjectSetEvent.childIndex);
                } else {
                    this.fireStructureChanged(modelObjectSet);
                }
            } else if (modelObjectSetEvent.isType(0)) {
                if (modelObjectSetEvent.getAffected() instanceof DesignObject) {
                    ((DesignObject)modelObjectSetEvent.getAffected()).removeObjectListener(this);
                }
                if (modelObjectSetEvent.childIndex > -1) {
                    this.fireStructureChanged(true, modelObjectSet, modelObjectSetEvent.getAffected(), modelObjectSetEvent.childIndex);
                } else {
                    this.fireStructureChanged(modelObjectSet);
                }
            }
        } else if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof RelationalObjectProxy) {
                this.traverseTreeAndRegisterListener(modelObjectSetEvent.getAffected());
            } else if (modelObjectSetEvent.getAffected() instanceof StorageObject) {
                this.traverseTreeAndRegisterListener(modelObjectSetEvent.getAffected());
            }
            if (modelObjectSetEvent.getAffected() instanceof StorageDesign) {
                this.traverseTreeAndRegisterListener(modelObjectSetEvent.getAffected());
            }
            if (modelObjectSetEvent.getAffected() instanceof DataFlowDesign) {
                this.traverseTreeAndRegisterListener(modelObjectSetEvent.getAffected());
            }
            if (modelObjectSetEvent.childIndex > -1) {
                this.fireStructureChanged(false, modelObjectSet, modelObjectSetEvent.getAffected(), modelObjectSetEvent.childIndex);
            } else {
                this.fireStructureChanged(modelObjectSet);
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof StorageObject) {
                ((StorageObject)modelObjectSetEvent.getAffected()).removeObjectListener(this);
            }
            if (modelObjectSetEvent.childIndex > -1) {
                this.fireStructureChanged(true, modelObjectSet, modelObjectSetEvent.getAffected(), modelObjectSetEvent.childIndex);
            } else {
                this.fireStructureChanged(modelObjectSet);
            }
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof RelationalObjectProxy) {
                this.traverseTreeAndRegisterListener(modelObjectSetEvent.getAffected());
            } else if (modelObjectSetEvent.getAffected() instanceof StorageObject) {
                this.traverseTreeAndRegisterListener(modelObjectSetEvent.getAffected());
            }
            if (modelObjectSetEvent.childIndex > -1) {
                this.fireStructureChanged(false, relationalObjectProxySet, modelObjectSetEvent.getAffected(), modelObjectSetEvent.childIndex);
            } else {
                this.fireStructureChanged(relationalObjectProxySet);
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof StorageObject) {
                ((StorageObject)modelObjectSetEvent.getAffected()).removeObjectListener(this);
            }
            if (modelObjectSetEvent.getAffected() instanceof RelationalObjectProxy) {
                ((RelationalObjectProxy)modelObjectSetEvent.getAffected()).removeObjectListener(this);
            }
            if (modelObjectSetEvent.childIndex > -1) {
                this.fireStructureChanged(true, relationalObjectProxySet, modelObjectSetEvent.getAffected(), modelObjectSetEvent.childIndex);
            } else {
                this.fireStructureChanged(relationalObjectProxySet);
            }
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (!this.isLoading()) {
            Object object;
            if (designObject instanceof Process && objectChangeEvent.isType(ObjectChangeEvent.PROCESS_DECOMPOSED)) {
                this.traverseTreeAndRegisterListener(designObject);
            }
            if (designObject instanceof TransformationPackage && objectChangeEvent.isType(ObjectChangeEvent.TRANSFORMATIONTASK_ADDED)) {
                this.traverseTreeAndRegisterListener(((TransformationPackage)designObject).getLastTaskAdded());
            }
            this.fireStructureChanged(designObject);
            if (designObject instanceof Table) {
                Table table = (Table)designObject;
                RelationalDesign relationalDesign = (RelationalDesign)table.getDesignPart();
                this.fireStructureChanged(relationalDesign.getFKIndexAssociationSet());
            } else if (designObject instanceof Entity) {
                Entity entity = (Entity)designObject;
                LogicalDesign logicalDesign = (LogicalDesign)entity.getDesignPart();
                this.fireStructureChanged(logicalDesign.getGlobalCandidateKeySet());
            } else if (!(designObject instanceof Relation) && !(designObject instanceof RelationalDesign.ColumnPlaceHolder) && designObject instanceof DesignObjectPlaceHolder && objectChangeEvent.isType(ObjectChangeEvent.DESIGN_OBJECT_NAME_CHANGED) && (object = ((DesignObjectPlaceHolder)designObject).getParent()) != null && object instanceof DesignObjectCollection) {
                this.fireStructureChanged((DesignObjectCollection)object);
            }
            if (objectChangeEvent.isType(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED) || objectChangeEvent.isType(ObjectChangeEvent.ENTITY_IN_RELATION_REMOVED)) {
                this.fireStructureChanged(designObject);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            ModelObject modelObject = storageObject.getObjectSet();
            if (storageObject instanceof RelationalObjectProxy) {
                modelObject = ((RelationalObjectProxy)storageObject).getProxySet();
            }
            if (modelObject != null) {
                this.fireStructureChanged(modelObject);
            }
        }
        this.fireNodeChanged(storageObject);
    }

    @Override
    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        if (!this.isLoading()) {
            if (containerObjectEvent.isType(0)) {
                containerObjectEvent.getElement().addObjectListener(this);
            } else if (containerObjectEvent.isType(1)) {
                containerObjectEvent.getElement().removeObjectListener(this);
            }
            this.fireStructureChanged(containerObject);
        }
    }

    protected void fireStructureChanged(ModelObject modelObject) {
        if (this.canUpdateTree()) {
            boolean bl = false;
            if (this.tree != null) {
                bl = this.tree.isEditable();
                this.tree.setEditable(false);
            }
            if (modelObject.hasAlternatePaths()) {
                Object[][] objectArray = modelObject.getAlternatePaths();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.fireStructureChanged(modelObject, objectArray[i]);
                }
            } else if (modelObject instanceof DesignSet || modelObject.getParent() != null) {
                this.fireStructureChanged(modelObject, modelObject.getPath());
            }
            if (this.tree != null) {
                this.tree.setEditable(bl);
            }
        }
    }

    protected void fireStructureChanged(boolean bl, ModelObject modelObject, ModelObject modelObject2, int n) {
        if (this.canUpdateTree()) {
            boolean bl2 = false;
            if (this.tree != null) {
                bl2 = this.tree.isEditable();
                this.tree.setEditable(false);
            }
            Object[] objectArray = new Object[]{modelObject2};
            int[] nArray = new int[]{n};
            if (modelObject.hasAlternatePaths()) {
                Object[][] objectArray2 = modelObject.getAlternatePaths();
                for (int i = 0; i < objectArray2.length; ++i) {
                    this.fireStructureChanged(bl, objectArray2[i], nArray, objectArray);
                }
            } else {
                this.fireStructureChanged(bl, modelObject.getPath(), nArray, objectArray);
            }
            if (this.tree != null) {
                this.tree.setEditable(bl2);
            }
        }
    }

    public void updateSubtree(ModelObject modelObject) {
        this.traverseTreeAndRegisterListener(modelObject);
        this.fireStructureChanged(modelObject);
    }

    public void clear() {
        this.fireStructureChanged(this.appView.getDesigns(), this.appView.getDesigns().getPath());
        this.traverseTreeAndRegisterListener(this.appView.getDesigns());
    }

    protected void fireStructureChanged(ModelObject modelObject, Object[] objectArray) {
        if (this.canUpdateTree()) {
            for (TreeModelListener treeModelListener : this.listeners) {
                treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, objectArray));
            }
        }
    }

    protected void fireStructureChanged(boolean bl, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (this.canUpdateTree()) {
            for (TreeModelListener treeModelListener : this.listeners) {
                if (bl) {
                    treeModelListener.treeNodesRemoved(new TreeModelEvent((Object)this, objectArray, nArray, objectArray2));
                    continue;
                }
                treeModelListener.treeNodesInserted(new TreeModelEvent((Object)this, objectArray, nArray, objectArray2));
            }
        }
    }

    protected void fireNodeChanged(ModelObject modelObject) {
        if (this.canUpdateTree()) {
            for (TreeModelListener treeModelListener : this.listeners) {
                treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, modelObject.getPath()));
            }
        }
    }

    public void updateDesignName(TreePath treePath) {
        if (this.canUpdateTree()) {
            for (TreeModelListener treeModelListener : this.listeners) {
                treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, treePath));
            }
        }
    }

    public boolean isLoading() {
        return ApplicationView.loading;
    }

    public boolean isImporting() {
        return ApplicationView.importing;
    }

    public void setTree(JTree jTree) {
        this.tree = jTree;
    }

    private boolean canUpdateTree() {
        Design design = this.appView.getCurrentDesign();
        return !design.isClosing() && (!this.isLoading() || design.isMerging()) && !design.isDisableTreeUpdate();
    }

    @Override
    public void designChanged(DesignEvent designEvent) {
        if (designEvent.isType(DesignEvent.DESIGNPART_NAME_CHANGED) && designEvent.getDesignPart() != null) {
            this.fireNodeChanged(designEvent.getDesignPart());
        }
    }
}

