/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.types;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.admin.types.Row;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class TypesAdmin
extends CustomDialog {
    private static final Logger LOGGER = new Logger(TypesAdmin.class);
    private static final String EMPTY_VALUE = "";
    private static final int DEFAULT_COMBO_MAX_ROW_COUNT = 20;
    private String currentRDBMS;
    private String[] typesRDBMSSites;
    private boolean isSaved = true;
    private boolean applyMode = false;
    private Design design;
    private String fileName;
    private JDialog dialog;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnModify;
    private JButton btnApply;
    private JButton btnSave;
    private JButton btnClose;
    private JPanel general;
    private JPanel addPanel;
    private JPanel listPanel;
    private JPanel propPanel;
    private JPanel buttonPanel;
    private JTabbedPane tabbed;
    private JPanel nativePanel;
    private JPanel nativeDBTPanel;
    private DefaultListModel allTypesModel;
    private JList allTypesList;
    private JList rdbmsJlist;
    private JList rdbmsDBTJlist;
    private JPanel typesButtonsPanel;
    private JPanel propSubPanelCurrentMapping;
    private JPanel pnDBButtons;
    private JComboBox cbNativeDataType;
    private JTextField tfName;
    private JPanel propSubPanelName;
    private JPanel propSubPanelNameLeft;
    private JPanel propSubPanelNameRight;
    private JPanel propSubPanelMappings;
    private Hashtable elementProps = new Hashtable();
    private Object[] dbtypes;
    private Map rdbmsMap = new TreeMap();
    private Map rdbmsNTMap = new TreeMap();
    private List currentMappings = new ArrayList();
    private List currentDBTList = new ArrayList();
    private JComboBox cbLogTypes;
    private JComboBox cbNativeTypeKinds;
    private JComboBox cbLogTypesInNT;
    private LogicalDatatype unknown;
    private boolean isDBRepos = false;
    private JButton bnCheckOut;
    private JButton bnCheckIn;
    private List lsDeleted = new ArrayList();
    private List lsAdded = new ArrayList();
    JTable nativeLog;
    JTable nativeTypes;

    public TypesAdmin(ApplicationView applicationView) {
        super(applicationView);
        this.design = applicationView.getCurrentDesign();
        this.dbtypes = this.design.getDefaultRDBMSTypeSet().toArray();
        this.typesRDBMSSites = new String[this.dbtypes.length];
        this.setTypesRDBMSSites(this.dbtypes);
        this.design.getSelectedRDBMSType();
        this.unknown = (LogicalDatatype)this.design.getLogicalDatatypeSet().getByName("UNKNOWN");
        this.buildNativeToLogicalMappings();
        AbstractRepositoryManager abstractRepositoryManager = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        this.isDBRepos = abstractRepositoryManager.isConnected() || this.getDesign().isLoadFromDB();
    }

    @Override
    protected String getHelpIndex() {
        return "TYPE_ADMINISTRATION_DIALOG";
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("TypesAdmin.TypesAdministration"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.general = new JPanel();
            this.tabbed = new JTabbedPane();
            this.general.setLayout(new BorderLayout());
            this.general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.addPanel = new JPanel(new BorderLayout());
            this.addPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.LogicalTypes")));
            this.addPanel.setPreferredSize(new Dimension(350, 400));
            this.propPanel = new JPanel(new BorderLayout());
            this.propPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.LogicalTypeMappings")));
            this.initAddPanel();
            this.buttonPanel = this.getButtonPanel();
            this.initPropPanel();
            this.general.add((Component)this.addPanel, "West");
            this.general.add((Component)this.propPanel, "Center");
            this.tabbed.add(Messages.getString("TypesAdmin.LogicalTypesToNativeTypes"), this.general);
            this.initNativePanel();
            this.initNativeDBtypePanel();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.tabbed, "Center");
            jPanel.add((Component)this.buttonPanel, "South");
            this.dialog.getContentPane().add(jPanel);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            if (this.isDBRepos) {
                boolean bl = this.canDoCheckIn();
                this.enableButtons(bl);
                this.nativeLog.setEnabled(bl);
            } else {
                this.enableButtons(true);
            }
            this.dialog.setResizable(true);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                    int n = jTabbedPane.getSelectedIndex();
                    if (n == 0) {
                        TypesAdmin.this.updateUD_NativeInAll();
                    }
                }
            };
            this.tabbed.addChangeListener(changeListener);
        }
        this.refreshTypesList();
        this.updateLogtypesCombo();
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private void initAddPanel() {
        this.initAddSubPanels();
        this.initTypesButtons();
        this.initTypesPanel();
    }

    private void initAddSubPanels() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        if (this.isDBRepos) {
            this.pnDBButtons = new JPanel();
            this.initDBButtons();
            jPanel.add(this.pnDBButtons);
            this.bnCheckIn.setEnabled(this.canDoCheckIn());
            this.bnCheckOut.setEnabled(this.canDoCheckOut());
        }
        this.typesButtonsPanel = new JPanel();
        this.typesButtonsPanel.setAlignmentX(0.5f);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.setAlignmentX(0.5f);
        jPanel.add(this.typesButtonsPanel);
        this.addPanel.add((Component)jPanel, "South");
        this.addPanel.add(this.listPanel);
    }

    private void initNativePanel() {
        this.nativePanel = new JPanel(new BorderLayout());
        this.nativePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rdbmsJlist = new JList(new RDBMSListModel());
        this.rdbmsJlist.setSelectionMode(0);
        this.rdbmsJlist.addListSelectionListener(new RDBMSSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.rdbmsJlist);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setAlignmentX(0.5f);
        jPanel.setPreferredSize(new Dimension(230, 400));
        jPanel.add(jScrollPane);
        this.nativePanel.add((Component)jPanel, "West");
        this.cbLogTypes = new JComboBox();
        this.nativeLog = new JTable(new NativeTableModel());
        this.nativeLog.setRowHeight(this.nativeLog.getRowHeight() + 3);
        TableColumn tableColumn = this.nativeLog.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(this.cbLogTypes));
        jScrollPane = new JScrollPane(this.nativeLog);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        this.nativePanel.add((Component)jPanel2, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.RDBMSTypes")));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.Mappings")));
        this.tabbed.add(Messages.getString("TypesAdmin.NativeTypesToLogicalTypes"), this.nativePanel);
    }

    private void initNativeDBtypePanel() {
        this.nativeDBTPanel = new JPanel(new BorderLayout());
        this.nativeDBTPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rdbmsDBTJlist = new JList(new RDBMSListModel());
        this.rdbmsDBTJlist.setSelectionMode(0);
        this.rdbmsDBTJlist.addListSelectionListener(new NTRDBMSSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.rdbmsDBTJlist);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setAlignmentX(0.5f);
        jPanel.setPreferredSize(new Dimension(230, 400));
        jPanel.add(jScrollPane);
        this.nativeDBTPanel.add((Component)jPanel, "West");
        this.cbNativeTypeKinds = new JComboBox<String>(new DefaultComboBoxModel<String>(NativeDBType.getNT_Types()));
        ArrayList arrayList = new ArrayList();
        arrayList.add(null);
        Enumeration enumeration = this.allTypesModel.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        this.cbLogTypesInNT = new JComboBox<Object>(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.nativeTypes = new JTable(new NativeTypesModel());
        this.nativeTypes.setRowHeight(this.nativeTypes.getRowHeight() + 3);
        this.rdbmsDBTJlist.setSelectionMode(0);
        TableColumn tableColumn = this.nativeTypes.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(new DefaultCellEditor(this.cbNativeTypeKinds));
        TableColumn tableColumn2 = this.nativeTypes.getColumnModel().getColumn(4);
        tableColumn2.setCellEditor(new DefaultCellEditor(this.cbLogTypesInNT));
        jScrollPane = new JScrollPane(this.nativeTypes);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(AbstractPropertiesDialog.BTN_ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n = TypesAdmin.this.nativeTypes.getEditingRow();
                int n2 = TypesAdmin.this.nativeTypes.getEditingColumn();
                if (n > -1 && n2 > -1 && (object = TypesAdmin.this.nativeTypes.getCellEditor(n, n2)) != null) {
                    object.stopCellEditing();
                }
                object = new NativeDBType();
                ((NativeDBType)object).setName("native_type");
                TypesAdmin.this.currentDBTList.add(object);
                TypesAdmin.this.nativeTypes.updateUI();
                TypesAdmin.this.nativeTypes.changeSelection(TypesAdmin.this.currentDBTList.size() - 1, 1, false, false);
                TypesAdmin.this.isSaved = false;
                TypesAdmin.this.btnSave.setEnabled(true);
            }
        });
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        jButton2.setToolTipText(AbstractPropertiesDialog.BTN_REMOVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TypesAdmin.this.nativeTypes.getSelectedRow();
                if (n > -1 && n < TypesAdmin.this.currentDBTList.size()) {
                    TypesAdmin.this.currentDBTList.remove(n);
                    TypesAdmin.this.nativeTypes.updateUI();
                    TypesAdmin.this.isSaved = false;
                    TypesAdmin.this.btnSave.setEnabled(true);
                }
            }
        });
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jPanel2.add((Component)jToolBar, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        this.nativeDBTPanel.add((Component)jPanel2, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.RDBMSTypes")));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.NativeTypes")));
        this.tabbed.add(Messages.getString("TypesAdmin.UserDefinedNativeTypes"), this.nativeDBTPanel);
        this.nativeTypes.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void updateLogtypesCombo() {
        int n = this.nativeLog.getEditingRow();
        int n2 = this.nativeLog.getEditingColumn();
        if (n > -1 && n2 > -1) {
            this.nativeLog.getCellEditor(n, n2).stopCellEditing();
        }
        ArrayList arrayList = new ArrayList();
        this.design.getLogicalDatatypeSet().addAllElementsTo(arrayList);
        Collections.sort(arrayList, ModelObjectSet.LONG_NAME_COMPARATOR);
        arrayList.add(0, null);
        this.cbLogTypes.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (this.cbLogTypesInNT != null) {
            arrayList.clear();
            Enumeration enumeration = this.allTypesModel.elements();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            this.cbLogTypesInNT.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        }
    }

    private void enableButtons(boolean bl) {
        this.btnAdd.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
        this.btnModify.setEnabled(bl);
    }

    private void initPropPanel() {
        this.initPropSubPanels();
        this.editableAll(false);
    }

    private void initPropSubPanels() {
        this.propSubPanelName = new JPanel();
        this.propSubPanelName.setLayout(new BorderLayout());
        this.propSubPanelName.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propPanel.add((Component)this.propSubPanelName, "North");
        this.propSubPanelNameLeft = new JPanel();
        this.propSubPanelNameLeft.setLayout(new GridLayout(2, 1));
        this.propSubPanelNameLeft.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propSubPanelName.add((Component)this.propSubPanelNameLeft, "West");
        this.propSubPanelNameRight = new JPanel();
        this.propSubPanelNameRight.setLayout(new GridLayout(2, 1));
        this.propSubPanelNameRight.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propSubPanelName.add((Component)this.propSubPanelNameRight, "Center");
        this.initSubPanelName();
        this.propSubPanelMappings = new JPanel();
        this.propSubPanelMappings.setLayout(new GridLayout(0, 1));
        this.propPanel.add(this.propSubPanelMappings);
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            this.propSubPanelCurrentMapping = new JPanel();
            this.propSubPanelCurrentMapping.setLayout(new FlowLayout());
            this.propSubPanelCurrentMapping.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.initSubPanelCurrentMapping(this.typesRDBMSSites[i], (RDBMSType)this.dbtypes[i]);
            this.propSubPanelMappings.add(this.propSubPanelCurrentMapping);
        }
    }

    private void initSubPanelName() {
        JLabel jLabel = new JLabel(Messages.getString("TypesAdmin.Name"));
        this.propSubPanelNameLeft.add(jLabel);
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(180, 20));
        this.propSubPanelNameLeft.add(this.tfName);
    }

    private void initSubPanelCurrentMapping(String string, RDBMSType rDBMSType) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(130, 20));
        this.propSubPanelCurrentMapping.add(jLabel);
        this.cbNativeDataType = new JComboBox<String>(this.getNativeDataTypes(rDBMSType));
        this.cbNativeDataType.addActionListener(new AddTypesActionListener(){});
        this.cbNativeDataType.setPreferredSize(new Dimension(160, 20));
        this.cbNativeDataType.setMaximumRowCount(20);
        this.setBG(this.cbNativeDataType);
        JCheckBox jCheckBox = new JCheckBox(Messages.getString("TypesAdmin.Precision"), false);
        jCheckBox.setHorizontalAlignment(4);
        JIntegerField jIntegerField = new JIntegerField();
        jIntegerField.setPreferredSize(new Dimension(40, 20));
        JCheckBox jCheckBox2 = new JCheckBox(Messages.getString("TypesAdmin.Size"), false);
        jCheckBox2.setHorizontalAlignment(4);
        JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(40, 20));
        JCheckBox jCheckBox3 = new JCheckBox(Messages.getString("TypesAdmin.Scale"), false);
        jCheckBox3.setHorizontalAlignment(4);
        JIntegerField jIntegerField2 = new JIntegerField();
        jIntegerField2.setPreferredSize(new Dimension(40, 20));
        Row row = new Row(string, this.cbNativeDataType, jCheckBox2, jCheckBox3, jCheckBox, jIntegerField, jTextField, jIntegerField2);
        this.propSubPanelCurrentMapping.add(row.getType());
        this.propSubPanelCurrentMapping.add(row.getPrecision());
        this.propSubPanelCurrentMapping.add(row.getTfPrecision());
        this.propSubPanelCurrentMapping.add(row.getScale());
        this.propSubPanelCurrentMapping.add(row.getTfScale());
        this.propSubPanelCurrentMapping.add(row.getSize());
        this.propSubPanelCurrentMapping.add(row.getTfSize());
        this.elementProps.put(string, row);
    }

    private String[] getNativeDataTypes(RDBMSType rDBMSType) {
        Object[] objectArray;
        List<String> list = Arrays.asList(StandardDatatypeNames.getPredefinedNativeDatatypes(rDBMSType));
        ArrayList<String> arrayList = new ArrayList<String>(list);
        for (RDBMSType rDBMSType2 = rDBMSType; rDBMSType2 != null; rDBMSType2 = rDBMSType2.getParentType()) {
            objectArray = (Object[])this.rdbmsNTMap.get(rDBMSType2);
            for (NativeDBType nativeDBType : objectArray) {
                String string = nativeDBType.getName();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        objectArray = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected boolean setProperties() {
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.allTypesList.getSelectedValue();
        if (logicalDatatype == null) {
            String string = this.design.getAppView().getIDGenerator().createNewID();
            while (this.design.getLogicalDatatypeSet().containsId(string)) {
                string = this.design.getAppView().getIDGenerator().createNewID();
            }
            logicalDatatype = this.design.getLogicalDatatypeSet().createLogicalDatatype(string);
        }
        logicalDatatype.setName(this.tfName.getText());
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            if (this.canApply(this.typesRDBMSSites[i])) {
                String string = this.encodeString(this.typesRDBMSSites[i]);
                logicalDatatype.put(this.typesRDBMSSites[i], string);
                TreeMap treeMap = this.getDefaultValues(this.typesRDBMSSites[i]);
                logicalDatatype.addDefaults(this.typesRDBMSSites[i], treeMap);
                this.refreshTypesList();
                this.editableAll(false);
                if (!this.isDBRepos) continue;
                this.getDesign().getLogicalDatatypeSet().setDirty(true);
                continue;
            }
            this.editableAll(true);
            if (this.isDBRepos) {
                this.getDesign().getLogicalDatatypeSet().setDirty(false);
            }
            return false;
        }
        return true;
    }

    private String encodeString(String string) {
        String string2 = null;
        Row row = (Row)this.elementProps.get(string);
        string2 = (String)row.getType().getSelectedItem();
        if (row.getSize().isSelected()) {
            string2 = string2.concat(", ");
            string2 = string2.concat("size");
        }
        if (row.getPrecision().isSelected() || row.getScale().isSelected()) {
            string2 = string2.concat(", ");
            string2 = string2.concat("precision");
        }
        if (row.getScale().isSelected()) {
            string2 = string2.concat(", ");
            string2 = string2.concat("scale");
        }
        return string2;
    }

    private void initTypesPanel() {
        this.initTypes();
    }

    private TreeMap getDefaultValues(String string) {
        String string2;
        String string3;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Row row = (Row)this.elementProps.get(string);
        String string4 = row.getTfPrecision().getText().trim();
        if (string4.length() > 0) {
            treeMap.put("precision_default_value", row.getTfPrecision().getText().trim());
        }
        if ((string3 = row.getTfSize().getText().trim()).length() > 0) {
            treeMap.put("size_default_value", row.getTfSize().getText().trim());
        }
        if ((string2 = row.getTfScale().getText().trim()).length() > 0) {
            treeMap.put("scale_default_value", row.getTfScale().getText().trim());
        }
        return treeMap;
    }

    private void initTypes() {
        this.lsDeleted.clear();
        this.lsAdded.clear();
        this.allTypesModel = new DefaultListModel();
        this.allTypesList = new JList(this.allTypesModel);
        this.allTypesList.setSelectionMode(0);
        this.allTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LogicalDatatype logicalDatatype = (LogicalDatatype)TypesAdmin.this.allTypesList.getSelectedValue();
                if (logicalDatatype != null) {
                    TypesAdmin.this.clear();
                    TypesAdmin.this.applyMode = false;
                    TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Modify"));
                    TypesAdmin.this.btnModify.setMnemonic(77);
                    if (logicalDatatype == TypesAdmin.this.unknown) {
                        TypesAdmin.this.btnRemove.setEnabled(false);
                        TypesAdmin.this.btnModify.setEnabled(false);
                    } else if (TypesAdmin.this.isDBRepos) {
                        TypesAdmin.this.btnRemove.setEnabled(TypesAdmin.this.canDoCheckIn());
                        TypesAdmin.this.btnModify.setEnabled(TypesAdmin.this.btnRemove.isEnabled());
                    } else {
                        TypesAdmin.this.btnRemove.setEnabled(true);
                        TypesAdmin.this.btnModify.setEnabled(true);
                    }
                    TypesAdmin.this.tfName.setText(logicalDatatype.getName());
                    for (int i = 0; i < TypesAdmin.this.typesRDBMSSites.length; ++i) {
                        String string = TypesAdmin.this.typesRDBMSSites[i];
                        Row row = (Row)TypesAdmin.this.elementProps.get(TypesAdmin.this.typesRDBMSSites[i]);
                        Map map = logicalDatatype.getToPhysical();
                        MDDataType mDDataType = logicalDatatype.createDataType(string, map);
                        try {
                            TypesAdmin.this.setNativeType(string, (RDBMSType)TypesAdmin.this.dbtypes[i], mDDataType);
                        }
                        catch (RuntimeException runtimeException) {
                            LOGGER.error("Error mapping native types: " + logicalDatatype.getName() + " rdbms: " + string, runtimeException);
                        }
                        String string2 = (String)map.get(TypesAdmin.this.typesRDBMSSites[i]);
                        String[] stringArray = MDDataTypeFactory.tokenize(string2);
                        TreeMap treeMap = (TreeMap)logicalDatatype.getDefaultValues();
                        TreeMap treeMap2 = (TreeMap)treeMap.get(TypesAdmin.this.typesRDBMSSites[i]);
                        if (treeMap2 != null) {
                            TypesAdmin.this.setTfPrecision(row, (String)treeMap2.get("precision_default_value"));
                            TypesAdmin.this.setTfSize(row, (String)treeMap2.get("size_default_value"));
                            TypesAdmin.this.setTfScale(row, (String)treeMap2.get("scale_default_value"));
                        }
                        if (stringArray.length == 1) {
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setScale(row, false);
                            TypesAdmin.this.setPrecision(row, false);
                            continue;
                        }
                        if (stringArray.length == 2) {
                            if (stringArray[1].equalsIgnoreCase("size")) {
                                TypesAdmin.this.setSize(row, true);
                                TypesAdmin.this.setPrecision(row, false);
                                TypesAdmin.this.setScale(row, false);
                                continue;
                            }
                            if (stringArray[1].equalsIgnoreCase("scale")) {
                                TypesAdmin.this.setSize(row, false);
                                TypesAdmin.this.setPrecision(row, false);
                                TypesAdmin.this.setScale(row, true);
                                continue;
                            }
                            if (!stringArray[1].equalsIgnoreCase("precision")) continue;
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setPrecision(row, true);
                            TypesAdmin.this.setScale(row, false);
                            continue;
                        }
                        if (stringArray.length != 3) continue;
                        if (stringArray[1].equalsIgnoreCase("size")) {
                            TypesAdmin.this.setSize(row, true);
                            TypesAdmin.this.setPrecision(row, false);
                            TypesAdmin.this.setScale(row, false);
                        } else if (stringArray[1].equalsIgnoreCase("scale")) {
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setPrecision(row, false);
                            TypesAdmin.this.setScale(row, true);
                        } else if (stringArray[1].equalsIgnoreCase("precision")) {
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setPrecision(row, true);
                            TypesAdmin.this.setScale(row, false);
                        }
                        if (stringArray[2].equalsIgnoreCase("size")) {
                            TypesAdmin.this.setSize(row, true);
                            continue;
                        }
                        if (stringArray[2].equalsIgnoreCase("scale")) {
                            TypesAdmin.this.setScale(row, true);
                            continue;
                        }
                        if (!stringArray[2].equalsIgnoreCase("precision")) continue;
                        TypesAdmin.this.setPrecision(row, true);
                    }
                    TypesAdmin.this.editableAll(false);
                    if (logicalDatatype == TypesAdmin.this.unknown) {
                        TypesAdmin.this.tfName.setEnabled(false);
                        TypesAdmin.this.tfName.setEditable(false);
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.allTypesList);
        this.listPanel.add(jScrollPane);
    }

    protected void setScale(Row row, boolean bl) {
        row.getScale().setSelected(bl);
    }

    protected void setTfScale(Row row, String string) {
        row.getTfScale().setText(string);
    }

    protected void setPrecision(Row row, boolean bl) {
        row.getPrecision().setSelected(bl);
    }

    protected void setTfPrecision(Row row, String string) {
        row.getTfPrecision().setText(string);
    }

    protected void setNativeType(String string, RDBMSType rDBMSType, MDDataType mDDataType) throws RuntimeException {
        Row row = (Row)this.elementProps.get(string);
        for (int i = 0; i < this.getNativeDataTypes(rDBMSType).length; ++i) {
            try {
                if (!((String)row.getType().getItemAt(i)).equalsIgnoreCase(mDDataType.getName())) continue;
                row.getType().setSelectedIndex(i);
                continue;
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error mapping native types!", runtimeException);
                throw new RuntimeException(runtimeException);
            }
        }
    }

    protected void setSize(Row row, boolean bl) {
        row.getSize().setSelected(bl);
    }

    protected void setTfSize(Row row, String string) {
        row.getTfSize().setText(string);
    }

    protected void initDBButtons() {
        this.bnCheckOut = new JButton(Messages.getString("TypesAdmin.CheckOut"));
        this.bnCheckOut.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCheckOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypesAdmin.this.enableButtons(true);
                TypesAdmin.this.bnCheckIn.setEnabled(true);
                TypesAdmin.this.bnCheckOut.setEnabled(false);
                TypesAdmin.this.nativeLog.setEnabled(true);
                TypesAdmin.this.checkOut();
            }
        });
        this.bnCheckIn = new JButton(Messages.getString("TypesAdmin.CheckIn"));
        this.bnCheckIn.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCheckIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypesAdmin.this.enableButtons(false);
                TypesAdmin.this.bnCheckIn.setEnabled(false);
                TypesAdmin.this.bnCheckOut.setEnabled(true);
                TypesAdmin.this.nativeLog.setEnabled(false);
                TypesAdmin.this.checkIn();
            }
        });
        this.pnDBButtons.add(this.bnCheckOut);
        this.pnDBButtons.add(this.bnCheckIn);
    }

    protected void initTypesButtons() {
        this.btnAdd = new JButton(Messages.getString("TypesAdmin.Add"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TypesAdmin.this.design != null) {
                    TypesAdmin.this.clear();
                    LogicalDatatype logicalDatatype = TypesAdmin.this.design.getLogicalDatatypeSet().createLogicalDatatype(null);
                    TypesAdmin.this.lsAdded.add(logicalDatatype);
                    for (int i = 0; i < TypesAdmin.this.typesRDBMSSites.length; ++i) {
                        logicalDatatype.put(TypesAdmin.this.typesRDBMSSites[i], "UNKNOWN");
                    }
                    if ("types".equalsIgnoreCase(TypesAdmin.this.fileName)) {
                        logicalDatatype.setOwnerDesignName("System");
                    } else {
                        logicalDatatype.setOwnerDesignName(TypesAdmin.this.getApplicationView().getDesignName());
                    }
                    TypesAdmin.this.refreshTypesList();
                    TypesAdmin.this.allTypesList.setSelectedValue(logicalDatatype, true);
                    TypesAdmin.this.editableAll(true);
                    TypesAdmin.this.applyMode = true;
                    TypesAdmin.this.isSaved = false;
                    TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Apply"));
                    TypesAdmin.this.btnModify.setMnemonic(89);
                    TypesAdmin.this.updateLogtypesCombo();
                    TypesAdmin.this.nativeLog.updateUI();
                }
            }
        });
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnAdd.setMnemonic(65);
        this.typesButtonsPanel.add(this.btnAdd);
        this.btnRemove = new JButton(Messages.getString("TypesAdmin.Remove"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogicalDatatype logicalDatatype = (LogicalDatatype)TypesAdmin.this.allTypesList.getSelectedValue();
                if (TypesAdmin.this.design != null && logicalDatatype != null) {
                    TypesAdmin.this.lsDeleted.add(logicalDatatype);
                    TypesAdmin.this.design.getLogicalDatatypeSet().remove(logicalDatatype);
                }
                TypesAdmin.this.refreshTypesList();
                TypesAdmin.this.clear();
                TypesAdmin.this.btnSave.setEnabled(true);
                TypesAdmin.this.isSaved = false;
                TypesAdmin.this.editableAll(false);
                TypesAdmin.this.applyMode = false;
                TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Modify"));
                TypesAdmin.this.btnModify.setMnemonic(77);
                TypesAdmin.this.updateLogtypesCombo();
                TypesAdmin.this.nullifyUsagerofType(logicalDatatype);
                TypesAdmin.this.nativeLog.updateUI();
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.typesButtonsPanel.add(this.btnRemove);
        this.btnModify = new JButton(Messages.getString("TypesAdmin.Modify"));
        this.btnModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TypesAdmin.this.applyMode) {
                    boolean bl = TypesAdmin.this.apply();
                    if (bl) {
                        TypesAdmin.this.applyMode = false;
                        TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Modify"));
                        TypesAdmin.this.btnModify.setMnemonic(77);
                    } else {
                        TypesAdmin.this.applyMode = true;
                        TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Apply"));
                        TypesAdmin.this.btnModify.setMnemonic(65);
                    }
                    TypesAdmin.this.updateLogtypesCombo();
                    TypesAdmin.this.nativeLog.updateUI();
                } else if (TypesAdmin.this.allTypesList.getSelectedIndex() > -1) {
                    TypesAdmin.this.editableAll(true);
                    LogicalDatatype logicalDatatype = (LogicalDatatype)TypesAdmin.this.allTypesList.getSelectedValue();
                    if (logicalDatatype == TypesAdmin.this.unknown) {
                        TypesAdmin.this.tfName.setEnabled(false);
                        TypesAdmin.this.tfName.setEditable(false);
                    }
                    TypesAdmin.this.applyMode = true;
                    TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Apply"));
                    TypesAdmin.this.btnModify.setMnemonic(89);
                }
            }
        });
        this.btnModify.setMnemonic(77);
        this.btnModify.setEnabled(false);
        this.btnModify.setPreferredSize(this.btnAdd.getPreferredSize());
        this.typesButtonsPanel.add(this.btnModify);
    }

    private void nullifyUsagerofType(LogicalDatatype logicalDatatype) {
        for (Holder holder : this.currentMappings) {
            if (holder.oldtype == logicalDatatype) {
                holder.oldtype = this.unknown;
            }
            if (holder.type != logicalDatatype) continue;
            holder.type = null;
        }
    }

    protected void refreshTypesList() {
        this.allTypesModel.clear();
        if (this.design != null) {
            LogicalDatatype[] logicalDatatypeArray = (LogicalDatatype[])this.design.getLogicalDatatypeSet().toArray();
            for (int i = 0; i < logicalDatatypeArray.length; ++i) {
                LogicalDatatype logicalDatatype = logicalDatatypeArray[i];
                this.allTypesModel.addElement(logicalDatatype);
            }
        }
    }

    protected void editableAll(boolean bl) {
        this.tfName.setEnabled(bl);
        this.tfName.setEditable(bl);
        this.btnApply.setEnabled(bl);
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            Row row = (Row)this.elementProps.get(this.typesRDBMSSites[i]);
            row.getType().setEnabled(bl);
            if (row.getPrecision().isSelected()) {
                row.getPrecision().setEnabled(bl);
                row.getTfPrecision().setEnabled(bl);
            } else {
                row.getPrecision().setEnabled(false);
                row.getTfPrecision().setEnabled(false);
            }
            if (row.getSize().isSelected()) {
                row.getSize().setEnabled(bl);
                row.getTfSize().setEnabled(bl);
            } else {
                row.getSize().setEnabled(false);
                row.getTfSize().setEnabled(false);
            }
            if (row.getScale().isSelected()) {
                row.getScale().setEnabled(bl);
                row.getTfScale().setEnabled(bl);
            } else {
                row.getScale().setEnabled(false);
                row.getTfScale().setEnabled(false);
            }
            if (!bl) continue;
            this.currentRDBMS = this.typesRDBMSSites[i];
            String string = StandardDatatypeNames.getUsedDatatypeName((String)row.getType().getSelectedItem());
            MDDataTypeFactory mDDataTypeFactory = MDDataTypeFactory.getInstance(this.currentRDBMS, this.getApplicationView().getSettings());
            AbstractDataType abstractDataType = (AbstractDataType)mDDataTypeFactory.createType(string, 1, 1);
            if (abstractDataType != null) {
                row.getScale().setEnabled(true);
                row.getPrecision().setEnabled(true);
                row.getSize().setEnabled(false);
                row.getTfScale().setEnabled(true);
                row.getTfPrecision().setEnabled(true);
                row.getTfSize().setEnabled(false);
            } else {
                abstractDataType = (AbstractDataType)mDDataTypeFactory.createType(string, "1");
                if (abstractDataType != null) {
                    row.getScale().setEnabled(false);
                    row.getPrecision().setEnabled(false);
                    row.getSize().setEnabled(true);
                    row.getTfScale().setEnabled(false);
                    row.getTfPrecision().setEnabled(false);
                    row.getTfSize().setEnabled(true);
                } else {
                    abstractDataType = (AbstractDataType)mDDataTypeFactory.createType(string);
                    if (abstractDataType != null) {
                        row.getScale().setEnabled(false);
                        row.getPrecision().setEnabled(false);
                        row.getSize().setEnabled(false);
                        row.getTfScale().setEnabled(false);
                        row.getTfPrecision().setEnabled(false);
                        row.getTfSize().setEnabled(false);
                    }
                }
            }
            if (abstractDataType == null) continue;
            row.getScale().setEnabled(abstractDataType.hasScale());
            row.getPrecision().setEnabled(abstractDataType.hasPrecision());
            row.getSize().setEnabled(abstractDataType.hasSize());
            row.getTfScale().setEnabled(abstractDataType.hasScale());
            row.getTfPrecision().setEnabled(abstractDataType.hasPrecision());
            row.getTfSize().setEnabled(abstractDataType.hasSize());
            row.getScale().setToolTipText(abstractDataType.getScaleText());
            row.getPrecision().setToolTipText(abstractDataType.getPrecisionText());
            row.getSize().setToolTipText(abstractDataType.getSizeText());
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setPreferredSize(new Dimension(200, 35));
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 5));
            this.btnSave = new JButton(Messages.getString("TypesAdmin.Save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TypesAdmin.this.applyMappings();
                    TypesAdmin.this.applyUD_NativeTypes();
                    TypesAdmin.this.design.getAppView().getPersistenceManager().writeTypes(TypesAdmin.this.design);
                    TypesAdmin.this.isSaved = true;
                    TypesAdmin.this.btnSave.setEnabled(false);
                    TypesAdmin.this.editableAll(false);
                    TypesAdmin.this.setUnknownToNull();
                    TypesAdmin.this.nativeLog.updateUI();
                    TypesAdmin.this.lsDeleted.clear();
                    TypesAdmin.this.lsAdded.clear();
                }
            });
            if (this.isDBRepos) {
                this.btnSave.setVisible(false);
            }
            this.btnApply = new JButton(Messages.getString("TypesAdmin.Apply"));
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = TypesAdmin.this.setProperties();
                    if (bl) {
                        TypesAdmin.this.isSaved = false;
                        TypesAdmin.this.btnSave.setEnabled(true);
                    } else {
                        TypesAdmin.this.isSaved = true;
                        TypesAdmin.this.btnSave.setEnabled(false);
                    }
                }
            });
            this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnApply.setMnemonic(80);
            this.btnApply.setEnabled(false);
            this.btnSave.setPreferredSize(this.btnAdd.getPreferredSize());
            this.btnSave.setMnemonic(83);
            this.btnSave.setEnabled(false);
            this.btnClose = new JButton(Messages.getString("TypesAdmin.Close"));
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TypesAdmin.this.close(TypesAdmin.this.getDialog());
                }
            });
            this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnClose.setMnemonic(67);
            JButton jButton = new JButton(this.getHelpAction());
            jButton.setMnemonic(72);
            jButton.setPreferredSize(this.btnAdd.getPreferredSize());
            jPanel.add(this.btnSave);
            jPanel.add(this.btnClose);
            jPanel.add(jButton);
            this.buttonPanel.add((Component)jPanel, "East");
        }
        return this.buttonPanel;
    }

    private boolean apply() {
        boolean bl = this.setProperties();
        if (bl) {
            this.isSaved = false;
            this.btnSave.setEnabled(true);
        } else {
            this.isSaved = true;
            this.btnSave.setEnabled(false);
        }
        return bl;
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    protected SpringLayout getPanelLayout(JPanel jPanel) {
        return (SpringLayout)jPanel.getLayout();
    }

    public void setBG(Component component) {
        component.setBackground(Color.WHITE);
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    public void close(Window window) {
        if (!this.isSaved) {
            if (this.closeConfirmed(window)) {
                this.doClose();
            }
        } else {
            this.doClose();
        }
    }

    private void doClose() {
        if (this.design != null) {
            for (LogicalDatatype logicalDatatype : this.lsAdded) {
                this.design.getLogicalDatatypeSet().remove(logicalDatatype);
            }
            for (LogicalDatatype logicalDatatype : this.lsDeleted) {
                this.design.getLogicalDatatypeSet().add(logicalDatatype);
            }
        }
        this.design = null;
        this.dialog.dispose();
    }

    private boolean closeConfirmed(Window window) {
        if (this.isDBRepos) {
            return true;
        }
        String string = Messages.getString("TypesAdmin.Yes");
        String string2 = Messages.getString("TypesAdmin.No");
        Object[] objectArray = new Object[]{string, string2};
        int n = JOptionPane.showOptionDialog(window, Messages.getString("TypesAdmin.TypesNotSaved"), Messages.getString("TypesAdmin.QuitConfirmation"), 0, 3, null, objectArray, string);
        return n == 0;
    }

    private void clear() {
        this.tfName.setText(EMPTY_VALUE);
    }

    public void setTypesRDBMSSites(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.typesRDBMSSites[i] = ((RDBMSType)objectArray[i]).getName();
            this.currentRDBMS = ((RDBMSType)objectArray[i]).getName();
        }
    }

    public void buildNativeToLogicalMappings() {
        for (int i = 0; i < this.dbtypes.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            RDBMSType rDBMSType = (RDBMSType)this.dbtypes[i];
            String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes((RDBMSType)this.dbtypes[i]);
            ArrayList<Object> arrayList = (ArrayList<Object>)this.rdbmsMap.get(rDBMSType);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                this.rdbmsMap.put(rDBMSType, arrayList);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                object4 = stringArray[j];
                if (((String)object4).equals("UNKNOWN")) continue;
                object3 = StandardDatatypeNames.getUsedDatatypeName((String)object4);
                if (!((String)object4).equals(object3 = StandardDatatypeNames.getTransformedDatatypeName((String)object3, rDBMSType))) continue;
                object2 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, (String)object3);
                if (object2 == null) {
                    object2 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, (String)object4);
                }
                object = new Holder((String)object4);
                if (object2 != null) {
                    ((Holder)object).setType((LogicalDatatype)object2);
                    ((Holder)object).oldtype = object2;
                    if (object2 == this.unknown) {
                        ((Holder)object).setType(null);
                    }
                }
                arrayList.add(object);
            }
            ArrayList<Object> arrayList2 = (ArrayList<Object>)this.rdbmsNTMap.get(rDBMSType);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Object>();
                this.rdbmsNTMap.put(rDBMSType, arrayList2);
            }
            object4 = StandardDatatypeNames.getUD_NativeTypesAsList(rDBMSType);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (NativeDBType)object3.next();
                object = ((NativeDBType)object2).getName();
                arrayList2.add(object2);
                ((NativeDBType)object2).setOldName((String)object);
            }
            Collections.sort(arrayList);
            Collections.sort(arrayList2);
        }
    }

    private void applyMappings() {
        for (int i = 0; i < this.dbtypes.length; ++i) {
            RDBMSType rDBMSType = (RDBMSType)this.dbtypes[i];
            List list = (List)this.rdbmsMap.get(rDBMSType);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                Holder holder = (Holder)list.get(j);
                if (holder.type == null) {
                    holder.type = this.unknown;
                }
                if (holder.type == holder.oldtype) continue;
                if (holder.type == this.unknown) {
                    MappingDatatypeNameLogicalDataType.removeNativeToLogicalMapping(rDBMSType, holder.typeName);
                } else {
                    MappingDatatypeNameLogicalDataType.addNativeToLogicalMapping(rDBMSType, holder.typeName, holder.type);
                }
                holder.oldtype = holder.type;
            }
        }
    }

    private void applyUD_NativeTypes() {
        Map map = StandardDatatypeNames.getUd_nativeMap();
        for (Object k : this.rdbmsNTMap.keySet()) {
            List list;
            TreeMap<String, NativeDBType> treeMap = (TreeMap<String, NativeDBType>)map.get(k);
            if (treeMap == null) {
                treeMap = new TreeMap<String, NativeDBType>();
                map.put(k, treeMap);
            }
            if ((list = (List)this.rdbmsNTMap.get(k)) == null) continue;
            treeMap.clear();
            for (NativeDBType nativeDBType : list) {
                treeMap.put(nativeDBType.getName(), nativeDBType);
            }
        }
    }

    private void setUnknownToNull() {
        for (int i = 0; i < this.dbtypes.length; ++i) {
            RDBMSType rDBMSType = (RDBMSType)this.dbtypes[i];
            List list = (List)this.rdbmsMap.get(rDBMSType);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                Holder holder = (Holder)list.get(j);
                if (holder.type != this.unknown) continue;
                holder.type = null;
            }
        }
    }

    public void checkOut() {
        LogicalDatatypeSet logicalDatatypeSet = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager abstractRepositoryManager = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (abstractRepositoryManager.isConnected()) {
            String string = null;
            try {
                string = abstractRepositoryManager.getCheckoutByUser(logicalDatatypeSet);
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("TypesAdmin.ErrorInCheckout"), sQLException.getMessage()}, Messages.getString("TypesAdmin.CheckoutError"), 0);
            }
            if (string != null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypesAdmin.CheckoutBy"), logicalDatatypeSet.getName(), string), Messages.getString("TypesAdmin.CheckoutError"), 0);
                logicalDatatypeSet.setCheckedOut(true);
                logicalDatatypeSet.setCheckedOutByMe(false);
            }
            if (bl = abstractRepositoryManager.checkOutObject(logicalDatatypeSet)) {
                logicalDatatypeSet.setCheckedOutByMe(true);
            }
        }
    }

    public void checkIn() {
        LogicalDatatypeSet logicalDatatypeSet = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager abstractRepositoryManager = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (abstractRepositoryManager.isConnected()) {
            int n;
            if (logicalDatatypeSet.isDirty() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypesAdmin.NotSaved"), logicalDatatypeSet.getName()), Messages.getString("TypesAdmin.ObjectNotSaved"), 1)) != 2 && n == 0) {
                this.applyMappings();
                this.applyUD_NativeTypes();
                abstractRepositoryManager.writeObject(logicalDatatypeSet);
                logicalDatatypeSet.setDirty(false);
            }
            if (bl = abstractRepositoryManager.checkInObject(logicalDatatypeSet)) {
                logicalDatatypeSet.setCheckedOut(false);
                logicalDatatypeSet.setCheckedOutByMe(false);
            }
        }
    }

    private boolean canDoCheckOut() {
        boolean bl = false;
        LogicalDatatypeSet logicalDatatypeSet = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager abstractRepositoryManager = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        if (!logicalDatatypeSet.isCheckedOut() && abstractRepositoryManager.isConnected()) {
            bl = logicalDatatypeSet.getRepositoryOID() != null;
        }
        return bl;
    }

    private boolean canDoCheckIn() {
        boolean bl = false;
        LogicalDatatypeSet logicalDatatypeSet = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager abstractRepositoryManager = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        if (logicalDatatypeSet.isCheckedOut() && abstractRepositoryManager.isConnected() && logicalDatatypeSet.isCheckedOutByMe()) {
            bl = logicalDatatypeSet.getRepositoryOID() != null;
        }
        return bl;
    }

    private boolean canApply(String string) {
        Row row = (Row)this.elementProps.get(string);
        if (!row.getSize().isSelected() && row.getTfSize().getText().trim().length() > 0) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("TypesAdmin.SizeCheck"), string));
            row.getTfSize().requestFocus();
            return false;
        }
        if (!row.getScale().isSelected() && row.getTfScale().getText().trim().length() > 0) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("TypesAdmin.ScaleCheck"), string));
            row.getTfScale().requestFocus();
            return false;
        }
        if (!row.getPrecision().isSelected() && row.getTfPrecision().getText().trim().length() > 0) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("TypesAdmin.PrecisionCheck"), string));
            row.getTfPrecision().requestFocus();
            return false;
        }
        return true;
    }

    void updateUD_NativeInAll() {
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            String string = this.typesRDBMSSites[i];
            RDBMSType rDBMSType = (RDBMSType)this.dbtypes[i];
            Row row = (Row)this.elementProps.get(string);
            JComboBox jComboBox = row.getType();
            Object object = jComboBox.getSelectedItem();
            boolean bl = row.getPrecision().isEnabled();
            boolean bl2 = row.getScale().isEnabled();
            boolean bl3 = row.getSize().isEnabled();
            boolean bl4 = row.getPrecision().isSelected();
            boolean bl5 = row.getScale().isSelected();
            boolean bl6 = row.getSize().isSelected();
            String string2 = row.getTfPrecision().getText();
            String string3 = row.getTfScale().getText();
            String string4 = row.getTfSize().getText();
            jComboBox.setModel(new DefaultComboBoxModel<String>(this.getNativeDataTypes(rDBMSType)));
            jComboBox.setSelectedItem(object);
            Object object2 = jComboBox.getSelectedItem();
            if (object != object2) continue;
            row.getScale().setEnabled(bl2);
            row.getPrecision().setEnabled(bl);
            row.getSize().setEnabled(bl3);
            row.getTfScale().setEnabled(bl2);
            row.getTfPrecision().setEnabled(bl);
            row.getTfSize().setEnabled(bl3);
            row.getTfPrecision().setText(string2);
            row.getTfScale().setText(string3);
            row.getTfSize().setText(string4);
            row.getPrecision().setSelected(bl4);
            row.getScale().setSelected(bl5);
            row.getSize().setSelected(bl6);
            String string5 = (String)object;
            NativeDBType nativeDBType = StandardDatatypeNames.getNativeDBType(rDBMSType, string5);
            if (nativeDBType == null) continue;
            if (!nativeDBType.isHasSize()) {
                row.getSize().setSelected(false);
                row.getSize().setEnabled(false);
                row.getTfSize().setText(EMPTY_VALUE);
                row.getTfSize().setEnabled(false);
            }
            if (!nativeDBType.isHasPrecision()) {
                row.getPrecision().setSelected(false);
                row.getScale().setSelected(false);
                row.getPrecision().setEnabled(false);
                row.getScale().setEnabled(false);
                row.getTfPrecision().setText(EMPTY_VALUE);
                row.getTfScale().setText(EMPTY_VALUE);
                row.getTfPrecision().setEnabled(false);
                row.getTfScale().setEnabled(false);
            }
            if (!this.applyMode) continue;
            if (nativeDBType.isHasSize()) {
                row.getSize().setEnabled(true);
                row.getTfSize().setEnabled(true);
            }
            if (!nativeDBType.isHasPrecision()) continue;
            row.getPrecision().setEnabled(true);
            row.getTfPrecision().setEnabled(true);
            row.getScale().setEnabled(true);
            row.getTfScale().setEnabled(true);
        }
    }

    class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        ComboBoxRenderer(Object[] objectArray) {
            super(new DefaultComboBoxModel<Object>(objectArray));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelectedItem(object);
            return this;
        }
    }

    class NativeTypesModel
    extends AbstractTableModel {
        String N_TYPE = Messages.getString("TypesAdmin.NativeType");
        String HAS_SIZE = Messages.getString("TypesAdmin.HasSize");
        String HAS_PRECISION = Messages.getString("TypesAdmin.HasPrecisionAndScale");
        String KIND = Messages.getString("TypesAdmin.Kind");
        String LOGICAL_TYPE = Messages.getString("TypesAdmin.LogicalType");
        String[] COL_NAMES = new String[]{this.N_TYPE, this.HAS_SIZE, this.HAS_PRECISION, this.KIND, this.LOGICAL_TYPE};

        NativeTypesModel() {
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            NativeDBType nativeDBType = (NativeDBType)TypesAdmin.this.currentDBTList.get(n);
            switch (n2) {
                case 0: {
                    return true;
                }
                case 1: {
                    return !nativeDBType.isHasPrecision() && TypesAdmin.EMPTY_VALUE.equals(nativeDBType.getTypeKind());
                }
                case 2: {
                    return !nativeDBType.isHasSize() && TypesAdmin.EMPTY_VALUE.equals(nativeDBType.getTypeKind());
                }
                case 3: {
                    return !nativeDBType.isHasPrecision() && !nativeDBType.isHasSize();
                }
            }
            return true;
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return TypesAdmin.this.currentDBTList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            NativeDBType nativeDBType = (NativeDBType)TypesAdmin.this.currentDBTList.get(n);
            switch (n2) {
                case 0: {
                    return nativeDBType.getName();
                }
                case 1: {
                    return nativeDBType.isHasSize();
                }
                case 2: {
                    return nativeDBType.isHasPrecision();
                }
                case 3: {
                    return nativeDBType.getTypeKind();
                }
                case 4: {
                    return nativeDBType.getLogicalDatatype();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            NativeDBType nativeDBType = (NativeDBType)TypesAdmin.this.currentDBTList.get(n);
            switch (n2) {
                case 0: {
                    nativeDBType.setName((String)object);
                    break;
                }
                case 1: {
                    nativeDBType.setHasSize((Boolean)object);
                    break;
                }
                case 2: {
                    nativeDBType.setHasPrecision((Boolean)object);
                    break;
                }
                case 3: {
                    nativeDBType.setTypeKind((String)object);
                    break;
                }
                case 4: {
                    nativeDBType.setLogicalDatatype((LogicalDatatype)object);
                }
            }
            if (object != null && !object.equals(object2)) {
                TypesAdmin.this.isSaved = false;
                TypesAdmin.this.btnSave.setEnabled(true);
            }
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return Boolean.class;
                }
                case 4: {
                    return LogicalDatatype.class;
                }
            }
            return String.class;
        }
    }

    class NativeTableModel
    extends AbstractTableModel {
        NativeTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TypesAdmin.NativeType");
            }
            return Messages.getString("TypesAdmin.LogicalType");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TypesAdmin.this.currentMappings.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Holder holder = (Holder)TypesAdmin.this.currentMappings.get(n);
            if (n2 == 0) {
                return holder.getTypeName();
            }
            if (n2 == 1) {
                return holder.getType();
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Holder holder = (Holder)TypesAdmin.this.currentMappings.get(n);
            if (n2 == 1) {
                LogicalDatatype logicalDatatype = (LogicalDatatype)object;
                if (logicalDatatype != holder.getType()) {
                    TypesAdmin.this.isSaved = false;
                    TypesAdmin.this.btnSave.setEnabled(true);
                    if (TypesAdmin.this.isDBRepos) {
                        TypesAdmin.this.getDesign().getLogicalDatatypeSet().setDirty(true);
                    }
                }
                holder.setType((LogicalDatatype)object);
            }
        }
    }

    class Holder
    implements Comparable {
        String typeName;
        LogicalDatatype type;
        LogicalDatatype oldtype;

        Holder(String string) {
            this.typeName = string;
        }

        public int compareTo(Object object) {
            if (object instanceof Holder) {
                return this.typeName.compareTo(((Holder)object).getTypeName());
            }
            return 0;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public LogicalDatatype getType() {
            return this.type;
        }

        public void setType(LogicalDatatype logicalDatatype) {
            this.type = logicalDatatype;
        }
    }

    class NTRDBMSSelectionListener
    implements ListSelectionListener {
        NTRDBMSSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TypesAdmin.this.rdbmsDBTJlist.getSelectedValue() != null) {
                RDBMSType rDBMSType = (RDBMSType)TypesAdmin.this.rdbmsDBTJlist.getSelectedValue();
                TypesAdmin.this.currentDBTList = (List)TypesAdmin.this.rdbmsNTMap.get(rDBMSType);
                TypesAdmin.this.nativeTypes.updateUI();
            }
        }
    }

    class RDBMSSelectionListener
    implements ListSelectionListener {
        RDBMSSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TypesAdmin.this.rdbmsJlist.getSelectedValue() != null) {
                RDBMSType rDBMSType = (RDBMSType)TypesAdmin.this.rdbmsJlist.getSelectedValue();
                TypesAdmin.this.currentMappings = (List)TypesAdmin.this.rdbmsMap.get(rDBMSType);
                TypesAdmin.this.nativeLog.updateUI();
            }
        }
    }

    class RDBMSListModel
    extends AbstractListModel {
        RDBMSListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            if (n < TypesAdmin.this.dbtypes.length) {
                return TypesAdmin.this.dbtypes[n];
            }
            return null;
        }

        @Override
        public int getSize() {
            return TypesAdmin.this.dbtypes.length;
        }
    }

    class AddTypesActionListener
    implements ActionListener {
        AddTypesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            for (int i = 0; i < TypesAdmin.this.typesRDBMSSites.length; ++i) {
                Row row = (Row)TypesAdmin.this.elementProps.get(TypesAdmin.this.typesRDBMSSites[i]);
                if (!jComboBox.equals(row.getType())) continue;
                TypesAdmin.this.currentRDBMS = TypesAdmin.this.typesRDBMSSites[i];
                String string = StandardDatatypeNames.getUsedDatatypeName((String)jComboBox.getSelectedItem());
                MDDataTypeFactory mDDataTypeFactory = MDDataTypeFactory.getInstance(TypesAdmin.this.currentRDBMS, TypesAdmin.this.getApplicationView().getSettings());
                AbstractDataType abstractDataType = (AbstractDataType)mDDataTypeFactory.createType(string, 1, 1);
                row.getScale().setSelected(false);
                row.getPrecision().setSelected(false);
                row.getSize().setSelected(false);
                row.getTfScale().setText(TypesAdmin.EMPTY_VALUE);
                row.getTfPrecision().setText(TypesAdmin.EMPTY_VALUE);
                row.getTfSize().setText(TypesAdmin.EMPTY_VALUE);
                if (abstractDataType != null) {
                    row.getScale().setEnabled(true);
                    row.getPrecision().setEnabled(true);
                    row.getSize().setEnabled(false);
                    row.getTfScale().setEnabled(true);
                    row.getTfPrecision().setEnabled(true);
                    row.getTfSize().setEnabled(false);
                } else {
                    abstractDataType = (AbstractDataType)mDDataTypeFactory.createType(string, "1");
                    if (abstractDataType != null) {
                        row.getScale().setEnabled(false);
                        row.getPrecision().setEnabled(false);
                        row.getSize().setEnabled(true);
                        row.getTfScale().setEnabled(false);
                        row.getTfPrecision().setEnabled(false);
                        row.getTfSize().setEnabled(true);
                    } else {
                        abstractDataType = (AbstractDataType)mDDataTypeFactory.createType(string);
                        if (abstractDataType != null) {
                            row.getScale().setEnabled(false);
                            row.getPrecision().setEnabled(false);
                            row.getSize().setEnabled(false);
                            row.getTfScale().setEnabled(false);
                            row.getTfPrecision().setEnabled(false);
                            row.getTfSize().setEnabled(true);
                        }
                    }
                }
                if (abstractDataType == null) break;
                row.getScale().setEnabled(abstractDataType.hasScale());
                row.getPrecision().setEnabled(abstractDataType.hasPrecision());
                row.getSize().setEnabled(abstractDataType.hasSize());
                row.getTfScale().setEnabled(abstractDataType.hasScale());
                row.getTfPrecision().setEnabled(abstractDataType.hasPrecision());
                row.getTfSize().setEnabled(abstractDataType.hasSize());
                row.getScale().setToolTipText(abstractDataType.getScaleText());
                row.getPrecision().setToolTipText(abstractDataType.getPrecisionText());
                row.getSize().setToolTipText(abstractDataType.getSizeText());
                break;
            }
        }
    }
}

