/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.rdbms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.RXMLDefaultRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.WXMLRDBMSSiteSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;

public class RDBMSSiteEditor
extends CustomDialog {
    private static final Logger LOGGER = new Logger(RDBMSSiteEditor.class);
    private boolean isSaved = true;
    private JDialog dialog;
    private JTabbedPane tpane;
    private JPanel currentDesignPanel;
    private JPanel rdbmsFilePanel;
    private JButton btnFileAdd;
    private JButton btnFileRemove;
    private JButton btnFileSave;
    private JButton btnFileApply;
    private JButton btnFileClose;
    private JButton btnOpen;
    private JPanel general;
    private JPanel addFilePanel;
    private JPanel listFilePanel;
    private JPanel propFilePanel;
    private JPanel buttonFilePanel;
    private JPanel openPanel;
    private JPanel typesFileButtonsPanel;
    private DefaultListModel allFileRDBMSSiteModel;
    private JList allFileSitesList;
    private JTextField tfFileName;
    private JTextField tfNameFile;
    private JComboBox cbRDBMSTypeFile;
    private String fileName;
    private RDBMSSiteSet currentRDBMSSites;
    private Set<RDBMSSite> storageDesignsSites;
    private JButton btnCurrentAdd;
    private JButton btnCurrentRemove;
    private JButton btnCurrentApply;
    private JButton btnCurrentOK;
    private JButton btnCurrentClose;
    private JPanel addCurrentPanel;
    private JPanel listCurrentPanel;
    private JPanel propCurrentPanel;
    private JPanel buttonCurrentPanel;
    private JPanel typesCurrentButtonsPanel;
    private DefaultListModel allCurrentRDBMSSiteModel;
    private JList allCurrentSitesList;
    private JTextField tfNameCurrent;
    private JComboBox cbRDBMSTypeCurrent;
    private boolean isDBRepos = false;
    private JButton bnCheckOut;
    private JButton bnCheckIn;
    private static File lastFolder = null;

    public RDBMSSiteEditor(ApplicationView applicationView) {
        super(applicationView);
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        this.isDBRepos = abstractRepositoryManager.isConnected() || this.getDesign().isLoadFromDB();
        this.storageDesignsSites = new HashSet<RDBMSSite>();
        Iterator iterator = this.getDesign().getStorageDesignFactory().getSorageDesigns().iterator();
        while (iterator.hasNext()) {
            this.storageDesignsSites.add(((StorageDesign)iterator.next()).getRDBMSSite());
        }
    }

    @Override
    protected String getHelpIndex() {
        return "RDBMS_SITE_EDITOR";
    }

    public boolean isDialogVisible() {
        if (this.dialog != null) {
            return this.dialog.isVisible();
        }
        return false;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("RDBMSSiteEditor.RDBMSSiteEditor"), true);
            this.general = new JPanel();
            this.general.setLayout(new BorderLayout());
            this.general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.general);
            this.currentDesignPanel = new JPanel();
            this.currentDesignPanel.setLayout(new BorderLayout());
            this.rdbmsFilePanel = new JPanel();
            this.rdbmsFilePanel.setLayout(new BorderLayout());
            this.tpane = new JTabbedPane();
            this.general.add((Component)this.tpane, "Center");
            this.tpane.addTab(Messages.getString("RDBMSSiteEditor.CurrentDesign"), this.currentDesignPanel);
            this.tpane.addTab(Messages.getString("RDBMSSiteEditor.ExternalRDBMSFile"), this.rdbmsFilePanel);
            this.initCurrentDesignPanel();
            this.initRDBMSFilePanel();
            if (this.isDBRepos) {
                boolean bl = this.canDoCheckIn();
                this.enableButtons(bl);
            } else {
                this.btnCurrentAdd.setEnabled(true);
            }
            this.dialog.setDefaultCloseOperation(2);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    private void initCurrentDesignPanel() {
        this.addCurrentPanel = new JPanel(new BorderLayout());
        this.addCurrentPanel.setPreferredSize(new Dimension(350, 400));
        this.addCurrentPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSites")));
        this.propCurrentPanel = new JPanel(new SpringLayout());
        this.propCurrentPanel.setPreferredSize(new Dimension(350, 400));
        this.propCurrentPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSiteProperties")));
        this.buttonCurrentPanel = this.getCurrentButtonPanel();
        this.buttonCurrentPanel.setBorder(BorderFactory.createEmptyBorder());
        this.initCurrentAddPanel();
        this.initCurrentPropPanel();
        this.currentDesignPanel.add((Component)this.addCurrentPanel, "West");
        this.currentDesignPanel.add((Component)this.propCurrentPanel, "Center");
        this.currentDesignPanel.add((Component)this.buttonCurrentPanel, "South");
    }

    private void initRDBMSFilePanel() {
        this.addFilePanel = new JPanel(new BorderLayout());
        this.addFilePanel.setPreferredSize(new Dimension(350, 400));
        this.addFilePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.ChooseRDBMSSite")));
        this.propFilePanel = new JPanel(new SpringLayout());
        this.propFilePanel.setPreferredSize(new Dimension(350, 400));
        this.propFilePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSiteProperties")));
        this.buttonFilePanel = this.getFileButtonPanel();
        this.buttonFilePanel.setBorder(BorderFactory.createEmptyBorder());
        this.currentRDBMSSites = new RDBMSSiteSet(this.getDesign());
        this.initFileAddPanel();
        this.initFilePropPanel();
        this.rdbmsFilePanel.add((Component)this.addFilePanel, "West");
        this.rdbmsFilePanel.add((Component)this.propFilePanel, "Center");
        this.rdbmsFilePanel.add((Component)this.buttonFilePanel, "South");
    }

    private void initFileAddPanel() {
        this.initFileAddSubPanels();
        this.initFileOpenPanel();
        this.initFileSitesButtons();
        this.initFileSitesPanel();
    }

    private void initCurrentAddPanel() {
        this.initCurrentAddSubPanels();
        this.initCurrentSitesPanel();
    }

    private void initFileAddSubPanels() {
        this.openPanel = new JPanel();
        this.openPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSitesFile")));
        this.openPanel.setAlignmentX(0.5f);
        this.typesFileButtonsPanel = new JPanel();
        this.typesFileButtonsPanel.setAlignmentX(0.5f);
        this.listFilePanel = new JPanel(new BorderLayout());
        this.listFilePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSites")));
        this.listFilePanel.setAlignmentX(0.5f);
        this.addFilePanel.add((Component)this.openPanel, "North");
        this.addFilePanel.add((Component)this.typesFileButtonsPanel, "South");
        this.addFilePanel.add(this.listFilePanel);
    }

    private void initCurrentAddSubPanels() {
        this.typesCurrentButtonsPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel = this.initDBSitesButtons();
        if (this.isDBRepos) {
            this.typesCurrentButtonsPanel.add(jPanel);
            this.bnCheckIn.setEnabled(this.canDoCheckIn());
            this.bnCheckOut.setEnabled(this.canDoCheckOut());
        }
        this.typesCurrentButtonsPanel.add(this.initCurrentSitesButtons());
        this.listCurrentPanel = new JPanel(new BorderLayout());
        this.listCurrentPanel.setAlignmentX(0.5f);
        this.addCurrentPanel.add((Component)this.typesCurrentButtonsPanel, "South");
        this.addCurrentPanel.add(this.listCurrentPanel);
    }

    private String selectRDBMSTypes() {
        Serializable serializable;
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.getName().endsWith("RDBMSSites".concat(".xml")) || file.isDirectory();
            }

            public String toString() {
                return new StringBuffer(MessageFormat.format(Messages.getString("RDBMSSiteEditor.OracleSQLDeveloperModelingRDBMSSiteFiles"), ".xml")).toString();
            }
        };
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(0);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setURLFilter(uRLFilter);
        if (lastFolder != null) {
            uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
        } else {
            String string = this.getApplicationView().getCurrentDesign().getDesignPath();
            if (string != null && string.length() > 0) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
            } else {
                serializable = this.getApplicationView().getUserHomeDirectory();
                if (serializable != null) {
                    uRLChooser.setSelectedURL((URL)serializable);
                }
            }
        }
        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("RDBMSSiteEditor.SelectRDBMSSites"));
        if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
            lastFolder = ((File)serializable).getParentFile();
            String string = ((File)serializable).getAbsolutePath();
            return string;
        }
        return null;
    }

    private void initFileOpenPanel() {
        this.tfFileName = new JTextField();
        this.btnOpen = new JButton(Messages.getString("RDBMSSiteEditor.Select"));
        this.btnOpen.setMnemonic(76);
        this.btnOpen.setEnabled(true);
        this.btnOpen.setPreferredSize(new Dimension(120, 23));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = RDBMSSiteEditor.this.selectRDBMSTypes();
                if (string != null) {
                    RDBMSSiteEditor.this.fileName = string;
                    RDBMSSiteEditor.this.tfFileName.setText(RDBMSSiteEditor.this.fileName);
                    RXMLDefaultRDBMSSiteSet rXMLDefaultRDBMSSiteSet = new RXMLDefaultRDBMSSiteSet();
                    RDBMSSiteEditor.this.currentRDBMSSites = (RDBMSSiteSet)rXMLDefaultRDBMSSiteSet.readDefaultRDBMSSites(RDBMSSiteEditor.this.fileName, RDBMSSiteEditor.this.getDesign());
                    RDBMSSiteEditor.this.allFileRDBMSSiteModel.clear();
                    if (RDBMSSiteEditor.this.getDesign() != null) {
                        RDBMSSite[] rDBMSSiteArray = (RDBMSSite[])RDBMSSiteEditor.this.currentRDBMSSites.toArray();
                        for (int i = 0; i < rDBMSSiteArray.length; ++i) {
                            RDBMSSite rDBMSSite = rDBMSSiteArray[i];
                            rDBMSSite.setIsDefault(false);
                            RDBMSSiteEditor.this.allFileRDBMSSiteModel.addElement(rDBMSSite);
                        }
                    }
                    RDBMSSiteEditor.this.enableFileButtons(true);
                    RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
                }
            }
        });
        this.tfFileName.setPreferredSize(new Dimension(180, 20));
        this.openPanel.add(this.tfFileName);
        this.openPanel.add(this.btnOpen);
        this.tfFileName.setEditable(false);
    }

    private void enableFileButtons(boolean bl) {
        this.btnFileAdd.setEnabled(bl);
        this.btnFileRemove.setEnabled(bl);
        this.btnFileApply.setEnabled(bl);
        this.btnFileSave.setEnabled(bl);
    }

    private void enableCurrentButtons(boolean bl) {
        this.btnCurrentAdd.setEnabled(bl);
        this.btnCurrentRemove.setEnabled(bl);
        this.btnCurrentOK.setEnabled(bl);
        this.btnCurrentApply.setEnabled(bl);
    }

    private void enableButtons(boolean bl) {
        this.btnCurrentAdd.setEnabled(bl);
    }

    private void initFilePropPanel() {
        this.initNameFile();
        this.initRDBMSTypeFile();
        this.editableFileAll(false);
    }

    private void initCurrentPropPanel() {
        this.initNameCurrent();
        this.initRDBMSTypeCurrent();
        this.editableCurrentAll(false);
    }

    private void initNameFile() {
        JLabel jLabel = new JLabel(Messages.getString("RDBMSSiteEditor.Name"));
        this.propFilePanel.add(jLabel);
        this.tfNameFile = new JTextField("", 17);
        this.propFilePanel.add(this.tfNameFile);
        CommonUtil.setLabelConstraints((SpringLayout)this.propFilePanel.getLayout(), jLabel, 20);
        CommonUtil.setObjectConstraints((SpringLayout)this.propFilePanel.getLayout(), this.tfNameFile, 20);
    }

    private void initNameCurrent() {
        JLabel jLabel = new JLabel(Messages.getString("RDBMSSiteEditor.Name"));
        this.propCurrentPanel.add(jLabel);
        this.tfNameCurrent = new JTextField("", 20);
        this.propCurrentPanel.add(this.tfNameCurrent);
        CommonUtil.setLabelConstraints((SpringLayout)this.propCurrentPanel.getLayout(), jLabel, 20);
        CommonUtil.setObjectConstraints((SpringLayout)this.propCurrentPanel.getLayout(), this.tfNameCurrent, 20);
    }

    private void initRDBMSTypeFile() {
        JLabel jLabel = new JLabel(Messages.getString("RDBMSSiteEditor.RBDMSType"));
        jLabel.setPreferredSize(this.tfNameFile.getPreferredSize());
        this.propFilePanel.add(jLabel);
        this.cbRDBMSTypeFile = new JComboBox();
        this.cbRDBMSTypeFile.setPreferredSize(this.tfNameFile.getPreferredSize());
        this.fillComboItems(this.getDesign().getRDBMSTypeSet().toArray(), this.cbRDBMSTypeFile);
        this.cbRDBMSTypeFile.setMaximumRowCount(10);
        this.propFilePanel.add(this.cbRDBMSTypeFile);
        this.setBG(this.cbRDBMSTypeFile);
        this.cbRDBMSTypeFile.setPreferredSize(this.tfNameFile.getPreferredSize());
        CommonUtil.setLabelConstraints((SpringLayout)this.propFilePanel.getLayout(), jLabel, 50);
        CommonUtil.setObjectConstraints((SpringLayout)this.propFilePanel.getLayout(), this.cbRDBMSTypeFile, 50);
    }

    private void initRDBMSTypeCurrent() {
        JLabel jLabel = new JLabel(Messages.getString("RDBMSSiteEditor.RBDMSType"));
        jLabel.setPreferredSize(this.tfNameCurrent.getPreferredSize());
        this.propCurrentPanel.add(jLabel);
        this.cbRDBMSTypeCurrent = new JComboBox();
        this.cbRDBMSTypeCurrent.setPreferredSize(this.tfNameCurrent.getPreferredSize());
        this.fillComboItems(this.getDesign().getRDBMSTypeSet().toArray(), this.cbRDBMSTypeCurrent);
        this.cbRDBMSTypeCurrent.setMaximumRowCount(10);
        this.propCurrentPanel.add(this.cbRDBMSTypeCurrent);
        this.setBG(this.cbRDBMSTypeCurrent);
        CommonUtil.setLabelConstraints((SpringLayout)this.propCurrentPanel.getLayout(), jLabel, 50);
        CommonUtil.setObjectConstraints((SpringLayout)this.propCurrentPanel.getLayout(), this.cbRDBMSTypeCurrent, 50);
    }

    protected void setFileProperties() {
        RDBMSSite rDBMSSite = (RDBMSSite)this.allFileSitesList.getSelectedValue();
        this.allFileRDBMSSiteModel.removeElement(rDBMSSite);
        if (rDBMSSite != null) {
            rDBMSSite.setName(this.tfNameFile.getText());
            rDBMSSite.setType((RDBMSType)this.cbRDBMSTypeFile.getSelectedItem());
        }
        this.allFileRDBMSSiteModel.addElement(rDBMSSite);
        this.currentRDBMSSites.removeAll();
        Object[] objectArray = this.allFileRDBMSSiteModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            RDBMSSite rDBMSSite2 = (RDBMSSite)objectArray[i];
            if (rDBMSSite2 == null) continue;
            this.currentRDBMSSites.add(rDBMSSite2);
            this.currentRDBMSSites.updateMaxIndex(rDBMSSite2.getPathID());
        }
        this.refreshCurrentRDBMSSiteList();
        this.tfNameFile.setText("");
        this.tfNameFile.setEnabled(false);
        this.cbRDBMSTypeFile.setEnabled(false);
    }

    protected void setCurrentProperties() {
        RDBMSSite rDBMSSite = (RDBMSSite)this.allCurrentSitesList.getSelectedValue();
        this.allCurrentRDBMSSiteModel.removeElement(rDBMSSite);
        if (rDBMSSite != null) {
            rDBMSSite.setName(this.tfNameCurrent.getText());
            rDBMSSite.setType((RDBMSType)this.cbRDBMSTypeCurrent.getSelectedItem());
        }
        this.allCurrentRDBMSSiteModel.addElement(rDBMSSite);
        this.getDesign().getRDBMSSiteSet().removeAll();
        Object[] objectArray = this.allCurrentRDBMSSiteModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            RDBMSSite rDBMSSite2 = (RDBMSSite)objectArray[i];
            if (rDBMSSite2 == null) continue;
            this.getDesign().getRDBMSSiteSet().add(rDBMSSite2);
            this.getDesign().getRDBMSSiteSet().updateMaxIndex(rDBMSSite2.getPathID());
        }
        this.tfNameCurrent.setText("");
        this.tfNameCurrent.setEnabled(false);
        this.cbRDBMSTypeCurrent.setEnabled(false);
        this.getDesign().setDirty(true);
        if (this.isDBRepos) {
            this.getDesign().getRDBMSSiteSet().setDirty(true);
        }
    }

    private void initFileSitesPanel() {
        this.allFileRDBMSSiteModel = new DefaultListModel();
        this.allFileSitesList = new JList(this.allFileRDBMSSiteModel);
        this.allFileSitesList.setSelectionMode(0);
        this.allFileSitesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (RDBMSSiteEditor.this.allFileSitesList.getSelectedValue() != null) {
                    RDBMSSiteEditor.this.tfNameFile.setText("");
                    RDBMSSite rDBMSSite = (RDBMSSite)RDBMSSiteEditor.this.allFileSitesList.getSelectedValue();
                    RDBMSSiteEditor.this.tfNameFile.setText(rDBMSSite.getName());
                    RDBMSSiteEditor.this.cbRDBMSTypeFile.setSelectedItem(rDBMSSite.getType());
                    if (!rDBMSSite.getIsDefault()) {
                        RDBMSSiteEditor.this.tfNameFile.setEnabled(true);
                        RDBMSSiteEditor.this.cbRDBMSTypeFile.setEnabled(true);
                        RDBMSSiteEditor.this.btnFileRemove.setEnabled(true);
                        RDBMSSiteEditor.this.btnFileApply.setEnabled(true);
                    } else {
                        RDBMSSiteEditor.this.tfNameFile.setEnabled(false);
                        RDBMSSiteEditor.this.cbRDBMSTypeFile.setEnabled(false);
                        RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
                        RDBMSSiteEditor.this.btnFileApply.setEnabled(false);
                    }
                } else {
                    RDBMSSiteEditor.this.tfNameFile.setEnabled(false);
                    RDBMSSiteEditor.this.cbRDBMSTypeFile.setEnabled(false);
                    RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.allFileSitesList);
        this.listFilePanel.add(jScrollPane);
    }

    private void enableCurrentSiteControls() {
        if (this.allCurrentSitesList.getSelectedValue() != null) {
            this.tfNameCurrent.setText("");
            RDBMSSite rDBMSSite = (RDBMSSite)this.allCurrentSitesList.getSelectedValue();
            this.tfNameCurrent.setText(rDBMSSite.getName());
            this.cbRDBMSTypeCurrent.setSelectedItem(rDBMSSite.getType());
            if (!rDBMSSite.getIsDefault()) {
                if (this.storageDesignsSites.contains(rDBMSSite)) {
                    this.tfNameCurrent.setEnabled(false);
                    this.cbRDBMSTypeCurrent.setEnabled(false);
                    this.btnCurrentRemove.setEnabled(false);
                    this.btnCurrentApply.setEnabled(false);
                } else if (this.isDBRepos) {
                    boolean bl = this.canDoCheckIn();
                    this.tfNameCurrent.setEnabled(bl);
                    this.cbRDBMSTypeCurrent.setEnabled(bl);
                    this.btnCurrentRemove.setEnabled(bl);
                    this.btnCurrentApply.setEnabled(bl);
                } else {
                    this.tfNameCurrent.setEnabled(true);
                    this.cbRDBMSTypeCurrent.setEnabled(true);
                    this.btnCurrentRemove.setEnabled(true);
                    this.btnCurrentApply.setEnabled(true);
                }
            } else {
                this.tfNameCurrent.setEnabled(false);
                this.cbRDBMSTypeCurrent.setEnabled(false);
                this.btnCurrentRemove.setEnabled(false);
                this.btnCurrentApply.setEnabled(false);
            }
        } else {
            this.tfNameCurrent.setEnabled(false);
            this.cbRDBMSTypeCurrent.setEnabled(false);
            this.btnCurrentRemove.setEnabled(false);
            this.btnCurrentApply.setEnabled(false);
        }
    }

    private void initCurrentSitesPanel() {
        this.allCurrentRDBMSSiteModel = new DefaultListModel();
        this.allCurrentSitesList = new JList(this.allCurrentRDBMSSiteModel);
        this.allCurrentSitesList.setSelectionMode(0);
        this.allCurrentSitesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RDBMSSiteEditor.this.enableCurrentSiteControls();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.allCurrentSitesList);
        this.listCurrentPanel.add(jScrollPane);
        this.refreshCurrentRDBMSSiteList();
    }

    protected void initFileSitesButtons() {
        this.btnFileAdd = new JButton(Messages.getString("RDBMSSiteEditor.AddSite"));
        this.btnFileAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RDBMSSiteEditor.this.getDesign() != null) {
                    String string = RDBMSSiteEditor.this.getApplicationView().getIDGenerator().createNewID();
                    String string2 = "SITE_";
                    int n = RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.size() + 1;
                    String string3 = string2 + n;
                    RDBMSSiteSet rDBMSSiteSet = new RDBMSSiteSet(RDBMSSiteEditor.this.getDesign());
                    for (int i = 0; i < RDBMSSiteEditor.this.allFileRDBMSSiteModel.getSize(); ++i) {
                        RDBMSSite rDBMSSite = (RDBMSSite)RDBMSSiteEditor.this.allFileRDBMSSiteModel.getElementAt(i);
                        rDBMSSiteSet.add(rDBMSSite);
                    }
                    while (RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getByName(string3) != null || rDBMSSiteSet.getByName(string3) != null) {
                        string3 = string2 + ++n;
                    }
                    RDBMSSite rDBMSSite = new RDBMSSite(string3, RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getDefaultType(), RDBMSSiteEditor.this.getDesign());
                    rDBMSSite.setObjectID(string);
                    RDBMSSiteEditor.this.tfNameFile.setText(string3);
                    RDBMSSiteEditor.this.cbRDBMSTypeFile.setSelectedItem(RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getDefaultType());
                    RDBMSSiteEditor.this.allFileRDBMSSiteModel.addElement(rDBMSSite);
                    RDBMSSiteEditor.this.allFileSitesList.setSelectedValue(rDBMSSite, true);
                    RDBMSSiteEditor.this.isSaved = false;
                    RDBMSSiteEditor.this.editableFileAll(true);
                }
            }
        });
        this.btnFileAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnFileAdd.setMnemonic(65);
        this.btnFileAdd.setEnabled(false);
        this.typesFileButtonsPanel.add(this.btnFileAdd);
        this.btnFileRemove = new JButton(Messages.getString("RDBMSSiteEditor.RemoveSite"));
        this.btnFileRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RDBMSSite rDBMSSite = (RDBMSSite)RDBMSSiteEditor.this.allFileSitesList.getSelectedValue();
                RDBMSSiteEditor.this.allFileRDBMSSiteModel.removeElement(rDBMSSite);
                RDBMSSiteEditor.this.currentRDBMSSites.remove(rDBMSSite);
                RDBMSSiteEditor.this.tfNameFile.setText("");
                RDBMSSiteEditor.this.btnFileSave.setEnabled(true);
                RDBMSSiteEditor.this.isSaved = false;
                RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
            }
        });
        this.btnFileRemove.setMnemonic(82);
        this.btnFileRemove.setEnabled(false);
        this.btnFileRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.typesFileButtonsPanel.add(this.btnFileRemove);
    }

    protected JPanel initCurrentSitesButtons() {
        JPanel jPanel = new JPanel();
        this.btnCurrentAdd = new JButton(Messages.getString("RDBMSSiteEditor.AddSite"));
        this.btnCurrentAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RDBMSSiteEditor.this.getDesign() != null) {
                    String string = RDBMSSiteEditor.this.getApplicationView().getIDGenerator().createNewID();
                    String string2 = "SITE_";
                    int n = RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.size() + 1;
                    String string3 = string2 + n;
                    while (RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getByName(string3) != null) {
                        string3 = string2 + ++n;
                    }
                    RDBMSSite rDBMSSite = new RDBMSSite(string3, RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getDefaultType(), RDBMSSiteEditor.this.getDesign());
                    rDBMSSite.setObjectID(string);
                    RDBMSSiteEditor.this.tfNameCurrent.setText(string3);
                    RDBMSSiteEditor.this.cbRDBMSTypeCurrent.setSelectedItem(RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getDefaultType());
                    RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.addElement(rDBMSSite);
                    RDBMSSiteEditor.this.allCurrentSitesList.setSelectedValue(rDBMSSite, true);
                    RDBMSSiteEditor.this.editableCurrentAll(true);
                }
            }
        });
        this.btnCurrentAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnCurrentAdd.setMnemonic(65);
        jPanel.add(this.btnCurrentAdd);
        this.btnCurrentRemove = new JButton(Messages.getString("RDBMSSiteEditor.RemoveSite"));
        this.btnCurrentRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RDBMSSite rDBMSSite = (RDBMSSite)RDBMSSiteEditor.this.allCurrentSitesList.getSelectedValue();
                RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.removeElement(rDBMSSite);
                RDBMSSiteEditor.this.tfNameCurrent.setText("");
                RDBMSSiteEditor.this.btnCurrentOK.setEnabled(true);
                RDBMSSiteEditor.this.btnCurrentRemove.setEnabled(false);
            }
        });
        this.btnCurrentRemove.setMnemonic(82);
        this.btnCurrentRemove.setEnabled(false);
        this.btnCurrentRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel.add(this.btnCurrentRemove);
        return jPanel;
    }

    protected JPanel initDBSitesButtons() {
        JPanel jPanel = new JPanel();
        this.bnCheckOut = new JButton(Messages.getString("RDBMSSiteEditor.CheckOut"));
        this.bnCheckOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RDBMSSiteEditor.this.enableButtons(true);
                RDBMSSiteEditor.this.bnCheckIn.setEnabled(true);
                RDBMSSiteEditor.this.bnCheckOut.setEnabled(false);
                RDBMSSiteEditor.this.checkOut();
                RDBMSSiteEditor.this.enableCurrentSiteControls();
            }
        });
        this.bnCheckOut.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnCheckOut);
        this.bnCheckIn = new JButton(Messages.getString("RDBMSSiteEditor.CheckIn"));
        this.bnCheckIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RDBMSSiteEditor.this.enableButtons(false);
                RDBMSSiteEditor.this.bnCheckIn.setEnabled(false);
                RDBMSSiteEditor.this.bnCheckOut.setEnabled(true);
                RDBMSSiteEditor.this.tfNameCurrent.setText("");
                RDBMSSiteEditor.this.tfNameCurrent.setEnabled(false);
                RDBMSSiteEditor.this.cbRDBMSTypeCurrent.setEnabled(false);
                RDBMSSiteEditor.this.checkIn();
            }
        });
        this.bnCheckIn.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnCheckIn);
        return jPanel;
    }

    public void refreshCurrentRDBMSSiteList() {
        this.allCurrentRDBMSSiteModel.clear();
        if (this.getDesign() != null) {
            RDBMSSite[] rDBMSSiteArray = (RDBMSSite[])this.getDesign().getRDBMSSiteSet().toArray();
            for (int i = 0; i < rDBMSSiteArray.length; ++i) {
                RDBMSSite rDBMSSite = rDBMSSiteArray[i];
                this.allCurrentRDBMSSiteModel.addElement(rDBMSSite);
            }
        }
    }

    protected void refreshRDBMSSiteList() {
        this.allFileRDBMSSiteModel.clear();
        for (int i = 0; i < this.currentRDBMSSites.toSiteArray().length; ++i) {
            RDBMSSite rDBMSSite = this.currentRDBMSSites.toSiteArray()[i];
            this.allFileRDBMSSiteModel.addElement(rDBMSSite);
        }
    }

    protected void editableFileAll(boolean bl) {
        this.tfNameFile.setEnabled(bl);
        this.cbRDBMSTypeFile.setEnabled(bl);
        this.enableFileButtons(bl);
    }

    protected void editableCurrentAll(boolean bl) {
        this.tfNameCurrent.setEnabled(bl);
        this.cbRDBMSTypeCurrent.setEnabled(bl);
        this.enableCurrentButtons(bl);
    }

    protected JPanel getFileButtonPanel() {
        if (this.buttonFilePanel == null) {
            this.buttonFilePanel = new JPanel(new BorderLayout());
            this.buttonFilePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 5));
            this.btnFileSave = new JButton(Messages.getString("RDBMSSiteEditor.Save"));
            this.btnFileSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WXMLRDBMSSiteSet wXMLRDBMSSiteSet = new WXMLRDBMSSiteSet(RDBMSSiteEditor.this.getApplicationView().getPersistenceManager());
                    Document document = wXMLRDBMSSiteSet.writeDocument(RDBMSSiteEditor.this.currentRDBMSSites);
                    if (document != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        wXMLRDBMSSiteSet.prettyPrint(document, stringBuffer);
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(new File(RDBMSSiteEditor.this.fileName));
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                            outputStreamWriter.write(stringBuffer.toString());
                            outputStreamWriter.close();
                        }
                        catch (Exception exception) {
                            LOGGER.warn(exception.getMessage(), exception);
                        }
                    }
                    RDBMSSiteEditor.this.isSaved = true;
                    RDBMSSiteEditor.this.tfNameFile.setEnabled(false);
                    RDBMSSiteEditor.this.cbRDBMSTypeFile.setEnabled(false);
                    RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
                }
            });
            this.btnFileApply = new JButton(Messages.getString("RDBMSSiteEditor.Apply"));
            this.btnFileApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RDBMSSiteEditor.this.setFileProperties();
                    RDBMSSiteEditor.this.isSaved = false;
                    RDBMSSiteEditor.this.btnFileSave.setEnabled(true);
                }
            });
            this.btnFileApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnFileApply.setMnemonic(80);
            this.btnFileApply.setEnabled(false);
            this.btnFileSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnFileSave.setMnemonic(83);
            this.btnFileSave.setEnabled(false);
            this.btnFileClose = new JButton(Messages.getString("RDBMSSiteEditor.Close"));
            this.btnFileClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RDBMSSiteEditor.this.close(RDBMSSiteEditor.this.getDialog());
                }
            });
            this.btnFileClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnFileClose.setMnemonic(67);
            JButton jButton = new JButton(this.getHelpAction());
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.setMnemonic(72);
            jPanel.add(this.btnFileSave);
            jPanel.add(this.btnFileApply);
            jPanel.add(this.btnFileClose);
            jPanel.add(jButton);
            this.buttonFilePanel.add((Component)jPanel, "East");
        }
        return this.buttonFilePanel;
    }

    protected JPanel getCurrentButtonPanel() {
        if (this.buttonCurrentPanel == null) {
            this.buttonCurrentPanel = new JPanel(new BorderLayout());
            this.buttonCurrentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(1, 4, 5, 5));
            this.btnCurrentOK = new JButton(Messages.getString("RDBMSSiteEditor.OK"));
            this.btnCurrentOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RDBMSSiteEditor.this.setCurrentProperties();
                    RDBMSSiteEditor.this.dialog.dispose();
                }
            });
            this.btnCurrentApply = new JButton(Messages.getString("RDBMSSiteEditor.Apply"));
            this.btnCurrentApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RDBMSSiteEditor.this.setCurrentProperties();
                    RDBMSSiteEditor.this.btnCurrentOK.setEnabled(true);
                }
            });
            this.btnCurrentApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCurrentApply.setMnemonic(80);
            this.btnCurrentApply.setEnabled(false);
            this.btnCurrentOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCurrentOK.setMnemonic(83);
            this.btnCurrentOK.setEnabled(false);
            this.btnCurrentClose = new JButton(Messages.getString("RDBMSSiteEditor.Close"));
            this.btnCurrentClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RDBMSSiteEditor.this.close(RDBMSSiteEditor.this.dialog);
                }
            });
            this.btnCurrentClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCurrentClose.setMnemonic(67);
            JButton jButton = new JButton(this.getHelpAction());
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.setMnemonic(72);
            jPanel.add(this.btnCurrentOK);
            jPanel.add(this.btnCurrentApply);
            jPanel.add(this.btnCurrentClose);
            jPanel.add(jButton);
            this.buttonCurrentPanel.add((Component)jPanel, "East");
        }
        return this.buttonCurrentPanel;
    }

    protected SpringLayout getPanelLayout(JPanel jPanel) {
        return (SpringLayout)jPanel.getLayout();
    }

    public void setBG(Component component) {
        component.setBackground(Color.WHITE);
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    public void close(Window window) {
        if (!this.isSaved) {
            if (this.closeConfirmed(window)) {
                window.dispose();
            }
        } else {
            window.dispose();
        }
    }

    private boolean closeConfirmed(Window window) {
        if (this.isDBRepos) {
            return true;
        }
        String string = Messages.getString("RDBMSSiteEditor.Yes");
        String string2 = Messages.getString("RDBMSSiteEditor.No");
        Object[] objectArray = new Object[]{string, string2};
        int n = JOptionPane.showOptionDialog(window, Messages.getString("RDBMSSiteEditor.RDBMSSitesAreNotSaved"), Messages.getString("RDBMSSiteEditor.QuitConfirmation"), 0, 3, null, objectArray, string);
        return n == 0;
    }

    public void fillComboItems(Object[] objectArray, JComboBox jComboBox) {
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    public void checkOut() {
        RDBMSSiteSet rDBMSSiteSet = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (abstractRepositoryManager.isConnected()) {
            String string = null;
            try {
                string = abstractRepositoryManager.getCheckoutByUser(rDBMSSiteSet);
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("RDBMSSiteEditor.ErrorInCheckout"), sQLException.getMessage()}, Messages.getString("RDBMSSiteEditor.CheckoutError"), 0);
            }
            if (string != null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("RDBMSSiteEditor.Checkoutby"), rDBMSSiteSet.getName(), string), Messages.getString("RDBMSSiteEditor.CheckoutError"), 0);
                rDBMSSiteSet.setCheckedOut(true);
                rDBMSSiteSet.setCheckedOutByMe(false);
            }
            if (bl = abstractRepositoryManager.checkOutObject(rDBMSSiteSet)) {
                rDBMSSiteSet.setCheckedOutByMe(true);
            }
        }
    }

    public void checkIn() {
        RDBMSSiteSet rDBMSSiteSet = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (abstractRepositoryManager.isConnected()) {
            int n;
            if (rDBMSSiteSet.isDirty() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("RDBMSSiteEditor.NotSaved"), rDBMSSiteSet.getName()), Messages.getString("RDBMSSiteEditor.ObjectNotSaved"), 1)) != 2 && n == 0) {
                abstractRepositoryManager.writeObject(rDBMSSiteSet);
                rDBMSSiteSet.setDirty(false);
            }
            if (bl = abstractRepositoryManager.checkInObject(rDBMSSiteSet)) {
                rDBMSSiteSet.setCheckedOut(false);
                rDBMSSiteSet.setCheckedOutByMe(false);
            }
        }
    }

    private boolean canDoCheckOut() {
        boolean bl = false;
        RDBMSSiteSet rDBMSSiteSet = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        if (!rDBMSSiteSet.isCheckedOut() && abstractRepositoryManager.isConnected()) {
            bl = rDBMSSiteSet.getRepositoryOID() != null;
        }
        return bl;
    }

    private boolean canDoCheckIn() {
        boolean bl = false;
        RDBMSSiteSet rDBMSSiteSet = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        if (rDBMSSiteSet.isCheckedOut() && abstractRepositoryManager.isConnected() && rDBMSSiteSet.isCheckedOutByMe()) {
            bl = rDBMSSiteSet.getRepositoryOID() != null;
        }
        return bl;
    }
}

