/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.OverlayLayout;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignUtilities;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.standalone_domains.ReadStAlDomains;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JTextFieldLimited;
import oracle.dbtools.crest.util.gui.swing.SortedJComboBoxModel;
import oracle.dbtools.crest.util.gui.swing.SortedJListModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;

public class DomainAdmin
extends CustomDialog
implements ActionListener {
    private static final String EMPTY_VALUE = "";
    private static final String APPLY_TXT = Messages.getString("DomainAdmin.Apply");
    private static final String MODIFY_TXT = Messages.getString("DomainAdmin.Modify");
    private LogicalDatatype[] logicalDatatypes = new LogicalDatatype[0];
    private boolean isSaved = true;
    private String fileName;
    private JDialog dialog;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnApply;
    private JButton btnSave;
    private JButton btnClose;
    private JButton btnOpen;
    private JButton bnCheckConstraint;
    private JButton bnRanges;
    private JButton bnValueList;
    private JPanel general;
    private JPanel addPanel;
    private JPanel listPanel;
    private JPanel propPanel;
    private JPanel buttonPanel;
    private JTextField tfSize;
    private JTextField tfName;
    private JTextField tfFileName;
    private JTextField tfComment;
    private JTextField tfSynonym;
    private String oldtfFileName;
    private String oldtfFileNameTooltip;
    private JComboBox cbDomainFileName;
    private JIntegerField tfPrecision;
    private JIntegerField tfScale;
    private JTextField tfUnitOfMeasure;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private DefaultListModel allDomainsModel;
    private SortedJListModel sortedAllDomainsModel;
    private JList allDomainsList;
    private JPanel openPanel;
    private JPanel domainButtonsPanel;
    private JPanel propSubPanel1;
    private JPanel propSubPanel5;
    private JPanel pnDomainType;
    private JComboBox cbLogDataType;
    private JComboBox cbUnits;
    private String path = "";
    private String designName = "";
    private Domain currentEditDomain;
    private boolean system = true;
    private boolean isDBRepos = false;
    private JRadioButton rbRepositoryBased;
    private JRadioButton rbDesignBased;
    private JPopupMenu puMenu;
    private JMenuItem miCheckOut;
    private JMenuItem miCheckIn;
    private JMenuItem miCopy;
    private JMenuItem miPaste;
    private List lsDeleted = new ArrayList();
    private List lsAdded = new ArrayList();
    private List<DesignUtilities.AttributeRef> allAttrListForDomainChange = new ArrayList<DesignUtilities.AttributeRef>();
    private List<DesignUtilities.ColumnRef> allColListForDomainChange = new ArrayList<DesignUtilities.ColumnRef>();
    private List<DesignUtilities.AttributeRef> usedInAttributesList;
    private List<DesignUtilities.ColumnRef> usedInColumnsList;
    private List<Domain> allSelectedDomains = new ArrayList<Domain>();
    private List<Domain> allCopiedDomains = new ArrayList<Domain>();
    private List<Domain> newCopiedDomains = new ArrayList<Domain>();
    private static File lastFolder = null;
    private boolean applyMode;
    private Domain lastSelectedDomain;
    private String lastUsedDomainsFileName = null;
    private ReadStAlDomains readStAlDomains;

    public DomainAdmin(ApplicationView applicationView) {
        super(applicationView);
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        this.isDBRepos = abstractRepositoryManager.isConnected() || this.getDesign().isLoadFromDB();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DomainAdmin.DomainsAdministration"), true);
            this.dialog.setDefaultCloseOperation(0);
            this.general = new JPanel();
            this.general.setLayout(new BorderLayout());
            this.general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.general);
            this.addPanel = new JPanel(new BorderLayout());
            this.addPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.ChooseDomain")));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.propPanel = new JPanel(new GridLayout(1, 3));
            jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.DomainProperties")));
            jPanel.add((Component)this.propPanel, "North");
            this.buttonPanel = this.getButtonPanel();
            this.initAddPanel();
            this.initPropPanel();
            this.general.add((Component)this.addPanel, "West");
            this.general.add((Component)jPanel, "Center");
            this.general.add((Component)this.buttonPanel, "South");
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.refreshDomainList();
            this.enableButtons(true);
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "DOMAINS_ADMINISTRATION_DIALOG";
    }

    private JPopupMenu getPopupMenu() {
        if (this.puMenu == null) {
            this.puMenu = new JPopupMenu();
            this.miCheckOut = new JMenuItem(Messages.getString("DomainAdmin.CheckOut"));
            this.miCheckOut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DomainAdmin.this.checkOut();
                }
            });
            this.miCheckIn = new JMenuItem(Messages.getString("DomainAdmin.CheckIn"));
            this.miCheckIn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DomainAdmin.this.checkIn();
                }
            });
            this.miCopy = new JMenuItem(Messages.getString("DomainAdmin.Copy"));
            this.miCopy.setIcon(GUIConfiguration.getInstance().getIcon("COPY_ICON"));
            this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.miCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DomainAdmin.this.copyDomains();
                }
            });
            this.puMenu.add(this.miCopy);
            this.miPaste = new JMenuItem(Messages.getString("DomainAdmin.Paste"));
            this.miPaste.setIcon(GUIConfiguration.getInstance().getIcon("PASTE_ICON"));
            this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.miPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DomainAdmin.this.pasteDomains();
                }
            });
            this.puMenu.add(this.miPaste);
        }
        this.miCheckOut.setEnabled(this.canShowCheckOutFor());
        this.miCheckIn.setEnabled(this.canShowCheckInFor());
        if (this.allDomainsList != null && !this.allDomainsList.isSelectionEmpty()) {
            this.miCopy.setEnabled(true);
        } else {
            this.miCopy.setEnabled(false);
        }
        if (this.allCopiedDomains.size() != 0) {
            this.miPaste.setEnabled(true);
        } else {
            this.miPaste.setEnabled(false);
        }
        return this.puMenu;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    @Override
    protected boolean canClose() {
        return this.closeConfirmed(this.getDialog());
    }

    private void initAddPanel() {
        if (this.isDBRepos) {
            this.initDomainTypePanel();
        } else {
            this.initAddSubPanels();
            this.initOpenPanel();
        }
        this.domainButtonsPanel = new JPanel();
        this.domainButtonsPanel.setAlignmentX(0.5f);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.AvailableDomains")));
        this.listPanel.setAlignmentX(0.5f);
        this.addPanel.add((Component)this.domainButtonsPanel, "South");
        this.addPanel.add(this.listPanel);
        this.initDomainButtons();
        this.initDomainsPanel();
    }

    private void initAddSubPanels() {
        this.openPanel = new JPanel();
        this.openPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.DomainsFile")));
        this.openPanel.setAlignmentX(0.5f);
        this.addPanel.add((Component)this.openPanel, "North");
    }

    private void initDomainTypePanel() {
        this.pnDomainType = new JPanel();
        this.rbRepositoryBased = new JRadioButton(Messages.getString("DomainAdmin.RepositoryLevel"));
        this.rbRepositoryBased.setSelected(true);
        this.rbRepositoryBased.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DomainAdmin.this.refreshDomainList();
            }
        });
        this.rbDesignBased = new JRadioButton(Messages.getString("DomainAdmin.DesignLevel"));
        this.rbDesignBased.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DomainAdmin.this.refreshDomainList();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbRepositoryBased);
        buttonGroup.add(this.rbDesignBased);
        this.pnDomainType.add(this.rbRepositoryBased);
        this.pnDomainType.add(this.rbDesignBased);
        this.addPanel.add((Component)this.pnDomainType, "North");
    }

    private File selectDomainsFile() {
        Serializable serializable;
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith("defaultdomains".concat(".xml")) || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("DomainAdmin.OracleSQLDeveloperModelingDomainsFiles");
            }
        };
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(0);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setURLFilter(uRLFilter);
        if (lastFolder != null) {
            uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
        } else {
            String string = this.getApplicationView().getSettings().getDefaultDesignsPath();
            if (EMPTY_VALUE.equals(string)) {
                string = this.getApplicationView().getSettings().getDefaultSavePath();
            }
            if (EMPTY_VALUE.equals(string)) {
                string = this.getApplicationView().getSettings().getDefaultSystemTypesPath();
            }
            if (EMPTY_VALUE.equals(string)) {
                string = this.getApplicationView().getSettings().getDefaultImportPath();
            }
            if (EMPTY_VALUE.equals(string)) {
                string = this.getApplicationView().getCurrentDesign().getDesignPath();
            }
            if (string != null && string.length() > 0) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
            } else {
                serializable = this.getApplicationView().getUserHomeDirectory();
                if (serializable != null) {
                    uRLChooser.setSelectedURL((URL)serializable);
                }
            }
        }
        ApplicationView.waitLoadFilesThreadToComplete();
        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DomainAdmin.SelectDomains"));
        if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
            lastFolder = serializable.getParentFile();
            return serializable;
        }
        return null;
    }

    private void initOpenPanel() {
        this.tfFileName = new JTextField();
        this.btnOpen = new JButton(Messages.getString("DomainAdmin.Select"));
        this.btnOpen.setMnemonic(76);
        this.btnOpen.setEnabled(true);
        this.btnOpen.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DomainAdmin.this.canClose()) {
                    File file = DomainAdmin.this.selectDomainsFile();
                    if (file != null) {
                        String string = file.getName().toLowerCase();
                        if (!string.endsWith(".xml")) {
                            file = string.endsWith(".") ? new File(file.getPath() + "xml") : new File(file.getPath() + ".xml");
                        }
                        DomainAdmin.this.fileName = file.getName();
                        String string2 = FileUtils.removeExt(file.getName());
                        DomainAdmin.this.designName = string2;
                        DomainAdmin.this.oldtfFileName = DomainAdmin.this.tfFileName.getText();
                        DomainAdmin.this.tfFileName.setText(DomainAdmin.this.fileName);
                        DomainAdmin.this.fileName = string2;
                        DomainAdmin.this.path = file.getPath();
                        DomainAdmin.this.oldtfFileNameTooltip = DomainAdmin.this.tfFileName.getToolTipText();
                        DomainAdmin.this.tfFileName.setToolTipText(DomainAdmin.this.path);
                        DomainAdmin.this.readStAlDomains = new ReadStAlDomains(DomainAdmin.this.getApplicationView(), null, DomainAdmin.this.getDesign());
                        DomainAdmin.this.readStAlDomains.getDesign().setName(DomainAdmin.this.designName);
                        DomainAdmin.this.readStAlDomains.getDesign().setFileName(DomainAdmin.this.designName);
                        if (DomainAdmin.this.readStAlDomains.readDomains(file).size() == 0) {
                            JOptionPane.showMessageDialog(DomainAdmin.this.dialog, MessageFormat.format(Messages.getString("DomainAdmin.NotADomainFile"), DomainAdmin.this.tfFileName.getText()), Messages.getString("DomainAdmin.Error"), 0, null);
                            DomainAdmin.this.tfFileName.setText(DomainAdmin.this.oldtfFileName);
                            DomainAdmin.this.tfFileName.setToolTipText(DomainAdmin.this.oldtfFileNameTooltip);
                        } else {
                            DomainAdmin.this.system = false;
                            DomainAdmin.this.refreshDomainList();
                            DomainAdmin.this.enableButtons(true);
                        }
                    }
                    DomainAdmin.this.isSaved = true;
                    DomainAdmin.this.btnSave.setEnabled(false);
                }
            }
        });
        this.tfFileName.setPreferredSize(new Dimension(180, 20));
        this.openPanel.add(this.tfFileName);
        this.openPanel.add(this.btnOpen);
        this.tfFileName.setEditable(false);
    }

    protected void enableButtons(boolean bl) {
        this.btnAdd.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
        this.btnApply.setEnabled(bl);
    }

    private void initPropPanel() {
        this.initPropSubPanels();
        this.editableAll(false);
    }

    private void initPropSubPanels() {
        this.propSubPanel1 = new JPanel();
        this.propSubPanel1.setLayout(new GridLayout(0, 1));
        this.propSubPanel1.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propPanel.add(this.propSubPanel1);
        this.propSubPanel5 = new JPanel();
        this.propSubPanel5.setLayout(new GridLayout(0, 1));
        this.propSubPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propPanel.add(this.propSubPanel5);
        this.initSubPanel1();
        this.initSubPanel5();
    }

    private void initSubPanel1() {
        JLabel jLabel = new JLabel(Messages.getString("DomainAdmin.Name"));
        this.propSubPanel1.add(jLabel);
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(180, 20));
        this.setBG(this.tfName);
        this.propSubPanel1.add(this.tfName);
        JLabel jLabel2 = new JLabel(Messages.getString("DomainAdmin.LogicalType"));
        this.propSubPanel1.add(jLabel2);
        this.cbLogDataType = new JComboBox<Object>(this.getLogDataTypes());
        this.cbLogDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbLogDataType.setMaximumRowCount(20);
        this.cbLogDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.setBG(this.cbLogDataType);
        this.propSubPanel1.add(this.cbLogDataType);
        JLabel jLabel3 = new JLabel(Messages.getString("DomainAdmin.Size"));
        this.propSubPanel1.add(jLabel3);
        this.tfSize = new JTextField();
        this.setBG(this.tfSize);
        this.tfSize.setPreferredSize(this.tfName.getPreferredSize());
        this.propSubPanel1.add(this.tfSize);
        JLabel jLabel4 = new JLabel(Messages.getString("DomainAdmin.Units"));
        this.propSubPanel1.add(jLabel4);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbUnits);
        this.propSubPanel1.add(this.cbUnits);
        JLabel jLabel5 = new JLabel(Messages.getString("DomainAdmin.Precision"));
        this.propSubPanel1.add(jLabel5);
        this.tfPrecision = new JIntegerField();
        this.setBG(this.tfPrecision);
        this.tfPrecision.setPreferredSize(this.tfName.getPreferredSize());
        this.propSubPanel1.add(this.tfPrecision);
        JLabel jLabel6 = new JLabel(Messages.getString("DomainAdmin.Scale"));
        this.propSubPanel1.add(jLabel6);
        this.tfScale = new JIntegerField();
        this.setBG(this.tfScale);
        this.tfScale.setPreferredSize(this.tfName.getPreferredSize());
        this.propSubPanel1.add(this.tfScale);
        JLabel jLabel7 = new JLabel(Messages.getString("DomainAdmin.DomainsFile"));
        this.propSubPanel1.add(jLabel7);
        SortedJComboBoxModel sortedJComboBoxModel = new SortedJComboBoxModel();
        this.cbDomainFileName = new JComboBox(sortedJComboBoxModel);
        this.cbDomainFileName.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbDomainFileName);
        this.propSubPanel1.add(this.cbDomainFileName);
    }

    private void initSubPanel5() {
        Dimension dimension = new Dimension(170, 20);
        JLabel jLabel = new JLabel(Messages.getString("DomainAdmin.Synonym"));
        this.propSubPanel5.add(jLabel);
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(dimension);
        this.setBG(this.tfSynonym);
        this.propSubPanel5.add(this.tfSynonym);
        JLabel jLabel2 = new JLabel(Messages.getString("DomainAdmin.Comments"));
        this.propSubPanel5.add(jLabel2);
        this.tfComment = new JTextField();
        this.tfComment.setPreferredSize(dimension);
        this.setBG(this.tfComment);
        this.propSubPanel5.add(this.tfComment);
        JLabel jLabel3 = new JLabel(Messages.getString("DomainAdmin.UnitOfMeasure"));
        this.propSubPanel5.add(jLabel3);
        this.tfUnitOfMeasure = new JTextFieldLimited(30);
        this.tfUnitOfMeasure.setPreferredSize(dimension);
        this.setBG(this.tfUnitOfMeasure);
        this.propSubPanel5.add(this.tfUnitOfMeasure);
        JLabel jLabel4 = new JLabel(Messages.getString("DomainAdmin.DefaultValue"));
        this.propSubPanel5.add(jLabel4);
        JPanel jPanel = new JPanel();
        OverlayLayout overlayLayout = new OverlayLayout(jPanel);
        jPanel.setLayout(overlayLayout);
        this.cbDefaultValue = new JComboBox();
        this.cbDefaultValue.setPreferredSize(dimension);
        this.cbDefaultValue.setMaximumRowCount(20);
        this.setBG(this.cbDefaultValue);
        this.cbDefaultValue.setVisible(false);
        jPanel.add(this.cbDefaultValue);
        this.tfDefaultValue = new JTextField();
        this.tfDefaultValue.setPreferredSize(dimension);
        this.setBG(this.tfDefaultValue);
        this.tfDefaultValue.setVisible(true);
        jPanel.add(this.tfDefaultValue);
        this.propSubPanel5.add(jPanel);
        this.propSubPanel5.add(new JLabel(EMPTY_VALUE));
        this.bnCheckConstraint = new JButton(Messages.getString("DomainAdmin.CheckConstraint"));
        this.bnCheckConstraint.setMnemonic(69);
        this.propSubPanel5.add(this.bnCheckConstraint);
        this.bnCheckConstraint.setPreferredSize(dimension);
        this.bnCheckConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DomainAdmin.this.currentEditDomain != null) {
                    Object object;
                    if (DomainAdmin.this.currentEditDomain.getCheck() == null) {
                        object = new CheckConstraint();
                        DomainAdmin.this.currentEditDomain.setCheck((CheckConstraint)object);
                    }
                    if (DomainAdmin.this.currentEditDomain.getCheck().getDesign() == null) {
                        DomainAdmin.this.currentEditDomain.getCheck().setDesign(DomainAdmin.this.getSelectedDomain().getDesign());
                    }
                    object = new CECheckConstraint((Dialog)((JDialog)DomainAdmin.this.getDialog()), DomainAdmin.this.getApplicationView(), !DomainAdmin.this.applyMode);
                    ((CECheckConstraint)object).configureEditComponentFor(DomainAdmin.this.currentEditDomain.getCheck());
                    ((CECheckConstraint)object).doEditing(DomainAdmin.this.currentEditDomain.getCheck());
                }
            }
        });
        this.propSubPanel5.add(new JLabel(EMPTY_VALUE));
        this.bnRanges = new JButton(Messages.getString("DomainAdmin.Ranges"));
        this.propSubPanel5.add(this.bnRanges);
        this.bnRanges.setMnemonic(78);
        this.bnRanges.setPreferredSize(dimension);
        this.bnRanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DomainAdmin.this.currentEditDomain != null) {
                    AVTEditor aVTEditor = new AVTEditor((Dialog)((JDialog)DomainAdmin.this.getDialog()), !DomainAdmin.this.applyMode);
                    aVTEditor.configureEditComponentFor(DomainAdmin.this.currentEditDomain, (LogicalDatatype)DomainAdmin.this.cbLogDataType.getSelectedItem());
                    aVTEditor.doEditing(DomainAdmin.this.currentEditDomain);
                }
            }
        });
        this.propSubPanel5.add(new JLabel(EMPTY_VALUE));
        this.bnValueList = new JButton(Messages.getString("DomainAdmin.ValueList"));
        this.bnValueList.setMnemonic(86);
        this.propSubPanel5.add(this.bnValueList);
        this.bnValueList.setPreferredSize(dimension);
        this.bnValueList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DomainAdmin.this.currentEditDomain != null) {
                    Object object;
                    if (DomainAdmin.this.currentEditDomain.getValueList() == null) {
                        object = new ConstraintEnumeration();
                        DomainAdmin.this.currentEditDomain.setValueList((ConstraintEnumeration)object);
                    }
                    object = new ValueListEditorEx((Dialog)((JDialog)DomainAdmin.this.getDialog()), !DomainAdmin.this.applyMode);
                    ((ValueListEditorEx)object).configureEditComponentFor(DomainAdmin.this.currentEditDomain.getValueList());
                    ((ValueListEditorEx)object).doEditing(DomainAdmin.this.currentEditDomain);
                }
            }
        });
    }

    private void setDefaultValueUI() {
        Domain domain = (Domain)this.allDomainsList.getSelectedValue();
        if (domain != null) {
            Object[] objectArray = null;
            if (domain.getValueList() != null && !domain.getValueList().isEmpty()) {
                objectArray = domain.getValues().toArray();
            }
            if (objectArray != null) {
                Object[] objectArray2 = new Object[objectArray.length + 1];
                objectArray2[0] = EMPTY_VALUE;
                int n = 0;
                String string = domain.getDefaultValue();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i + 1] = objectArray[i];
                    if (string == null || !string.equals(objectArray[i].toString())) continue;
                    n = i + 1;
                }
                this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(objectArray2));
                this.cbDefaultValue.setSelectedIndex(n);
                this.cbDefaultValue.setVisible(true);
                this.tfDefaultValue.setVisible(false);
            } else {
                this.tfDefaultValue.setText(domain.getDefaultValue());
                this.tfDefaultValue.setVisible(true);
                this.cbDefaultValue.setVisible(false);
            }
        } else {
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    private boolean canShowCheckOutFor() {
        boolean bl = false;
        Object e = this.allDomainsList.getSelectedValue();
        if (e != null) {
            Domain domain = (Domain)e;
            AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            if (!domain.isCheckedOut() && abstractRepositoryManager.isConnected()) {
                bl = domain.getRepositoryOID() != null;
            }
        }
        return bl;
    }

    private boolean canShowCheckInFor() {
        boolean bl = false;
        Object e = this.allDomainsList.getSelectedValue();
        if (e != null) {
            Domain domain = (Domain)e;
            AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            if (domain.isCheckedOut() && abstractRepositoryManager.isConnected() && domain.isCheckedOutByMe()) {
                bl = domain.getRepositoryOID() != null;
            }
        }
        return bl;
    }

    public void checkOut() {
        Object e = this.allDomainsList.getSelectedValue();
        if (e != null) {
            Domain domain = (Domain)e;
            AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            boolean bl = false;
            if (abstractRepositoryManager.isConnected()) {
                String string = null;
                try {
                    string = abstractRepositoryManager.getCheckoutByUser(domain);
                }
                catch (SQLException sQLException) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("DomainAdmin.ErrorInCheckout"), sQLException.getMessage()}, Messages.getString("DomainAdmin.CheckoutError"), 0);
                }
                if (string != null) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DomainAdmin.CheckoutBy"), domain.getName(), string), Messages.getString("DomainAdmin.CheckoutError"), 0);
                    domain.setCheckedOut(true);
                    domain.setCheckedOutByMe(false);
                }
                if (bl = abstractRepositoryManager.checkOutObject(domain)) {
                    domain.setCheckedOutByMe(true);
                    this.editableAll(true);
                }
            }
        }
    }

    public void checkIn() {
        Object e = this.allDomainsList.getSelectedValue();
        if (e != null) {
            Domain domain = (Domain)e;
            AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            boolean bl = false;
            if (abstractRepositoryManager.isConnected()) {
                if (domain.isDirty()) {
                    abstractRepositoryManager.writeObject(domain);
                    domain.setDirty(false);
                }
                if (bl = abstractRepositoryManager.checkInObject(domain)) {
                    domain.setCheckedOut(false);
                    domain.setCheckedOutByMe(false);
                }
            }
        }
    }

    public void copyDomains() {
        this.allCopiedDomains.clear();
        int[] nArray = this.allDomainsList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            Domain domain = (Domain)this.allDomainsList.getModel().getElementAt(nArray[i]);
            this.allCopiedDomains.add(domain);
        }
    }

    public void pasteDomains() {
        this.newCopiedDomains.clear();
        for (int i = 0; i < this.allCopiedDomains.size(); ++i) {
            String string = this.createNewDomainName(this.allCopiedDomains.get(i).getName(), false);
            Domain domain = this.getDesign().getDomainSet().createDomain();
            Domain domain2 = this.allCopiedDomains.get(i);
            domain2.copyTo(domain);
            domain.setDesign(domain2.getDesign());
            domain.setFileName(this.allCopiedDomains.get(i).getFileName());
            domain.setName(string);
            if (this.tfFileName.getText().equals(EMPTY_VALUE)) {
                this.addDomain(domain);
            }
            this.allDomainsModel.addElement(domain);
            this.newCopiedDomains.add(domain);
        }
        int[] nArray = new int[this.newCopiedDomains.size()];
        for (int i = 0; i < this.newCopiedDomains.size(); ++i) {
            nArray[i] = this.sortedAllDomainsModel.toSortedModelIndex(this.allDomainsModel.indexOf(this.newCopiedDomains.get(i)));
        }
        this.allDomainsList.setSelectedIndices(nArray);
        this.isSaved = false;
        this.btnSave.setEnabled(true);
    }

    private Object[] getLogDataTypes() {
        if (this.getDesign() != null) {
            this.logicalDatatypes = (LogicalDatatype[])this.getDesign().getLogicalDatatypeSet().toArray();
        } else {
            Design design = new Design(this.getApplicationView());
            this.logicalDatatypes = (LogicalDatatype[])design.getLogicalDatatypeSet().toArray();
        }
        return this.logicalDatatypes;
    }

    private Domain getSelectedDomain() {
        return (Domain)this.allDomainsList.getSelectedValue();
    }

    protected void setProperties() {
        String string;
        Domain domain = this.lastSelectedDomain;
        if (domain == null) {
            domain = this.readStAlDomains.getDomainSet().createDomain();
            if ("defaultdomains".equalsIgnoreCase(this.fileName)) {
                domain.setOwnerDesignName("System");
            } else {
                domain.setOwnerDesignName(this.designName);
                domain.setFileName(this.fileName);
            }
            this.allDomainsModel.addElement(domain);
            this.allDomainsList.updateUI();
        }
        domain.setName(this.tfName.getText());
        this.tfName.setText(domain.getName());
        domain.setSynonym(this.tfSynonym.getText());
        domain.setComment(this.tfComment.getText());
        domain.setUnitOfMeasure(this.tfUnitOfMeasure.getText());
        this.fileName = (String)this.cbDomainFileName.getSelectedItem();
        if (this.isValidFileName(this.fileName)) {
            domain.setFileName((String)this.cbDomainFileName.getSelectedItem());
            this.lastUsedDomainsFileName = (String)this.cbDomainFileName.getSelectedItem();
        } else {
            if (this.lastUsedDomainsFileName == null) {
                this.lastUsedDomainsFileName = "defaultdomains";
            }
            JOptionPane.showMessageDialog(this.dialog, MessageFormat.format(Messages.getString("DomainAdmin.InvalidFileName"), this.lastUsedDomainsFileName), Messages.getString("DomainAdmin.Error"), 0, null);
            this.cbDomainFileName.addItem(this.lastUsedDomainsFileName);
            this.cbDomainFileName.setSelectedItem(this.lastUsedDomainsFileName);
            domain.setFileName(this.lastUsedDomainsFileName);
        }
        this.allDomainsList.updateUI();
        domain.setOwnerDesignName(domain.getOwnerDesignName());
        domain.setPersisted(true);
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbLogDataType.getSelectedItem();
        String string2 = this.tfSize.getText().trim();
        if (string2.length() > 0 && (string = (String)this.cbUnits.getSelectedItem()).length() > 0) {
            string2 = string2 + " " + string;
        }
        domain.setDataTypeParameter("size", string2);
        domain.setDataTypeParameter("precision", this.tfPrecision.getText());
        domain.setDataTypeParameter("scale", this.tfScale.getText());
        domain.setLogicalDatatype(logicalDatatype);
        if (this.cbDefaultValue.isVisible()) {
            domain.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            domain.setDefaultValue(this.tfDefaultValue.getText());
        }
        this.editableAll(false);
        if (this.currentEditDomain != null) {
            DomainPropertiesComparator.copyCheckConstrant(this.currentEditDomain, domain);
            DomainPropertiesComparator.copyLOVConstrant(this.currentEditDomain, domain);
            DomainPropertiesComparator.copyRangeConstrant(this.currentEditDomain, domain);
        }
        if (domain.getCheck() != null && domain.getCheck().isEmpty()) {
            domain.setCheck(null);
        }
        if (domain.getValueList() != null && domain.getValueList().isEmpty()) {
            domain.setValueList(null);
        }
        if (this.system) {
            domain.setDirty(true);
            this.getDesign().setSaveDefaultDomains(true);
        }
    }

    private void initDomainsPanel() {
        this.initDomains();
    }

    private void initDomains() {
        this.lsDeleted.clear();
        this.lsAdded.clear();
        this.allDomainsModel = new DefaultListModel();
        this.sortedAllDomainsModel = new SortedJListModel(this.allDomainsModel);
        this.allDomainsList = new JList(this.sortedAllDomainsModel);
        this.allDomainsList.setSelectionMode(2);
        this.allDomainsList.setCellRenderer(new DomainCellRenderer());
        this.allDomainsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DomainAdmin.this.currentEditDomain != null && DomainAdmin.this.applyMode) {
                    int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("DomainAdmin.ModifiedDomainMessage"), Messages.getString("DomainAdmin.ModifiedDomain"), 0);
                    if (n == 0) {
                        DomainAdmin.this.applyButtonClicked();
                    }
                    DomainAdmin.this.applyMode = false;
                }
                DomainAdmin.this.lastSelectedDomain = (Domain)DomainAdmin.this.allDomainsList.getSelectedValue();
                if (DomainAdmin.this.lastSelectedDomain != null) {
                    DomainAdmin.this.clear();
                    DomainAdmin.this.tfName.setText(DomainAdmin.this.lastSelectedDomain.getName());
                    DomainAdmin.this.tfSynonym.setText(DomainAdmin.this.lastSelectedDomain.getSynonym());
                    DomainAdmin.this.cbLogDataType.setSelectedIndex(DomainAdmin.this.getIndexOfLogType(DomainAdmin.this.lastSelectedDomain.getLogicalDatatype()));
                    DomainAdmin.this.cbDomainFileName.insertItemAt(DomainAdmin.this.lastSelectedDomain.getFileName(), 1);
                    DomainAdmin.this.cbDomainFileName.setSelectedIndex(1);
                    String string = DomainAdmin.this.lastSelectedDomain.getDataTypeParameter("size");
                    if (string != null && string.length() > 0) {
                        String[] stringArray = string.split(" ");
                        DomainAdmin.this.tfSize.setText(stringArray[0]);
                        if (stringArray.length == 2) {
                            DomainAdmin.this.cbUnits.setSelectedItem(stringArray[1]);
                        }
                    }
                    try {
                        DomainAdmin.this.tfPrecision.setText(DomainAdmin.this.lastSelectedDomain.getDataTypeParameter("precision"));
                    }
                    catch (RuntimeException runtimeException) {
                        DomainAdmin.this.tfPrecision.setEditable(false);
                    }
                    try {
                        DomainAdmin.this.tfScale.setText(DomainAdmin.this.lastSelectedDomain.getDataTypeParameter("scale"));
                    }
                    catch (RuntimeException runtimeException) {
                        DomainAdmin.this.tfScale.setEditable(false);
                    }
                    DomainAdmin.this.setDefaultValueUI();
                    DomainAdmin.this.tfUnitOfMeasure.setText(DomainAdmin.this.lastSelectedDomain.getUnitOfMeasure());
                    DomainAdmin.this.tfComment.setText(DomainAdmin.this.lastSelectedDomain.getComment());
                    DomainAdmin.this.tfComment.setCaretPosition(0);
                    DomainAdmin.this.currentEditDomain = new Domain(DomainAdmin.this.lastSelectedDomain.getDesignPart());
                    DomainAdmin.this.lastSelectedDomain.copyTo(DomainAdmin.this.currentEditDomain);
                    DomainAdmin.this.currentEditDomain.setDesign(DomainAdmin.this.lastSelectedDomain.getDesign());
                    if (DomainAdmin.this.isDBRepos) {
                        if (DomainAdmin.this.lastSelectedDomain.isCheckedOutByMe()) {
                            DomainAdmin.this.editableAll(true);
                        } else {
                            DomainAdmin.this.editableAll(false);
                        }
                    } else {
                        DomainAdmin.this.editableAll(false);
                        if (DomainAdmin.this.lastSelectedDomain.isReadOnly()) {
                            DomainAdmin.this.btnRemove.setEnabled(false);
                            DomainAdmin.this.btnApply.setEnabled(false);
                        } else {
                            DomainAdmin.this.btnRemove.setEnabled(true);
                            DomainAdmin.this.btnApply.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.allDomainsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    DomainAdmin.this.btnApply.doClick();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    DomainAdmin.this.getPopupMenu().show(DomainAdmin.this.allDomainsList, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.allDomainsList);
        jScrollPane.setPreferredSize(new Dimension(100, 300));
        this.listPanel.add(jScrollPane);
    }

    protected void initDomainButtons() {
        this.btnAdd = new JButton(Messages.getString("DomainAdmin.Add"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Domain domain = DomainAdmin.this.addDomain(null);
                DomainAdmin.this.allDomainsModel.addElement(domain);
                DomainAdmin.this.allDomainsList.setSelectedIndex(DomainAdmin.this.sortedAllDomainsModel.toSortedModelIndex(DomainAdmin.this.allDomainsModel.indexOf(domain)));
                DomainAdmin.this.editableAll(DomainAdmin.this.allDomainsList, true);
            }
        });
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setEnabled(false);
        this.btnRemove = new JButton(Messages.getString("DomainAdmin.Remove"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Domain domain;
                int n;
                boolean bl = false;
                DomainAdmin.this.allSelectedDomains.clear();
                boolean bl2 = false;
                int[] nArray = DomainAdmin.this.allDomainsList.getSelectedIndices();
                for (n = 0; n < nArray.length; ++n) {
                    domain = (Domain)DomainAdmin.this.allDomainsList.getModel().getElementAt(nArray[n]);
                    DomainAdmin.this.allSelectedDomains.add(domain);
                }
                bl = DomainAdmin.this.checkIfUsed(DomainAdmin.this.allSelectedDomains);
                if (bl) {
                    for (n = 0; n < nArray.length; ++n) {
                        domain = (Domain)DomainAdmin.this.allDomainsList.getModel().getElementAt(nArray[n]);
                        if (!domain.isReadOnly()) {
                            DomainSet domainSet;
                            Design design = DomainAdmin.this.getDesign();
                            if (design != null && (domainSet = design.getDomainSet()).contains(domain)) {
                                domainSet.remove(domain);
                                DomainAdmin.this.lsDeleted.add(domain);
                            }
                            if (DomainAdmin.this.system) {
                                design.setSaveDefaultDomains(true);
                            } else if (DomainAdmin.this.readStAlDomains != null) {
                                DomainAdmin.this.readStAlDomains.getDomainSet().remove(domain);
                            }
                        }
                        bl2 = true;
                    }
                    if (bl2) {
                        DomainAdmin.this.btnSave.setEnabled(true);
                        DomainAdmin.this.isSaved = false;
                        DomainAdmin.this.refreshDomainList();
                        DomainAdmin.this.clear();
                        DomainAdmin.this.editableAll(false);
                    }
                }
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.btnApply = new JButton();
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DomainAdmin.this.applyButtonClicked();
            }
        });
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.setMnemonic(77);
        this.domainButtonsPanel.add(this.btnAdd);
        this.domainButtonsPanel.add(this.btnRemove);
        this.domainButtonsPanel.add(this.btnApply);
    }

    private void applyButtonClicked() {
        if (this.applyMode) {
            this.applyMode = false;
            if (this.canApply()) {
                if (AbstractDataType.parseSize(this.tfSize.getText()) != -1) {
                    this.setProperties();
                    this.isSaved = false;
                    this.btnSave.setEnabled(true);
                } else {
                    this.okConfirmed(this.dialog);
                }
                this.setDefaultValueUI();
            }
        } else {
            this.editableAll(true);
            this.btnApply.setMnemonic(89);
        }
    }

    private boolean checkIfUsed(List list) {
        boolean bl = false;
        String string = EMPTY_VALUE;
        String string2 = EMPTY_VALUE;
        for (Domain domain : list) {
            this.usedInAttributesList = DesignUtilities.extractUsedInAttributes(domain.getDesign(), domain, (short)0);
            this.usedInColumnsList = DesignUtilities.extractUsedInColumns(domain.getDesign(), domain, (short)0);
            if (this.usedInAttributesList.size() > 0 || this.usedInColumnsList.size() > 0) {
                this.allAttrListForDomainChange.addAll(this.usedInAttributesList);
                this.allColListForDomainChange.addAll(this.usedInColumnsList);
                string = string + ",\n" + domain.getName();
                continue;
            }
            string2 = string2 + ",\n" + domain.getName();
        }
        if (string.length() > 0) {
            string = string.substring(1, string.length());
        }
        if (!string.equals(EMPTY_VALUE)) {
            int n = JOptionPane.showConfirmDialog(this, MessageFormat.format(Messages.getString("DomainAdmin.TheDomainsAreUsed"), string), Messages.getString("DomainAdmin.SelectOption"), 0);
            if (n == 1) {
                this.allAttrListForDomainChange.clear();
                this.allColListForDomainChange.clear();
                bl = false;
            } else {
                bl = n == 0;
            }
        }
        if (!string2.equals(EMPTY_VALUE)) {
            bl = string.equals(EMPTY_VALUE) || bl;
        }
        return bl;
    }

    protected void refreshDomainList() {
        this.allDomainsModel.clear();
        this.clear();
        if (this.isDBRepos) {
            if (this.getDesign() != null) {
                Domain[] domainArray = (Domain[])this.getDesign().getDomainSet().toArray();
                for (int i = 0; i < domainArray.length; ++i) {
                    Domain domain = domainArray[i];
                    if (this.rbRepositoryBased.isSelected()) {
                        if (!domain.isDefault()) continue;
                        this.allDomainsModel.addElement(domain);
                        continue;
                    }
                    if (domain.isDefault()) continue;
                    this.allDomainsModel.addElement(domain);
                }
            }
        } else if (this.system) {
            if (this.getDesign() != null) {
                Domain[] domainArray = (Domain[])this.getDesign().getDomainSet().toArray();
                for (int i = 0; i < domainArray.length; ++i) {
                    Domain domain = domainArray[i];
                    this.allDomainsModel.addElement(domain);
                }
            }
        } else if (this.readStAlDomains != null) {
            Domain[] domainArray = (Domain[])this.readStAlDomains.getDomainSet().toArray();
            for (int i = 0; i < domainArray.length; ++i) {
                Domain domain = domainArray[i];
                this.allDomainsModel.addElement(domain);
            }
        }
        this.allDomainsList.updateUI();
    }

    protected void editableAll(boolean bl) {
        this.tfName.setEnabled(bl);
        this.tfName.setEditable(bl);
        this.tfSynonym.setEnabled(bl);
        this.tfSynonym.setEditable(bl);
        this.tfComment.setEnabled(bl);
        this.tfComment.setEditable(bl);
        this.tfUnitOfMeasure.setEnabled(bl);
        this.tfUnitOfMeasure.setEditable(bl);
        this.cbLogDataType.setEnabled(bl);
        this.cbUnits.setEnabled(bl);
        this.tfSize.setEnabled(bl);
        this.tfSize.setEditable(bl);
        this.tfPrecision.setEnabled(bl);
        this.tfPrecision.setEditable(bl);
        this.tfScale.setEnabled(bl);
        this.tfScale.setEditable(bl);
        this.tfDefaultValue.setEnabled(bl);
        this.tfDefaultValue.setEditable(bl);
        this.cbDefaultValue.setEnabled(bl);
        if (bl && this.cbDomainFileName.getSelectedItem() != null) {
            if (((String)this.cbDomainFileName.getSelectedItem()).equals("defaultdomains") || !this.tfFileName.getText().isEmpty()) {
                this.cbDomainFileName.setEditable(false);
                this.cbDomainFileName.setEnabled(false);
            } else {
                this.cbDomainFileName.setEditable(bl);
                this.cbDomainFileName.setEnabled(bl);
            }
        } else {
            this.cbDomainFileName.setEditable(bl);
            this.cbDomainFileName.setEnabled(bl);
        }
        Domain domain = (Domain)this.allDomainsList.getSelectedValue();
        if (domain == null || domain.isReadOnly()) {
            this.bnCheckConstraint.setEnabled(false);
            this.bnRanges.setEnabled(false);
            this.bnValueList.setEnabled(false);
        } else {
            this.bnCheckConstraint.setEnabled(true);
            this.bnRanges.setEnabled(true);
            this.bnValueList.setEnabled(true);
        }
        this.btnApply.setText(bl ? APPLY_TXT : MODIFY_TXT);
        this.applyMode = bl;
    }

    protected void editableAll(JList jList, boolean bl) {
        this.editableAll(bl);
        if (!this.getDesign().isNewDesign()) {
            if (this.tfFileName.getText().isEmpty()) {
                int n = jList.getModel().getSize();
                for (int i = 0; i < n; ++i) {
                    if (this.contains(this.cbDomainFileName, ((Domain)jList.getModel().getElementAt(i)).getFileName())) continue;
                    this.cbDomainFileName.insertItemAt(((Domain)jList.getModel().getElementAt(i)).getFileName(), this.cbDomainFileName.getComponentCount());
                }
                if (this.lastUsedDomainsFileName != null) {
                    this.cbDomainFileName.setSelectedItem(this.lastUsedDomainsFileName);
                }
                this.cbDomainFileName.setEditable(bl);
                this.cbDomainFileName.setEnabled(bl);
            } else {
                this.cbDomainFileName.removeAllItems();
                this.cbDomainFileName.insertItemAt(this.tfFileName.getText(), 0);
                this.cbDomainFileName.setSelectedItem(this.tfFileName.getText());
                this.cbDomainFileName.setEditable(false);
                this.cbDomainFileName.setEnabled(false);
            }
        }
    }

    public boolean contains(JComboBox jComboBox, Object object) {
        int n = 0;
        while (jComboBox.getItemAt(n) != null) {
            if (((String)jComboBox.getItemAt(n)).equals((String)object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void clearAll() {
        this.allDomainsModel.clear();
        this.tfFileName.setText(EMPTY_VALUE);
        this.tfName.setText(EMPTY_VALUE);
        this.tfSynonym.setText(EMPTY_VALUE);
        this.tfComment.setText(EMPTY_VALUE);
        this.tfUnitOfMeasure.setText(EMPTY_VALUE);
        this.tfSize.setText(EMPTY_VALUE);
        this.tfPrecision.setText(EMPTY_VALUE);
        this.tfScale.setText(EMPTY_VALUE);
        this.tfDefaultValue.setText(EMPTY_VALUE);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(1, 4, 5, 5));
            this.btnSave = new JButton(Messages.getString("DomainAdmin.Save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DomainAdmin.this.system) {
                        DomainAdmin.this.saveCurrentDesignDomains(DomainAdmin.this.getDesign());
                    } else {
                        XMLTransformationManager xMLTransformationManager = ApplicationView.getInstance().getXMLTransformationManager();
                        String string = new File(DomainAdmin.this.path).getName();
                        int n = string.lastIndexOf(46);
                        if (n > 0) {
                            string = string.substring(0, n);
                        }
                        DomainFileWrapper domainFileWrapper = new DomainFileWrapper(DomainAdmin.this.getDesign(), string, false);
                        List list = domainFileWrapper.getDomains();
                        Object[] objectArray = DomainAdmin.this.allDomainsModel.toArray();
                        for (int i = 0; i < objectArray.length; ++i) {
                            list.add(objectArray[i]);
                        }
                        Document document = xMLTransformationManager.getXMLContent(domainFileWrapper);
                        if (document != null) {
                            XMLTransformationManager.saveDocument(DomainAdmin.this.path, document, false);
                        }
                        DomainAdmin.this.refreshSystemDomains();
                    }
                    ApplicationView.log(Messages.getString("DomainAdmin.DomainsSaved"));
                    DomainAdmin.this.isSaved = true;
                    DomainAdmin.this.btnSave.setEnabled(false);
                    DomainAdmin.this.editableAll(false);
                    DomainAdmin.this.lsDeleted.clear();
                    DomainAdmin.this.lsAdded.clear();
                }
            });
            this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnSave.setMnemonic(83);
            this.btnSave.setEnabled(false);
            this.btnClose = new JButton(Messages.getString("DomainAdmin.Close"));
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DomainAdmin.this.canClose()) {
                        DomainAdmin.this.close(DomainAdmin.this.getDialog());
                    }
                }
            });
            this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnClose.setMnemonic(67);
            JButton jButton = new JButton(this.getHelpAction());
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.setMnemonic(72);
            if (!this.isDBRepos) {
                jPanel.add(this.btnSave);
            }
            jPanel.add(this.btnClose);
            jPanel.add(jButton);
            this.buttonPanel.add((Component)jPanel, "East");
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel jPanel) {
        return (SpringLayout)jPanel.getLayout();
    }

    public void setBG(Component component) {
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void close(Window window) {
        if (this.getDesign() != null) {
            for (Domain domain : this.lsAdded) {
                this.getDesign().getDomainSet().remove(domain);
            }
            for (Domain domain : this.lsDeleted) {
                this.getDesign().getDomainSet().add(domain);
            }
        }
        window.dispose();
    }

    private boolean closeConfirmed(Window window) {
        if (!this.isDBRepos && !this.isSaved) {
            String string = Messages.getString("DomainAdmin.Yes");
            String string2 = Messages.getString("DomainAdmin.No");
            Object[] objectArray = new Object[]{string, string2};
            int n = JOptionPane.showOptionDialog(window, Messages.getString("DomainAdmin.DomainsNotSaved"), Messages.getString("DomainAdmin.QuitConfirmation"), 0, 3, null, objectArray, string);
            return n == 0;
        }
        return true;
    }

    private void clear() {
        this.tfName.setText(EMPTY_VALUE);
        this.tfSynonym.setText(EMPTY_VALUE);
        this.cbLogDataType.setSelectedIndex(0);
        this.tfSize.setText(EMPTY_VALUE);
        this.cbUnits.setSelectedIndex(0);
        this.tfPrecision.setText(EMPTY_VALUE);
        this.tfScale.setText(EMPTY_VALUE);
        this.tfDefaultValue.setText(EMPTY_VALUE);
        this.tfComment.setText(EMPTY_VALUE);
        this.tfUnitOfMeasure.setText(EMPTY_VALUE);
        this.cbDomainFileName.removeAllItems();
        this.cbDomainFileName.insertItemAt(EMPTY_VALUE, 0);
    }

    public int getIndexOfLogType(LogicalDatatype logicalDatatype) {
        int n = -1;
        for (int i = 0; i < this.logicalDatatypes.length; ++i) {
            if (!this.logicalDatatypes[i].getName().equalsIgnoreCase(logicalDatatype.getName())) continue;
            n = i;
        }
        return n;
    }

    private void okConfirmed(JDialog jDialog) {
        JOptionPane.showMessageDialog(jDialog, Messages.getString("DomainAdmin.InvalidSizeFormat"), Messages.getString("DomainAdmin.Error"), 0, null);
    }

    private void saveCurrentDesignDomains(Design design) {
        Collection collection = design.getStorableDesignObjects();
        HashMap hashMap = new HashMap();
        if (design.isSaveDefaultDomains()) {
            hashMap.put("defaultdomains", new ArrayList());
        }
        Iterator iterator = collection.iterator();
        DesignObject designObject = null;
        while (iterator.hasNext()) {
            designObject = (DesignObject)iterator.next();
            this.handleDesignObject(designObject, hashMap);
        }
        ApplicationView.getInstance().getXMLTransformationManager().saveDomains(design);
        for (DesignUtilities.AttributeRef object : this.allAttrListForDomainChange) {
            if (object.getAttribute() == null) continue;
            object.getAttribute().setDomain(null);
            object.getAttribute().setDirty(true);
        }
        for (DesignUtilities.ColumnRef columnRef : this.allColListForDomainChange) {
            if (columnRef.getColumn() == null) continue;
            columnRef.getColumn().setDomain(null);
            columnRef.getColumn().setDirty(true);
        }
    }

    private void handleDesignObject(DesignObject designObject, Map map) {
        if (designObject instanceof Domain) {
            String string = ((Domain)designObject).getFileName();
            List<DesignObject> list = null;
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(designObject);
            } else {
                list = new ArrayList();
                list.add(designObject);
                map.put(string, list);
            }
        }
    }

    protected boolean canApply() {
        if (!EMPTY_VALUE.equalsIgnoreCase(this.tfName.getText()) && this.tfName.getText() != null && this.tfName.getText().trim().length() > 0) {
            return true;
        }
        MessageDialogs.showErrorMessage(this, Messages.getString("DomainAdmin.NameCanNotBeEmpty"));
        this.tfName.requestFocus();
        return false;
    }

    private void refreshSystemDomains() {
        if (this.readStAlDomains != null) {
            Domain[] domainArray = (Domain[])this.readStAlDomains.getDomainSet().toArray();
            Iterator iterator = this.getApplicationView().getDesigns().iterator();
            while (iterator.hasNext()) {
                Domain domain;
                Design design = (Design)iterator.next();
                if (design == this.getDesign()) continue;
                ArrayList<Domain> arrayList = new ArrayList<Domain>();
                for (int i = 0; i < domainArray.length; ++i) {
                    Domain domain2 = domainArray[i];
                    if (!domain2.isDefault()) continue;
                    domain = (Domain)design.getDomainSet().getByName(domain2.getName());
                    if (domain == null) {
                        domain = design.getDomainSet().createDomain();
                        domain.setDesign(design);
                        domain2.setOwnerDesignName("System");
                        domain.setFileName(domain2.getFileName());
                    }
                    domain2.copyTo(domain);
                    LogicalDatatype logicalDatatype = (LogicalDatatype)CompareModelToModel.getCorrespondingObject(design.getLogicalDatatypeSet(), domain2.getLogicalDatatype());
                    if (logicalDatatype != null) {
                        domain.setLogicalDatatype(logicalDatatype);
                    }
                    arrayList.add(domain);
                }
                Object[] objectArray = design.getDomainSet().toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    domain = (Domain)objectArray[i];
                    if (!domain.isDefault() || arrayList.contains(domain)) continue;
                    design.getDomainSet().remove(domain);
                }
            }
        }
    }

    public boolean isValidFileName(String string) {
        File file = new File(string);
        boolean bl = true;
        try {
            if (file.createNewFile()) {
                file.delete();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private String createNewDomainName(String string, Boolean bl) {
        String string2 = null;
        String string3 = null;
        int n = 1;
        int n2 = string.indexOf("_");
        string3 = n2 > 0 ? string.substring(0, n2) : string;
        if (!bl.booleanValue()) {
            string3 = string;
        }
        if (bl.booleanValue()) {
            n = this.allDomainsList.getModel().getSize();
        }
        do {
            string2 = string3 + "_" + n;
            ++n;
        } while (this.domainNameExists(string2));
        return string2;
    }

    private boolean domainNameExists(String string) {
        for (int i = 0; i < this.allDomainsList.getModel().getSize(); ++i) {
            if (!((Domain)this.allDomainsList.getModel().getElementAt(i)).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private Domain addDomain(Domain domain) {
        if (this.getDesign() != null) {
            this.clear();
            Domain domain2 = domain == null ? this.getDesign().getDomainSet().createDomain() : domain;
            if (this.isDBRepos) {
                if (this.rbRepositoryBased.isSelected()) {
                    domain2.setOwnerDesignName("System");
                    domain2.setFileName("defaultdomains");
                } else {
                    domain2.setOwnerDesignName(this.designName);
                    domain2.setFileName(this.designName);
                }
                this.lsAdded.add(domain2);
                this.refreshDomainList();
            } else if (this.system) {
                domain2.setOwnerDesignName("System");
                domain2.setFileName("defaultdomains");
                this.getDesign().setSaveDefaultDomains(true);
            } else {
                if ("defaultdomains".equalsIgnoreCase(this.fileName)) {
                    domain2.setOwnerDesignName("System");
                } else {
                    domain2.setOwnerDesignName(this.designName);
                }
                domain2.setFileName(this.fileName);
                domain2.setName(this.createNewDomainName("Domain", true));
            }
            this.isSaved = false;
            return domain2;
        }
        return null;
    }

    class DomainCellRenderer
    extends JLabel
    implements ListCellRenderer {
        DomainCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Domain domain = (Domain)object;
            this.setText(domain.getName());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            String string = "<html><body>Domain - <b>" + domain.getName() + "</b>" + "<p>" + "File - " + "<b>" + domain.getFileName() + "</b>" + "</body>" + "</html>";
            this.setToolTipText(string);
            Icon icon = GUIConfiguration.getInstance().getIcon("DOMAIN_ICON");
            if (DomainAdmin.this.isDBRepos) {
                if (domain.isCheckedOut()) {
                    if (domain.isCheckedOutByMe()) {
                        this.setIcon(GUIConfiguration.getInstance().getCheckOutIcon(icon));
                    } else {
                        this.setIcon(GUIConfiguration.getInstance().getCheckOutIconRed(icon));
                    }
                } else {
                    this.setIcon(icon);
                }
            } else {
                this.setIcon(icon);
            }
            return this;
        }
    }
}

