/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.editor.TextEditDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class CECheckConstraint
extends JDialog {
    private JDialog dialog;
    private CheckConstraint constraint;
    private CheckConstraint originalConstraint;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JButton btnCancel;
    private ApplicationView view;
    private boolean readOnly = false;
    private JButton editButton;
    private JTable constraintTable;
    private List constraintsList;
    private String description = "";
    private Dialog parent;
    KeyListener escKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u001b') {
                CECheckConstraint.this.btnCancel.doClick();
            }
        }
    };

    public CECheckConstraint(Dialog dialog, ApplicationView applicationView) {
        this(dialog, applicationView, false);
    }

    public CECheckConstraint(Dialog dialog, ApplicationView applicationView, boolean bl) {
        this.parent = dialog;
        this.view = applicationView;
        this.readOnly = bl;
    }

    public void configureEditComponentFor(CheckConstraint checkConstraint) {
        this.originalConstraint = checkConstraint;
        this.constraint = new CheckConstraint();
        this.constraint.setDesign(this.originalConstraint.getDesign());
        this.originalConstraint.copyTo(this.constraint);
        this.constraintsList = null;
    }

    public void doEditing(CheckConstraint checkConstraint) {
        this.dialog = this.getDialog();
        this.dialog.setTitle(checkConstraint.getName() + Messages.getString("CECheckConstraint.ConstraintS"));
        this.dialog.setVisible(true);
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("CECheckConstraint.Constraint"));
            this.dialog.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.setModal(true);
            this.dialog.setSize(new Dimension(600, 350));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = CECheckConstraint.this.dialog.getWidth();
                    int n2 = CECheckConstraint.this.dialog.getHeight();
                    n = Math.max(400, n);
                    n2 = Math.max(250, n2);
                    CECheckConstraint.this.dialog.setSize(n, n2);
                }
            });
        }
        this.getConstraintsList();
        CommonUtil.centerOnScreen(this.dialog);
        return this.dialog;
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.add(this.getEditButton());
            this.mainPanel.add((Component)jToolBar, "North");
            this.constraintTable = new JTable(new ConstraintTableModel());
            this.constraintTable.setSelectionMode(0);
            this.constraintTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        CECheckConstraint.this.showTextEditDialog();
                    }
                }
            });
            this.constraintTable.addKeyListener(this.escKey);
            this.constraintTable.updateUI();
            JScrollPane jScrollPane = new JScrollPane(this.constraintTable);
            this.mainPanel.add((Component)jScrollPane, "Center");
        }
        return this.mainPanel;
    }

    private void showTextEditDialog() {
        int n = this.constraintTable.getSelectedRow();
        if (this.constraintTable.getSelectedRow() != -1) {
            ConstraintObject constraintObject = (ConstraintObject)this.constraintsList.get(n);
            TextEditDialog textEditDialog = new TextEditDialog(this, this.view, constraintObject.getConstraintRule(), this.readOnly);
            textEditDialog.showDialog();
            this.constraintTable.repaint();
            constraintObject.setConstraintRule(textEditDialog.getText());
            if (!this.constraint.getLongName().equalsIgnoreCase(textEditDialog.getText())) {
                this.constraint.add(constraintObject, textEditDialog.getText());
            }
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            String string = Messages.getString("CECheckConstraint.Close");
            if (!this.readOnly) {
                JButton jButton = new JButton(Messages.getString("CECheckConstraint.OK"));
                jButton.setMnemonic(79);
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CECheckConstraint.this.setProperties();
                        CECheckConstraint.this.getDialog().setVisible(false);
                    }
                });
                this.buttonPanel.add(jButton);
                JButton jButton2 = new JButton(Messages.getString("CECheckConstraint.Apply"));
                jButton2.setMnemonic(65);
                jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CECheckConstraint.this.setProperties();
                    }
                });
                jButton2.addKeyListener(this.escKey);
                this.buttonPanel.add(jButton2);
                string = Messages.getString("CECheckConstraint.Cancel");
            }
            this.btnCancel = new JButton(string);
            this.btnCancel.setMnemonic(67);
            this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CECheckConstraint.this.getDialog().setVisible(false);
                }
            });
            this.buttonPanel.add(this.btnCancel);
        }
        return this.buttonPanel;
    }

    protected List getConstraintsList() {
        if (this.constraintsList == null) {
            this.constraintsList = new ArrayList();
            GenericConstraint genericConstraint = new GenericConstraint();
            this.constraintsList.add(new ConstraintObject(genericConstraint.getTypeName(), this.constraint.getConstraintFor(genericConstraint)));
            Object[] objectArray = this.constraint.getTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                RDBMSType rDBMSType = (RDBMSType)objectArray[i];
                String string = rDBMSType.getTypeName();
                String string2 = this.constraint.getConstraintFor(rDBMSType);
                this.constraintsList.add(new ConstraintObject(string, string2));
            }
        }
        return this.constraintsList;
    }

    protected JButton getEditButton() {
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.editButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", 16));
        this.editButton.setToolTipText(Messages.getString("CECheckConstraint.EditConstraint"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CECheckConstraint.this.showTextEditDialog();
            }
        });
        this.editButton.addKeyListener(this.escKey);
        return this.editButton;
    }

    private void setProperties() {
        int n = this.constraintTable.getEditingColumn();
        int n2 = this.constraintTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            this.constraintTable.getCellEditor(n2, n).stopCellEditing();
        }
        this.constraint.copyTo(this.originalConstraint);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    class ConstraintTableModel
    extends AbstractTableModel {
        ConstraintTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return CECheckConstraint.this.getConstraintsList().size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ConstraintObject constraintObject = (ConstraintObject)CECheckConstraint.this.constraintsList.get(n);
            if (n2 == 0) {
                return constraintObject.getTypeName();
            }
            if (n2 == 1) {
                return constraintObject.getConstraintRule();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ConstraintObject constraintObject = (ConstraintObject)CECheckConstraint.this.constraintsList.get(n);
            constraintObject.setConstraintRule((String)object);
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CECheckConstraint.Type");
            }
            if (n == 1) {
                return Messages.getString("CECheckConstraint.Constraint");
            }
            return " ";
        }
    }

    class ConstraintObject
    implements ConstraintType {
        private String typeName;
        private String constraintRule;
        private Object typeConstraint;
        private List listOfConstraints = new ArrayList();

        ConstraintObject(String string, String string2) {
            this.typeName = string;
            this.constraintRule = string2;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        public String getConstraintRule() {
            return this.constraintRule;
        }

        public void setConstraintRule(String string) {
            this.constraintRule = string;
        }

        public List getConstraintsList() {
            return this.listOfConstraints;
        }

        @Override
        public RDBMSType getParentType() {
            return (RDBMSType)this.typeConstraint;
        }

        @Override
        public void setParentType(RDBMSType rDBMSType) {
            this.typeConstraint = rDBMSType;
        }
    }
}

