/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignObjectView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SwingUIConstants;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.GUID;

public abstract class TopView
implements SwingUIConstants,
DesignObjectView,
ObjectListener {
    public static final Integer DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer RELATION_LAYER = new Integer(-1);
    public final TopView[] EMPTY_ARRAY = new TopView[0];
    protected DesignObject model;
    private String viewID = null;
    private String generatorID;
    protected ApplicationView applicationView;
    protected Dimension size = new Dimension(DPVRelational.TOPVIEW_SIZE);
    protected Point location = new Point(20, 20);
    private AbstractCellView cellView;
    protected DesignPartView dpv;
    private int viewNumber = 0;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private boolean useDefaultColor = true;
    private boolean useCustomFormat = false;

    public TopView(ApplicationView applicationView, DesignPartView designPartView) {
        this.applicationView = applicationView;
        this.dpv = designPartView;
        designPartView.registerTopView(this);
    }

    public ApplicationView getApplicationView() {
        return this.applicationView;
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public Design getDesign() {
        return this.dpv.getDesign();
    }

    @Override
    public void setModel(DesignObject designObject) {
        if (this.model != null) {
            this.model.removeObjectListener(this);
        }
        this.model = designObject;
        designObject.setTopView(this);
        this.model.addObjectListener(this);
    }

    @Override
    public DesignObject getModel() {
        return this.model;
    }

    public String getViewID() {
        if (this.viewID == null) {
            this.viewID = new GUID().toString();
        }
        return this.viewID;
    }

    public void setViewID(String string) {
        if (this.getDesign().getLoadedVersion() < 2.4f) {
            return;
        }
        this.viewID = string;
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public abstract SelectableObject getSelectableObject();

    public ContainerView createViewSynonim(DesignPartView designPartView) {
        return null;
    }

    public boolean isConnection() {
        return false;
    }

    public void makeSelected() {
        this.getDesignPartView().setCurrentSelection(this.getSelectableObject());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append('[').append(this.getModel()).append(']');
        return stringBuffer.toString();
    }

    public boolean calculateConnectionPoints() {
        return false;
    }

    public Object getLayerConstraint() {
        return DEFAULT_LAYER;
    }

    public boolean acceptsDrop(SelectableObject selectableObject) {
        return false;
    }

    public void drop(SelectableObject selectableObject) {
    }

    public boolean canRemove() {
        return true;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point point) {
        this.location = point;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public void paint(Graphics graphics) {
    }

    public void setBounds(Rectangle rectangle) {
        this.size.width = rectangle.width;
        this.size.height = rectangle.height;
        this.location.x = rectangle.x;
        this.location.y = rectangle.y;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.location, this.size);
    }

    public AbstractCellView getCellView() {
        return this.cellView;
    }

    public void setCellView(AbstractCellView abstractCellView) {
        this.cellView = abstractCellView;
    }

    public void setVisible(boolean bl) {
    }

    public String getGeneratorID() {
        return this.generatorID;
    }

    public void setGeneratorID(String string) {
        this.generatorID = string;
    }

    public Rectangle getCalculatedBounds() {
        Rectangle rectangle = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
        return rectangle;
    }

    public Color getBackgroundColor() {
        if (this.useCustomFormat()) {
            return this.backgroundColor;
        }
        return this.getModel().getBackgroundColor();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        if (!this.useCustomFormat()) {
            this.getModel().setBackgroundColor(color);
        }
    }

    public Color getForegroundColor() {
        if (this.useCustomFormat()) {
            return this.foregroundColor;
        }
        return this.getModel().getForegroundColor();
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
        if (!this.useCustomFormat()) {
            this.getModel().setForegroundColor(color);
        }
    }

    public boolean useDefaultColor() {
        if (this.useCustomFormat()) {
            return this.useDefaultColor;
        }
        return this.getModel().useDefaultColor();
    }

    public void setUseDefaultColor(boolean bl) {
        this.useDefaultColor = bl;
        if (!this.useCustomFormat()) {
            this.getModel().setUseDefaultColor(bl);
        }
    }

    public boolean useCustomFormat() {
        return this.useCustomFormat;
    }

    public void setUseCustomFormat(boolean bl) {
        this.useCustomFormat = bl;
    }

    public int getLineWidth() {
        return this.getModel().getLineWidth();
    }

    public void setLineWidth(int n) {
        this.getModel().setLineWidth(n);
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public void setViewNumber(int n) {
        this.viewNumber = n;
    }

    public int getDefaultLineWidth() {
        return 1;
    }

    public Color getDefaultLineColor() {
        return Color.BLACK;
    }

    public void sendToBack() {
        if (this.cellView != null && this.cellView.getCell() != null) {
            this.getDesignPartView().getWorkSpace().sendToBack(this.cellView.getCell());
        }
    }

    public void synchronizeBoundsWithCellView() {
        if (this.getCellView() != null && this.getCellView().getCell() != null) {
            this.setBounds(this.getCellView().getBounds().getBounds());
        }
    }
}

