/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import oracle.dbtools.crest.model.StatusBarOwner;

public class StatusBar
extends JPanel
implements ActionListener,
StatusBarOwner {
    private static final String EMPTY_MESSAGE = " ";
    private String fixedMessage = " ";
    private Timer timer = new Timer(1000, this);
    private JLabel label;

    public StatusBar() {
        this.setLayout(new GridLayout(1, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add(this.getLabel());
        this.add(jPanel);
    }

    @Override
    public void setFixedStatusMessage(String string) {
        this.timer.stop();
        this.getLabel().setText(EMPTY_MESSAGE + string);
    }

    @Override
    public void clearStatusMessage() {
        this.timer.stop();
        this.fixedMessage = EMPTY_MESSAGE;
        this.getLabel().setText(this.fixedMessage);
    }

    @Override
    public void setTempStatusMessage(String string, int n) {
        this.timer.stop();
        this.timer.setDelay(n);
        this.getLabel().setText(EMPTY_MESSAGE + string);
        this.getLabel().paintImmediately(this.getLabel().getBounds());
        this.timer.start();
    }

    @Override
    public void setTempStatusMessage(String string) {
        this.setTempStatusMessage(string, 5000);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getLabel().setText(this.fixedMessage);
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel(this.fixedMessage);
            this.label.setForeground(Color.black);
            Font font = this.label.getFont().deriveFont(0, 10.0f);
            this.label.setFont(font);
        }
        return this.label;
    }
}

