/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import oracle.dbtools.crest.fcp.preferences.ModelingPreferences;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class OpenDesignDialog
extends JDialog {
    private ApplicationView view;
    private Design design;
    private JPanel mainPanel = new JPanel();
    private JPanel buttonsPanel;
    private JScrollPane jsp;
    private JButton okButton = new JButton(Messages.getString("OpenDesignDialog.OK"));
    private JList list;
    private JCheckBox chbDontShowAgain;
    private final Preferences p = Preferences.getPreferences();

    public OpenDesignDialog(ApplicationView applicationView, Design design) {
        super(applicationView.getFrame());
        this.view = applicationView;
        this.design = design;
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getCaption());
        this.initDialog();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.centerOnScreen(this);
        this.setModal(true);
        this.setResizable(false);
    }

    private void initDialog() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(450, 300));
        this.initLogical();
        this.initRelational();
        this.initButtons();
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private void initLogical() {
    }

    public String getCaption() {
        return Messages.getString("OpenDesignDialog.SelectRelationalModels");
    }

    private void initRelational() {
        RelationalDesign[] relationalDesignArray = (RelationalDesign[])this.design.getRelationalDesigns().toArray();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                Rectangle rectangle = jList.getCellBounds(n, n);
                Object e = jList.getModel().getElementAt(n);
                if (e != null && e instanceof DesignPart && rectangle.contains(mouseEvent.getPoint())) {
                    DesignPart designPart;
                    designPart.setShouldBeOpen(!(designPart = (DesignPart)e).isShouldBeOpen());
                    jList.repaint(rectangle);
                }
            }
        };
        this.list = new JList<RelationalDesign>(relationalDesignArray);
        this.list.setCellRenderer(new CBCellRenderer());
        this.list.addMouseListener(mouseAdapter);
        this.jsp = new JScrollPane(this.list);
        this.mainPanel.add((Component)this.jsp, "Center");
    }

    private void initButtons() {
        this.buttonsPanel = new JPanel(new GridLayout(2, 0));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.buttonsPanel.add(jPanel);
        this.buttonsPanel.add(jPanel2);
        this.chbDontShowAgain = new JCheckBox(Messages.getString("OpenDesignDialog.DontShowDialogAgain"));
        this.chbDontShowAgain.setSelected(!this.view.getSettings().showSelectRelModelDialog());
        this.chbDontShowAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenDesignDialog.this.view.getSettings().setShowSelectRelModelDialog(!OpenDesignDialog.this.chbDontShowAgain.isSelected());
                ModelingPreferences modelingPreferences = ModelingPreferences.getInstance((PropertyStorage)OpenDesignDialog.this.p);
                modelingPreferences.setShowSelectRelModelDialog(!OpenDesignDialog.this.chbDontShowAgain.isSelected());
            }
        });
        jPanel.add(this.chbDontShowAgain);
        this.okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenDesignDialog.this.dispose();
            }
        });
        jPanel2.add(this.okButton);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
    }

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 3);
        jDialog.setLocation(point);
    }

    class CBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            this.setSelected(((DesignPart)object).isShouldBeOpen());
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            this.setOpaque(true);
            return this;
        }
    }
}

