/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ControllerApplication;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuPath;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectAction;

public class MenuStructure {
    private MenuPath root = MenuPath.createRoot();
    private Map pathToMenu = new HashMap();
    private Map actionMenu = new HashMap();
    private JMenuBar mbar = null;
    private String[] firstMenuNames = null;
    private String helpMenuName = null;
    private Set registeredActions = new HashSet();
    private MListener menuListener = new MListener();
    private ApplicationView appView;
    private boolean enable = true;

    public MenuStructure(ApplicationView applicationView, String[] stringArray, String string) {
        this.appView = applicationView;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.fixName(stringArray[i]);
        }
        this.firstMenuNames = stringArray;
        this.helpMenuName = this.fixName(string);
    }

    private String fixName(String string) {
        int n = string.indexOf(38);
        if (n > -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            return stringBuffer.toString();
        }
        return string;
    }

    public void put(MenuPath menuPath, JMenu jMenu) {
        this.pathToMenu.put(menuPath, jMenu);
    }

    public JMenu get(MenuPath menuPath) {
        if (!this.pathToMenu.containsKey(menuPath)) {
            JMenu jMenu = new JMenu(menuPath.getLastNodeName());
            jMenu.setName(menuPath.getLastNodeName());
            jMenu.setMnemonic(menuPath.getMnemonic());
            this.put(menuPath, jMenu);
            this.hookUpJMenu(menuPath);
        }
        return (JMenu)this.pathToMenu.get(menuPath);
    }

    public JMenu get(String[] stringArray) {
        MenuPath menuPath = this.root.getLastNodeIn(stringArray);
        return this.get(menuPath);
    }

    public JMenu getFirst(String[] stringArray) {
        MenuPath menuPath = this.root.getFirstNodeIn(stringArray);
        if (menuPath != null) {
            return this.get(menuPath);
        }
        return null;
    }

    public void remove(MDBAction mDBAction) {
        if (!this.registeredActions.contains(mDBAction)) {
            return;
        }
        JMenu jMenu = this.get(mDBAction.getMenuPath());
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || jMenuItem.getAction() == null || !jMenuItem.getAction().equals(mDBAction)) continue;
            jMenu.remove(jMenuItem);
            this.registeredActions.remove(mDBAction);
            this.actionMenu.remove(mDBAction);
            break;
        }
    }

    public void add(MDBAction mDBAction) {
        if (this.registeredActions.contains(mDBAction)) {
            return;
        }
        if (!mDBAction.getMenuPath().equals(MDBAction.DEFAULT_MENU_PATH)) {
            if (mDBAction.isPopupMenu()) {
                JMenu jMenu = new JMenu(mDBAction.getName());
                JMenu jMenu2 = this.get(mDBAction.getMenuPath());
                mDBAction.setMenu(jMenu);
                jMenu2.add(jMenu);
                this.actionMenu.put(mDBAction, jMenu2);
                this.registeredActions.add(mDBAction);
            } else {
                JMenu jMenu;
                JMenuItem jMenuItem = new JMenuItem(mDBAction.getName(), (Icon)mDBAction.getValue("SmallIcon"));
                jMenuItem.setAction(mDBAction);
                jMenuItem.setMnemonic(mDBAction.getMnemonic());
                jMenuItem.setAccelerator(mDBAction.getAccelerator());
                if (mDBAction.getToolTipText() != null) {
                    jMenuItem.setToolTipText(mDBAction.getToolTipText());
                }
                JMenu jMenu3 = this.get(mDBAction.getMenuPath());
                if (mDBAction.addSeparatorBefore()) {
                    jMenu3.addSeparator();
                }
                if (mDBAction.getPosition() > -1) {
                    jMenu3.add((Component)jMenuItem, mDBAction.getPosition());
                } else {
                    jMenu3.add(jMenuItem);
                }
                if (mDBAction.addSeparatorAfterInRoot() && (jMenu = this.getFirst(mDBAction.getMenuPath())) != null) {
                    jMenu.addSeparator();
                }
                if (mDBAction.addSeparatorAfter()) {
                    jMenu3.addSeparator();
                }
                if (mDBAction.isObjectAction()) {
                    this.showObjectMenu(true);
                    if (!jMenu3.isVisible()) {
                        jMenu3.setVisible(true);
                    }
                }
                this.actionMenu.put(mDBAction, jMenu3);
                this.registeredActions.add(mDBAction);
            }
        }
    }

    public JMenuBar getJMenuBar() {
        if (this.mbar == null) {
            this.createJMenuBar();
        }
        return this.mbar;
    }

    private JMenuBar createJMenuBar() {
        this.mbar = new JMenuBar();
        this.updateMenuItems();
        return this.mbar;
    }

    public void updateMenuItems() {
        JMenu jMenu;
        Object object;
        int n;
        HashMap<String, JMenu> hashMap = new HashMap<String, JMenu>();
        MenuPath[] menuPathArray = this.root.getChildren();
        for (n = 0; n < menuPathArray.length; ++n) {
            object = menuPathArray[n].getLastNodeName();
            jMenu = this.get(menuPathArray[n]);
            hashMap.put((String)object, jMenu);
        }
        for (n = 0; n < this.firstMenuNames.length; ++n) {
            if (!hashMap.containsKey(this.firstMenuNames[n])) continue;
            object = this.mbar.add((JMenu)hashMap.get(this.firstMenuNames[n]));
            ((JMenu)object).addMenuListener(this.menuListener);
            hashMap.remove(this.firstMenuNames[n]);
        }
        JMenu jMenu2 = null;
        if (this.helpMenuName != null && !this.helpMenuName.equals("")) {
            jMenu2 = (JMenu)hashMap.get(this.helpMenuName);
            hashMap.remove(this.helpMenuName);
        }
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            jMenu = this.mbar.add((JMenu)hashMap.get(object.next()));
            jMenu.addMenuListener(this.menuListener);
        }
        if (jMenu2 != null) {
            jMenu = this.mbar.add(jMenu2);
            jMenu.addMenuListener(this.menuListener);
        }
    }

    public void clearObjectActions() {
        Object[] objectArray = this.registeredActions.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            MDBAction mDBAction = (MDBAction)objectArray[i];
            if (!mDBAction.isObjectAction()) continue;
            JMenu jMenu = (JMenu)this.actionMenu.get(mDBAction);
            if (jMenu != null) {
                jMenu.setVisible(false);
            }
            this.remove(mDBAction);
        }
    }

    protected void hookUpJMenu(MenuPath menuPath) {
        JMenu jMenu = this.get(menuPath);
        MenuPath menuPath2 = menuPath.getParent();
        if (!menuPath2.isRoot()) {
            this.get(menuPath2).add(jMenu);
        }
    }

    public MenuPath getRoot() {
        return this.root;
    }

    public MListener getMenuListener() {
        return this.menuListener;
    }

    public void showObjectMenu(boolean bl) {
        JMenu jMenu = this.get(new String[]{AbstractController.OBJECT_CAPTION});
        if (jMenu != null) {
            jMenu.setVisible(bl);
        }
    }

    public void enableActions(boolean bl) {
        try {
            this.enable = bl;
            for (MDBAction mDBAction : this.registeredActions) {
                if (!bl) {
                    mDBAction.setOldState(mDBAction.isEnabled());
                    mDBAction.setEnabled(bl);
                    continue;
                }
                mDBAction.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class MListener
    implements MenuListener {
        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            ControllerApplication controllerApplication = MenuStructure.this.appView.getController();
            if (MenuStructure.this.enable) {
                controllerApplication.updateMenus();
            }
            for (MDBAction mDBAction : MenuStructure.this.registeredActions) {
                if (!(mDBAction instanceof SelectedObjectAction) || MenuStructure.this.appView.getCurrentDPV() == null) continue;
                SelectableObject selectableObject = MenuStructure.this.appView.getCurrentDPV().getCurrentSelection();
                mDBAction.setEnabled(((SelectedObjectAction)mDBAction).canHandle(selectableObject));
            }
        }
    }
}

