/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBActionListener;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class MDBAction
extends AbstractAction
implements MDBActionListener {
    public static final ImageIcon APPLICATION_ICON = (ImageIcon)GUIConfiguration.getInstance().getIcon("APPLICATION_ICON", 16);
    private static final JFrame OWNER_FRAME;
    private static final Logger LOGGER;
    public static final String[] DEFAULT_MENU_PATH;
    private String[] menuPath = DEFAULT_MENU_PATH;
    private boolean inToolbar = true;
    private String name = "  ";
    private Set listeners = new HashSet();
    private List propertyChangeListeners = new ArrayList();
    private int mnemonic;
    private int position = -1;
    private boolean oldState = true;
    private KeyStroke accelerator;
    private boolean isObjectAction = false;
    private JMenu menu;

    public MDBAction() {
    }

    public MDBAction(String string) {
        super(string);
        this.name = string;
    }

    public MDBAction(String string, Icon icon) {
        super(string, icon);
        this.name = string;
    }

    public String getToolTipText() {
        return null;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.remove(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeListeners.toArray(new PropertyChangeListener[this.propertyChangeListeners.size()]);
        return propertyChangeListenerArray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.putValue("Name", string);
        this.name = string;
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setMenuPath(String[] stringArray) {
        this.menuPath = stringArray;
    }

    public String[] getMenuPath() {
        return this.menuPath;
    }

    public void setAllowedInToolbar(boolean bl) {
        this.inToolbar = bl;
    }

    public boolean isAllowedInToolbar() {
        return this.inToolbar;
    }

    public boolean needSelectedObject() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ActionInvoker actionInvoker = new ActionInvoker(actionEvent);
        SwingUtilities.invokeLater(actionInvoker);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.accelerator = keyStroke;
    }

    public void addMDBActionListener(MDBActionListener mDBActionListener) {
        this.listeners.add(mDBActionListener);
    }

    public void removeMDBActionListener(MDBActionListener mDBActionListener) {
        this.listeners.remove(mDBActionListener);
    }

    protected void fireBefore(ActionEvent actionEvent) {
        if (!this.listeners.isEmpty()) {
            for (MDBActionListener mDBActionListener : this.listeners) {
                mDBActionListener.beforeAction(this, actionEvent);
            }
        }
    }

    protected void fireAfter(ActionEvent actionEvent) {
        if (!this.listeners.isEmpty()) {
            for (MDBActionListener mDBActionListener : this.listeners) {
                mDBActionListener.afterAction(this, actionEvent);
            }
        }
    }

    public abstract void doActionPerformed(ActionEvent var1);

    @Override
    public void afterAction(MDBAction mDBAction, ActionEvent actionEvent) {
    }

    @Override
    public void beforeAction(MDBAction mDBAction, ActionEvent actionEvent) {
    }

    public void setDelegate(MDBAction mDBAction) {
        throw new IllegalStateException(Messages.getString("MDBAction.ThisActionIsNotReplaceable"));
    }

    public MDBAction getDelegate() {
        throw new IllegalStateException(Messages.getString("MDBAction.ThisActionIsNotReplaceable"));
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean addSeparatorAfter() {
        return false;
    }

    public boolean addSeparatorAfterInRoot() {
        return false;
    }

    public boolean addSeparatorBefore() {
        return false;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int n) {
        this.mnemonic = n;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void setOldState(boolean bl) {
        this.oldState = bl;
    }

    public void reset() {
        this.setEnabled(this.oldState);
    }

    public boolean isToggleButton() {
        return false;
    }

    public boolean addToolbarSeparator() {
        return false;
    }

    public boolean isObjectAction() {
        return this.isObjectAction;
    }

    public void setObjectAction(boolean bl) {
        this.isObjectAction = bl;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void setMenu(JMenu jMenu) {
        this.menu = jMenu;
    }

    public boolean isPopupMenu() {
        return false;
    }

    static {
        LOGGER = new Logger(MDBAction.class);
        OWNER_FRAME = new JFrame();
        OWNER_FRAME.setIconImage(APPLICATION_ICON.getImage());
        DEFAULT_MENU_PATH = new String[]{"Object"};
    }

    class ActionInvoker
    implements Runnable {
        ActionEvent event;

        ActionInvoker(ActionEvent actionEvent) {
            this.event = actionEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MDBAction.this.fireBefore(this.event);
                MDBAction.this.doActionPerformed(this.event);
                MDBAction.this.fireAfter(this.event);
            }
            catch (Throwable throwable) {
                LOGGER.error(throwable);
                throwable.printStackTrace();
            }
            finally {
                this.event = null;
            }
        }
    }
}

