/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.View;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignSet;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageEvent;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.DBPersistenceManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ControllerApplication;
import oracle.dbtools.crest.swingui.ControllerSet;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectChangeListener;
import oracle.dbtools.crest.swingui.StatusBar;
import oracle.dbtools.crest.swingui.SwingUIConstants;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMakerEditor;
import oracle.dbtools.crest.swingui.ddl.DDLViewer;
import oracle.dbtools.crest.swingui.designrules.CustomDesignRulesManager;
import oracle.dbtools.crest.swingui.designrules.CustomDesignRulesPersistence;
import oracle.dbtools.crest.swingui.designrules.CustomLibrariesManager;
import oracle.dbtools.crest.swingui.designrules.CustomTransformationsManager;
import oracle.dbtools.crest.swingui.designrules.DesignRuleView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.editor.SelectDesignsDialog;
import oracle.dbtools.crest.swingui.editor.SelectRelationalModelDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.swingui.storage.ControllerStorage;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplatesPersistence;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.DDLExceptionList;
import oracle.dbtools.crest.util.io.NullOutputStream;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.runtime.RuntimeMonitor;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;

public class ApplicationView
implements SelectedObjectChangeListener,
StatusBarOwner,
View,
SwingUIConstants,
ChangeListener {
    private static final String MENU_HIDE = Messages.getString("ApplicationView.Hide");
    private static final String MENU_DELETE_SUBVIEW = Messages.getString("ApplicationView.DeleteSubView");
    private static final String USE_CUSTOM_FORMAT = "use_custom_format";
    private static final String USE_DEFAULT_COLOR = "use_default_color";
    private static final String BACKGROUND_COLOR = "background_color";
    private static final String FOREGROUND_COLOR = "foreground_color";
    public static boolean DROP_GENERATED_OBJECTS_ONLY = true;
    public static boolean USE_DROP_DEPENDENCY = true;
    private static final String NULL_STR = "NULL";
    public static final boolean EXIT_ON_CLOSE = true;
    public static boolean IS_VIEWER = Extension.isViewer();
    public static boolean LOGICAL_MODEL_ONLY = false;
    public static final boolean BACK_UP_IS_VIEWER = IS_VIEWER;
    public static final boolean BACK_UP_LOGICAL_MODEL_ONLY = LOGICAL_MODEL_ONLY;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static boolean importing = false;
    public static boolean loading = false;
    public static boolean merging = false;
    public static boolean canLogging = true;
    private GUIConfiguration guiConfig = GUIConfiguration.getInstance();
    private DesignPartView currentDPV;
    private ControllerSet controllers = new ControllerSet(this);
    private ControllerApplication appController;
    private ControllerStorage sharedStorageController;
    private DDLViewer ddlViewer;
    private DDLFileMakerEditor ddlFileMakerEditor;
    private StatusBar statusBar;
    private JMenuBar jmenuBar = null;
    private DesignRuleView designRuleView = null;
    private CustomDesignRulesManager customDesignRulesManager = null;
    private CustomLibrariesManager customLibrariesManager = null;
    private CustomTransformationsManager transformationsManager = null;
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private ArrayList scriptEngines = new ArrayList();
    private ApplicationCloser applicationCloser = null;
    private JPopupMenu popupPhS;
    private JPopupMenu popupDFD;
    private JPopupMenu popupMDD;
    private JPopupMenu popupTrTask;
    private JMenuItem miDeleteSubView;
    private JMenuItem miCloseSubView;
    private JMenuItem miRearrangeDiagram;
    private JPopupMenu.Separator sepMDCompact;
    private JMenuItem miCompactDiagramProps;
    private JMenuItem miCloseDFD;
    private JMenuItem miCloseMDD;
    private JMenuItem miCloseTrTask;
    private static DateFormat df;
    private BrowserPanel browserPanel;
    private SearchPanel searchPanel;
    public static boolean debugMode;
    public static JFrame frame;
    public static String basePath;
    private DDLExceptionList ddlExceptionList;
    private JDialog navigator;
    private JPanel navPanel;
    private Settings settings = null;
    private Design currentDesign;
    private IDGenerator globalGenerator;
    private DDLFileMaker ddlFileMaker = null;
    protected MDConfiguration configuration = MDConfiguration.getDefaultInstance();
    private MDPreferences preferences = MDPreferences.getDefaultInstance();
    protected XMLPersistenceManager persistenceManager;
    private DesignRuleManager designRuleManager;
    private DBPersistenceManager dbPersistenceManager;
    private DropTargetListener dropTargetListener = null;
    private int currentOperation = -1;
    private List objectsToSave = new ArrayList();
    private DesignSet designSet;
    private List copiedObjects = new ArrayList();
    private ArrayList<DRCustomScript> customDesignRules = new ArrayList();
    private ArrayList<DRLibrary> customLibraries = new ArrayList();
    private static ApplicationView instance;
    private CustomDesignRulesPersistence designRulesPersistence = new CustomDesignRulesPersistence(this);
    private XMLTransformationManager xmlTransformationManager = null;
    private ReportTemplatesPersistence reportTemplatesPersistence = new ReportTemplatesPersistence(this);
    private ArrayList<ReportTemplate> reportTemplates = new ArrayList();
    public static boolean PROPAGATE_FKATTRIBUTE_DESCRIPTION;
    public static boolean SHOW_SENSITIVE_DATA;
    public static boolean SHOW_MASKED_DATA;
    public static boolean REBUILD_OBJECT_LIST;
    private Settings initialSettings;
    private static final Logger LOGGER;
    private ToggleListener tl = new ToggleListener();
    private static final String DM_KEY = "DM_KEY";
    private boolean isUpdating = false;
    public boolean cancel = false;
    private static boolean instantiating;

    public ApplicationView() {
        this(null);
    }

    public ApplicationView(DropTargetListener dropTargetListener) {
        this.setDebugMode();
        this.setJDOMparsing();
        this.setPropagateFKAttributeDescription();
        this.setSensitiveAndMasked();
        this.setRebuildObjectList();
        this.getPersistenceManager();
        this.createDesignSet();
        Extension.isExtension = true;
        this.dropTargetListener = dropTargetListener;
        this.statusBar = new StatusBar();
        this.popupPhS = new JPopupMenu();
        this.popupDFD = new JPopupMenu();
        this.popupMDD = new JPopupMenu();
        this.popupTrTask = new JPopupMenu();
        this.miCloseSubView = new JMenuItem(MENU_HIDE);
        this.miDeleteSubView = new JMenuItem(MENU_DELETE_SUBVIEW);
        this.miRearrangeDiagram = new JMenuItem(Messages.getString("ApplicationView.RearrangeDiagram"));
        this.sepMDCompact = new JPopupMenu.Separator();
        this.miCompactDiagramProps = new JMenuItem(Messages.getString("ApplicationView.Properties"));
        this.miCloseDFD = new JMenuItem(MENU_HIDE);
        this.miCloseMDD = new JMenuItem(MENU_HIDE);
        this.miCloseTrTask = new JMenuItem(MENU_HIDE);
        this.settings = new Settings(this);
        this.settings.loadPreferences();
        this.settings.loadLocalSettings();
        this.setInitialSettings(this.settings);
        this.addDesign(false);
        this.settings.loadPreferredDomains();
        this.settings.loadPreferredLogicalTypes();
        this.initScriptEngines();
        this.designRulesPersistence.loadCustomDRScripts(this.settings);
        this.getCurrentDesign().setDlSettings(this.settings.saveSettingsToString());
        this.updateSettings(false, false);
        this.controllers.add(this.getController());
        this.getControllerStorage();
        this.controllers.updateMenu();
        this.currentDPV = this.getDPVLogical();
        this.browserPanel = new BrowserPanel(this);
        this.browserPanel.getJTree().getModel().addTreeModelListener(new MyTreeModelListener());
        this.getCurrentDesign().getDataTypesDesign().setDirty(false);
        this.popupDFD.add(this.miCloseDFD);
        this.popupMDD.add(this.miCloseMDD);
        if (!IS_VIEWER) {
            this.popupMDD.addSeparator();
            this.popupMDD.add(this.miRearrangeDiagram);
        }
        this.popupMDD.add(this.sepMDCompact);
        this.popupMDD.add(this.miCompactDiagramProps);
        this.popupTrTask.add(this.miCloseTrTask);
        this.popupPhS.add(this.miCloseSubView);
        if (!IS_VIEWER) {
            this.popupPhS.addSeparator();
            this.miDeleteSubView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationView.this.deleteSubview();
                }
            });
            this.popupPhS.add(this.miDeleteSubView);
        }
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        environOptions.addChangeListener((ChangeListener)new SettingsListener());
        this.settings.loadPreferencesExtraData(this);
        this.nullifyDesignRuleManager();
        this.reportTemplatesPersistence.loadReportTemplates(this.settings);
    }

    public void loadCustomDRScripts() {
        this.designRulesPersistence.loadCustomDRScripts(this.settings);
    }

    public void saveCustomDRScripts() {
        this.designRulesPersistence.saveCustomDRScripts();
    }

    public static void clearToolbar() {
        try {
            Toolbar toolbar = Ide.getToolbar();
            if (!Extension.isDataModeler()) {
                for (int i = toolbar.getComponentCount() - 1; i >= 0; --i) {
                    Component component = toolbar.getComponent(i);
                    if (!(component instanceof JComponent) || ((JComponent)component).getClientProperty(DM_KEY) == null) continue;
                    toolbar.remove(i);
                }
            } else {
                toolbar.removeAll();
            }
            toolbar.repaint();
        }
        catch (Exception exception) {
            LOGGER.error("Error clearing main toolbar.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIdeToolbar(JToolBar jToolBar) {
        if (!this.isUpdating) {
            this.isUpdating = true;
            try {
                ApplicationView.clearToolbar();
                Toolbar toolbar = Ide.getToolbar();
                int n = 0;
                if (toolbar.getComponentCount() > 0) {
                    ++n;
                }
                if (toolbar.getComponentAtIndex(toolbar.getComponentCount() - 1) instanceof JComboBox) {
                    ++n;
                }
                for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
                    AbstractButton abstractButton;
                    Serializable serializable;
                    Component component = jToolBar.getComponent(i);
                    if (component instanceof JToolBar.Separator) {
                        serializable = new JToolBar.Separator();
                        ((JComponent)serializable).putClientProperty(DM_KEY, DM_KEY);
                        toolbar.add((Component)serializable, toolbar.getComponentCount() - n);
                        continue;
                    }
                    if (component instanceof JToggleButton) {
                        MDBAction mDBAction;
                        serializable = (MDBAction)((JToggleButton)component).getAction();
                        abstractButton = new JToggleButton((Action)((Object)serializable));
                        abstractButton.setText("");
                        abstractButton.setToolTipText(((MDBAction)serializable).getName());
                        abstractButton.addActionListener(this.tl);
                        abstractButton.putClientProperty(DM_KEY, DM_KEY);
                        toolbar.add((Component)abstractButton, toolbar.getComponentCount() - n);
                        if (this.currentDPV == null || (mDBAction = this.currentDPV.getWorkSpace().getCurrentAction()) == null || serializable != mDBAction) continue;
                        abstractButton.doClick();
                        continue;
                    }
                    if (!(component instanceof JButton)) continue;
                    serializable = (MDBAction)((JButton)component).getAction();
                    abstractButton = new JButton((Action)((Object)serializable));
                    abstractButton.setText("");
                    toolbar.add((Component)abstractButton, toolbar.getComponentCount() - n);
                    abstractButton.putClientProperty(DM_KEY, DM_KEY);
                    abstractButton.setToolTipText(String.valueOf(((MDBAction)serializable).getName()));
                }
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    public void openMainDiagrams() {
        ApplicationView.log(Messages.getString("ApplicationView.BuildingDiagrams"));
        this.getCurrentDesign().getLogicalDesign().setMainViewVisible(true);
        this.getCurrentDesign().getRelationalDesign().setMainViewVisible(true);
        this.controllers.updateObjectMenu(this.currentDPV);
        if (this.currentDPV != null) {
            this.updateIdeToolbar(this.currentDPV.getController().getJToolBar());
        }
        this.getBrowserPanel().expandToPath(this.getCurrentDesign().getPath());
    }

    protected int getPreferredIconSize() {
        return 24;
    }

    public void clearTree() {
        this.browserPanel.clearTree();
    }

    public void deleteSubview() {
        this.getCurrentDPV().getDesignPart().deleteSubview(this.getCurrentDPV());
    }

    public void closeSubview() {
    }

    public void closeSubview(int n) {
    }

    public ControllerSet getControllerSet() {
        return this.controllers;
    }

    public void clearDPView(DesignPartView designPartView) {
        Diagram diagram = designPartView.getWorkSpace();
        diagram.removeAll();
    }

    public ControllerApplication getController() {
        if (this.appController == null) {
            this.appController = new ControllerApplication(this);
            this.appController.setName("Application");
        }
        return this.appController;
    }

    public ControllerStorage getControllerStorage() {
        if (this.sharedStorageController == null) {
            this.sharedStorageController = new ControllerStorage(this);
            this.sharedStorageController.setName("_Physical");
        }
        return this.sharedStorageController;
    }

    public AbstractController getRelationalController() {
        return this.getCurrentDesign().getRelationalDesign().getMainView().getController();
    }

    public AbstractController getLogicalController() {
        return this.getCurrentDesign().getLogicalDesign().getMainView().getController();
    }

    public Design getCurrentDesign() {
        return this.currentDesign;
    }

    public void setCurrentDesign(Design design) {
        this.currentDesign = design;
        if (this.currentDesign != null) {
            // empty if block
        }
    }

    public GUIConfiguration getConfiguration() {
        return this.guiConfig;
    }

    public JFrame getFrame() {
        return frame;
    }

    public void synchronizeTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMDConfiguration().get("appName"));
        stringBuffer.append(" - ");
        stringBuffer.append(this.getCurrentDesign().getFileName());
        this.getFrame().setTitle(stringBuffer.toString());
        this.updateDesignRules(!this.getCurrentDesign().isReadOnly());
    }

    public void clearTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMDConfiguration().get("appName"));
        this.getFrame().setTitle(stringBuffer.toString());
        this.setDesignName(this.getCurrentDesign().getName());
        this.updateDesignRules(!this.getCurrentDesign().isReadOnly());
    }

    public void search(int n) {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel(this);
            this.searchPanel.getDialog().setLocationRelativeTo(frame);
        }
        this.searchPanel.resetItems(n);
        this.searchPanel.getDialog().setVisible(true);
    }

    public DDLViewer getDDLViewer() {
        if (this.ddlViewer == null) {
            this.ddlViewer = new DDLViewer(this);
        }
        return this.ddlViewer;
    }

    public void putOnDDLViewer(Object object) {
        if (this.getDDLViewer().isDialogVisible()) {
            this.getDDLViewer().setDDLObject(object);
        }
    }

    public void setDDLViewerVisible(boolean bl) {
        Object object = null;
        String string = Messages.getString("ApplicationView.msgPreviewDDL");
        if (bl) {
            Object[] objectArray;
            if (this.getCurrentDPV() != null && this.getCurrentDPV().getDesignPart() instanceof RelationalDesign && (objectArray = this.getCurrentDPV().getSelectedObjects()).length > 0) {
                this.getDDLViewer().ddlPreview(objectArray, (RelationalDesign)this.getCurrentDPV().getDesignPart());
                this.getDDLViewer().setDialogVisible(true);
                return;
            }
            if (this.getCurrentDPV() != null && this.getCurrentDPV().getCurrentSelection() != null && ((objectArray = this.getCurrentDPV().getCurrentSelection().getSelectedObject()) instanceof Table || objectArray instanceof TableView || objectArray instanceof Index)) {
                object = this.getCurrentDPV().getCurrentSelection().getSelectedObject();
            }
            if (object == null && this.getCurrentDPV() != null) {
                objectArray = this.getCurrentDPV().getSelectedObjects();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (!(object2 instanceof Table) && !(object2 instanceof TableView) && !(object2 instanceof Index)) continue;
                    object = object2;
                    break;
                }
            }
            if (object != null) {
                this.getDDLViewer().setDDLObject(object);
            }
        }
        if (object == null) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string);
        }
        if (object != null && bl) {
            this.getDDLViewer().setDialogVisible(true);
        } else {
            this.getDDLViewer().setDialogVisible(false);
        }
    }

    public DDLFileMakerEditor getDDLFileMakerEditor() {
        if (this.ddlFileMakerEditor == null) {
            this.ddlFileMakerEditor = new DDLFileMakerEditor(this);
        }
        this.ddlFileMakerEditor.updateRDBMSSitesComboBox();
        this.ddlFileMakerEditor.getStorageDesignCombo().setSelectedItem(this.getCurrentDesign().getSelectedRDBMSSite());
        this.ddlFileMakerEditor.updateDesignSubViewComboBox();
        this.initLineTerminator();
        return this.ddlFileMakerEditor;
    }

    public void setDDLFileMakerEditorVisible(boolean bl) {
        this.getDDLFileMakerEditor().setDialogVisible(bl);
    }

    public JMenuBar getJMenuBar() {
        if (this.jmenuBar == null) {
            this.jmenuBar = this.controllers.getJMenuBar();
        }
        return this.jmenuBar;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        try {
            DesignPartView.NamedTabbedPane namedTabbedPane = (DesignPartView.NamedTabbedPane)changeEvent.getSource();
            DesignPartView designPartView = (DesignPartView)namedTabbedPane.getSelectedComponent();
            this.editorChanged(designPartView);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void editorChanged(DesignPartView designPartView) {
        if (!loading) {
            if (designPartView instanceof DesignPartView) {
                this.currentDPV = designPartView;
                this.setCurrentDesign(this.currentDPV.getDesign());
                if (this.currentDPV.getDesignPart() instanceof DataFlowDesign) {
                    this.getCurrentDesign().getProcessModel().setDataFlowDesign((DataFlowDesign)this.currentDPV.getDesignPart());
                } else if (this.currentDPV.getDesignPart() instanceof MultidimensionalDesign) {
                    this.getCurrentDesign().setMultidimensionalDesign((MultidimensionalDesign)this.currentDPV.getDesignPart());
                }
                JToolBar jToolBar = this.currentDPV.getController().getJToolBar();
                this.updateIdeToolbar(jToolBar);
                this.selectionChanged(this.currentDPV.getCurrentSelection());
                this.setNavigatorPanel(this.currentDPV.getNavigatorPanel());
            } else {
                this.currentDPV = null;
                ApplicationView.clearToolbar();
            }
            this.getControllerSet().updateObjectMenu(this.currentDPV);
            this.updateActions();
        }
    }

    public void updateDesignRules(boolean bl) {
    }

    public void updateActionsFor(DesignPart designPart) {
        DesignPartView designPartView;
        DesignPartViewPlaceHolder designPartViewPlaceHolder;
        designPart.getMainView().getController().updateActions();
        Iterator iterator = designPart.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            designPartView = designPartViewPlaceHolder.getDesignPartView();
            designPartView.getController().updateActions();
            Iterator iterator2 = designPartView.getDisplays().iterator();
            while (iterator2.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder2 = (DesignPartViewPlaceHolder)iterator2.next();
                DesignPartView designPartView2 = designPartViewPlaceHolder2.getDesignPartView();
                designPartView2.getController().updateActions();
            }
        }
        iterator = designPart.getMainView().getDisplays().iterator();
        while (iterator.hasNext()) {
            designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            designPartView = designPartViewPlaceHolder.getDesignPartView();
            designPartView.getController().updateActions();
        }
    }

    public void updateActions() {
        try {
            ModelIDObject modelIDObject;
            this.updateActionsFor(this.getCurrentDesign().getLogicalDesign());
            Iterator iterator = this.getCurrentDesign().getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (DesignPart)iterator.next();
                this.updateActionsFor((DesignPart)modelIDObject);
            }
            this.updateActionsFor(this.getCurrentDesign().getDataTypesDesign());
            iterator = this.getCurrentDesign().getMultidimensionalDesigns().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (DesignPart)iterator.next();
                this.updateActionsFor((DesignPart)modelIDObject);
            }
            iterator = this.getCurrentDesign().getProcessModel().getDataFlowDesigns().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (DesignPart)iterator.next();
                this.updateActionsFor((DesignPart)modelIDObject);
            }
            iterator = this.getCurrentDesign().getProcessModel().getTransformationPackageSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (TransformationPackage)iterator.next();
                Iterator iterator2 = ((TransformationPackage)modelIDObject).getTransformationTaskSet().iterator();
                while (iterator2.hasNext()) {
                    TransformationTask transformationTask = (TransformationTask)iterator2.next();
                    this.updateActionsFor(transformationTask);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DPVLogical getDPVLogical() {
        return (DPVLogical)this.getCurrentDesign().getLogicalDesign().getMainView();
    }

    public DPVRelational getDPVRelational() {
        return (DPVRelational)this.getCurrentDesign().getRelationalDesign().getMainView();
    }

    public DesignPartView getCurrentDPV() {
        return this.currentDPV;
    }

    public void setCurrentDPV(DesignPartView designPartView) {
        if (designPartView.getContext() != null && designPartView.activateEditor()) {
            return;
        }
        if (designPartView.canCreateDisplays()) {
            Editor editor = DMDiagramEditor.openNewDiagram(designPartView.getTabbedPane());
            if (editor != null) {
                designPartView.setContext(editor.getContext());
            }
        } else {
            Editor editor = DMDiagramEditor.openNewDiagram(designPartView);
            if (editor != null) {
                designPartView.setContext(editor.getContext());
            }
        }
    }

    @Override
    public void selectionChanged(SelectableObject selectableObject) {
        if (!loading && selectableObject != null && selectableObject.getSelectedObject() != null) {
            this.putOnDDLViewer(selectableObject.getSelectedObject());
            this.setFixedStatusMessage(selectableObject.getSelectedObject().toString());
            this.sharedStorageController.selectionChanged(selectableObject);
            if (this.getCurrentDPV() != null) {
                this.getCurrentDPV().getController().selectionChanged(selectableObject);
            }
        } else {
            this.clearStatusMessage();
        }
        this.getController().updateMenus();
    }

    @Override
    public void setFixedStatusMessage(String string) {
        this.statusBar.setFixedStatusMessage(string);
    }

    @Override
    public void setTempStatusMessage(String string, int n) {
        this.statusBar.setTempStatusMessage(string, n);
    }

    @Override
    public void setTempStatusMessage(String string) {
        this.statusBar.setTempStatusMessage(string, 5000);
    }

    @Override
    public void clearStatusMessage() {
        this.statusBar.clearStatusMessage();
    }

    @Override
    public Map getGraphicalPropsFor(DesignObject designObject) {
        TopView topView;
        DesignPartView designPartView = this.getDPVFor(designObject);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (!(designPartView == null || (topView = designObject.getTopView()) == null || topView instanceof TVRelation || topView instanceof TVArc || topView instanceof TVFlow || topView instanceof TVFKRelation)) {
            Rectangle rectangle = topView.getCellView() != null ? topView.getCellView().getBounds().getBounds() : topView.getBounds();
            treeMap.put("x", String.valueOf(rectangle.getX()));
            treeMap.put("y", String.valueOf(rectangle.getY()));
            treeMap.put("w", String.valueOf(rectangle.getWidth()));
            treeMap.put("h", String.valueOf(rectangle.getHeight()));
            treeMap.put(USE_CUSTOM_FORMAT, Boolean.toString(topView.useCustomFormat()));
            treeMap.put(USE_DEFAULT_COLOR, Boolean.toString(topView.useDefaultColor()));
            treeMap.put(BACKGROUND_COLOR, topView.getBackgroundColor() != null ? Integer.toString(topView.getBackgroundColor().getRGB()) : NULL_STR);
            treeMap.put(FOREGROUND_COLOR, topView.getForegroundColor() != null ? Integer.toString(topView.getForegroundColor().getRGB()) : NULL_STR);
        }
        return treeMap;
    }

    @Override
    public Map getGraphicalPropsFor(TopView topView) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Rectangle rectangle = topView.getCellView() != null ? topView.getCellView().getBounds().getBounds() : topView.getBounds();
        treeMap.put("x", String.valueOf(rectangle.getX()));
        treeMap.put("y", String.valueOf(rectangle.getY()));
        treeMap.put("w", String.valueOf(rectangle.getWidth()));
        treeMap.put("h", String.valueOf(rectangle.getHeight()));
        treeMap.put(USE_CUSTOM_FORMAT, Boolean.toString(topView.useCustomFormat()));
        treeMap.put(USE_DEFAULT_COLOR, Boolean.toString(topView.useDefaultColor()));
        treeMap.put(BACKGROUND_COLOR, topView.getBackgroundColor() != null ? Integer.toString(topView.getBackgroundColor().getRGB()) : NULL_STR);
        treeMap.put(FOREGROUND_COLOR, topView.getForegroundColor() != null ? Integer.toString(topView.getForegroundColor().getRGB()) : NULL_STR);
        return treeMap;
    }

    @Override
    public void setGraphicalPropsFor(String string, Map map) {
        DesignObject designObject = this.getCurrentDesign().getDesignObject(string);
        if (designObject != null) {
            this.setGraphicalPropsFor(designObject, map);
        }
    }

    @Override
    public String getViewType() {
        return "SwingUI";
    }

    @Override
    public void setGraphicalPropsFor(DesignObject designObject, Map map) {
        TopView topView = designObject.getTopView();
        if (topView != null) {
            try {
                Object v;
                Object v2;
                String string = (String)map.get("x");
                String string2 = (String)map.get("y");
                String string3 = (String)map.get("w");
                String string4 = (String)map.get("h");
                double d = -1.0;
                double d2 = -1.0;
                double d3 = -1.0;
                double d4 = -1.0;
                if (string != null && string2 != null) {
                    d = Double.parseDouble(string);
                    d2 = Double.parseDouble(string2);
                }
                if (string3 != null && string4 != null) {
                    d3 = Double.parseDouble(string4);
                    d4 = Double.parseDouble(string3);
                }
                if (d > -1.0 && d2 > -1.0 && d3 > -1.0 && d4 > -1.0) {
                    if (topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(new Rectangle((int)d, (int)d2, (int)d4, (int)d3));
                    } else {
                        topView.setBounds(new Rectangle((int)d, (int)d2, (int)d4, (int)d3));
                    }
                }
                if ((v2 = map.get(USE_CUSTOM_FORMAT)) != null) {
                    boolean bl = Boolean.valueOf((String)v2);
                    topView.setUseCustomFormat(bl);
                }
                if ((v = map.get(USE_DEFAULT_COLOR)) != null) {
                    boolean bl = Boolean.valueOf((String)v);
                    topView.setUseDefaultColor(bl);
                    if (!bl) {
                        Object object;
                        Object v3 = map.get(BACKGROUND_COLOR);
                        if (v3 != null && !NULL_STR.equalsIgnoreCase((String)v3)) {
                            object = new Color(Integer.parseInt((String)v3));
                            topView.setBackgroundColor((Color)object);
                        }
                        if ((object = map.get(FOREGROUND_COLOR)) != null && !NULL_STR.equalsIgnoreCase((String)object)) {
                            Color color = new Color(Integer.parseInt((String)object));
                            topView.setForegroundColor(color);
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Graphical info problem: " + exception);
            }
        }
    }

    @Override
    public void setGraphicalPropsFor(TopView topView, Map map) {
        if (topView != null) {
            try {
                Object v;
                Object v2;
                String string = (String)map.get("x");
                String string2 = (String)map.get("y");
                String string3 = (String)map.get("w");
                String string4 = (String)map.get("h");
                double d = -1.0;
                double d2 = -1.0;
                double d3 = -1.0;
                double d4 = -1.0;
                if (string != null && string2 != null) {
                    d = Double.parseDouble(string);
                    d2 = Double.parseDouble(string2);
                }
                if (string3 != null && string4 != null) {
                    d3 = Double.parseDouble(string4);
                    d4 = Double.parseDouble(string3);
                }
                if (d > -1.0 && d2 > -1.0 && d3 > -1.0 && d4 > -1.0) {
                    if (topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(new Rectangle((int)d, (int)d2, (int)d4, (int)d3));
                    } else {
                        topView.setBounds(new Rectangle((int)d, (int)d2, (int)d4, (int)d3));
                    }
                }
                if ((v2 = map.get(USE_CUSTOM_FORMAT)) != null) {
                    boolean bl = Boolean.valueOf((String)v2);
                    topView.setUseCustomFormat(bl);
                }
                if ((v = map.get(USE_DEFAULT_COLOR)) != null) {
                    boolean bl = Boolean.valueOf((String)v);
                    topView.setUseDefaultColor(bl);
                    if (!bl) {
                        Object object;
                        Object v3 = map.get(BACKGROUND_COLOR);
                        if (v3 != null && !NULL_STR.equalsIgnoreCase((String)v3)) {
                            object = new Color(Integer.parseInt((String)v3));
                            topView.setBackgroundColor((Color)object);
                        }
                        if ((object = map.get(FOREGROUND_COLOR)) != null && !NULL_STR.equalsIgnoreCase((String)object)) {
                            Color color = new Color(Integer.parseInt((String)object));
                            topView.setForegroundColor(color);
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Graphical info problem: " + exception);
            }
        }
    }

    protected DesignPartView getDPVFor(DesignObject designObject) {
        return designObject.getDesignPart().getMainView();
    }

    public Component getSelectedWorkSpaceComponent() {
        DesignPartView designPartView = this.currentDPV;
        if (designPartView instanceof DesignPartView) {
            DesignPartView designPartView2 = designPartView;
            return designPartView2.getWorkSpace();
        }
        if (designPartView instanceof JTabbedPane) {
            Component component = ((JTabbedPane)((Object)designPartView)).getSelectedComponent();
            if (component instanceof DesignPartView) {
                DesignPartView designPartView3 = (DesignPartView)component;
                return designPartView3.getWorkSpace();
            }
            return component;
        }
        return designPartView;
    }

    public Dimension getSelectedWorkSpaceSize() {
        if (this.currentDPV != null) {
            Dimension dimension;
            DesignPartView designPartView = this.currentDPV;
            if (designPartView instanceof DesignPartView) {
                DesignPartView designPartView2 = designPartView;
                dimension = designPartView2.getWorkSpaceUsedSize();
            } else if (designPartView instanceof JTabbedPane) {
                Component component = ((JTabbedPane)((Object)designPartView)).getSelectedComponent();
                if (component instanceof DesignPartView) {
                    DesignPartView designPartView3 = (DesignPartView)component;
                    dimension = designPartView3.getWorkSpaceUsedSize();
                } else {
                    dimension = component.getSize();
                }
            } else {
                dimension = designPartView.getSize();
            }
            dimension = new Dimension(dimension.width + 20, dimension.height + 20);
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public ApplicationCloser getApplicationCloser() {
        if (this.applicationCloser == null) {
            this.applicationCloser = new ApplicationCloser();
        }
        return this.applicationCloser;
    }

    public void closeApplication() {
        Design design;
        Iterator iterator = this.getDesigns().iterator();
        while (iterator.hasNext()) {
            design = (Design)iterator.next();
            design.removeDeletedProxies();
        }
        design = this.getCurrentDesign();
        if (design != null && !design.isNewDesign()) {
            this.getSettings().setLastOpenDesign(this.getCurrentDesign().getStorageName());
            if (this.getCurrentDPV() != null) {
                this.getSettings().setLastOpenDPV(this.getCurrentDPV().getDPVId());
            } else {
                this.getSettings().setLastOpenDPV("");
            }
        } else {
            this.getSettings().setLastOpenDesign("");
            this.getSettings().setLastOpenDPV("");
        }
        design.setDesignPath("../");
        this.deleteDesign("Untitled_1");
        this.getSettings().savePreferences();
        this.reportTemplatesPersistence.saveReportTemplates();
        AbstractRepositoryManager abstractRepositoryManager = this.getDBPersistenceManager().getDBRepositoryManager();
        if (abstractRepositoryManager.isConnected()) {
            try {
                abstractRepositoryManager.getConnection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getApplicationCloser().doExit();
    }

    public DesignRuleView getDesignRuleView(RelationalDesign relationalDesign, DataFlowDesign dataFlowDesign) {
        this.designRuleView = new DesignRuleView(this, relationalDesign, dataFlowDesign);
        this.designRuleView.setRelDesign(relationalDesign);
        this.designRuleView.setDataFlowDesign(dataFlowDesign);
        return this.designRuleView;
    }

    public void setDesignRuleViewVisible(boolean bl) {
        RelationalDesign relationalDesign = null;
        if (this.getCurrentDesign().getRelationalDesigns().size() > 0) {
            relationalDesign = this.selectRelationalDesign();
        }
        DataFlowDesign dataFlowDesign = this.selectDataFlowDiagram();
        this.getDesignRuleView(relationalDesign, dataFlowDesign).getDialog().setVisible(true);
    }

    public CustomDesignRulesManager getCustomDesignRulesManager(RelationalDesign relationalDesign) {
        this.customDesignRulesManager = new CustomDesignRulesManager(this, relationalDesign, this.scriptEngineManager);
        return this.customDesignRulesManager;
    }

    public void setCustomDesignRulesManagerVisible(boolean bl) {
        RelationalDesign relationalDesign = this.selectRelationalDesign();
        this.getCustomDesignRulesManager(relationalDesign).getDialog().setVisible(true);
    }

    public CustomLibrariesManager getCustomLibrariesManager() {
        this.customLibrariesManager = new CustomLibrariesManager(this);
        return this.customLibrariesManager;
    }

    public void setCustomLibrariesManagerVisible(boolean bl) {
        this.getCustomLibrariesManager().getDialog().setVisible(true);
    }

    public CustomTransformationsManager getTransformationsManager(RelationalDesign relationalDesign) {
        this.transformationsManager = new CustomTransformationsManager(this, this.getCurrentDPV().getDesignPart(), this.scriptEngineManager);
        return this.transformationsManager;
    }

    public void setTransformationsManagerVisible(boolean bl) {
        RelationalDesign relationalDesign = this.selectRelationalDesign();
        this.getTransformationsManager(relationalDesign).getDialog().setVisible(true);
    }

    public MDBAction getActionByName(String string) {
        return this.controllers.getActionByName(string);
    }

    public boolean closeStorageDesign(StorageDesign storageDesign) {
        if (!storageDesign.isTempModel() && (storageDesign.isDirty() || storageDesign.hasDirtyStorableObjects())) {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ApplicationView.SavePhysicalModel"), storageDesign.getName()), Messages.getString("ApplicationView.SaveDesign"), 1);
            switch (n) {
                case 0: {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ApplicationView.SavingPhysicalModel"), storageDesign.getName()));
                    storageDesign.save();
                    storageDesign.setDirty(false);
                    break;
                }
                case 1: {
                    storageDesign.setDirty(false);
                    break;
                }
                case 2: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static void log(String string) {
        if (canLogging) {
            try {
                String string2 = df.format(new Date(System.currentTimeMillis()));
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(" - ").append(string).append('\n');
                LogManager.getIdeLogWindow().log((Object)stringBuffer.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void centerDesign() {
        this.getDPVLogical().centerDesign();
        for (int i = 0; i < this.getCurrentDesign().getRelationalDesigns().size(); ++i) {
            ((RelationalDesign)this.getCurrentDesign().getRelationalDesigns().getElement(i)).getMainView().centerDesign();
        }
    }

    public String getDesignName() {
        return this.getCurrentDesign().getFileName();
    }

    public void setDesignName(String string) {
        this.getCurrentDesign().setFileName(string);
    }

    public boolean deleteDesign(String string) {
        ApplicationView.log(MessageFormat.format(Messages.getString("ApplicationView.DeleteDesign"), string));
        return this.getXMLTransformationManager().deleteDesign(this.getCurrentDesign().getDesignPath(), string);
    }

    public boolean designExists(String string) {
        return this.getXMLTransformationManager().designExists(this.getCurrentDesign().getDesignPath(), string);
    }

    public RelationalDesign selectRelationalDesign() {
        if (this.getDesigns().size() == 1 && this.getCurrentDesign().getRelationalDesigns().size() == 1) {
            return this.getCurrentDesign().getRelationalDesign();
        }
        return SelectRelationalModelDialog.showDialog(this);
    }

    public Design selectDesign() {
        Design[] designArray = (Design[])this.getDesigns().toArray();
        if (designArray.length > 1) {
            return SelectDesignsDialog.showDialog(this);
        }
        if (designArray.length == 1) {
            return designArray[0];
        }
        return null;
    }

    public Design selectFirstDesign() {
        Design[] designArray = (Design[])this.getDesigns().toArray();
        if (designArray.length > 0) {
            return designArray[0];
        }
        return null;
    }

    public DataFlowDesign selectDataFlowDiagram() {
        Object[] objectArray;
        Iterator iterator = this.getCurrentDesign().getProcessModel().getDataFlowDesigns().iterator();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            if (!objectArray.isTopLevel()) continue;
            arrayList.add(objectArray);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (DataFlowDesign)arrayList.get(0);
        }
        objectArray = arrayList.toArray();
        Object object = JOptionPane.showInputDialog((Component)Ide.getMainWindow(), Messages.getString("ApplicationView.SelectDataFlowDiagram"), Messages.getString("ApplicationView.DataFlowDiagrams"), 3, this.getConfiguration().getIcon("DESIGN_ICON", this.getPreferredIconSize()), objectArray, this.getCurrentDesign().getProcessModel().getDataFlowDesign());
        if (object != null && object instanceof DataFlowDesign) {
            return (DataFlowDesign)object;
        }
        return null;
    }

    public URL getUserHomeDirectory() {
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)uRL) ? uRL : null;
    }

    public String selectDesignName(String string) {
        int n;
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("ApplicationView.OracleSQLDeveloperModelingDesignFiles");
            }
        };
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(0);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setURLFilter(uRLFilter);
        String string2 = this.getSettings().getDefaultDesignsPath();
        if (string2 != null) {
            uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string2));
        } else {
            URL uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                uRLChooser.setSelectedURL(uRL);
            }
        }
        if (string != null) {
            uRLChooser.setFileNameURL(string + ".dmd");
        }
        if ((n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("ApplicationView.SaveDesign"))) == 0) {
            File file = new File(uRLChooser.getSelectedURL().getPath());
            this.getCurrentDesign().setDesignPath(file.getParentFile().getAbsolutePath());
            String string3 = file.getName();
            if (string3.endsWith(".dmdz")) {
                this.getCurrentDesign().setCompressedDesign(true);
            }
            return FileUtils.removeExt(string3);
        }
        return null;
    }

    public boolean overwriteDesign(String string) {
        if (Extension.isSVNExtensionLoaded() && this.pathIsVersioned(new File(this.getCurrentDesign().getDesignPath(), string).getAbsolutePath())) {
            MessageDialogs.showWarningMessage(Messages.getString("ApplicationView.CanNotUseVersionedDir"));
            return false;
        }
        if (!this.checkDesignNameUnique(string)) {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ApplicationView.AllreadyExistsOverwrite"), string), Messages.getString("ApplicationView.DesignAlreadyExists"), 0, 3);
            switch (n) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public DDLExceptionList getDDLExceptionList() {
        if (this.ddlExceptionList == null) {
            this.ddlExceptionList = new DDLExceptionList();
        }
        return this.ddlExceptionList;
    }

    public void addRecent(String string, String string2) {
        if (!this.getSettings().recentDesignExists(string, string2)) {
            ControllerApplication.Recent recent = new ControllerApplication.Recent(this.getController());
            recent.setDesignName(string);
            recent.setDesignPath(string2);
            this.getSettings().addRecent(recent);
        }
    }

    public boolean isImporting() {
        return importing;
    }

    public void setImporting(boolean bl) {
        importing = bl;
        this.enableControls(!bl);
    }

    public boolean isMerging() {
        return merging;
    }

    public void setMerging(boolean bl) {
        merging = bl;
    }

    public void enableControls(boolean bl) {
        this.getControllerSet().getMenuStructure().enableActions(bl);
        this.browserPanel.getJTree().setEnabled(bl);
    }

    public BrowserPanel getBrowserPanel() {
        return this.browserPanel;
    }

    public JDialog getNavigator() {
        if (this.navigator == null) {
            this.navigator = new JDialog(this.getFrame());
            this.navigator.setTitle(Messages.getString("ApplicationView.Navigator"));
            this.navigator.setSize(new Dimension(280, 210));
            this.navigator.setLocationRelativeTo(this.getFrame());
        }
        return this.navigator;
    }

    public JPanel getNavigatorPanel() {
        if (this.navPanel == null) {
            this.navPanel = new JPanel(new BorderLayout());
            if (this.currentDPV != null) {
                this.setNavigatorPanel(this.currentDPV.getNavigatorPanel());
            }
        }
        return this.navPanel;
    }

    public void setNavigatorPanel(JPanel jPanel) {
        this.getNavigatorPanel().removeAll();
        this.getNavigatorPanel().add(jPanel);
        if (this.getNavigatorPanel().getParent() != null && this.getNavigatorPanel().getParent() instanceof JPanel) {
            ((JPanel)this.getNavigatorPanel().getParent()).updateUI();
        } else {
            this.getNavigatorPanel().updateUI();
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void updateSettings(boolean bl, boolean bl2) {
        ModelIDObject modelIDObject;
        this.getCurrentDesign().getDataTypesDesign().getMainView().updateSettings(bl, bl2);
        this.getCurrentDesign().getLogicalDesign().getMainView().updateSettings(bl, bl2);
        Iterator iterator = this.getCurrentDesign().getLogicalDesign().getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (DesignPartViewPlaceHolder)iterator.next();
            ((DesignPartViewPlaceHolder)modelIDObject).getDesignPartView().updateSettings(bl, bl2);
        }
        iterator = this.getCurrentDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (RelationalDesign)iterator.next();
            ((RelationalDesign)modelIDObject).getMainView().updateSettings(bl, bl2);
            Iterator iterator2 = ((DesignPart)modelIDObject).getDesignSubviews().iterator();
            while (iterator2.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
                designPartViewPlaceHolder.getDesignPartView().updateSettings(bl, bl2);
            }
        }
        iterator = this.getCurrentDesign().getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (DataFlowDesign)iterator.next();
            ((DataFlowDesign)modelIDObject).getMainView().updateSettings(bl, bl2);
        }
        iterator = this.getCurrentDesign().getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (MultidimensionalDesign)iterator.next();
            ((MultidimensionalDesign)modelIDObject).getMainView().updateSettings(bl, bl2);
        }
    }

    public void updateFontsAndColors(boolean bl) {
        ModelIDObject modelIDObject;
        this.getCurrentDesign().getDataTypesDesign().updateFontsAndColors(bl);
        this.getCurrentDesign().getLogicalDesign().updateFontsAndColors(bl);
        Iterator iterator = this.getCurrentDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (RelationalDesign)iterator.next();
            ((RelationalDesign)modelIDObject).updateFontsAndColors(bl);
        }
        iterator = this.getCurrentDesign().getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (DataFlowDesign)iterator.next();
            ((DataFlowDesign)modelIDObject).updateFontsAndColors(bl);
        }
        iterator = this.getCurrentDesign().getProcessModel().getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (TransformationPackage)iterator.next();
            Iterator iterator2 = ((TransformationPackage)modelIDObject).getTransformationTaskSet().iterator();
            while (iterator2.hasNext()) {
                TransformationTask transformationTask = (TransformationTask)iterator2.next();
                transformationTask.updateFontsAndColors(bl);
            }
        }
        iterator = this.getCurrentDesign().getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (MultidimensionalDesign)iterator.next();
            ((MultidimensionalDesign)modelIDObject).updateFontsAndColors(bl);
        }
        this.updateLegendsSize();
    }

    public void updateLegendsSize() {
        ModelIDObject modelIDObject;
        Iterator iterator;
        ModelIDObject modelIDObject2;
        this.getCurrentDesign().getDataTypesDesign().getMainView().updateLegendSize();
        this.getCurrentDesign().getLogicalDesign().getMainView().updateLegendSize();
        Iterator iterator2 = this.getCurrentDesign().getLogicalDesign().getDesignSubviews().iterator();
        while (iterator2.hasNext()) {
            modelIDObject2 = (DesignPartViewPlaceHolder)iterator2.next();
            ((DesignPartViewPlaceHolder)modelIDObject2).getDesignPartView().updateLegendSize();
        }
        iterator2 = this.getCurrentDesign().getRelationalDesigns().iterator();
        while (iterator2.hasNext()) {
            modelIDObject2 = (RelationalDesign)iterator2.next();
            ((RelationalDesign)modelIDObject2).getMainView().updateLegendSize();
            iterator = ((DesignPart)modelIDObject2).getDesignSubviews().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (DesignPartViewPlaceHolder)iterator.next();
                ((DesignPartViewPlaceHolder)modelIDObject).getDesignPartView().updateLegendSize();
            }
        }
        iterator2 = this.getCurrentDesign().getProcessModel().getDataFlowDesigns().iterator();
        while (iterator2.hasNext()) {
            modelIDObject2 = (DataFlowDesign)iterator2.next();
            ((DataFlowDesign)modelIDObject2).getMainView().updateLegendSize();
        }
        iterator2 = this.getCurrentDesign().getProcessModel().getTransformationPackageSet().iterator();
        while (iterator2.hasNext()) {
            modelIDObject2 = (TransformationPackage)iterator2.next();
            iterator = ((TransformationPackage)modelIDObject2).getTransformationTaskSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (TransformationTask)iterator.next();
                ((TransformationTask)modelIDObject).getMainView().updateLegendSize();
            }
        }
        iterator2 = this.getCurrentDesign().getMultidimensionalDesigns().iterator();
        while (iterator2.hasNext()) {
            modelIDObject2 = (MultidimensionalDesign)iterator2.next();
            ((MultidimensionalDesign)modelIDObject2).getMainView().updateLegendSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitApplication() {
        this.cancel = false;
        if (!IS_VIEWER) {
            if (!this.getCurrentDesign().isLoadFromDB() && (this.getCurrentDesign().isNewDesign() || "".equalsIgnoreCase(this.getCurrentDesign().getDesignPath()))) {
                Object[] objectArray = this.whatToSave(true);
                if (objectArray != null && objectArray.length > 0) {
                    objectArray = ApplicationView.checkAndAddDesign(this.getCurrentDesign(), objectArray);
                }
                if (objectArray != null && objectArray.length > 0) {
                    String string;
                    String string2 = this.getCurrentDesign().getDesignPath();
                    String string3 = null;
                    if (!this.getCurrentDesign().isNewDesign()) {
                        string3 = this.getCurrentDesign().getName();
                    }
                    if ((string = this.selectDesignName(string3)) != null) {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            boolean bl = this.overwriteDesign(string);
                            if (!bl) {
                                while (string != null && !bl) {
                                    if ((string = this.selectDesignName(string)) != null) {
                                        bl = this.overwriteDesign(string);
                                        continue;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                this.getCurrentDesign().setFileName(string);
                                this.setDesignName(string);
                                this.synchronizeTitle();
                                this.getXMLTransformationManager().setCheckDirty(!this.getCurrentDesign().isNewDesign());
                                ApplicationView.log(Messages.getString("ApplicationView.SavingDesignAndPhysicalModels"));
                                this.doSave(objectArray);
                                this.addRecent(this.getDesignName(), this.getCurrentDesign().getDesignPath());
                                this.getCurrentDesign().setReadOnly(false);
                                this.getCurrentDesign().setDirty(false);
                            }
                            this.getCurrentDesign().setDesignPath(string2);
                            ApplicationView.log(Messages.getString("ApplicationView.SaveDesignAsCanceled"));
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    } else {
                        ApplicationView.log(Messages.getString("ApplicationView.SaveDesignAsCanceled"));
                        this.cancel = true;
                    }
                }
            } else {
                Object[] objectArray = this.whatToSave(false);
                if (objectArray != null && objectArray.length > 0) {
                    try {
                        objectArray = ApplicationView.checkAndAddDesign(this.getCurrentDesign(), objectArray);
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        this.doSave(objectArray);
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        }
        if (!this.cancel) {
            this.closeApplication();
        }
    }

    public static Object[] checkAndAddDesign(Design design, Object[] objectArray) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (design != objectArray[i]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length + 1);
            arrayList.add(design);
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return objectArray;
    }

    public Object[] whatToSave(boolean bl) {
        Object[] objectArray = this.getDirtyDesigns(bl);
        String string = Messages.getString("ApplicationView.DesignNotSaved");
        return this.whatToSave(objectArray, objectArray, string);
    }

    public Object[] whatToSave(Object[] objectArray, Object[] objectArray2, String string) {
        Object[] objectArray3 = new Object[]{Messages.getString("ApplicationView.SaveSelected"), Messages.getString("ApplicationView.CloseWithoutSave"), Messages.getString("ApplicationView.Cancel")};
        return this.whatToSave(objectArray, objectArray2, string, objectArray3);
    }

    public Object[] whatToSave(Object[] objectArray, Object[] objectArray2, String string, Object[] objectArray3) {
        Collection<Object> collection = null;
        collection = objectArray2 == null ? Collections.EMPTY_SET : Arrays.asList(objectArray2);
        if (objectArray != null && objectArray.length > 0) {
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            JCheckBox[] jCheckBoxArray = new JCheckBox[objectArray.length];
            int n = objectArray.length <= 3 ? 90 : (objectArray.length <= 6 ? 130 : 200);
            for (int i = 0; i < objectArray.length; ++i) {
                jCheckBoxArray[i] = new JCheckBox(objectArray[i].toString(), collection.contains(objectArray[i]));
                jPanel.add(jCheckBoxArray[i]);
            }
            this.cancel = false;
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setPreferredSize(new Dimension(300, n));
            int n2 = !Extension.isExtension ? 1 : 0;
            int n3 = JOptionPane.showOptionDialog(this.getFrame(), new Object[]{string, jScrollPane}, MessageFormat.format(Messages.getString("ApplicationView.SaveDesignName"), this.getCurrentDesign().getName()), n2, 3, null, objectArray3, objectArray3[0]);
            if (n3 == 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < jCheckBoxArray.length; ++i) {
                    if (!jCheckBoxArray[i].isSelected()) continue;
                    arrayList.add(objectArray[i]);
                }
                if (!Extension.isExtension) {
                    this.getFrame().setDefaultCloseOperation(0);
                }
                return arrayList.toArray();
            }
            if (n3 == 2 || n3 == -1) {
                this.cancel = true;
                if (!Extension.isExtension) {
                    this.getFrame().setDefaultCloseOperation(0);
                }
                return null;
            }
            if (!Extension.isExtension) {
                this.getFrame().setDefaultCloseOperation(0);
            }
            return null;
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(Object[] objectArray) {
        try {
            this.objectsToSave.clear();
            this.objectsToSave.addAll(Arrays.asList(objectArray));
            ProgressDialog progressDialog = new ProgressDialog(this, "", 0, objectArray.length);
            int n = this.getCurrentOperation();
            this.setCurrentOperation(2);
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    progressDialog.setNote(MessageFormat.format(Messages.getString("ApplicationView.SaveDesignNo"), String.valueOf(objectArray[i])));
                    progressDialog.setProgress(i);
                    if (this.getCurrentDesign().isLoadFromDB()) {
                        AbstractRepositoryManager abstractRepositoryManager = this.getDBPersistenceManager().getDBRepositoryManager();
                        if (objectArray[i] instanceof Design.DLSettings) {
                            abstractRepositoryManager.writeDesignLevelSettings(this.getCurrentDesign());
                            continue;
                        }
                        abstractRepositoryManager.writeObject((RepositoryObject)objectArray[i]);
                        continue;
                    }
                    if (objectArray[i] instanceof DesignPart) {
                        ((DesignPart)objectArray[i]).save();
                        continue;
                    }
                    if (objectArray[i] instanceof StorageDesign) {
                        ((StorageDesign)objectArray[i]).save();
                        continue;
                    }
                    if (objectArray[i] instanceof Design) {
                        ((Design)objectArray[i]).saveDesign();
                        continue;
                    }
                    if (!(objectArray[i] instanceof Design.DLSettings)) continue;
                    this.getCurrentDesign().saveDesignLevelSettings();
                }
            }
            finally {
                progressDialog.close();
                this.setCurrentOperation(n);
            }
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            MessageDialogs.showErrorMessage(Messages.getString("ApplicationView.UnableToSavetheDesign"));
        }
    }

    private boolean pathIsVersioned(String string) {
        SVNClientHelper sVNClientHelper = SVNClientHelper.getInstance();
        return sVNClientHelper.isVersioned(string);
    }

    protected boolean checkDesignNameUnique(String string) {
        boolean bl = this.getXMLTransformationManager().designExists(this.getCurrentDesign().getDesignPath(), string);
        return !bl;
    }

    public void loadDesign(String string, String string2) {
        ControllerApplication.Recent recent = new ControllerApplication.Recent(this.getController());
        recent.setDesignName(string);
        recent.setDesignPath(string2);
        recent.actionPerformed(null);
    }

    public DesignPartView createSubview(DesignPartView designPartView) {
        DesignPart designPart = designPartView.getDesignPart();
        if (designPart.canCreateDPSubview()) {
            DesignPartView designPartView2 = designPart.createDesignPartSubView();
            Editor editor = DMDiagramEditor.openNewDiagram(designPartView2.getTabbedPane());
            designPartView2.setContext(editor.getContext());
            designPartView2.setAutoRoute(designPartView.isAutoRoute());
            designPartView2.setNotation(designPartView.getNotation());
            designPartView2.setBoxInBox(designPartView.isBoxInBox());
            designPartView2.setShowNamesOnly(designPartView.isShowNamesOnly());
            designPartView2.setShowElements(designPartView.showElements());
            designPartView2.setShowKeyElements(designPartView.showKeyElements());
            designPartView2.setShowDatatype(designPartView.showDatatype());
            designPartView2.setShowAllDetails(designPartView.showAllDetails());
            designPartView2.setShowKeys(designPartView.showKeys());
            return designPartView2;
        }
        return null;
    }

    public DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(int n) {
        this.currentOperation = n;
    }

    public boolean isSelectedForSave(Object object) {
        if (this.getCurrentOperation() != 2) {
            return true;
        }
        return this.objectsToSave.contains(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationView getInstance() {
        if (instance == null) {
            if (instantiating) {
                System.err.println("ERROR: ApplicationView.getInstanse() can not be called during initialization of ApplicationView!!!");
                System.err.println();
                return null;
            }
            instantiating = true;
            try {
                instance = new ApplicationView();
            }
            finally {
                instantiating = false;
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationView getInstance(DropTargetListener dropTargetListener) {
        if (instance == null) {
            if (instantiating) {
                System.err.println("ERROR: ApplicationView.getInstanse() can not be called during initialization of ApplicationView!!!");
                System.err.println();
                return null;
            }
            instantiating = true;
            try {
                instance = new ApplicationView(dropTargetListener);
            }
            finally {
                instantiating = false;
            }
        }
        return instance;
    }

    public void setDebugMode() {
        String string = System.getProperty("ide.debugmode");
        if (string == null || !"true".equalsIgnoreCase(string)) {
            System.setOut(NullOutputStream.getNullPrintStream());
        } else {
            debugMode = true;
        }
    }

    public void setJDOMparsing() {
        String string = System.getProperty("dm.JDOMparsing");
        XMLTransformationManager.JDOM_PARSING = string != null && "true".equalsIgnoreCase(string);
    }

    public void setPropagateFKAttributeDescription() {
        String string = System.getProperty("dm.PropagateFKAttributeDescription");
        PROPAGATE_FKATTRIBUTE_DESCRIPTION = string != null && "true".equalsIgnoreCase(string);
    }

    public void setSensitiveAndMasked() {
        String string = System.getProperty("dm.ShowSensitiveData");
        SHOW_SENSITIVE_DATA = string != null && "true".equalsIgnoreCase(string);
        string = System.getProperty("dm.ShowMaskedData");
        SHOW_MASKED_DATA = string != null && "true".equalsIgnoreCase(string);
    }

    public void setRebuildObjectList() {
        String string = System.getProperty("dm.RebuildObjectList");
        REBUILD_OBJECT_LIST = string != null && "true".equalsIgnoreCase(string);
    }

    public DDLFileMaker getDDLFileMaker() {
        if (this.ddlFileMaker == null) {
            this.ddlFileMaker = new DDLFileMaker(this.getCurrentDesign());
        }
        return this.ddlFileMaker;
    }

    public IDGenerator getIDGenerator() {
        if (this.globalGenerator == null) {
            this.globalGenerator = new IDGenerator();
        }
        return this.globalGenerator;
    }

    public MDConfiguration getMDConfiguration() {
        return this.configuration;
    }

    public MDPreferences getPreference() {
        return this.preferences;
    }

    public XMLPersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = new XMLPersistenceManager(this.configuration);
            this.persistenceManager.setAppView(this);
        }
        return this.persistenceManager;
    }

    public DesignRuleManager getDesignRuleManager(RelationalDesign relationalDesign) {
        if (this.designRuleManager == null) {
            this.designRuleManager = new DesignRuleManager(this.getCurrentDesign(), relationalDesign, this);
        } else if (relationalDesign != null) {
            this.designRuleManager.setRelDesign(relationalDesign);
        }
        return this.designRuleManager;
    }

    public Object[] getDirtyDesigns(boolean bl) {
        Object object;
        DesignPart designPart;
        LogicalDesign logicalDesign;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getCurrentDesign().isDirty()) {
            arrayList.add(this.getCurrentDesign());
        }
        if ((logicalDesign = this.getCurrentDesign().getLogicalDesign()).isDirty() || logicalDesign.hasDirtyStorableObjects()) {
            arrayList.add(logicalDesign);
        }
        Iterator iterator = this.getCurrentDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            designPart = (RelationalDesign)iterator.next();
            if (designPart.isDirty() || designPart.hasDirtyStorableObjects()) {
                arrayList.add(designPart);
            }
            object = ((RelationalDesign)designPart).getStorageDesignFactory().getOpenStorageDesigns();
            for (int i = 0; i < ((StorageDesign[])object).length; ++i) {
                if (!object[i].isDirty() && !((StorageDesign)object[i]).hasDirtyStorableObjects() || !((StorageDesign)object[i]).isOpen()) continue;
                arrayList.add(object[i]);
            }
        }
        designPart = this.getCurrentDesign().getProcessModel();
        if (designPart.isDirty() && !((ProcessModel)designPart).isEmpty() || designPart.hasDirtyStorableObjects()) {
            arrayList.add(designPart);
        }
        iterator = ((ProcessModel)designPart).getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            object = (DataFlowDesign)iterator.next();
            if (!((ModelIDObject)object).isDirty() && !((DesignPart)object).hasDirtyStorableObjects()) continue;
            arrayList.add(object);
        }
        if (this.getCurrentDesign().getDataTypesDesign().isDirty() || this.getCurrentDesign().getDataTypesDesign().hasDirtyStorableObjects()) {
            arrayList.add(this.getCurrentDesign().getDataTypesDesign());
        }
        iterator = this.getCurrentDesign().getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            object = (DesignPart)iterator.next();
            if (!((ModelIDObject)object).isDirty() && !((DesignPart)object).hasDirtyStorableObjects()) continue;
            arrayList.add(object);
        }
        if (!bl && this.getCurrentDesign().areDlSettingsChanged()) {
            arrayList.add(0, this.getCurrentDesign().getDLSettings());
        }
        return arrayList.toArray();
    }

    public DBPersistenceManager getDBPersistenceManager() {
        if (this.dbPersistenceManager == null) {
            this.dbPersistenceManager = new DBPersistenceManager(this);
        }
        return this.dbPersistenceManager;
    }

    public DesignSet getDesigns() {
        return this.designSet;
    }

    private void createDesignSet() {
        this.designSet = new DesignSet(this);
        this.designSet.setName(Messages.getString("ApplicationView.ApplicationView.Designs"));
        this.designSet.setElementDescriptor(Design.class);
        this.designSet.setParent(this);
    }

    public Design addDesign(boolean bl) {
        this.currentDesign = (Design)this.designSet.createElement(null);
        this.currentDesign.setDlSettings(this.initialSettings.getDesignLevelSettings());
        this.designSet.sortByName();
        if (bl) {
            this.openMainDiagrams();
        }
        this.currentDesign.setDirty(false);
        return this.currentDesign;
    }

    public void removeDesign(Design design) {
        design.closeAllDiagramsAndClearRefs();
        this.designSet.remove(design);
        if (this.getDBPersistenceManager().getDBRepositoryManager().getDesign() == design) {
            this.getDBPersistenceManager().nullifyDBRepositoryManager();
        }
        if (this.currentDPV != null && this.currentDPV.getDesign() == design) {
            this.currentDPV = null;
        }
        if (this.designSet.size() > 0) {
            this.currentDesign = (Design)this.designSet.getElement(this.designSet.size() - 1);
        } else {
            this.currentDesign = this.addDesign(true);
            this.currentDesign.getDLSettings().loadDLSettings(this.initialSettings.getDesignLevelSettings());
            if (!this.getSettings().isRestorePreviousDLSettingsAfterClose()) {
                this.currentDesign.getDLSettings().loadDLSettings(this.initialSettings.getDesignLevelSettings());
                this.updateSettings(false, false);
            }
        }
        this.getBrowserPanel().getJTree().updateUI();
        SetEvent.clearEvents();
        ObjectChangeEvent.clearEvents();
        StorageEvent.clearEvents();
        TableLevelConstraintEvent.clearEvents();
        Domain.clearEvents();
        LogicalDatatype.clearEvents();
        TableProxy.clearEvents();
    }

    public void closeAllDesigns() {
        Object[] objectArray = this.designSet.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Design design = (Design)objectArray[i];
            this.setCurrentDesign(design);
            ((ControllerApplication.CloseDesign)this.getController().getCloseDesignAction()).execute();
        }
        System.gc();
        System.runFinalization();
    }

    public List getCopiedObjects() {
        return this.copiedObjects;
    }

    public void addCopiedObject(DesignObject designObject) {
        this.copiedObjects.add(designObject);
    }

    public void clearCopiedObjects() {
        this.copiedObjects.clear();
    }

    public ArrayList<DRCustomScript> getCustomDesignRules() {
        return this.customDesignRules;
    }

    public ArrayList<DRLibrary> getCustomLibraries() {
        return this.customLibraries;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public XMLTransformationManager getXMLTransformationManager() {
        if (this.xmlTransformationManager == null) {
            this.xmlTransformationManager = new XMLTransformationManager();
        }
        return this.xmlTransformationManager;
    }

    private void initScriptEngines() {
        this.scriptEngines.clear();
        List<ScriptEngineFactory> list = this.scriptEngineManager.getEngineFactories();
        for (ScriptEngineFactory scriptEngineFactory : list) {
            String string = scriptEngineFactory.getEngineName();
            this.scriptEngineManager.registerEngineName(string, scriptEngineFactory);
            this.scriptEngines.add(string);
        }
    }

    public ArrayList getScriptEngines() {
        return this.scriptEngines;
    }

    public ArrayList<ReportTemplate> getReportTemplates() {
        return this.reportTemplates;
    }

    public void closeAllDialogs() {
        try {
            Window[] windowArray = Window.getWindows();
            for (int i = windowArray.length - 1; i >= 0; --i) {
                Window window = windowArray[i];
                if (!(window instanceof Dialog)) continue;
                window.dispose();
            }
        }
        catch (Exception exception) {
            LOGGER.error("ApplicationView.closeAllDialogs", exception);
        }
    }

    public static void waitLoadFilesThreadToComplete() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        for (Thread thread : threadArray) {
            if (thread == null || !thread.getClass().getName().equals("javax.swing.plaf.basic.BasicDirectoryModel$LoadFilesThread")) continue;
            try {
                thread.join();
            }
            catch (Exception exception) {
                System.out.println("error in waitLoadFilesThreadToComplete " + thread.getClass().getName());
            }
        }
    }

    public void initLineTerminator() {
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        int n = environOptions.getLineTerminator();
        String string = n == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")));
        SQLStatementBuilder.NEWLINE = string;
    }

    public Settings getInitialSettings() {
        return this.initialSettings;
    }

    public void setInitialSettings(Settings settings) {
        this.initialSettings = new Settings(this);
        this.initialSettings.loadSettingsFromString(settings.saveSettingsToString(), true);
    }

    public void nullifyDesignRuleManager() {
        this.designRuleManager = null;
    }

    static {
        debugMode = false;
        frame = Ide.getMainWindow();
        basePath = "../";
        instance = null;
        PROPAGATE_FKATTRIBUTE_DESCRIPTION = false;
        SHOW_SENSITIVE_DATA = false;
        SHOW_MASKED_DATA = false;
        REBUILD_OBJECT_LIST = false;
        LOGGER = new Logger(ApplicationView.class);
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        instantiating = false;
    }

    class SettingsListener
    implements ChangeListener {
        SettingsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            LOGGER.update();
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        TreePath lastSucPath;

        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath;
            if (!ApplicationView.this.getCurrentDesign().isClosing() && !loading && (treePath = treeModelEvent.getTreePath()).getParentPath() != null) {
                this.lastSucPath = treePath;
            }
        }
    }

    public class ApplicationCloser
    extends WindowAdapter {
        private String[] options = new String[]{Messages.getString("ApplicationView.WaitUntilTasksFinish"), Messages.getString("ApplicationView.ExitLoseData")};
        String appName = MDConfiguration.getDefaultInstance().get("appName");
        private Object messageWarning = new String[]{MessageFormat.format(Messages.getString("ApplicationView.WaitingTasksTofinish"), this.appName), MessageFormat.format(Messages.getString("ApplicationView.IfYouSelect"), this.options[1]), Messages.getString("ApplicationView.DoNotContinue")};
        private int closeCount = 0;

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ControllerApplication.ExitApplication exitApplication;
            ControllerApplication controllerApplication = ApplicationView.this.getController();
            if (controllerApplication != null && (exitApplication = controllerApplication.getExitAction()) != null) {
                ApplicationView.this.getFrame().setDefaultCloseOperation(0);
                ((MDBAction)exitApplication).doActionPerformed(null);
                return;
            }
            this.doExit();
        }

        private void doExit() {
            if (++this.closeCount > 1) {
                this.forceExit();
            } else if (!Extension.isExtension) {
                RuntimeMonitor.getInstance().systemExitAfterThreadsNonBlocking();
            }
        }

        private void forceExit() {
            int n = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), this.messageWarning, Messages.getString("ApplicationView.Closeapplication"), 1, 2, null, this.options, this.options[0]);
            if (n == 1) {
                System.exit(0);
            }
        }
    }

    class ToggleListener
    implements ActionListener {
        ToggleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            Component[] componentArray = Ide.getToolbar().getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof AbstractButton)) continue;
                AbstractButton abstractButton2 = (AbstractButton)componentArray[i];
                if (abstractButton2 != abstractButton) {
                    abstractButton2.setSelected(false);
                    continue;
                }
                abstractButton2.setSelected(true);
            }
        }
    }
}

