/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.xtdmapping.ContainerMapping;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class RelMapping {
    XtdMapping mapping;
    RMExtendedMap xmap;
    DesignObject lob;
    DesignObject rob;
    boolean log_rel = true;
    ContainerMapping containerMapping;

    public RelMapping(XtdMapping xtdMapping, RMExtendedMap rMExtendedMap) {
        this.mapping = xtdMapping;
        this.xmap = rMExtendedMap;
        this.lob = xtdMapping.getLogicalObject();
        this.rob = xtdMapping.getRelationalObject();
        if (this.rob != null) {
            if (this.rob != xtdMapping.getTargetObject()) {
                this.log_rel = false;
            }
        } else if (!rMExtendedMap.getRelationalModel().getObjectID().equals(xtdMapping.getTargetDesignPartID())) {
            this.log_rel = false;
        }
    }

    public String getID() {
        return this.mapping.getID();
    }

    public void setID(String string) {
        this.mapping.setID(string);
    }

    public String getLogID() {
        if (this.lob != null) {
            return this.lob.getObjectID();
        }
        if (this.log_rel) {
            return this.mapping.getOwnerID();
        }
        return this.mapping.getTargetID();
    }

    public void setLogID(String string) {
        this.mapping.setOwnerID(string);
    }

    public String getRelID() {
        if (this.rob != null) {
            return this.rob.getObjectID();
        }
        if (this.log_rel) {
            return this.mapping.getTargetID();
        }
        return this.mapping.getOwnerID();
    }

    public void setRelID(String string) {
        this.mapping.setTargetID(string);
    }

    public String getLogContainerID() {
        String string = this.getLogicalContainerID();
        if (this.containerMapping != null && string != null && !string.equals(this.containerMapping.getLogID())) {
            return string;
        }
        return null;
    }

    private String getLogicalContainerID() {
        if (this.lob != null) {
            ContainerObject containerObject = RelMapping.getContainer(this.lob);
            if (containerObject != null) {
                return containerObject.getObjectID();
            }
            return null;
        }
        if (this.log_rel) {
            return this.mapping.getOwnerContainerID();
        }
        return this.mapping.getTargetContainerID();
    }

    public void setLogContainerID(String string) {
        this.mapping.setOwnerContainerID(string);
    }

    public String getRelContainerID() {
        return null;
    }

    public String getRelationalContainerID() {
        if (this.rob != null) {
            ContainerObject containerObject = RelMapping.getContainer(this.rob);
            if (containerObject != null) {
                return containerObject.getObjectID();
            }
            return null;
        }
        if (this.log_rel) {
            return this.mapping.getTargetContainerID();
        }
        return this.mapping.getOwnerContainerID();
    }

    public void setRelContainerID(String string) {
        this.mapping.setTargetContainerID(string);
    }

    public static ContainerObject getContainer(DesignObject designObject) {
        if (designObject instanceof ContainedObject) {
            return ((ContainedObject)designObject).getContainer();
        }
        if (designObject instanceof KeyObject) {
            return ((KeyObject)designObject).getContainerWithKeyObject();
        }
        return null;
    }

    public int getLogType() {
        if (this.lob != null) {
            return XtdMapping.getTypeFor(this.lob);
        }
        if (this.log_rel) {
            return this.mapping.getOwnerType();
        }
        return this.mapping.getTargetType();
    }

    public void setLogType(int n) {
        this.mapping.setOwnerType(n);
    }

    public int getRelType() {
        if (this.rob != null) {
            return XtdMapping.getTypeFor(this.rob);
        }
        if (this.log_rel) {
            return this.mapping.getTargetType();
        }
        return this.mapping.getOwnerType();
    }

    public void setRelType(int n) {
        this.mapping.setTargetType(n);
    }

    public int getInheritanceType() {
        return this.mapping.getInheritanceType();
    }

    public void setInheritanceType(int n) {
        this.mapping.setInheritanceType(n);
    }

    public long getCreationTime() {
        return this.mapping.getCreationTime();
    }

    public void setCreationTime(long l) {
        this.mapping.setCreationTime(l);
    }

    public XtdMapping getXtdMapping() {
        return this.mapping;
    }

    public void setContainerMapping(ContainerMapping containerMapping) {
        this.containerMapping = containerMapping;
    }
}

