/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class MappingCollector {
    private String objectID;
    private List map = new ArrayList();
    private Design design;

    public MappingCollector(Design design, String string) {
        this.objectID = string;
        this.design = design;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public List getMappingsForDesignPart(String string) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : this.map) {
            String string2 = xtdMapping.getOwnerDesignPartID();
            String string3 = xtdMapping.getTargetDesignPartID();
            if ((string2 == null || !string2.equalsIgnoreCase(string)) && (string3 == null || !string3.equalsIgnoreCase(string)) || xtdMapping.isDeleted()) continue;
            arrayList.add(xtdMapping);
        }
        return arrayList;
    }

    public List getDeletedMappingsForDesignPart(String string) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : this.map) {
            String string2 = xtdMapping.getOwnerDesignPartID();
            String string3 = xtdMapping.getTargetDesignPartID();
            if ((string2 == null || !string2.equalsIgnoreCase(string)) && (string3 == null || !string3.equalsIgnoreCase(string)) || !xtdMapping.isDeleted()) continue;
            arrayList.add(xtdMapping);
        }
        return arrayList;
    }

    public void addMapping(XtdMapping xtdMapping) {
        if (!this.map.contains(xtdMapping)) {
            this.map.add(xtdMapping);
        }
    }

    public void removeMapping(XtdMapping xtdMapping) {
        this.map.remove(xtdMapping);
    }

    public void removeMappingFor(String string) {
        for (int i = this.map.size() - 1; i >= 0; --i) {
            XtdMapping xtdMapping = (XtdMapping)this.map.get(i);
            if (!xtdMapping.getOwnerID().equalsIgnoreCase(string) && !xtdMapping.getTargetID().equalsIgnoreCase(string)) continue;
            this.map.remove(i);
        }
    }

    public void setMappingToDeleted(String string) {
        for (int i = this.map.size() - 1; i >= 0; --i) {
            XtdMapping xtdMapping = (XtdMapping)this.map.get(i);
            if (!xtdMapping.getOwnerID().equalsIgnoreCase(string) && !xtdMapping.getTargetID().equalsIgnoreCase(string)) continue;
            xtdMapping.setDeletedID(string);
        }
    }

    public Design getDesign() {
        return this.design;
    }

    public List getAllMappings() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    void clearAllMappings() {
        this.map.clear();
    }

    void nullifyObjects() {
        for (XtdMapping xtdMapping : this.map) {
            xtdMapping.nulifyObjects();
        }
    }
}

