/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.reference.AbstractReference;
import oracle.dbtools.crest.model.reference.CompositeReference;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.NullReference;
import oracle.dbtools.crest.model.reference.Reference;

public class ReferenceSet {
    protected int counter = 0;
    private Set atomicSet = new TreeSet();
    private Set compositeSet = new TreeSet();
    private Map refIdMap = new TreeMap();
    private Map objectIdMap = new TreeMap();
    private Reference nullReference;
    private Design design;

    public ModelIDObjectReference createReference(Design design) {
        this.design = design;
        ModelIDObjectReference modelIDObjectReference = this.instantiateReference(design);
        this.atomicSet.add(modelIDObjectReference);
        this.refIdMap.put(modelIDObjectReference.getIdString(), modelIDObjectReference);
        return modelIDObjectReference;
    }

    public ModelIDObjectReference createReference(Design design, int n) {
        this.design = design;
        ModelIDObjectReference modelIDObjectReference = this.instantiateReference(design, n);
        this.atomicSet.add(modelIDObjectReference);
        this.refIdMap.put(modelIDObjectReference.getIdString(), modelIDObjectReference);
        return modelIDObjectReference;
    }

    protected ModelIDObjectReference instantiateReference(Design design, int n) {
        return new ModelIDObjectReference(n, design, this);
    }

    protected ModelIDObjectReference instantiateReference(Design design) {
        return new ModelIDObjectReference(this.counter++, design, this);
    }

    public void removeReference(Reference reference) {
        if (reference.isCompositeReference()) {
            this.compositeSet.remove(reference);
        } else {
            this.atomicSet.remove(reference);
        }
        this.refIdMap.remove(reference.getIdString());
    }

    public boolean hasReferenceFor(String string) {
        if (string == null) {
            return false;
        }
        return this.objectIdMap.containsKey(string);
    }

    public Reference getFirstReferenceFor(String string) {
        return (Reference)this.objectIdMap.get(string);
    }

    public Reference getNullReference() {
        if (this.nullReference == null) {
            this.nullReference = new NullReference();
        }
        return this.nullReference;
    }

    protected void remapReference(ModelIDObjectReference modelIDObjectReference, String string) {
        if (string != null && this.objectIdMap.containsKey(string)) {
            this.objectIdMap.remove(string);
        }
        if (modelIDObjectReference.getObjectId() != null) {
            this.objectIdMap.put(modelIDObjectReference.getObjectId(), modelIDObjectReference);
        }
    }

    public Reference createCompositeReference() {
        CompositeReference compositeReference = (CompositeReference)this.createCompositeReference(this.getDesign().getRelationalDesign().getObjectID());
        return compositeReference;
    }

    public Reference createCompositeReference(String string) {
        CompositeReference compositeReference = new CompositeReference(this.counter++, string);
        this.compositeSet.add(compositeReference);
        this.refIdMap.put(compositeReference.getIdString(), compositeReference);
        return compositeReference;
    }

    public Reference createCompositeReference(int n) {
        CompositeReference compositeReference = (CompositeReference)this.createCompositeReference(this.getDesign().getRelationalDesign().getObjectID(), n);
        return compositeReference;
    }

    public Reference createCompositeReference(String string, int n) {
        CompositeReference compositeReference = new CompositeReference(n, string);
        this.compositeSet.add(compositeReference);
        this.refIdMap.put(compositeReference.getIdString(), compositeReference);
        return compositeReference;
    }

    public Reference getReferenceByIdString(String string) {
        return string == null ? new NullReference() : (Reference)this.refIdMap.get(string);
    }

    public void clearAll() {
        this.counter = 0;
        this.atomicSet.clear();
        this.compositeSet.clear();
        this.refIdMap.clear();
        this.objectIdMap.clear();
        this.nullReference = null;
    }

    public Reference[] getAtomicReferences() {
        return this.atomicSet.toArray(Reference.PROTOTYPE);
    }

    public Reference[] getCompositeReferences() {
        return this.compositeSet.toArray(Reference.PROTOTYPE);
    }

    public Design getDesign() {
        return this.design;
    }

    public void resetRefCounter() {
        Iterator iterator = this.refIdMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = Integer.valueOf(string);
            if (n2 <= n) continue;
            n = n2;
        }
        this.counter = n + 1;
    }

    public void removeReferenceByRefId(int n) {
        AbstractReference abstractReference;
        int n2;
        Object[] objectArray = this.atomicSet.toArray();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            abstractReference = (AbstractReference)objectArray[n2];
            if (abstractReference.getReferenceId() != n) continue;
            this.refIdMap.remove(abstractReference.getIdString());
            this.atomicSet.remove(abstractReference);
        }
        objectArray = this.compositeSet.toArray();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            abstractReference = (AbstractReference)objectArray[n2];
            if (abstractReference.getReferenceId() != n) continue;
            this.refIdMap.remove(abstractReference.getIdString());
            this.compositeSet.remove(abstractReference);
        }
    }
}

