/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.reference.AbstractReference;
import oracle.dbtools.crest.model.reference.Creator;
import oracle.dbtools.crest.model.reference.ReferenceSet;
import oracle.dbtools.crest.model.reference.SingleReferenceIterator;

public class ModelIDObjectReference
extends AbstractReference {
    public static final Object[] PROTOTYPE_ARRAY = new ModelIDObjectReference[0];
    private Design design;
    private ReferenceSet referenceSet;
    private ReferenceState state = new UninitializedReferenceState();
    private ReferenceState forwardState = null;
    private boolean keepAlive = false;

    protected ModelIDObjectReference(int n, Design design, ReferenceSet referenceSet) {
        super(n);
        this.referenceSet = referenceSet;
        this.design = design;
    }

    public Design getDesign() {
        return this.design;
    }

    protected RelationalDesign getPhysicalDesign() {
        return this.getDesign().getRelationalDesign();
    }

    public void setObject(ModelIDObject modelIDObject) {
        this.getState().setObject(modelIDObject);
    }

    @Override
    public DesignObject getObject() {
        DesignObject designObject;
        if (!this.getState().resolved() && this.getState().resolvable()) {
            this.getState().resolve();
        }
        if ((designObject = (DesignObject)this.getState().getObject()) != null && designObject.getDesignPart() != null) {
            this.setDesignPartId(designObject.getDesignPartId());
        }
        return designObject;
    }

    public void setObjectId(String string) {
        this.getState().setObjectId(string);
    }

    @Override
    public String getObjectId() {
        return this.getState().getObjectId();
    }

    public void setCreator(Creator creator) {
        this.getState().setCreator(creator);
    }

    public Creator getCreator() {
        return this.getState().getCreator();
    }

    public void loadOrCreateObject() {
        this.getState().resolve();
    }

    public boolean isResolved() {
        return this.getState().resolved();
    }

    public boolean isResolvable() {
        return this.getState().resolvable();
    }

    public void setDelegate(ModelIDObjectReference modelIDObjectReference) {
        this.getState().setDelegate(modelIDObjectReference);
    }

    private void setState(ReferenceState referenceState) {
        this.state = referenceState;
    }

    private ReferenceState getState() {
        return this.state;
    }

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isModelIDObjectReference() {
        return true;
    }

    @Override
    public ModelIDObjectReference asModelIDObjectReference() {
        return this;
    }

    protected void remapReference(String string) {
        if (this.referenceSet != null) {
            this.referenceSet.remapReference(this, string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendToString(stringBuffer);
        return stringBuffer.toString();
    }

    protected void appendToString(StringBuffer stringBuffer) {
        stringBuffer.append("[REF ").append(this.getIdString());
        this.appendStringProps("\n     ", stringBuffer);
        stringBuffer.append("\n    ");
        this.getState().appendToString(stringBuffer);
        stringBuffer.append(']');
    }

    public void setNullified(boolean bl) {
        if (bl) {
            this.setProperty("target.nullified", VALUE_TRUE);
            this.forwardState = null;
            this.setObject(null);
            this.setState(new DisabledState());
        } else {
            this.setProperty("target.nullified", VALUE_FALSE);
            if (this.forwardState != null) {
                this.setState(this.forwardState);
            } else {
                this.setState(new UninitializedReferenceState());
            }
        }
    }

    public boolean isNullified() {
        return this.hasProperty("target.nullified", VALUE_TRUE);
    }

    @Override
    public Iterator getSingleTargetReferences() {
        return new SingleReferenceIterator(this);
    }

    private class DisabledState
    extends ReferenceState {
        String message;

        private DisabledState() {
            this.message = "Reference is disabled";
        }

        @Override
        protected boolean resolved() {
            return false;
        }

        @Override
        protected void resolve() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected boolean resolvable() {
            return false;
        }

        @Override
        protected void setObject(ModelIDObject modelIDObject) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected ModelIDObject getObject() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void setObjectId(String string) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected String getObjectId() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void setCreator(Creator creator) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected Creator getCreator() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void setDelegate(ModelIDObjectReference modelIDObjectReference) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void appendToString(StringBuffer stringBuffer) {
            stringBuffer.append("Disabled reference");
        }
    }

    private class DelegateState
    extends ReferenceState {
        private ModelIDObjectReference delegate;

        DelegateState() {
            this.delegate = null;
        }

        @Override
        protected boolean resolved() {
            return this.delegate.getState().resolved();
        }

        @Override
        protected void resolve() {
            this.delegate.getState().resolve();
        }

        @Override
        protected boolean resolvable() {
            return this.delegate != null && this.delegate.getState().resolvable();
        }

        @Override
        protected void setObject(ModelIDObject modelIDObject) {
            this.delegate.getState().setObject(modelIDObject);
        }

        @Override
        protected ModelIDObject getObject() {
            return this.delegate.getState().getObject();
        }

        @Override
        protected void setObjectId(String string) {
            this.delegate.getState().setObjectId(string);
        }

        @Override
        protected String getObjectId() {
            return this.delegate.getState().getObjectId();
        }

        @Override
        protected void setCreator(Creator creator) {
            this.delegate.getState().setCreator(creator);
        }

        @Override
        protected Creator getCreator() {
            return this.delegate.getCreator();
        }

        @Override
        protected void setDelegate(ModelIDObjectReference modelIDObjectReference) {
            if (modelIDObjectReference != null) {
                if (ModelIDObjectReference.this == modelIDObjectReference) {
                    throw new IllegalArgumentException("A Reference can not delegate to itself.");
                }
                this.delegate = modelIDObjectReference;
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        @Override
        protected void appendToString(StringBuffer stringBuffer) {
            this.delegate.appendToString(stringBuffer);
        }
    }

    private class ConcreteObjectReferenceState
    extends ReferenceState
    implements SetListener {
        private ModelIDObject modelIdObject;

        private ConcreteObjectReferenceState() {
        }

        @Override
        protected boolean resolved() {
            return true;
        }

        @Override
        protected void resolve() {
            DesignObject designObject = ModelIDObjectReference.this.getDesign().getDesignObject(this.getObjectId());
            if (designObject != null) {
                this.setObject(designObject);
            }
        }

        @Override
        protected void setObject(ModelIDObject modelIDObject) {
            DesignObject designObject = null;
            if (this.modelIdObject instanceof DesignObject) {
                designObject = (DesignObject)this.modelIdObject;
            }
            if (designObject != null) {
                designObject.getDesignObjectSet().removeSetListener(this);
            }
            this.modelIdObject = modelIDObject;
            if (this.modelIdObject != null) {
                if (this.modelIdObject instanceof DesignObject) {
                    designObject = (DesignObject)this.modelIdObject;
                }
                if (designObject != null) {
                    designObject.getDesignObjectSet().addSetListener(this);
                    this.copyInfoFromProperties();
                }
            } else {
                this.restoreForwardReferenceState();
            }
        }

        protected void restoreForwardReferenceState() {
            if (ModelIDObjectReference.this.forwardState != null) {
                ModelIDObjectReference.this.setState(ModelIDObjectReference.this.forwardState);
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        protected void copyInfoFromProperties() {
            if (ModelIDObjectReference.this.hasProperty("object.name")) {
                this.modelIdObject.setName(ModelIDObjectReference.this.getProperty("object.name"));
            }
            if (ModelIDObjectReference.this.hasProperty("object.comment.fromsource")) {
                this.modelIdObject.addReplaceLabeledComment("Source", ModelIDObjectReference.this.getProperty("object.comment.fromsource"));
            }
            if (ModelIDObjectReference.this.hasProperty("object.comment.engineering")) {
                this.modelIdObject.addReplaceLabeledComment("Engineering", ModelIDObjectReference.this.getProperty("object.comment.engineering"));
            }
            if (ModelIDObjectReference.this.hasProperty("object.generatorid")) {
                this.modelIdObject.setGeneratorID(ModelIDObjectReference.this.getProperty("object.generatorid"));
            }
        }

        @Override
        protected ModelIDObject getObject() {
            return this.modelIdObject;
        }

        @Override
        protected String getObjectId() {
            return this.modelIdObject.getObjectID();
        }

        @Override
        protected void appendToString(StringBuffer stringBuffer) {
            stringBuffer.append(" object: ").append(this.modelIdObject.getObjectID());
        }

        @Override
        public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
            if (setEvent.isRemoved() && setEvent.getAffected() == this.modelIdObject) {
                DesignObject designObject = (DesignObject)this.modelIdObject;
                designObject.getDesignObjectSet().removeSetListener(this);
                designObject = null;
                this.restoreForwardReferenceState();
            }
        }
    }

    private class ConcreteIDReferenceState
    extends ReferenceState {
        private String objectId;

        private ConcreteIDReferenceState() {
        }

        @Override
        protected void setObjectId(String string) {
            this.objectId = string;
        }

        @Override
        protected String getObjectId() {
            return this.objectId;
        }

        @Override
        protected void resolve() {
            DesignObject designObject = ModelIDObjectReference.this.getDesign().getDesignObject(this.getObjectId());
            if (designObject != null) {
                this.setObject(designObject);
            }
        }

        @Override
        protected void appendToString(StringBuffer stringBuffer) {
            stringBuffer.append(" id: ").append(this.objectId);
        }
    }

    private class ForwardReferenceState
    extends ReferenceState {
        private Creator creator;

        private ForwardReferenceState() {
        }

        @Override
        protected void setCreator(Creator creator) {
            this.creator = creator;
        }

        @Override
        protected Creator getCreator() {
            return this.creator;
        }

        @Override
        protected boolean resolvable() {
            return this.creator != null && this.creator.canCreateNow();
        }

        @Override
        protected void resolve() {
            ModelIDObject modelIDObject = (ModelIDObject)this.creator.create();
            this.setObject(modelIDObject);
        }

        @Override
        protected void appendToString(StringBuffer stringBuffer) {
            stringBuffer.append(" fwd: ").append(this.creator);
        }
    }

    private class UninitializedReferenceState
    extends ReferenceState {
        private UninitializedReferenceState() {
        }

        @Override
        protected boolean resolvable() {
            return false;
        }

        @Override
        protected void appendToString(StringBuffer stringBuffer) {
            stringBuffer.append(" unresolved");
        }
    }

    private abstract class ReferenceState {
        private ReferenceState() {
        }

        protected boolean resolved() {
            return false;
        }

        protected void resolve() {
        }

        protected boolean resolvable() {
            return true;
        }

        protected void setObject(ModelIDObject modelIDObject) {
            if (modelIDObject != null) {
                String string = ModelIDObjectReference.this.getState().getObjectId();
                ConcreteObjectReferenceState concreteObjectReferenceState = new ConcreteObjectReferenceState();
                ((ReferenceState)concreteObjectReferenceState).setObject(modelIDObject);
                ModelIDObjectReference.this.setState(concreteObjectReferenceState);
                ModelIDObjectReference.this.remapReference(string);
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        protected ModelIDObject getObject() {
            return null;
        }

        protected void setObjectId(String string) {
            if (string != null && !string.equals(ModelIDObjectReference.this.getState().getObjectId())) {
                String string2 = ModelIDObjectReference.this.getState().getObjectId();
                ConcreteIDReferenceState concreteIDReferenceState = new ConcreteIDReferenceState();
                ((ReferenceState)concreteIDReferenceState).setObjectId(string);
                ModelIDObjectReference.this.setState(concreteIDReferenceState);
                ModelIDObjectReference.this.remapReference(string2);
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        protected String getObjectId() {
            return null;
        }

        protected void setCreator(Creator creator) {
            ForwardReferenceState forwardReferenceState = new ForwardReferenceState();
            ((ReferenceState)forwardReferenceState).setCreator(creator);
            ModelIDObjectReference.this.setState(forwardReferenceState);
            ModelIDObjectReference.this.forwardState = forwardReferenceState;
        }

        protected Creator getCreator() {
            return null;
        }

        protected void setDelegate(ModelIDObjectReference modelIDObjectReference) {
            if (modelIDObjectReference != null) {
                DelegateState delegateState = new DelegateState();
                ((ReferenceState)delegateState).setDelegate(modelIDObjectReference);
                ModelIDObjectReference.this.setState(delegateState);
            }
        }

        protected abstract void appendToString(StringBuffer var1);
    }
}

