/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.reference.CompositeReference;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.Reference;
import oracle.dbtools.crest.model.reference.ReferencePropertyNames;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapImplementation;

public abstract class AbstractReference
implements Reference,
PropertyMap,
ReferencePropertyNames {
    public static final Object[] PROTOTYPE_ARRAY = new Reference[0];
    private int refId = -1;
    private PropertyMapImplementation properties = new PropertyMapImplementation();
    private String designPartId;
    private static final Logger LOGGER = new Logger(AbstractReference.class);

    public AbstractReference(int n) {
        if (!this.isNullReference() && n == -1) {
            throw new IllegalArgumentException("id '-1' reserved for NullReference");
        }
        this.refId = n;
    }

    public final boolean equals(Object object) {
        if (object != null && object instanceof Reference) {
            return this.getReferenceId() == ((AbstractReference)object).getReferenceId();
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceId();
    }

    public int compareTo(Object object) {
        return this.getReferenceId() - ((Reference)object).getReferenceId();
    }

    @Override
    public int getReferenceId() {
        return this.refId;
    }

    public boolean setReferenceId(String string) {
        try {
            this.refId = Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("setReferenceId: id is not an int: " + string, numberFormatException);
            return false;
        }
    }

    @Override
    public boolean isModelIDObjectReference() {
        return false;
    }

    @Override
    public boolean isCompositeReference() {
        return false;
    }

    @Override
    public CompositeReference asCompositeReference() {
        throw new ClassCastException("This Reference is not a CompositeReference");
    }

    @Override
    public ModelIDObjectReference asModelIDObjectReference() {
        throw new ClassCastException("This Reference is not a ModelIDObjectReference");
    }

    @Override
    public boolean refersTo(Reference reference) {
        return this.equals(reference);
    }

    @Override
    public boolean isNullReference() {
        return false;
    }

    @Override
    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    @Override
    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    @Override
    public boolean hasProperty(String string, String string2) {
        return this.properties.hasProperty(string, string2);
    }

    @Override
    public boolean hasProperty(String string) {
        return this.properties.hasProperty(string);
    }

    @Override
    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    @Override
    public void clearProperties() {
        this.properties.clearProperties();
    }

    @Override
    public Iterator getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    @Override
    public Iterator getReferencesWithProperty(String string) {
        return this.getReferencesWithProperty(string, null);
    }

    @Override
    public Iterator getReferencesWithProperty(String string, String string2) {
        return this.getReferencesWithPropertyCollection(string, string2).iterator();
    }

    @Override
    public Collection getReferencesWithPropertyCollection(String string, String string2) {
        Iterator iterator = this.getSingleTargetReferences();
        ArrayList<Reference> arrayList = new ArrayList<Reference>(2);
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (!reference.hasProperty(string)) continue;
            if (string2 != null) {
                if (!string2.equals(reference.getProperty(string))) continue;
                arrayList.add(reference);
                continue;
            }
            arrayList.add(reference);
        }
        return arrayList;
    }

    @Override
    public String getIdString() {
        return String.valueOf(this.getReferenceId());
    }

    @Override
    public boolean containsReferenceWithProperty(String string, String string2) {
        return this.hasProperty(string) && (string2 == null || string2.equals(this.getProperty(string)));
    }

    @Override
    public void removeReferenceWithProperty(String string, String string2) {
    }

    public void appendStringProps(String string, StringBuffer stringBuffer) {
        this.properties.appendStringProps(string, stringBuffer);
    }

    @Override
    public DesignObject getObject() {
        return null;
    }

    public String getObjectId() {
        return null;
    }

    @Override
    public String getDesignPartId() {
        String string;
        if (this.designPartId != null || this.isCompositeReference()) {
            return this.designPartId;
        }
        if (this.getObjectId() != null && (string = this.getObjectId()).indexOf(64) > 0) {
            return string.substring(0, string.indexOf(64));
        }
        return "null";
    }

    @Override
    public void setDesignPartId(String string) {
        this.designPartId = string;
    }
}

