/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifierAbstract;

public class PVStringStartsChar
extends PropertyVerifierAbstract {
    @Override
    public boolean accept(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() > 0) {
                return Character.isLetter(string.charAt(0));
            }
            return false;
        }
        return false;
    }

    @Override
    public String error(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() > 0) {
                return MessageFormat.format(Messages.getString("PVStringStartsChar.CharacterNotALetter"), Character.getNumericValue(string.charAt(0)));
            }
            return Messages.getString("PVStringStartsChar.EmptyStringDoesNotStartWithCharacter");
        }
        if (object == null) {
            return Messages.getString("PVStringStartsChar.NullValueNotAccepted");
        }
        return Messages.getString("PVStringStartsChar.StringValueExpected");
    }

    @Override
    public boolean acceptNullValues() {
        return false;
    }
}

