/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import oracle.dbtools.crest.model.propertyholder.PVStringParser;
import oracle.dbtools.crest.model.propertyholder.PropertyParseException;

public class PVStringLength
extends PVStringParser {
    private int maxLength = 10;
    private int minLength = 0;

    public PVStringLength() {
        this(10, 0);
    }

    public PVStringLength(int n) {
        this(n, 0);
    }

    public PVStringLength(int n, int n2) {
        this.setBoundaries(n, n2);
    }

    private void setBoundaries(int n, int n2) {
        n = n < 0 ? 0 : n;
        n2 = n2 < 0 ? 0 : n2;
        this.maxLength = Math.max(n, n2);
        this.minLength = Math.min(n, n2);
    }

    @Override
    public boolean accept(Object object) {
        if (object instanceof String) {
            int n = ((String)object).length();
            return this.minLength <= n && this.maxLength >= n;
        }
        return false;
    }

    @Override
    public String error(Object object) {
        if (!(object instanceof String)) {
            return "String value expected.";
        }
        String string = (String)object;
        if (string.length() < this.minLength) {
            return "Expect a string of minimal length: " + this.minLength;
        }
        if (string.length() > this.maxLength) {
            return "Expect a string of maximal length: " + this.maxLength;
        }
        return "unchecked error";
    }

    @Override
    public Object parse(String string) throws PropertyParseException {
        return string;
    }
}

