/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;

public class StoragePathTranslator
implements XMLConstants {
    public static boolean WRITE_OPERATION = false;

    public static String getPath(StorageDesign storageDesign) {
        return StoragePathTranslator.getPathBuffer(storageDesign).toString();
    }

    public static StringBuffer getPathBuffer(StorageDesign storageDesign) {
        if (storageDesign.getRDBMSSite() == null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("StoragePathTranslator.StorageDesignShouldHhaveRDBMSSiteSet"), storageDesign));
        }
        RelationalDesign relationalDesign = storageDesign.getPhysicalDesign();
        MDConfiguration mDConfiguration = MDConfiguration.getDefaultInstance();
        StringBuffer stringBuffer = new StringBuffer();
        if (relationalDesign != null) {
            String string = relationalDesign.getAppView().getDesignName();
            stringBuffer.append(string).append('/');
            if (relationalDesign.getDesign().getLoadedVersion() < 3.2f && !WRITE_OPERATION) {
                String string2 = storageDesign.getRDBMSSite().getObjectID();
                if (storageDesign.isCloneOperation() && storageDesign.getClonedSite() != null) {
                    string2 = storageDesign.getClonedSite().getObjectID();
                }
                stringBuffer.append("relational").append('/').append(relationalDesign.getObjectID()).append('/');
                stringBuffer.append(mDConfiguration.get("oldstoragePath")).append('/').append(string2);
            } else if (relationalDesign.getDesign().getLoadedVersion() < 3.3f && !WRITE_OPERATION) {
                String string3 = storageDesign.getRDBMSSite().getPathIDString();
                if (storageDesign.isCloneOperation() && storageDesign.getClonedSite() != null) {
                    string3 = storageDesign.getClonedSite().getPathIDString();
                }
                stringBuffer.append("rel").append('/').append(relationalDesign.getPathIDString()).append('/');
                stringBuffer.append(mDConfiguration.get("storagePath")).append('/').append(string3);
            } else {
                String string4 = storageDesign.getRDBMSSite().getShortObjectID();
                if (storageDesign.isCloneOperation() && storageDesign.getClonedSite() != null) {
                    string4 = storageDesign.getClonedSite().getShortObjectID();
                }
                stringBuffer.append("rel").append('/').append(relationalDesign.getPathIDString()).append('/');
                stringBuffer.append(mDConfiguration.get("storagePath")).append('/').append(string4);
            }
        }
        return stringBuffer;
    }

    public static String getPath(StorageObject storageObject) {
        return StoragePathTranslator.getPathBuffer(storageObject).toString();
    }

    public static StringBuffer getPathBuffer(StorageObject storageObject) {
        if (storageObject.getStorageDesign() == null || storageObject.getStorageDesign().isNullInstance()) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("StoragePathTranslator.StorageObjectShouldHaveStorageDesignSet"), storageObject));
        }
        StringBuffer stringBuffer = StoragePathTranslator.getPathBuffer(storageObject.getStorageDesign());
        stringBuffer.append('/');
        if (storageObject.isPhysicalObjectProxy() && storageObject.getDesign().getLoadedVersion() < 3.2f && !WRITE_OPERATION) {
            stringBuffer.append("specific").append('/');
        }
        if (storageObject.getDesign().getLoadedVersion() < 3.2f && !WRITE_OPERATION) {
            stringBuffer.append(storageObject.getOldObjectTypeName()).append('/');
        } else {
            stringBuffer.append(storageObject.getObjectTypeName()).append('/');
        }
        return stringBuffer;
    }
}

