/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLModelIDObject;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractWXMLStorageDesign;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPooled;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GenericWXMLStorageObject
extends AbstractWXMLModelIDObject {
    private Class baseClass = StorageObject.class;
    private Class wrappeeClass = StorageObject.class;
    private Set priorities = Collections.EMPTY_SET;
    private AbstractWXMLStorageDesign storageDesignWriter;
    private static final Logger LOGGER = new Logger(GenericWXMLStorageObject.class);

    public GenericWXMLStorageObject(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    private Element appendInfo(Document document, Element element, ModelIDObject modelIDObject, String string, boolean bl, String string2) {
        String string3;
        modelIDObject.setPersisted(true);
        String string4 = "object";
        if (string2 != null) {
            string4 = string2;
        }
        Element element2 = bl ? document.createElement(string4) : document.createElement(string);
        element2.setAttribute("type", string);
        element2.setAttribute("id", modelIDObject.getObjectID());
        if (modelIDObject.getRepositoryOID() != null) {
            element2.setAttribute("rep_oid", modelIDObject.getRepositoryOID());
        }
        if (modelIDObject.getRepositoryOVID() != null) {
            element2.setAttribute("rep_ovid", modelIDObject.getRepositoryOVID());
        }
        if (!modelIDObject.hasOwnerDesignName() && modelIDObject.isWriteable()) {
            modelIDObject.setOwnerDesign();
        }
        Element element3 = document.createElement("name");
        Text text = document.createTextNode(StringUtilities.encodeAttributeValue(modelIDObject.getName()));
        element3.appendChild(text);
        element2.appendChild(element3);
        String string5 = modelIDObject.getComment();
        if (string5 != null) {
            element3 = document.createElement("comment");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string5));
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        if ((string3 = modelIDObject.getNotes()) != null) {
            element3 = document.createElement("notes");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string3));
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        this.appendChange(element2, modelIDObject.getCreation(), "created");
        this.appendChange(element2, modelIDObject.getChange(), "changed");
        String string6 = modelIDObject.getGeneratorID();
        if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(string6)) {
            element3 = document.createElement("generator");
            text = document.createTextNode(string6);
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        this.appendWrappedProperties(element2, (StorageObject)modelIDObject);
        element.appendChild(element2);
        return element2;
    }

    @Override
    protected Element appendObjectInfo(Document document, Element element, ModelIDObject modelIDObject, String string) {
        Element element2 = this.appendInfo(document, element, modelIDObject, string, true, null);
        if ("Table".equalsIgnoreCase(string) && modelIDObject instanceof TableProxy) {
            this.writeTableElements((TableProxy)modelIDObject, element);
        }
        return element2;
    }

    protected void appendWrappedProperties(Element element, StorageObject storageObject) {
        PropertyMapWrapper propertyMapWrapper = this.getPropertyMapWrapper(storageObject);
        propertyMapWrapper.setTranslators(storageObject.getStorageDesign().getPropertyTranslators());
        this.releasePropertyMapWrapper(propertyMapWrapper);
    }

    @Override
    protected void appendProperty(Element element, String string, String string2) {
        super.appendProperty(element, string, string2);
        if (this.priorities.contains(string)) {
            element.setAttribute("prioritized", VALUE_TRUE);
        }
    }

    protected PropertyMapWrapper getPropertyMapWrapper(ModelIDObject modelIDObject) {
        return this.getPMWPoolMap().getInstance(this.getWrappeeClass(), this.getBaseClass(), modelIDObject);
    }

    protected void releasePropertyMapWrapper(PropertyMapWrapper propertyMapWrapper) {
        if (propertyMapWrapper instanceof PMWPooled) {
            ((PMWPooled)propertyMapWrapper).releaseFromPool();
        } else {
            LOGGER.error("releasePropertyMapWrapper: can not release");
        }
    }

    public void setBaseClass(Class clazz) {
        this.baseClass = clazz;
    }

    public void setWrappeeClass(Class clazz) {
        if (!StorageObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("wrappee class should be a StorageObject subclass");
        }
        this.wrappeeClass = clazz;
    }

    protected Class getBaseClass() {
        return this.baseClass;
    }

    protected Class getWrappeeClass() {
        return this.wrappeeClass;
    }

    @Override
    public Document writeDocument(Object object) {
        StorageObject storageObject = (StorageObject)object;
        boolean bl = this.getPersistenceManager().isCheckDirty() && !AbstractRepositoryManager.INITIAL_WRITE_TODB ? storageObject.isDirty() : true;
        if (bl) {
            Document document = this.createDocument();
            Element element = document.getDocumentElement();
            Element element2 = this.appendObjectInfo(document, element, storageObject, storageObject.getObjectTypeName());
            this.appendSpecificObjectInfo(element2, storageObject);
            return document;
        }
        return null;
    }

    public void writeTableElements(TableProxy tableProxy, Element element) {
        this.appendContained(tableProxy, element);
        this.appendSAC_StorageObjects(tableProxy, element);
    }

    private void appendContained(TableProxy tableProxy, Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("columns");
        Element element3 = document.createElement("keys_and_indexes");
        AbstractWXMLStorageDesign abstractWXMLStorageDesign = this.getStorageDesignWriter();
        if (abstractWXMLStorageDesign != null) {
            Object object;
            GenericWXMLStorageObject genericWXMLStorageObject;
            ModelIDObject modelIDObject;
            ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
            for (int i = 0; i < columnProxyArray.length; ++i) {
                modelIDObject = columnProxyArray[i];
                genericWXMLStorageObject = (GenericWXMLStorageObject)abstractWXMLStorageDesign.getWriterFor(modelIDObject);
                if (genericWXMLStorageObject == null) continue;
                object = genericWXMLStorageObject.appendInfo(document, element2, modelIDObject, "Column", false, null);
                this.appendSpecificObjectInfo((Element)object, (StorageObject)modelIDObject);
            }
            Table table = (Table)tableProxy.getObject();
            modelIDObject = tableProxy.getStorageDesign();
            object = table.getKeys();
            for (int i = 0; i < ((KeyObject[])object).length; ++i) {
                Index index = (Index)object[i];
                String string = index.getObjectID();
                StorageObject storageObject = ((StorageDesign)modelIDObject).getStorageObject(string);
                if (storageObject == null && index.isFK()) {
                    string = index.getFKAssociation().getObjectID();
                    storageObject = ((StorageDesign)modelIDObject).getStorageObject(string);
                }
                if (storageObject == null || (genericWXMLStorageObject = (GenericWXMLStorageObject)abstractWXMLStorageDesign.getWriterFor(storageObject)) == null) continue;
                Element element4 = genericWXMLStorageObject.appendInfo(document, element3, storageObject, storageObject.getObjectTypeName(), false, null);
                this.appendSpecificObjectInfo(element4, storageObject);
            }
        }
        element.appendChild(element2);
        element.appendChild(element3);
    }

    private void appendSAC_StorageObjects(TableProxy tableProxy, Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("storage_objects");
        AbstractWXMLStorageDesign abstractWXMLStorageDesign = this.getStorageDesignWriter();
        if (abstractWXMLStorageDesign != null) {
            for (StorageObject storageObject : tableProxy.getSAC_StorageObjects()) {
                GenericWXMLStorageObject genericWXMLStorageObject = (GenericWXMLStorageObject)abstractWXMLStorageDesign.getWriterFor(storageObject);
                if (genericWXMLStorageObject == null) continue;
                Element element3 = genericWXMLStorageObject.appendInfo(document, element2, storageObject, storageObject.getObjectTypeName(), true, "storage_object");
                this.appendSpecificObjectInfo(element3, storageObject);
            }
        }
        element.appendChild(element2);
    }

    public void appendSpecificObjectInfo(Element element, StorageObject storageObject) {
    }

    @Override
    public String getRelativePath() {
        throw new RuntimeException("StorageDesigns need a variable path");
    }

    @Override
    public String getRelativePath(Object object) {
        StoragePathTranslator.WRITE_OPERATION = true;
        String string = StoragePathTranslator.getPath((StorageObject)object);
        return string;
    }

    @Override
    public boolean canWrite(Object object) {
        return this.getWrappeeClass().isAssignableFrom(object.getClass());
    }

    @Override
    public String getFilenameFor(Object object) {
        String string = ((StorageObject)object).getObjectID();
        return string;
    }

    public void addPrioritizedPropertyName(String string) {
        if (this.priorities.isEmpty()) {
            this.priorities = new TreeSet();
        }
        this.priorities.add(string);
    }

    protected boolean isPrioritized() {
        return this.priorities.isEmpty();
    }

    public AbstractWXMLStorageDesign getStorageDesignWriter() {
        return this.storageDesignWriter;
    }

    public void setStorageDesignWriter(AbstractWXMLStorageDesign abstractWXMLStorageDesign) {
        this.storageDesignWriter = abstractWXMLStorageDesign;
    }
}

