/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.storage.GenericWXMLStorageObject;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractWXMLStorageDesign
extends AbstractXMLWriter {
    private GenericWXMLStorageObject first = null;
    private static final Logger LOGGER = new Logger(AbstractWXMLStorageDesign.class);

    public AbstractWXMLStorageDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
        this.first = new GenericWXMLStorageObject(xMLPersistenceManager);
    }

    public void insert(GenericWXMLStorageObject genericWXMLStorageObject) {
        genericWXMLStorageObject.setSuccessor(this.first);
        this.first = genericWXMLStorageObject;
        genericWXMLStorageObject.setStorageDesignWriter(this);
    }

    @Override
    public Document writeDocument(Object object) {
        if (this.isStorageDesign(object)) {
            StorageDesign storageDesign = (StorageDesign)object;
            Document document = this.createDocument();
            Element element = document.getDocumentElement();
            this.writeStorageDesign(document, element, storageDesign);
            storageDesign.setDirty(false);
            return document;
        }
        if (this.isStorageObject(object)) {
            AbstractXMLWriter abstractXMLWriter = this.first.getWriterFor(object);
            if (abstractXMLWriter != null) {
                Document document = abstractXMLWriter.writeDocument(object);
                return document;
            }
            LOGGER.error("writeDocument(Object): can not find appropriate delegate");
            Document document = this.createDocument();
            Element element = document.getDocumentElement();
            this.appendComment(element, new StringBuffer("could not find XML handler for: ").append(object).append(" id: ").append(((ModelIDObject)object).getObjectID()).toString());
            return document;
        }
        return null;
    }

    public AbstractXMLWriter getWriterFromChain(StorageObject storageObject) {
        if (this.first != null) {
            this.first.getWriterFor(storageObject);
        }
        return null;
    }

    public void writeStorageDesign(Document document, Element element, StorageDesign storageDesign) {
        if (storageDesign.getRepositoryOID() != null) {
            element.setAttribute("rep_oid", storageDesign.getRepositoryOID());
        }
        if (storageDesign.getRepositoryOVID() != null) {
            element.setAttribute("rep_ovid", storageDesign.getRepositoryOVID());
        }
        element.setAttribute("stdes_version", String.valueOf(storageDesign.getVersion()));
        this.writeStorageDesign(element, storageDesign);
    }

    public abstract void writeStorageDesign(Element var1, StorageDesign var2);

    @Override
    public String getFilenameFor(Object object) {
        return ((StorageDesign)object).getFileName();
    }

    @Override
    public String getRelativePath() {
        throw new RuntimeException("StorageDesigns need a variable path");
    }

    @Override
    public String getRelativePath(Object object) {
        String string = StoragePathTranslator.getPathBuffer((StorageDesign)object).toString();
        return string;
    }

    @Override
    public boolean canWrite(Object object) {
        return this.isCorrectRDBMSType(object);
    }

    public boolean isCorrectRDBMSType(Object object) {
        if (this.isStorageObject(object)) {
            return this.getRDBMSType().equals(((StorageObject)object).getRDBMSType());
        }
        if (this.isStorageDesign(object)) {
            return this.getRDBMSType().equals(((StorageDesign)object).getRDBMSType());
        }
        return false;
    }

    public abstract RDBMSType getRDBMSType();

    public boolean isStorageObjectOrDesign(Object object) {
        return this.isStorageObject(object) || this.isStorageDesign(object);
    }

    public boolean isStorageDesign(Object object) {
        return object instanceof StorageDesign;
    }

    public boolean isStorageObject(Object object) {
        return object instanceof StorageObject;
    }

    @Override
    public AbstractXMLWriter getWriterFor(Object object) {
        if (this.isStorageObject(object)) {
            return this.first.getWriterFor(object);
        }
        if (this.isStorageDesign(object) && this.isCorrectRDBMSType(object)) {
            return this;
        }
        return super.getWriterFor(object);
    }

    protected void writeStorageObjectSet(Element element, RelationalObjectProxySet relationalObjectProxySet) {
        StringBuffer stringBuffer = new StringBuffer("Specific properties for physical objects of type: ");
        stringBuffer.append(relationalObjectProxySet.getLongName());
        this.appendComment(element, stringBuffer.toString(), 1);
        this.writeStorageObjectSet(element, relationalObjectProxySet.getObjectCollection().iterator(), relationalObjectProxySet.getStorageDesign());
    }

    protected void writeStorageObjectSet(Element element, StorageObjectSet storageObjectSet) {
        StringBuffer stringBuffer = new StringBuffer("RDBMS objects of type: ");
        stringBuffer.append(storageObjectSet);
        this.appendComment(element, stringBuffer.toString(), 2);
        this.writeStorageObjectSet(element, storageObjectSet.iterator(), storageObjectSet.getStorageDesign());
    }

    protected void writeStorageObjectSet(Element element, Iterator iterator, StorageDesign storageDesign) {
        boolean bl;
        Design design = storageDesign.getDesign();
        boolean bl2 = bl = storageDesign.getDesign().getCurrentOperation() == 5;
        while (iterator.hasNext()) {
            StorageObject storageObject = (StorageObject)iterator.next();
            boolean bl3 = storageObject.belongsTo(storageDesign);
            AbstractXMLWriter abstractXMLWriter = this.getWriterFor(storageObject);
            if (abstractXMLWriter == null || !bl3 || storageObject.isNullInstance()) continue;
            String string = storageObject.getObjectID();
            Element element2 = this.createElement(element, "object");
            element2.setAttribute("oid", string);
            element2.setAttribute("type", storageObject.getObjectTypeName());
            element2.setAttribute("role", bl3 ? "contains" : "uses");
            element2.setAttribute("marked_generate", String.valueOf(storageObject.isMarkedGenerate()));
            if (this.getPersistenceManager().isXML_FromDataBase()) continue;
            if (bl) {
                if (storageObject instanceof RelationalObjectProxy) {
                    if (!design.shouldExport((RelationalObjectProxy)storageObject)) continue;
                    abstractXMLWriter.write(storageObject);
                    continue;
                }
                abstractXMLWriter.write(storageObject);
                continue;
            }
            boolean bl4 = abstractXMLWriter.write(storageObject);
            if (!bl4) continue;
            storageObject.setPersisted(true);
        }
    }
}

