/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLStore
extends AbstractWXMLDesignObject
implements DFConstants {
    private InfoStore store = null;

    public WXMLStore(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof InfoStore;
        if (bl) {
            this.store = (InfoStore)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.store != null) {
            String string = this.store.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("storePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof InfoStore) {
            InfoStore infoStore = (InfoStore)designObject;
            if (infoStore.getSynonym() != null && !"".equalsIgnoreCase(infoStore.getSynonym())) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(infoStore.getSynonym()));
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("systemobjective", infoStore.getSystemObjective());
            treeMap.put("type", StringUtilities.encodeAttributeValue(infoStore.getType()));
            treeMap.put("rdbmstype", StringUtilities.encodeAttributeValue(infoStore.getRdbmsSite()));
            treeMap.put("owner", StringUtilities.encodeAttributeValue(infoStore.getOwner()));
            treeMap.put("source", StringUtilities.encodeAttributeValue(infoStore.getSource()));
            treeMap.put("filename", StringUtilities.encodeAttributeValue(infoStore.getFileName()));
            treeMap.put("location", StringUtilities.encodeAttributeValue(infoStore.getLocation()));
            treeMap.put("filetype", StringUtilities.encodeAttributeValue(infoStore.getFileType()));
            treeMap.put("fieldseparator", StringUtilities.encodeAttributeValue(infoStore.getFieldSeparator()));
            treeMap.put("transfertype", StringUtilities.encodeAttributeValue(infoStore.getTransferType()));
            treeMap.put("scope", StringUtilities.encodeAttributeValue(infoStore.getScope()));
            treeMap.put("objectType", StringUtilities.encodeAttributeValue(infoStore.getObjectType()));
            treeMap.put("implementationName", StringUtilities.encodeAttributeValue(infoStore.getImplementationName()));
            treeMap.put("selfDescribing", new Boolean(infoStore.isSelfDescribing()).toString());
            treeMap.put("skipRecords", new Integer(infoStore.getSkipRecords()).toString());
            treeMap.put("textDelimiter", StringUtilities.encodeAttributeValue(infoStore.getTextDelimiter()));
            this.appendProperties(element, "attributes", treeMap);
            Iterator iterator = infoStore.getEntityImplementations().keySet().iterator();
            TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
            while (iterator.hasNext()) {
                DesignObject designObject2 = (DesignObject)iterator.next();
                DesignObject designObject3 = (DesignObject)infoStore.getEntityImplementations().get(designObject2);
                if (designObject3 == null) continue;
                treeMap2.put(StringUtilities.encodeAttributeValue(designObject2.getObjectID()), StringUtilities.encodeAttributeValue(designObject3.getObjectID()));
            }
            this.appendProperties(element, "entityimpl", treeMap2);
            this.appendObjects(element, infoStore.getDatas().toArray(), "storedatas");
        }
    }
}

