/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLRole
extends AbstractWXMLDesignObject
implements DFConstants {
    private Role role = null;

    public WXMLRole(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Role;
        if (bl) {
            this.role = (Role)object;
        }
        return bl;
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Role) {
            Role role = (Role)designObject;
            if (role.getSynonym() != null && !role.getSynonym().equalsIgnoreCase("")) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(role.getSynonym()));
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", role.getDescription());
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, role.getProcesses().toArray(), "processes");
        }
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.role != null) {
            String string = this.role.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("rolePath"));
        return stringBuffer.toString();
    }
}

