/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLProcess
extends AbstractWXMLDesignObject
implements DFConstants {
    private Process process = null;

    public WXMLProcess(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Process;
        if (bl) {
            this.process = (Process)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.process != null) {
            String string = this.process.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm/dflows").append('/').append(StringUtilities.encodeAttributeValue(this.process.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("processPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Process) {
            Process process = (Process)designObject;
            if (process.getSynonym() != null && !"".equalsIgnoreCase(process.getSynonym())) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(process.getSynonym()));
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("filter_condition", process.getFilterCondition());
            treeMap.put("join_condition", process.getJoinCondition());
            treeMap.put("type", Integer.toString(process.getType()));
            treeMap.put("diagram", process.getDiagram() != null ? StringUtilities.encodeAttributeValue(process.getDiagram().getObjectID()) : "null");
            treeMap.put("footnote", StringUtilities.encodeAttributeValue(process.getFootNote()));
            treeMap.put("frequencytimes", Integer.toString(process.getFrequencyTimes()));
            treeMap.put("frequencytimeunit", process.getFrequencyTimeUnit());
            treeMap.put("priority", process.getPriority());
            treeMap.put("mode", process.getMode());
            treeMap.put("batchmintransactions", Integer.toString(process.getBatchMinimumTransactions()));
            treeMap.put("batchtimeunit", process.getBatchTimeUnit());
            treeMap.put("longestresponsetime", Integer.toString(process.getInteractiveLongestResponseTime()));
            treeMap.put("responsetimeunit", process.getInteractiveResponseTimeUnit());
            boolean[] blArray = process.getPeakPeriods();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < blArray.length; ++i) {
                stringBuffer.append(blArray[i] ? "1" : "0");
            }
            treeMap.put("peakperiods", stringBuffer.toString());
            treeMap.put("trtask_input_params", process.getParamsWrappersString());
            String string = "none";
            if (process.getTransformationTask() != null) {
                string = process.getTransformationTask().getObjectID();
            }
            treeMap.put("transformation_task", StringUtilities.encodeAttributeValue(string));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, process.getEvents().toArray(), "events");
            process.removeInvalidElements();
            Element element2 = element.getOwnerDocument().createElement("contained");
            element.appendChild(element2);
            for (TargetElement targetElement : process.getTargetElements()) {
                this.appendTargetInfo(element2, targetElement);
            }
        }
    }

    private void appendTargetInfo(Element element, TargetElement targetElement) {
        Element element2 = element.getOwnerDocument().createElement("targetelement");
        Element element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "attributeid", StringUtilities.encodeAttributeValue(targetElement.getTarget().getObjectID()));
        Iterator iterator = targetElement.getSources().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(StringUtilities.encodeAttributeValue(((DesignObject)iterator.next()).getObjectID()));
        }
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "sources", stringBuffer.toString());
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "type", targetElement.getTransformationType());
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "description", targetElement.getDescription());
        element.appendChild(element2);
    }
}

