/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLInfoStructure
extends AbstractWXMLDesignObject
implements DFConstants {
    private InfoStructure structure = null;

    public WXMLInfoStructure(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof InfoStructure;
        if (bl) {
            this.structure = (InfoStructure)object;
        }
        return bl;
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof InfoStructure) {
            InfoStructure infoStructure = (InfoStructure)designObject;
            if (infoStructure.getSynonym() != null && !"".equalsIgnoreCase(infoStructure.getSynonym())) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(infoStructure.getSynonym()));
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("volume", String.valueOf(infoStructure.getVolume()));
            treeMap.put("growthRatePercent", String.valueOf(infoStructure.getGrowthRatePercent()));
            treeMap.put("growthRateUnit", infoStructure.getGrowthRateUnit());
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, infoStructure.getAttributes().toArray(), "isattributes");
        }
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.structure != null) {
            String string = this.structure.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("infoStructurePath"));
        return stringBuffer.toString();
    }
}

