/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLEvent
extends AbstractWXMLDesignObject
implements DFConstants {
    private Event event = null;

    public WXMLEvent(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Event;
        if (bl) {
            this.event = (Event)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.event != null) {
            String string = this.event.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("eventPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Event) {
            Event event = (Event)designObject;
            if (event.getSynonym() != null && !"".equalsIgnoreCase(event.getSynonym())) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(event.getSynonym()));
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("type", Integer.toString(event.getEventType()));
            treeMap.put("eventtext", StringUtilities.encodeAttributeValue(event.getText()));
            treeMap.put("frequency", Integer.toString(event.getFrequency()));
            treeMap.put("onday", String.valueOf(event.isOnDay()));
            treeMap.put("dayofweek", StringUtilities.encodeAttributeValue(event.getDayOfWeek()));
            treeMap.put("dayofmonth", StringUtilities.encodeAttributeValue(Integer.toString(event.getDayOfMonth())));
            treeMap.put("months", event.getMonths());
            treeMap.put("quarter", Integer.toString(event.getQuarter()));
            treeMap.put("year", Integer.toString(event.getYear()));
            treeMap.put("fiscal", String.valueOf(event.isFiscal()));
            treeMap.put("timeswhenrun", Integer.toString(event.getTimesWhenRun()));
            treeMap.put("attime", String.valueOf(event.isAtTime()));
            treeMap.put("hour", Integer.toString(event.getHour()));
            treeMap.put("minute", Integer.toString(event.getMinute()));
            treeMap.put("timefreq", Integer.toString(event.getTimeFreq()));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

