/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLStore
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLStore(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getInfoStoreSet().createInfoStore(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        String string;
        int n;
        InfoStore infoStore = (InfoStore)super.recreateObject(element, design, bl);
        String string2 = element.getAttribute("synonym");
        if (string2 != null) {
            infoStore.setSynonym(StringUtilities.decodeAttributeValue(string2));
        }
        Map map = this.getProperties(element, "attributes");
        infoStore.setSystemObjective((String)map.get("systemobjective"));
        infoStore.setType(StringUtilities.decodeAttributeValue((String)map.get("type")));
        infoStore.setRdbmsSite(StringUtilities.decodeAttributeValue((String)map.get("rdbmstype")));
        infoStore.setObjectType(StringUtilities.decodeAttributeValue((String)map.get("objectType")));
        infoStore.setImplementationName(StringUtilities.decodeAttributeValue((String)map.get("implementationName")));
        infoStore.setScope(StringUtilities.decodeAttributeValue((String)map.get("scope")));
        infoStore.setOwner(StringUtilities.decodeAttributeValue((String)map.get("owner")));
        infoStore.setSource(StringUtilities.decodeAttributeValue((String)map.get("source")));
        infoStore.setFileName(StringUtilities.decodeAttributeValue((String)map.get("filename")));
        infoStore.setLocation(StringUtilities.decodeAttributeValue((String)map.get("location")));
        infoStore.setFileType(StringUtilities.decodeAttributeValue((String)map.get("filetype")));
        infoStore.setFieldSeparator((String)map.get("fieldseparator"));
        infoStore.setTransferType(StringUtilities.decodeAttributeValue((String)map.get("transfertype")));
        infoStore.setSelfDescribing(new Boolean((String)map.get("selfDescribing")));
        infoStore.setSkipRecords(new Integer((String)map.get("skipRecords")));
        infoStore.setTextDelimiter(StringUtilities.decodeAttributeValue((String)map.get("textDelimiter")));
        Map map2 = this.getProperties(element, "storedatas");
        Object[] objectArray = map2.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map2.get(objectArray[n]);
            object = (ExternalData)infoStore.getDesign().getProcessModel().getExternalDataSet().getObjectByID(string);
            if (object == null) continue;
            infoStore.addData((ExternalData)object);
        }
        map2 = this.getProperties(element, "entityimpl");
        objectArray = map2.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)objectArray[n];
            object = (String)map2.get(objectArray[n]);
            Entity entity = (Entity)infoStore.getDesign().getDesignObject(string);
            Table table = (Table)infoStore.getDesign().getDesignObject((String)object);
            if (entity == null || table == null) continue;
            infoStore.addEntityImpl(entity, table);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(infoStore.getObjectID())).append(".dmd");
        infoStore.setFilePath(stringBuffer.toString());
        return infoStore;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                stringBuffer.append(string).append('/').append("processmodel").append('/');
            } else {
                stringBuffer.append(string).append('/').append("pm").append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("storePath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == InfoStore.class;
    }
}

