/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLFlow
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLFlow(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getDataFlowDesign().getFlowSet().createFlow(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        Object object2;
        String string;
        Object object3;
        Flow flow = (Flow)super.recreateObject(element, design, bl);
        NodeList nodeList = element.getElementsByTagName("connection");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object3 = (Element)nodeList.item(i);
            string = object3.getAttribute("dfobject");
            object2 = (AbstractProcessObject)design.getDesignObject(string);
            if ("source".equals(object3.getAttribute("endpoint"))) {
                flow.setSourceProcessObject((AbstractProcessObject)object2);
                continue;
            }
            if (!"target".equals(object3.getAttribute("endpoint"))) continue;
            flow.setTargetProcessObject((AbstractProcessObject)object2);
        }
        String string2 = element.getAttribute("synonym");
        if (string2 != null) {
            flow.setSynonym(StringUtilities.decodeAttributeValue(string2));
        }
        if (!"null".equalsIgnoreCase(string = (String)(object3 = this.getProperties(element, "attributes")).get("event")) && (object2 = (Event)flow.getDesign().getProcessModel().getEventSet().getObjectByID(string)) != null) {
            flow.setEvent((Event)object2);
        }
        flow.setLogging(Boolean.valueOf((String)object3.get("loggingflow")));
        flow.setSystemObjective((String)object3.get("systemobjective"));
        flow.setOpCreate(Boolean.valueOf((String)object3.get("opCreate")));
        flow.setOpRead(Boolean.valueOf((String)object3.get("opRead")));
        flow.setOpUpdate(Boolean.valueOf((String)object3.get("opUpdate")));
        flow.setOpDelete(Boolean.valueOf((String)object3.get("opDelete")));
        object2 = RXMLFlow.getFirstChildByTagName(element, "infostructures");
        if (object2 != null) {
            object = this.getProperties(element, "infostructures");
            Object[] objectArray = object.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)object.get(objectArray[i]);
                InfoStructure infoStructure = (InfoStructure)flow.getDesign().getProcessModel().getInfoStructureSet().getObjectByID(string3);
                if (infoStructure == null) continue;
                flow.addInfoStructure(infoStructure);
            }
        } else {
            object = (String)object3.get("infostructures");
            if (object != null) {
                String[] stringArray = ((String)object).split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    InfoStructure infoStructure = (InfoStructure)flow.getDesign().getProcessModel().getInfoStructureSet().getObjectByID(string4);
                    if (infoStructure == null) continue;
                    flow.addInfoStructure(infoStructure);
                }
            }
        }
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(flow.getObjectID())).append(".dmd");
        flow.setFilePath(((StringBuffer)object).toString());
        return flow;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getDataFlowDesign().getObjectID();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                stringBuffer.append("processmodel/dataflows");
            } else {
                stringBuffer.append("pm/dflows");
            }
            stringBuffer.append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("flowPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Flow.class && clazz != TransformationFlow.class;
    }
}

