/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLExternalData
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLExternalData(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getExternalDataSet().createExternalData(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        String string;
        ExternalData externalData = (ExternalData)super.recreateObject(element, design, bl);
        String string2 = element.getAttribute("synonym");
        if (string2 != null) {
            externalData.setSynonym(string2);
        }
        Map map = this.getProperties(element, "attributes");
        externalData.setStructured(new Boolean((String)map.get("structured")));
        if (externalData.isStructured()) {
            string = (String)map.get("recordstructure");
            object = (RecordStructure)externalData.getDesign().getProcessModel().getRecordStructureSet().getObjectByID(string);
            if (object != null) {
                externalData.setRecordStructure((RecordStructure)object);
            }
        } else {
            string = (String)map.get("type");
            object = (LogicalDatatype)externalData.getDesign().getLogicalDatatypeSet().getObjectByID(string);
            if (object != null) {
                externalData.setType((LogicalDatatype)object);
            }
        }
        try {
            int n = Integer.parseInt((String)map.get("startingpos"));
            externalData.setStartingPos(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        externalData.setDescription((String)map.get("description"));
        String string3 = (String)map.get("mappedobject");
        if (string3 != null && !"".equalsIgnoreCase(string3) && (object = design.getLogicalDesign().getAttributeSet().getObjectByID(string3)) != null) {
            externalData.setMappedDesignObject((DesignObject)object);
        }
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(externalData.getObjectID())).append(".dmd");
        externalData.setFilePath(((StringBuffer)object).toString());
        return externalData;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                stringBuffer.append(string).append('/').append("processmodel").append('/');
            } else {
                stringBuffer.append(string).append('/').append("pm").append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("extDataPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == ExternalData.class;
    }
}

